/*
 * Decompiled with CFR 0.152.
 */
package potionstudios.byg.common.world.biome.overworld;

import com.google.common.collect.ImmutableMap;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import corgitaco.corgilib.serialization.codec.CodecUtil;
import corgitaco.corgilib.serialization.codec.FromFileCodec;
import corgitaco.corgilib.serialization.codec.Wrapped;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Biomes;
import potionstudios.byg.common.world.biome.BYGBiomes;
import potionstudios.byg.util.BYGUtil;

public class BYGOverworldBiomeSelectors {
    public static final FromFileCodec<List<List<ResourceKey<Biome>>>> BIOME_LAYOUT_CODEC = FromFileCodec.create((Codec)CodecUtil.wrapCodecForCollectionSerializing((Codec)Codec.list((Codec)Codec.list((Codec)CodecUtil.BIOME_CODEC))).xmap(CodecUtil.WrapForSerialization::value, CodecUtil::wrap), (String)"biome_layout");
    public static final Codec<List<List<ResourceKey<Biome>>>> OLD_BIOME_LAYOUT_CODEC = Codec.list((Codec)Codec.list((Codec)CodecUtil.BIOME_CODEC));
    public static final Map<String, Pair<Map<String, String>, Wrapped<List<List<ResourceKey<Biome>>>>>> BIOME_LAYOUTS = new HashMap<String, Pair<Map<String, String>, Wrapped<List<List<ResourceKey<Biome>>>>>>();
    public static final String BIOME_LAYOUT = "\n[ ARID-ICY, DRY-ICY, NEUTRAL-ICY, WET-ICY, HUMID-ICY ],\n[ ARID-COLD, DRY-COLD, NEUTRAL-COLD, WET-COLD, HUMID-COLD ],\n[ ARID-NEUTRAL, DRY-NEUTRAL, NEUTRAL-NEUTRAL, WET-NEUTRAL, HUMID-NEUTRAL ],\n[ ARID-WARM, DRY-WARM, NEUTRAL-WARM, WET-WARM, HUMID-WARM ],\n[ ARID-HOT, DRY-HOT, NEUTRAL-HOT, WET-HOT, HUMID-HOT ]\n\n";
    public static final String OCEAN_BIOMES_LAYOUT = "[ DEEP-ICY, DEEP-COLD, DEEP-NEUTRAL, DEEP-WARM, DEEP-HOT ]\n[ SHALLOW-ICY, SHALLOW-COLD, SHALLOW-NEUTRAL, SHALLOW-WARM, SHALLOW-HOT ],\n\n";
    public static final String REQUIRES_VALID_KEYS = "All keys passed in must be valid in the biome registry!\n\"minecraft:the_void\" is invalid as it represents a value of \"NULL(nothing)\" internally.\n";
    public static final String SHATTERED_BIOMES_LAYOUT = "Appearing on shattered terrain here is the \"shattered_biomes\" layout:\n\n[ ARID-ICY, DRY-ICY, NEUTRAL-ICY, WET-ICY, HUMID-ICY ],\n[ ARID-COLD, DRY-COLD, NEUTRAL-COLD, WET-COLD, HUMID-COLD ],\n[ ARID-NEUTRAL, DRY-NEUTRAL, NEUTRAL-NEUTRAL, WET-NEUTRAL, HUMID-NEUTRAL ],\n[ ARID-WARM, DRY-WARM, NEUTRAL-WARM, WET-WARM, HUMID-WARM ],\n[ ARID-HOT, DRY-HOT, NEUTRAL-HOT, WET-HOT, HUMID-HOT ]\n\nAll keys passed in must be valid in the biome registry!\nIn slots containing \"minecraft:the_void\", biomes at the equivalent temperature/humidity index in \"middle_biomes\" will be used instead.\n";
    public static final String PEAK_BIOMES_LAYOUT = "Appearing on mountainous terrain & BELOW weirdness 0, here is the \"peak_biomes\" layout:\n\n[ ARID-ICY, DRY-ICY, NEUTRAL-ICY, WET-ICY, HUMID-ICY ],\n[ ARID-COLD, DRY-COLD, NEUTRAL-COLD, WET-COLD, HUMID-COLD ],\n[ ARID-NEUTRAL, DRY-NEUTRAL, NEUTRAL-NEUTRAL, WET-NEUTRAL, HUMID-NEUTRAL ],\n[ ARID-WARM, DRY-WARM, NEUTRAL-WARM, WET-WARM, HUMID-WARM ],\n[ ARID-HOT, DRY-HOT, NEUTRAL-HOT, WET-HOT, HUMID-HOT ]\n\nAll keys passed in must be valid in the biome registry!\n\"minecraft:the_void\" is invalid as it represents a value of \"NULL(nothing)\" internally.\n";
    public static final String SLOPE_BIOMES_LAYOUT = "Appearing on sloped terrain, near mountainous terrain, & BELOW weirdness 0, here is the \"slope_biomes\" layout:\n\n[ ARID-ICY, DRY-ICY, NEUTRAL-ICY, WET-ICY, HUMID-ICY ],\n[ ARID-COLD, DRY-COLD, NEUTRAL-COLD, WET-COLD, HUMID-COLD ],\n[ ARID-NEUTRAL, DRY-NEUTRAL, NEUTRAL-NEUTRAL, WET-NEUTRAL, HUMID-NEUTRAL ],\n[ ARID-WARM, DRY-WARM, NEUTRAL-WARM, WET-WARM, HUMID-WARM ],\n[ ARID-HOT, DRY-HOT, NEUTRAL-HOT, WET-HOT, HUMID-HOT ]\n\nAll keys passed in must be valid in the biome registry!\n\"minecraft:the_void\" is invalid as it represents a value of \"NULL(nothing)\" internally.\n";
    public static final String SLOPE_BIOMES_VARIANT_LAYOUT = "Appearing on sloped terrain, near mountainous terrain, & ABOVE weirdness 0, here is the \"slope_biome_variants\" layout:\n\n[ ARID-ICY, DRY-ICY, NEUTRAL-ICY, WET-ICY, HUMID-ICY ],\n[ ARID-COLD, DRY-COLD, NEUTRAL-COLD, WET-COLD, HUMID-COLD ],\n[ ARID-NEUTRAL, DRY-NEUTRAL, NEUTRAL-NEUTRAL, WET-NEUTRAL, HUMID-NEUTRAL ],\n[ ARID-WARM, DRY-WARM, NEUTRAL-WARM, WET-WARM, HUMID-WARM ],\n[ ARID-HOT, DRY-HOT, NEUTRAL-HOT, WET-HOT, HUMID-HOT ]\n\n" + BYGOverworldBiomeSelectors.invalidKeysOkay("slope_biomes");
    public static final String PEAK_BIOMES_VARIANT_LAYOUT = "Appearing on mountainous terrain & ABOVE weirdness 0, here is the \"peak_biome_variants\" layout:\n\n[ ARID-ICY, DRY-ICY, NEUTRAL-ICY, WET-ICY, HUMID-ICY ],\n[ ARID-COLD, DRY-COLD, NEUTRAL-COLD, WET-COLD, HUMID-COLD ],\n[ ARID-NEUTRAL, DRY-NEUTRAL, NEUTRAL-NEUTRAL, WET-NEUTRAL, HUMID-NEUTRAL ],\n[ ARID-WARM, DRY-WARM, NEUTRAL-WARM, WET-WARM, HUMID-WARM ],\n[ ARID-HOT, DRY-HOT, NEUTRAL-HOT, WET-HOT, HUMID-HOT ]\n\n" + BYGOverworldBiomeSelectors.invalidKeysOkay("slope_biomes");
    public static final String OCEANS_BIOMES_LAYOUT_COMMENT = "Appearing on terrain below sea level, here is the \"ocean_biomes\" layout:\n[ DEEP-ICY, DEEP-COLD, DEEP-NEUTRAL, DEEP-WARM, DEEP-HOT ]\n[ SHALLOW-ICY, SHALLOW-COLD, SHALLOW-NEUTRAL, SHALLOW-WARM, SHALLOW-HOT ],\n\nAll keys passed in must be valid in the biome registry!\n\"minecraft:the_void\" is invalid as it represents a value of \"NULL(nothing)\" internally.\n";
    public static final String PLATEAU_BIOMES_LAYOUT = "Appearing on elevated flat terrain BELOW weirdness 0 or in unfilled(\"NULL(nothing)\") spots in \"plateau_biome_variants\", here is the \"plateau_biomes\" layout:\n\n[ ARID-ICY, DRY-ICY, NEUTRAL-ICY, WET-ICY, HUMID-ICY ],\n[ ARID-COLD, DRY-COLD, NEUTRAL-COLD, WET-COLD, HUMID-COLD ],\n[ ARID-NEUTRAL, DRY-NEUTRAL, NEUTRAL-NEUTRAL, WET-NEUTRAL, HUMID-NEUTRAL ],\n[ ARID-WARM, DRY-WARM, NEUTRAL-WARM, WET-WARM, HUMID-WARM ],\n[ ARID-HOT, DRY-HOT, NEUTRAL-HOT, WET-HOT, HUMID-HOT ]\n\nAll keys passed in must be valid in the biome registry!\n\"minecraft:the_void\" is invalid as it represents a value of \"NULL(nothing)\" internally.\n";
    public static final String PLATEAU_BIOMES_VARIANT_LAYOUT = "Appearing on elevated flat terrain ABOVE weirdness 0, here is the \"plateau_biomes_variant\" layout:\n\n[ ARID-ICY, DRY-ICY, NEUTRAL-ICY, WET-ICY, HUMID-ICY ],\n[ ARID-COLD, DRY-COLD, NEUTRAL-COLD, WET-COLD, HUMID-COLD ],\n[ ARID-NEUTRAL, DRY-NEUTRAL, NEUTRAL-NEUTRAL, WET-NEUTRAL, HUMID-NEUTRAL ],\n[ ARID-WARM, DRY-WARM, NEUTRAL-WARM, WET-WARM, HUMID-WARM ],\n[ ARID-HOT, DRY-HOT, NEUTRAL-HOT, WET-HOT, HUMID-HOT ]\n\n" + BYGOverworldBiomeSelectors.invalidKeysOkay("plateau_biomes");
    public static final String MIDDLE_BIOMES_LAYOUT = "Appearing on terrain BELOW weirdness 0 or in unfilled(\"NULL(nothing)\") spots in \"middle_biomes_variants\", here is the \"middle_biomes\" layout:\n\n[ ARID-ICY, DRY-ICY, NEUTRAL-ICY, WET-ICY, HUMID-ICY ],\n[ ARID-COLD, DRY-COLD, NEUTRAL-COLD, WET-COLD, HUMID-COLD ],\n[ ARID-NEUTRAL, DRY-NEUTRAL, NEUTRAL-NEUTRAL, WET-NEUTRAL, HUMID-NEUTRAL ],\n[ ARID-WARM, DRY-WARM, NEUTRAL-WARM, WET-WARM, HUMID-WARM ],\n[ ARID-HOT, DRY-HOT, NEUTRAL-HOT, WET-HOT, HUMID-HOT ]\n\nAll keys passed in must be valid in the biome registry!\n\"minecraft:the_void\" is invalid as it represents a value of \"NULL(nothing)\" internally.\n";
    public static final String MIDDLE_BIOMES_VARIANT_LAYOUT = "Appearing on terrain ABOVE weirdness 0, here is the \"middle_biomes_variant\" layout:\n\n[ ARID-ICY, DRY-ICY, NEUTRAL-ICY, WET-ICY, HUMID-ICY ],\n[ ARID-COLD, DRY-COLD, NEUTRAL-COLD, WET-COLD, HUMID-COLD ],\n[ ARID-NEUTRAL, DRY-NEUTRAL, NEUTRAL-NEUTRAL, WET-NEUTRAL, HUMID-NEUTRAL ],\n[ ARID-WARM, DRY-WARM, NEUTRAL-WARM, WET-WARM, HUMID-WARM ],\n[ ARID-HOT, DRY-HOT, NEUTRAL-HOT, WET-HOT, HUMID-HOT ]\n\n" + BYGOverworldBiomeSelectors.invalidKeysOkay("middle_biomes");
    public static final String BEACH_BIOMES_LAYOUT = "Appearing on terrain bordering oceans, here is the \"beach_biomes\" layout:\n\n[ ARID-ICY, DRY-ICY, NEUTRAL-ICY, WET-ICY, HUMID-ICY ],\n[ ARID-COLD, DRY-COLD, NEUTRAL-COLD, WET-COLD, HUMID-COLD ],\n[ ARID-NEUTRAL, DRY-NEUTRAL, NEUTRAL-NEUTRAL, WET-NEUTRAL, HUMID-NEUTRAL ],\n[ ARID-WARM, DRY-WARM, NEUTRAL-WARM, WET-WARM, HUMID-WARM ],\n[ ARID-HOT, DRY-HOT, NEUTRAL-HOT, WET-HOT, HUMID-HOT ]\n\nAll keys passed in must be valid in the biome registry!\n\"minecraft:the_void\" is invalid as it represents a value of \"NULL(nothing)\" internally.\n";
    protected static final Wrapped<List<List<ResourceKey<Biome>>>> OCEANS_VANILLA = BYGOverworldBiomeSelectors.create("oceans/oceans_vanilla", "Appearing on terrain below sea level, here is the \"ocean_biomes\" layout:\n[ DEEP-ICY, DEEP-COLD, DEEP-NEUTRAL, DEEP-WARM, DEEP-HOT ]\n[ SHALLOW-ICY, SHALLOW-COLD, SHALLOW-NEUTRAL, SHALLOW-WARM, SHALLOW-HOT ],\n\nAll keys passed in must be valid in the biome registry!\n\"minecraft:the_void\" is invalid as it represents a value of \"NULL(nothing)\" internally.\n", new ResourceKey[][]{{Biomes.f_48172_, Biomes.f_48171_, Biomes.f_48225_, Biomes.f_48170_, Biomes.f_48166_}, {Biomes.f_48211_, Biomes.f_48168_, Biomes.f_48174_, Biomes.f_48167_, Biomes.f_48166_}});
    protected static final Wrapped<List<List<ResourceKey<Biome>>>> MIDDLE_BIOMES_VANILLA = BYGOverworldBiomeSelectors.create("middle_biomes/middle_biomes_vanilla", "Appearing on terrain BELOW weirdness 0 or in unfilled(\"NULL(nothing)\") spots in \"middle_biomes_variants\", here is the \"middle_biomes\" layout:\n\n[ ARID-ICY, DRY-ICY, NEUTRAL-ICY, WET-ICY, HUMID-ICY ],\n[ ARID-COLD, DRY-COLD, NEUTRAL-COLD, WET-COLD, HUMID-COLD ],\n[ ARID-NEUTRAL, DRY-NEUTRAL, NEUTRAL-NEUTRAL, WET-NEUTRAL, HUMID-NEUTRAL ],\n[ ARID-WARM, DRY-WARM, NEUTRAL-WARM, WET-WARM, HUMID-WARM ],\n[ ARID-HOT, DRY-HOT, NEUTRAL-HOT, WET-HOT, HUMID-HOT ]\n\nAll keys passed in must be valid in the biome registry!\n\"minecraft:the_void\" is invalid as it represents a value of \"NULL(nothing)\" internally.\n", new ResourceKey[][]{{Biomes.f_186761_, Biomes.f_186761_, Biomes.f_186761_, Biomes.f_48152_, Biomes.f_48206_}, {Biomes.f_48202_, Biomes.f_48202_, Biomes.f_48205_, Biomes.f_48206_, Biomes.f_186764_}, {Biomes.f_48179_, Biomes.f_48202_, Biomes.f_48205_, Biomes.f_48149_, Biomes.f_48151_}, {Biomes.f_48157_, Biomes.f_48157_, Biomes.f_48205_, Biomes.f_48222_, Biomes.f_48222_}, {Biomes.f_48203_, Biomes.f_48203_, Biomes.f_48203_, Biomes.f_48203_, Biomes.f_48203_}});
    protected static final Wrapped<List<List<ResourceKey<Biome>>>> MIDDLE_BIOMES_VARIANT_VANILLA = BYGOverworldBiomeSelectors.create("middle_biomes_variant/middle_biomes_variant_vanilla", MIDDLE_BIOMES_VARIANT_LAYOUT, new ResourceKey[][]{{Biomes.f_48182_, Biomes.f_48173_, Biomes.f_48152_, Biomes.f_48173_, Biomes.f_48173_}, {Biomes.f_48173_, Biomes.f_48173_, Biomes.f_48173_, Biomes.f_48173_, Biomes.f_186763_}, {Biomes.f_48176_, Biomes.f_48173_, Biomes.f_48173_, Biomes.f_186762_, Biomes.f_48173_}, {Biomes.f_48173_, Biomes.f_48173_, Biomes.f_48202_, Biomes.f_186769_, Biomes.f_48197_}, {Biomes.f_48173_, Biomes.f_48173_, Biomes.f_48173_, Biomes.f_48173_, Biomes.f_48173_}});
    public static final Wrapped<List<List<ResourceKey<Biome>>>> PLATEAU_BIOMES_VANILLA = BYGOverworldBiomeSelectors.create("plateau_biomes/plateau_biomes_vanilla", "Appearing on elevated flat terrain BELOW weirdness 0 or in unfilled(\"NULL(nothing)\") spots in \"plateau_biome_variants\", here is the \"plateau_biomes\" layout:\n\n[ ARID-ICY, DRY-ICY, NEUTRAL-ICY, WET-ICY, HUMID-ICY ],\n[ ARID-COLD, DRY-COLD, NEUTRAL-COLD, WET-COLD, HUMID-COLD ],\n[ ARID-NEUTRAL, DRY-NEUTRAL, NEUTRAL-NEUTRAL, WET-NEUTRAL, HUMID-NEUTRAL ],\n[ ARID-WARM, DRY-WARM, NEUTRAL-WARM, WET-WARM, HUMID-WARM ],\n[ ARID-HOT, DRY-HOT, NEUTRAL-HOT, WET-HOT, HUMID-HOT ]\n\nAll keys passed in must be valid in the biome registry!\n\"minecraft:the_void\" is invalid as it represents a value of \"NULL(nothing)\" internally.\n", new ResourceKey[][]{{Biomes.f_186761_, Biomes.f_186761_, Biomes.f_186761_, Biomes.f_48152_, Biomes.f_48152_}, {Biomes.f_186754_, Biomes.f_186754_, Biomes.f_48205_, Biomes.f_48206_, Biomes.f_186764_}, {Biomes.f_186754_, Biomes.f_186754_, Biomes.f_186754_, Biomes.f_186754_, Biomes.f_48151_}, {Biomes.f_48158_, Biomes.f_48158_, Biomes.f_48205_, Biomes.f_48205_, Biomes.f_48222_}, {Biomes.f_48159_, Biomes.f_48159_, Biomes.f_48159_, Biomes.f_186753_, Biomes.f_186753_}});
    protected static final Wrapped<List<List<ResourceKey<Biome>>>> PLATEAU_BIOMES_VARIANT_VANILLA = BYGOverworldBiomeSelectors.create("plateau_biomes_variant/plateau_biomes_variant_vanilla", PLATEAU_BIOMES_VARIANT_LAYOUT, new ResourceKey[][]{{Biomes.f_48182_, Biomes.f_48173_, Biomes.f_48173_, Biomes.f_48173_, Biomes.f_48173_}, {Biomes.f_48173_, Biomes.f_48173_, Biomes.f_186754_, Biomes.f_186754_, Biomes.f_186763_}, {Biomes.f_48173_, Biomes.f_48173_, Biomes.f_48205_, Biomes.f_48149_, Biomes.f_48173_}, {Biomes.f_48173_, Biomes.f_48173_, Biomes.f_48173_, Biomes.f_48173_, Biomes.f_48173_}, {Biomes.f_48194_, Biomes.f_48194_, Biomes.f_48173_, Biomes.f_48173_, Biomes.f_48173_}});
    protected static final Wrapped<List<List<ResourceKey<Biome>>>> PEAK_BIOMES_VANILLA = BYGOverworldBiomeSelectors.create("peak_biomes/peak_biomes_vanilla", "Appearing on mountainous terrain & BELOW weirdness 0, here is the \"peak_biomes\" layout:\n\n[ ARID-ICY, DRY-ICY, NEUTRAL-ICY, WET-ICY, HUMID-ICY ],\n[ ARID-COLD, DRY-COLD, NEUTRAL-COLD, WET-COLD, HUMID-COLD ],\n[ ARID-NEUTRAL, DRY-NEUTRAL, NEUTRAL-NEUTRAL, WET-NEUTRAL, HUMID-NEUTRAL ],\n[ ARID-WARM, DRY-WARM, NEUTRAL-WARM, WET-WARM, HUMID-WARM ],\n[ ARID-HOT, DRY-HOT, NEUTRAL-HOT, WET-HOT, HUMID-HOT ]\n\nAll keys passed in must be valid in the biome registry!\n\"minecraft:the_void\" is invalid as it represents a value of \"NULL(nothing)\" internally.\n", new ResourceKey[][]{{Biomes.f_186758_, Biomes.f_186758_, Biomes.f_186758_, Biomes.f_186758_, Biomes.f_186758_}, {Biomes.f_186758_, Biomes.f_186758_, Biomes.f_186758_, Biomes.f_186758_, Biomes.f_186758_}, {Biomes.f_186758_, Biomes.f_186758_, Biomes.f_186758_, Biomes.f_186758_, Biomes.f_186758_}, {Biomes.f_186759_, Biomes.f_186759_, Biomes.f_186759_, Biomes.f_186759_, Biomes.f_186759_}, {Biomes.f_48194_, Biomes.f_48194_, Biomes.f_48159_, Biomes.f_186753_, Biomes.f_186753_}});
    protected static final Wrapped<List<List<ResourceKey<Biome>>>> SHATTERED_BIOMES_VANILLA = BYGOverworldBiomeSelectors.create("shattered_biomes/shattered_biomes_vanilla", "Appearing on shattered terrain here is the \"shattered_biomes\" layout:\n\n[ ARID-ICY, DRY-ICY, NEUTRAL-ICY, WET-ICY, HUMID-ICY ],\n[ ARID-COLD, DRY-COLD, NEUTRAL-COLD, WET-COLD, HUMID-COLD ],\n[ ARID-NEUTRAL, DRY-NEUTRAL, NEUTRAL-NEUTRAL, WET-NEUTRAL, HUMID-NEUTRAL ],\n[ ARID-WARM, DRY-WARM, NEUTRAL-WARM, WET-WARM, HUMID-WARM ],\n[ ARID-HOT, DRY-HOT, NEUTRAL-HOT, WET-HOT, HUMID-HOT ]\n\nAll keys passed in must be valid in the biome registry!\nIn slots containing \"minecraft:the_void\", biomes at the equivalent temperature/humidity index in \"middle_biomes\" will be used instead.\n", new ResourceKey[][]{{Biomes.f_186766_, Biomes.f_186766_, Biomes.f_186765_, Biomes.f_186767_, Biomes.f_186767_}, {Biomes.f_186766_, Biomes.f_186766_, Biomes.f_186765_, Biomes.f_186767_, Biomes.f_186767_}, {Biomes.f_186765_, Biomes.f_186765_, Biomes.f_186765_, Biomes.f_186767_, Biomes.f_186767_}, {Biomes.f_48173_, Biomes.f_48173_, Biomes.f_48173_, Biomes.f_48173_, Biomes.f_48173_}, {Biomes.f_48173_, Biomes.f_48173_, Biomes.f_48173_, Biomes.f_48173_, Biomes.f_48173_}});
    protected static final Wrapped<List<List<ResourceKey<Biome>>>> BEACH_BIOMES_VANILLA = BYGOverworldBiomeSelectors.create("beach_biomes/beach_biomes_vanilla", "Appearing on terrain bordering oceans, here is the \"beach_biomes\" layout:\n\n[ ARID-ICY, DRY-ICY, NEUTRAL-ICY, WET-ICY, HUMID-ICY ],\n[ ARID-COLD, DRY-COLD, NEUTRAL-COLD, WET-COLD, HUMID-COLD ],\n[ ARID-NEUTRAL, DRY-NEUTRAL, NEUTRAL-NEUTRAL, WET-NEUTRAL, HUMID-NEUTRAL ],\n[ ARID-WARM, DRY-WARM, NEUTRAL-WARM, WET-WARM, HUMID-WARM ],\n[ ARID-HOT, DRY-HOT, NEUTRAL-HOT, WET-HOT, HUMID-HOT ]\n\nAll keys passed in must be valid in the biome registry!\n\"minecraft:the_void\" is invalid as it represents a value of \"NULL(nothing)\" internally.\n", new ResourceKey[][]{{Biomes.f_48148_, Biomes.f_48148_, Biomes.f_48148_, Biomes.f_48148_, Biomes.f_48148_}, {Biomes.f_48217_, Biomes.f_48217_, Biomes.f_48217_, Biomes.f_48217_, Biomes.f_48217_}, {Biomes.f_48217_, Biomes.f_48217_, Biomes.f_48217_, Biomes.f_48217_, Biomes.f_48217_}, {Biomes.f_48217_, Biomes.f_48217_, Biomes.f_48217_, Biomes.f_48217_, Biomes.f_48217_}, {Biomes.f_48203_, Biomes.f_48203_, Biomes.f_48203_, Biomes.f_48203_, Biomes.f_48203_}});
    protected static final Wrapped<List<List<ResourceKey<Biome>>>> PEAK_BIOMES_VARIANT_VANILLA = BYGOverworldBiomeSelectors.create("peak_biomes_variant/peak_biomes_variant_vanilla", PEAK_BIOMES_VARIANT_LAYOUT, new ResourceKey[][]{{Biomes.f_186757_, Biomes.f_186757_, Biomes.f_186757_, Biomes.f_186757_, Biomes.f_186757_}, {Biomes.f_186757_, Biomes.f_186757_, Biomes.f_186757_, Biomes.f_186757_, Biomes.f_186757_}, {Biomes.f_186757_, Biomes.f_186757_, Biomes.f_186757_, BYGBiomes.DACITE_RIDGES, BYGBiomes.DACITE_RIDGES}, {Biomes.f_186759_, Biomes.f_186759_, Biomes.f_186759_, Biomes.f_186759_, Biomes.f_186759_}, {Biomes.f_48159_, Biomes.f_48159_, Biomes.f_48159_, Biomes.f_186753_, Biomes.f_186753_}});
    protected static final Wrapped<List<List<ResourceKey<Biome>>>> BEACH_BIOMES_1 = BYGOverworldBiomeSelectors.create("beach_biomes/beach_biomes_1", "Appearing on terrain bordering oceans, here is the \"beach_biomes\" layout:\n\n[ ARID-ICY, DRY-ICY, NEUTRAL-ICY, WET-ICY, HUMID-ICY ],\n[ ARID-COLD, DRY-COLD, NEUTRAL-COLD, WET-COLD, HUMID-COLD ],\n[ ARID-NEUTRAL, DRY-NEUTRAL, NEUTRAL-NEUTRAL, WET-NEUTRAL, HUMID-NEUTRAL ],\n[ ARID-WARM, DRY-WARM, NEUTRAL-WARM, WET-WARM, HUMID-WARM ],\n[ ARID-HOT, DRY-HOT, NEUTRAL-HOT, WET-HOT, HUMID-HOT ]\n\nAll keys passed in must be valid in the biome registry!\n\"minecraft:the_void\" is invalid as it represents a value of \"NULL(nothing)\" internally.\n", new ResourceKey[][]{{Biomes.f_48148_, Biomes.f_48148_, Biomes.f_48148_, Biomes.f_48148_, Biomes.f_48148_}, {Biomes.f_48217_, Biomes.f_48217_, Biomes.f_48217_, Biomes.f_48217_, Biomes.f_48217_}, {BYGBiomes.BASALT_BARRERA, BYGBiomes.BASALT_BARRERA, BYGBiomes.BASALT_BARRERA, BYGBiomes.BASALT_BARRERA, BYGBiomes.BASALT_BARRERA}, {BYGBiomes.RAINBOW_BEACH, BYGBiomes.RAINBOW_BEACH, BYGBiomes.RAINBOW_BEACH, BYGBiomes.RAINBOW_BEACH, BYGBiomes.RAINBOW_BEACH}, {BYGBiomes.WINDSWEPT_DESERT, BYGBiomes.WINDSWEPT_DESERT, BYGBiomes.WINDSWEPT_DESERT, BYGBiomes.WINDSWEPT_DESERT, BYGBiomes.WINDSWEPT_DESERT}});
    protected static final Wrapped<List<List<ResourceKey<Biome>>>> PEAK_BIOMES_1 = BYGOverworldBiomeSelectors.create("peak_biomes/peak_biomes_1", "Appearing on mountainous terrain & BELOW weirdness 0, here is the \"peak_biomes\" layout:\n\n[ ARID-ICY, DRY-ICY, NEUTRAL-ICY, WET-ICY, HUMID-ICY ],\n[ ARID-COLD, DRY-COLD, NEUTRAL-COLD, WET-COLD, HUMID-COLD ],\n[ ARID-NEUTRAL, DRY-NEUTRAL, NEUTRAL-NEUTRAL, WET-NEUTRAL, HUMID-NEUTRAL ],\n[ ARID-WARM, DRY-WARM, NEUTRAL-WARM, WET-WARM, HUMID-WARM ],\n[ ARID-HOT, DRY-HOT, NEUTRAL-HOT, WET-HOT, HUMID-HOT ]\n\nAll keys passed in must be valid in the biome registry!\n\"minecraft:the_void\" is invalid as it represents a value of \"NULL(nothing)\" internally.\n", new ResourceKey[][]{{BYGBiomes.HOWLING_PEAKS, BYGBiomes.HOWLING_PEAKS, BYGBiomes.HOWLING_PEAKS, BYGBiomes.HOWLING_PEAKS, BYGBiomes.HOWLING_PEAKS}, {BYGBiomes.HOWLING_PEAKS, BYGBiomes.HOWLING_PEAKS, BYGBiomes.HOWLING_PEAKS, BYGBiomes.HOWLING_PEAKS, BYGBiomes.HOWLING_PEAKS}, {BYGBiomes.CANADIAN_SHIELD, BYGBiomes.CANADIAN_SHIELD, BYGBiomes.DACITE_RIDGES, BYGBiomes.DACITE_RIDGES, BYGBiomes.DACITE_RIDGES}, {BYGBiomes.CANADIAN_SHIELD, BYGBiomes.CANADIAN_SHIELD, BYGBiomes.GUIANA_SHIELD, BYGBiomes.GUIANA_SHIELD, BYGBiomes.GUIANA_SHIELD}, {Biomes.f_48194_, Biomes.f_48194_, Biomes.f_48159_, Biomes.f_186753_, Biomes.f_186753_}});
    protected static final Wrapped<List<List<ResourceKey<Biome>>>> SLOPE_BIOMES_VANILLA = BYGOverworldBiomeSelectors.create("slope_biomes/slope_biomes_vanilla", "Appearing on sloped terrain, near mountainous terrain, & BELOW weirdness 0, here is the \"slope_biomes\" layout:\n\n[ ARID-ICY, DRY-ICY, NEUTRAL-ICY, WET-ICY, HUMID-ICY ],\n[ ARID-COLD, DRY-COLD, NEUTRAL-COLD, WET-COLD, HUMID-COLD ],\n[ ARID-NEUTRAL, DRY-NEUTRAL, NEUTRAL-NEUTRAL, WET-NEUTRAL, HUMID-NEUTRAL ],\n[ ARID-WARM, DRY-WARM, NEUTRAL-WARM, WET-WARM, HUMID-WARM ],\n[ ARID-HOT, DRY-HOT, NEUTRAL-HOT, WET-HOT, HUMID-HOT ]\n\nAll keys passed in must be valid in the biome registry!\n\"minecraft:the_void\" is invalid as it represents a value of \"NULL(nothing)\" internally.\n", new ResourceKey[][]{{Biomes.f_186756_, Biomes.f_186756_, Biomes.f_186755_, Biomes.f_186755_, Biomes.f_186755_}, {Biomes.f_186756_, Biomes.f_186756_, Biomes.f_186755_, Biomes.f_186755_, Biomes.f_186755_}, {Biomes.f_186756_, Biomes.f_186756_, Biomes.f_186755_, Biomes.f_186755_, Biomes.f_186755_}, {Biomes.f_48158_, Biomes.f_48158_, Biomes.f_48205_, Biomes.f_48205_, Biomes.f_48222_}, {Biomes.f_48159_, Biomes.f_48159_, Biomes.f_48159_, Biomes.f_186753_, Biomes.f_186753_}});
    protected static final Wrapped<List<List<ResourceKey<Biome>>>> SLOPE_BIOMES_1 = BYGOverworldBiomeSelectors.create("slope_biomes/slope_biomes_1", "Appearing on sloped terrain, near mountainous terrain, & BELOW weirdness 0, here is the \"slope_biomes\" layout:\n\n[ ARID-ICY, DRY-ICY, NEUTRAL-ICY, WET-ICY, HUMID-ICY ],\n[ ARID-COLD, DRY-COLD, NEUTRAL-COLD, WET-COLD, HUMID-COLD ],\n[ ARID-NEUTRAL, DRY-NEUTRAL, NEUTRAL-NEUTRAL, WET-NEUTRAL, HUMID-NEUTRAL ],\n[ ARID-WARM, DRY-WARM, NEUTRAL-WARM, WET-WARM, HUMID-WARM ],\n[ ARID-HOT, DRY-HOT, NEUTRAL-HOT, WET-HOT, HUMID-HOT ]\n\nAll keys passed in must be valid in the biome registry!\n\"minecraft:the_void\" is invalid as it represents a value of \"NULL(nothing)\" internally.\n", new ResourceKey[][]{{BYGBiomes.HOWLING_PEAKS, BYGBiomes.HOWLING_PEAKS, BYGBiomes.HOWLING_PEAKS, BYGBiomes.HOWLING_PEAKS, BYGBiomes.HOWLING_PEAKS}, {BYGBiomes.HOWLING_PEAKS, BYGBiomes.HOWLING_PEAKS, BYGBiomes.HOWLING_PEAKS, BYGBiomes.HOWLING_PEAKS, BYGBiomes.HOWLING_PEAKS}, {BYGBiomes.CANADIAN_SHIELD, BYGBiomes.CANADIAN_SHIELD, BYGBiomes.DACITE_RIDGES, BYGBiomes.DACITE_RIDGES, BYGBiomes.DACITE_RIDGES}, {BYGBiomes.CANADIAN_SHIELD, BYGBiomes.CANADIAN_SHIELD, BYGBiomes.GUIANA_SHIELD, BYGBiomes.GUIANA_SHIELD, BYGBiomes.GUIANA_SHIELD}, {Biomes.f_48159_, Biomes.f_48159_, Biomes.f_48159_, Biomes.f_186753_, Biomes.f_186753_}});
    protected static final Wrapped<List<List<ResourceKey<Biome>>>> SLOPE_BIOMES_VARIANT_VANILLA = BYGOverworldBiomeSelectors.create("slope_biomes_variant/slope_biomes_variant_vanilla", SLOPE_BIOMES_VARIANT_LAYOUT, new ResourceKey[][]{{Biomes.f_186756_, Biomes.f_186756_, Biomes.f_186755_, Biomes.f_186755_, Biomes.f_186755_}, {Biomes.f_186756_, Biomes.f_186756_, Biomes.f_186755_, Biomes.f_186755_, Biomes.f_186755_}, {Biomes.f_186756_, Biomes.f_186756_, Biomes.f_186755_, Biomes.f_186755_, Biomes.f_186755_}, {Biomes.f_48173_, Biomes.f_48173_, Biomes.f_48173_, Biomes.f_48173_, Biomes.f_48173_}, {Biomes.f_48194_, Biomes.f_48194_, Biomes.f_48173_, Biomes.f_48173_, Biomes.f_48173_}});
    public static final Wrapped<List<List<ResourceKey<Biome>>>> OCEANS = BYGOverworldBiomeSelectors.create("oceans/oceans_1", "Appearing on terrain below sea level, here is the \"ocean_biomes\" layout:\n[ DEEP-ICY, DEEP-COLD, DEEP-NEUTRAL, DEEP-WARM, DEEP-HOT ]\n[ SHALLOW-ICY, SHALLOW-COLD, SHALLOW-NEUTRAL, SHALLOW-WARM, SHALLOW-HOT ],\n\nAll keys passed in must be valid in the biome registry!\n\"minecraft:the_void\" is invalid as it represents a value of \"NULL(nothing)\" internally.\n", new ResourceKey[][]{{Biomes.f_48172_, Biomes.f_48168_, Biomes.f_48174_, BYGBiomes.LUSH_STACKS, BYGBiomes.DEAD_SEA}, {Biomes.f_48211_, Biomes.f_48168_, Biomes.f_48174_, BYGBiomes.LUSH_STACKS, BYGBiomes.DEAD_SEA}});
    protected static final Wrapped<List<List<ResourceKey<Biome>>>> MIDDLE_BIOMES_1 = BYGOverworldBiomeSelectors.create("middle_biomes/middle_biomes_1", "Appearing on terrain BELOW weirdness 0 or in unfilled(\"NULL(nothing)\") spots in \"middle_biomes_variants\", here is the \"middle_biomes\" layout:\n\n[ ARID-ICY, DRY-ICY, NEUTRAL-ICY, WET-ICY, HUMID-ICY ],\n[ ARID-COLD, DRY-COLD, NEUTRAL-COLD, WET-COLD, HUMID-COLD ],\n[ ARID-NEUTRAL, DRY-NEUTRAL, NEUTRAL-NEUTRAL, WET-NEUTRAL, HUMID-NEUTRAL ],\n[ ARID-WARM, DRY-WARM, NEUTRAL-WARM, WET-WARM, HUMID-WARM ],\n[ ARID-HOT, DRY-HOT, NEUTRAL-HOT, WET-HOT, HUMID-HOT ]\n\nAll keys passed in must be valid in the biome registry!\n\"minecraft:the_void\" is invalid as it represents a value of \"NULL(nothing)\" internally.\n", new ResourceKey[][]{{BYGBiomes.SHATTERED_GLACIER, BYGBiomes.CARDINAL_TUNDRA, BYGBiomes.CARDINAL_TUNDRA, BYGBiomes.SKYRIS_VALE, BYGBiomes.SKYRIS_VALE}, {BYGBiomes.ROSE_FIELDS, BYGBiomes.WEEPING_WITCH_FOREST, BYGBiomes.TWILIGHT_MEADOW, BYGBiomes.AUTUMNAL_VALLEY, BYGBiomes.CIKA_WOODS}, {BYGBiomes.FORGOTTEN_FOREST, BYGBiomes.PRAIRIE, BYGBiomes.ALLIUM_FIELDS, BYGBiomes.ASPEN_FOREST, BYGBiomes.TEMPERATE_RAINFOREST}, {BYGBiomes.ARAUCARIA_SAVANNA, BYGBiomes.BAOBAB_SAVANNA, BYGBiomes.CHERRY_BLOSSOM_FOREST, BYGBiomes.EBONY_WOODS, BYGBiomes.JACARANDA_FOREST}, {BYGBiomes.ATACAMA_DESERT, BYGBiomes.RED_ROCK_VALLEY, BYGBiomes.MOJAVE_DESERT, BYGBiomes.SIERRA_BADLANDS, BYGBiomes.WINDSWEPT_DESERT}});
    protected static final Wrapped<List<List<ResourceKey<Biome>>>> MIDDLE_BIOMES_2 = BYGOverworldBiomeSelectors.create("middle_biomes/middle_biomes_2", "Appearing on terrain BELOW weirdness 0 or in unfilled(\"NULL(nothing)\") spots in \"middle_biomes_variants\", here is the \"middle_biomes\" layout:\n\n[ ARID-ICY, DRY-ICY, NEUTRAL-ICY, WET-ICY, HUMID-ICY ],\n[ ARID-COLD, DRY-COLD, NEUTRAL-COLD, WET-COLD, HUMID-COLD ],\n[ ARID-NEUTRAL, DRY-NEUTRAL, NEUTRAL-NEUTRAL, WET-NEUTRAL, HUMID-NEUTRAL ],\n[ ARID-WARM, DRY-WARM, NEUTRAL-WARM, WET-WARM, HUMID-WARM ],\n[ ARID-HOT, DRY-HOT, NEUTRAL-HOT, WET-HOT, HUMID-HOT ]\n\nAll keys passed in must be valid in the biome registry!\n\"minecraft:the_void\" is invalid as it represents a value of \"NULL(nothing)\" internally.\n", new ResourceKey[][]{{BYGBiomes.FROSTED_CONIFEROUS_FOREST, BYGBiomes.FROSTED_CONIFEROUS_FOREST, BYGBiomes.FROSTED_TAIGA, BYGBiomes.AUTUMNAL_FOREST, BYGBiomes.AUTUMNAL_TAIGA}, {BYGBiomes.WEEPING_WITCH_FOREST, BYGBiomes.FRAGMENT_FOREST, BYGBiomes.ZELKOVA_FOREST, BYGBiomes.COCONINO_MEADOW, BYGBiomes.REDWOOD_THICKET}, {BYGBiomes.GROVE, BYGBiomes.ORCHARD, BYGBiomes.ORCHARD, BYGBiomes.RED_OAK_FOREST, BYGBiomes.JACARANDA_FOREST}, {BYGBiomes.FIRECRACKER_SHRUBLAND, BYGBiomes.FIRECRACKER_SHRUBLAND, BYGBiomes.AMARANTH_FIELDS, BYGBiomes.CRAG_GARDENS, BYGBiomes.TROPICAL_RAINFOREST}, {BYGBiomes.ATACAMA_DESERT, BYGBiomes.ATACAMA_DESERT, BYGBiomes.SIERRA_BADLANDS, BYGBiomes.ATACAMA_DESERT, BYGBiomes.MOJAVE_DESERT}});
    protected static final Wrapped<List<List<ResourceKey<Biome>>>> MIDDLE_BIOMES_3 = BYGOverworldBiomeSelectors.create("middle_biomes/middle_biomes_3", "Appearing on terrain BELOW weirdness 0 or in unfilled(\"NULL(nothing)\") spots in \"middle_biomes_variants\", here is the \"middle_biomes\" layout:\n\n[ ARID-ICY, DRY-ICY, NEUTRAL-ICY, WET-ICY, HUMID-ICY ],\n[ ARID-COLD, DRY-COLD, NEUTRAL-COLD, WET-COLD, HUMID-COLD ],\n[ ARID-NEUTRAL, DRY-NEUTRAL, NEUTRAL-NEUTRAL, WET-NEUTRAL, HUMID-NEUTRAL ],\n[ ARID-WARM, DRY-WARM, NEUTRAL-WARM, WET-WARM, HUMID-WARM ],\n[ ARID-HOT, DRY-HOT, NEUTRAL-HOT, WET-HOT, HUMID-HOT ]\n\nAll keys passed in must be valid in the biome registry!\n\"minecraft:the_void\" is invalid as it represents a value of \"NULL(nothing)\" internally.\n", new ResourceKey[][]{{BYGBiomes.SHATTERED_GLACIER, BYGBiomes.CARDINAL_TUNDRA, BYGBiomes.BOREALIS_GROVE, BYGBiomes.BOREALIS_GROVE, BYGBiomes.BLACK_FOREST}, {BYGBiomes.COCONINO_MEADOW, BYGBiomes.MAPLE_TAIGA, BYGBiomes.MAPLE_TAIGA, BYGBiomes.COCONINO_MEADOW, BYGBiomes.CONIFEROUS_FOREST}, {BYGBiomes.GROVE, BYGBiomes.PRAIRIE, BYGBiomes.ALLIUM_FIELDS, BYGBiomes.ASPEN_FOREST, BYGBiomes.DACITE_RIDGES}, {BYGBiomes.BAOBAB_SAVANNA, BYGBiomes.ARAUCARIA_SAVANNA, BYGBiomes.CHERRY_BLOSSOM_FOREST, BYGBiomes.EBONY_WOODS, BYGBiomes.TROPICAL_RAINFOREST}, {BYGBiomes.ATACAMA_DESERT, BYGBiomes.WINDSWEPT_DESERT, BYGBiomes.WINDSWEPT_DESERT, BYGBiomes.MOJAVE_DESERT, BYGBiomes.RED_ROCK_VALLEY}});
    protected static final Wrapped<List<List<ResourceKey<Biome>>>> PLATEAU_BIOMES_1 = BYGOverworldBiomeSelectors.create("plateau_biomes/plateau_biomes_1", "Appearing on elevated flat terrain BELOW weirdness 0 or in unfilled(\"NULL(nothing)\") spots in \"plateau_biome_variants\", here is the \"plateau_biomes\" layout:\n\n[ ARID-ICY, DRY-ICY, NEUTRAL-ICY, WET-ICY, HUMID-ICY ],\n[ ARID-COLD, DRY-COLD, NEUTRAL-COLD, WET-COLD, HUMID-COLD ],\n[ ARID-NEUTRAL, DRY-NEUTRAL, NEUTRAL-NEUTRAL, WET-NEUTRAL, HUMID-NEUTRAL ],\n[ ARID-WARM, DRY-WARM, NEUTRAL-WARM, WET-WARM, HUMID-WARM ],\n[ ARID-HOT, DRY-HOT, NEUTRAL-HOT, WET-HOT, HUMID-HOT ]\n\nAll keys passed in must be valid in the biome registry!\n\"minecraft:the_void\" is invalid as it represents a value of \"NULL(nothing)\" internally.\n", new ResourceKey[][]{{BYGBiomes.FROSTED_CONIFEROUS_FOREST, BYGBiomes.CARDINAL_TUNDRA, BYGBiomes.FROSTED_TAIGA, BYGBiomes.BOREALIS_GROVE, BYGBiomes.BLACK_FOREST}, {BYGBiomes.WEEPING_WITCH_FOREST, BYGBiomes.COCONINO_MEADOW, BYGBiomes.ZELKOVA_FOREST, BYGBiomes.CANADIAN_SHIELD, BYGBiomes.SKYRIS_VALE}, {BYGBiomes.GROVE, BYGBiomes.ORCHARD, BYGBiomes.ASPEN_FOREST, BYGBiomes.RED_OAK_FOREST, BYGBiomes.DACITE_RIDGES}, {BYGBiomes.BAOBAB_SAVANNA, BYGBiomes.ARAUCARIA_SAVANNA, BYGBiomes.EBONY_WOODS, BYGBiomes.TROPICAL_RAINFOREST, BYGBiomes.GUIANA_SHIELD}, {BYGBiomes.FIRECRACKER_SHRUBLAND, BYGBiomes.SIERRA_BADLANDS, BYGBiomes.SIERRA_BADLANDS, BYGBiomes.RED_ROCK_VALLEY, BYGBiomes.RED_ROCK_VALLEY}});
    protected static final Wrapped<List<List<ResourceKey<Biome>>>> PLATEAU_BIOMES_2 = BYGOverworldBiomeSelectors.create("plateau_biomes/plateau_biomes_2", "Appearing on elevated flat terrain BELOW weirdness 0 or in unfilled(\"NULL(nothing)\") spots in \"plateau_biome_variants\", here is the \"plateau_biomes\" layout:\n\n[ ARID-ICY, DRY-ICY, NEUTRAL-ICY, WET-ICY, HUMID-ICY ],\n[ ARID-COLD, DRY-COLD, NEUTRAL-COLD, WET-COLD, HUMID-COLD ],\n[ ARID-NEUTRAL, DRY-NEUTRAL, NEUTRAL-NEUTRAL, WET-NEUTRAL, HUMID-NEUTRAL ],\n[ ARID-WARM, DRY-WARM, NEUTRAL-WARM, WET-WARM, HUMID-WARM ],\n[ ARID-HOT, DRY-HOT, NEUTRAL-HOT, WET-HOT, HUMID-HOT ]\n\nAll keys passed in must be valid in the biome registry!\n\"minecraft:the_void\" is invalid as it represents a value of \"NULL(nothing)\" internally.\n", new ResourceKey[][]{{BYGBiomes.FROSTED_CONIFEROUS_FOREST, BYGBiomes.CARDINAL_TUNDRA, BYGBiomes.FROSTED_TAIGA, BYGBiomes.BOREALIS_GROVE, BYGBiomes.BLACK_FOREST}, {BYGBiomes.ROSE_FIELDS, BYGBiomes.COCONINO_MEADOW, BYGBiomes.TWILIGHT_MEADOW, BYGBiomes.CANADIAN_SHIELD, BYGBiomes.SKYRIS_VALE}, {BYGBiomes.GROVE, BYGBiomes.ORCHARD, BYGBiomes.ASPEN_FOREST, BYGBiomes.ALLIUM_FIELDS, BYGBiomes.DACITE_RIDGES}, {BYGBiomes.BAOBAB_SAVANNA, BYGBiomes.ARAUCARIA_SAVANNA, BYGBiomes.EBONY_WOODS, BYGBiomes.AMARANTH_FIELDS, BYGBiomes.GUIANA_SHIELD}, {BYGBiomes.FIRECRACKER_SHRUBLAND, BYGBiomes.SIERRA_BADLANDS, BYGBiomes.SIERRA_BADLANDS, BYGBiomes.RED_ROCK_VALLEY, BYGBiomes.RED_ROCK_VALLEY}});
    protected static final Wrapped<List<List<ResourceKey<Biome>>>> PLATEAU_BIOMES_3 = BYGOverworldBiomeSelectors.create("plateau_biomes/plateau_biomes_3", "Appearing on elevated flat terrain BELOW weirdness 0 or in unfilled(\"NULL(nothing)\") spots in \"plateau_biome_variants\", here is the \"plateau_biomes\" layout:\n\n[ ARID-ICY, DRY-ICY, NEUTRAL-ICY, WET-ICY, HUMID-ICY ],\n[ ARID-COLD, DRY-COLD, NEUTRAL-COLD, WET-COLD, HUMID-COLD ],\n[ ARID-NEUTRAL, DRY-NEUTRAL, NEUTRAL-NEUTRAL, WET-NEUTRAL, HUMID-NEUTRAL ],\n[ ARID-WARM, DRY-WARM, NEUTRAL-WARM, WET-WARM, HUMID-WARM ],\n[ ARID-HOT, DRY-HOT, NEUTRAL-HOT, WET-HOT, HUMID-HOT ]\n\nAll keys passed in must be valid in the biome registry!\n\"minecraft:the_void\" is invalid as it represents a value of \"NULL(nothing)\" internally.\n", new ResourceKey[][]{{BYGBiomes.FROSTED_CONIFEROUS_FOREST, BYGBiomes.CARDINAL_TUNDRA, BYGBiomes.FROSTED_TAIGA, BYGBiomes.BOREALIS_GROVE, BYGBiomes.BLACK_FOREST}, {BYGBiomes.ROSE_FIELDS, BYGBiomes.COCONINO_MEADOW, BYGBiomes.TWILIGHT_MEADOW, BYGBiomes.CANADIAN_SHIELD, BYGBiomes.SKYRIS_VALE}, {BYGBiomes.GROVE, BYGBiomes.ORCHARD, BYGBiomes.ASPEN_FOREST, BYGBiomes.ALLIUM_FIELDS, BYGBiomes.DACITE_RIDGES}, {BYGBiomes.BAOBAB_SAVANNA, BYGBiomes.ARAUCARIA_SAVANNA, BYGBiomes.EBONY_WOODS, BYGBiomes.AMARANTH_FIELDS, BYGBiomes.GUIANA_SHIELD}, {BYGBiomes.FIRECRACKER_SHRUBLAND, BYGBiomes.SIERRA_BADLANDS, BYGBiomes.SIERRA_BADLANDS, BYGBiomes.RED_ROCK_VALLEY, BYGBiomes.RED_ROCK_VALLEY}});

    private static String invalidKeysOkay(String fallback) {
        return String.format("All keys passed in must be valid in the biome registry!\nIn slots containing \"minecraft:the_void\", biomes at the equivalent temperature/humidity index in \"%s\" will be used instead.\n", fallback);
    }

    protected static Wrapped<List<List<ResourceKey<Biome>>>> create(String id, String header, ResourceKey<Biome>[][] biomeKeys) {
        return BYGOverworldBiomeSelectors.create(id, biomeKeys, (Map<String, String>)ImmutableMap.of((Object)"", (Object)("/*\nThis file uses the \".json5\" file extension which allows for comments like this in a json file!\nYour text editor may show this file with invalid/no syntax, if so, we recommend you download:\n\nVSCode: https://code.visualstudio.com/\nJSON5 plugin(for VSCode): https://marketplace.visualstudio.com/items?itemName=mrmlnc.vscode-json5\n\nto make editing this file much easier.\n" + header + "*/")));
    }

    protected static Wrapped<List<List<ResourceKey<Biome>>>> create(String id, ResourceKey<Biome>[][] biomeKeys) {
        return BYGOverworldBiomeSelectors.create(id, biomeKeys, new HashMap<String, String>());
    }

    protected static Wrapped<List<List<ResourceKey<Biome>>>> create(String id, ResourceKey<Biome>[][] biomeKeys, Map<String, String> comments) {
        Wrapped result = new Wrapped(Optional.of(id), BYGUtil.convert2DArray(biomeKeys));
        BIOME_LAYOUTS.put(id, (Pair<Map<String, String>, Wrapped<List<List<ResourceKey<Biome>>>>>)Pair.of(comments, (Object)result));
        return result;
    }
}

