/*
 * Decompiled with CFR 0.152.
 */
package potionstudios.byg.common.entity.pumpkinwarden;

import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.behavior.BehaviorUtils;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MoveToBlockGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.AttachedStemBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.StemGrownBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;

public class PumpkinWarden
extends PathfinderMob
implements IAnimatable {
    private final AnimationFactory factory = new AnimationFactory((IAnimatable)this);
    private BlockPos jukebox;
    private boolean party;
    private static final EntityDataAccessor<Boolean> HIDING = SynchedEntityData.m_135353_(PumpkinWarden.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> TIMER = SynchedEntityData.m_135353_(PumpkinWarden.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Optional<BlockState>> DATA_CARRY_STATE = SynchedEntityData.m_135353_(PumpkinWarden.class, (EntityDataSerializer)EntityDataSerializers.f_135034_);

    public PumpkinWarden(EntityType<? extends PathfinderMob> $$0, Level $$1) {
        super($$0, $$1);
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(DATA_CARRY_STATE, Optional.empty());
        this.f_19804_.m_135372_(HIDING, (Object)false);
        this.f_19804_.m_135372_(TIMER, (Object)0);
        super.m_8097_();
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 10.0).m_22268_(Attributes.f_22279_, 0.4);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(3, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(4, (Goal)new TemptGoal((PathfinderMob)this, 1.2, Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42687_}), false));
        this.f_21345_.m_25352_(7, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 2.0f));
        this.f_21345_.m_25352_(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(2, (Goal)new PumpkinWardenLeaveBlockGoal(this, 1.0, 32, 5));
        this.f_21345_.m_25352_(1, (Goal)new PumpkinWardenTakeBlockGoal(this, 1.0, 32, 5));
        this.f_21345_.m_25352_(0, (Goal)new AvoidEntityGoal<Zombie>((PathfinderMob)this, Zombie.class, 8.0f, 1.0, 1.0){

            public boolean m_8045_() {
                if (((PumpkinWarden)this.f_25015_).isHiding()) {
                    return false;
                }
                return super.m_8045_();
            }
        });
        this.f_21345_.m_25352_(3, (Goal)new StayByBellGoal(this, 1.0, 5000));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        super.m_8099_();
    }

    public boolean m_6785_(double $$0) {
        return false;
    }

    public void m_6043_() {
    }

    private <E extends IAnimatable> PlayState predicate(AnimationEvent<E> event) {
        AnimationController controller = event.getController();
        controller.transitionLengthTicks = 0.0;
        if (this.isHiding()) {
            if (this.getTimer() < 10) {
                controller.setAnimation(new AnimationBuilder().addAnimation("animation.pumpkinwarden.hidestart", Boolean.valueOf(false)));
                return PlayState.CONTINUE;
            }
            if (this.getTimer() > 10 && this.getTimer() < 180 || !this.f_19853_.m_46461_() && this.getTimer() > 10) {
                controller.setAnimation(new AnimationBuilder().addAnimation("animation.pumpkinwarden.hide", Boolean.valueOf(true)));
                return PlayState.CONTINUE;
            }
            if (this.getTimer() > 180) {
                if (this.f_19853_.m_45517_(LightLayer.SKY, this.m_20097_()) > 2) {
                    controller.setAnimation(new AnimationBuilder().addAnimation("animation.pumpkinwarden.hideend", Boolean.valueOf(false)));
                } else {
                    controller.setAnimation(new AnimationBuilder().addAnimation("animation.pumpkinwarden.hide", Boolean.valueOf(true)));
                }
                return PlayState.CONTINUE;
            }
        }
        if (this.getCarriedBlock() != null) {
            if (event.isMoving()) {
                controller.setAnimation(new AnimationBuilder().addAnimation("animation.pumpkinwarden.holding_walking", Boolean.valueOf(true)));
            } else {
                controller.setAnimation(new AnimationBuilder().addAnimation("animation.pumpkinwarden.holding_idle", Boolean.valueOf(true)));
            }
            return PlayState.CONTINUE;
        }
        if (event.isMoving() && this.getCarriedBlock() == null) {
            controller.setAnimation(new AnimationBuilder().addAnimation("animation.pumpkinwarden.walking", Boolean.valueOf(true)));
            return PlayState.CONTINUE;
        }
        if (this.party) {
            controller.setAnimation(new AnimationBuilder().addAnimation("animation.pumpkinwarden.wave", Boolean.valueOf(true)));
            return PlayState.CONTINUE;
        }
        return PlayState.STOP;
    }

    public void m_6818_(BlockPos pPos, boolean pIsPartying) {
        this.jukebox = pPos;
        this.party = pIsPartying;
    }

    public void m_8107_() {
        super.m_8107_();
        if (this.jukebox == null || !this.jukebox.m_203195_((Position)this.m_20182_(), 10.0) || !this.f_19853_.m_8055_(this.jukebox).m_60713_(Blocks.f_50131_)) {
            this.party = false;
            this.jukebox = null;
        }
        if (!this.f_19853_.f_46443_) {
            if (!this.f_19853_.m_46461_()) {
                this.setTimer(this.getTimer() + 1);
                this.setHiding(true);
            } else if (this.getTimer() > 0 && this.m_21188_() == null) {
                this.setTimer(0);
                this.setHiding(false);
            }
            if (this.m_21188_() != null) {
                if (this.getTimer() < 200) {
                    this.setTimer(this.getTimer() + 1);
                    this.setHiding(true);
                } else {
                    this.setTimer(0);
                    this.setHiding(false);
                }
            }
        }
        if (this.isHiding()) {
            this.m_20334_(0.0, this.m_20184_().m_7098_(), 0.0);
            this.m_19915_(0.0f, 0.0f);
            if (this.getCarriedBlock() != null) {
                BehaviorUtils.m_22613_((LivingEntity)this, (ItemStack)this.getCarriedBlock().m_60734_().m_5456_().m_7968_(), (Vec3)new Vec3(this.m_20185_() + 2.0, this.m_20186_(), this.m_20189_()));
                this.setCarriedBlock(null);
            }
        }
        if (this.getCarriedBlock() != null) {
            this.m_21008_(this.m_7655_(), this.getCarriedBlock().m_60734_().m_5456_().m_7968_());
        } else {
            this.m_21008_(this.m_7655_(), ItemStack.f_41583_);
        }
    }

    public boolean m_6573_(Player $$0) {
        return true;
    }

    @Nullable
    protected SoundEvent m_7515_() {
        return SoundEvents.f_12503_;
    }

    @Nullable
    protected SoundEvent m_7975_(DamageSource $$0) {
        return SoundEvents.f_12506_;
    }

    @Nullable
    protected SoundEvent m_5592_() {
        return SoundEvents.f_12505_;
    }

    public float m_6100_() {
        return (this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.2f + 1.5f;
    }

    public void registerControllers(AnimationData data) {
        data.addAnimationController(new AnimationController((IAnimatable)this, "controller", 0.0f, this::predicate));
    }

    public boolean isHiding() {
        return (Boolean)this.f_19804_.m_135370_(HIDING);
    }

    public void setHiding(boolean flag) {
        this.f_19804_.m_135381_(HIDING, (Object)flag);
    }

    public int getTimer() {
        return (Integer)this.f_19804_.m_135370_(TIMER);
    }

    public void setTimer(int flag) {
        this.f_19804_.m_135381_(TIMER, (Object)flag);
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }

    public void setCarriedBlock(@javax.annotation.Nullable BlockState pState) {
        this.f_19804_.m_135381_(DATA_CARRY_STATE, Optional.ofNullable(pState));
    }

    @javax.annotation.Nullable
    public BlockState getCarriedBlock() {
        return ((Optional)this.f_19804_.m_135370_(DATA_CARRY_STATE)).orElse(null);
    }

    static class PumpkinWardenLeaveBlockGoal
    extends MoveToBlockGoal {
        public PumpkinWarden warden;

        public PumpkinWardenLeaveBlockGoal(PumpkinWarden warden, double speed, int range, int y) {
            super((PathfinderMob)warden, speed, range, y);
            this.warden = warden;
        }

        public double m_8052_() {
            return 8.0;
        }

        protected int m_6099_(PathfinderMob $$0) {
            return 0;
        }

        public boolean m_8045_() {
            return this.warden.getCarriedBlock() != null;
        }

        public boolean m_8036_() {
            if (this.warden.getCarriedBlock() == null) {
                return false;
            }
            return super.m_8036_();
        }

        public void m_8037_() {
            super.m_8037_();
            if (this.m_25625_() && this.warden.getCarriedBlock() != null) {
                BehaviorUtils.m_22613_((LivingEntity)this.warden, (ItemStack)this.warden.getCarriedBlock().m_60734_().m_5456_().m_7968_(), (Vec3)new Vec3((double)this.f_25602_.m_123341_(), (double)this.f_25602_.m_123342_(), (double)this.f_25602_.m_123343_()));
                this.warden.setCarriedBlock(null);
                this.m_8041_();
            }
        }

        protected boolean m_6465_(LevelReader var1, BlockPos var2) {
            BlockState pos = var1.m_8055_(var2);
            return pos.m_60713_(Blocks.f_50143_);
        }
    }

    static class PumpkinWardenTakeBlockGoal
    extends MoveToBlockGoal {
        private final PumpkinWarden warden;

        public PumpkinWardenTakeBlockGoal(PumpkinWarden p, double speed, int range, int y) {
            super((PathfinderMob)p, speed, range, y);
            this.warden = p;
        }

        public boolean m_8036_() {
            if (this.warden.getCarriedBlock() != null) {
                return false;
            }
            return super.m_8036_();
        }

        public double m_8052_() {
            return 1.7;
        }

        protected int m_6099_(PathfinderMob $$0) {
            return 0;
        }

        public void m_8037_() {
            Level level;
            BlockState blockstate;
            Block block;
            super.m_8037_();
            if (this.m_25625_() && (block = (blockstate = (level = this.warden.f_19853_).m_8055_(this.f_25602_)).m_60734_()) instanceof StemGrownBlock) {
                StemGrownBlock block2 = (StemGrownBlock)block;
                level.m_7471_(this.f_25602_, false);
                level.m_220407_(GameEvent.f_157794_, this.f_25602_, GameEvent.Context.m_223719_((Entity)this.warden, (BlockState)blockstate));
                this.warden.setCarriedBlock(blockstate.m_60734_().m_49966_());
            }
        }

        protected boolean m_6465_(LevelReader level, BlockPos pos) {
            if (level.m_8055_(pos).m_60713_(Blocks.f_50133_)) {
                return level.m_8055_(pos.m_5487_(Direction.Axis.X, 1)).m_60734_() instanceof AttachedStemBlock || level.m_8055_(pos.m_5487_(Direction.Axis.Z, 1)).m_60734_() instanceof AttachedStemBlock;
            }
            if (level.m_8055_(pos).m_60713_(Blocks.f_50186_)) {
                return level.m_8055_(pos.m_5487_(Direction.Axis.X, 1)).m_60734_() instanceof AttachedStemBlock || level.m_8055_(pos.m_5487_(Direction.Axis.Z, 1)).m_60734_() instanceof AttachedStemBlock;
            }
            return false;
        }
    }

    static class StayByBellGoal
    extends MoveToBlockGoal {
        public PumpkinWarden warden;

        public StayByBellGoal(PumpkinWarden warden, double $$1, int $$2) {
            super((PathfinderMob)warden, $$1, $$2, 12);
            this.warden = warden;
        }

        protected boolean m_6465_(LevelReader world, BlockPos var2) {
            List blockStates = world.m_45556_(new AABB(this.warden.m_20183_()).m_82400_(30.0)).toList();
            return !((BlockState)blockStates.get(this.warden.f_19796_.m_188503_(blockStates.size()))).m_60795_();
        }
    }
}

