/*
 * Decompiled with CFR 0.152.
 */
package potionstudios.byg.common.entity.manowar;

import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.TryFindWaterGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Bucketable;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import potionstudios.byg.common.entity.BYGEntities;
import potionstudios.byg.common.item.BYGItems;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;

public class ManOWar
extends Animal
implements IAnimatable,
Bucketable {
    private final AnimationFactory factory = new AnimationFactory((IAnimatable)this);
    private static final EntityDataAccessor<Integer> COLOR = SynchedEntityData.m_135353_(ManOWar.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> FROM_BUCKET = SynchedEntityData.m_135353_(ManOWar.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public float xBodyRot;
    public float xBodyRotO;
    public float zBodyRot;
    public float zBodyRotO;
    public float tentacleMovement;
    public float oldTentacleMovement;
    public float tentacleAngle;
    public float oldTentacleAngle;
    private float speed;
    private float tentacleSpeed;
    private float rotateSpeed;
    private float tx;
    private float ty;
    private float tz;
    public boolean glowLayer = false;

    public ManOWar(EntityType<? extends ManOWar> entityType, Level level) {
        super(entityType, level);
        this.m_21441_(BlockPathTypes.WATER, 0.0f);
        this.tentacleSpeed = 1.0f / (this.f_19796_.m_188501_() + 1.0f) * 0.2f;
    }

    public boolean m_6040_() {
        return true;
    }

    public MobType m_6336_() {
        return MobType.f_21644_;
    }

    public boolean m_6914_(LevelReader $$0) {
        return $$0.m_45784_((Entity)this);
    }

    public int m_8100_() {
        return 120;
    }

    public int m_213860_() {
        return 1 + this.f_19853_.f_46441_.m_188503_(3);
    }

    protected void handleAirSupply(int $$0) {
        if (this.m_6084_() && !this.m_20072_()) {
            this.m_20301_($$0 - 1);
            if (this.m_20146_() == -20) {
                this.m_20301_(0);
                this.m_6469_(DamageSource.f_19312_, 2.0f);
            }
        } else {
            this.m_20301_(300);
        }
    }

    public boolean m_6898_(ItemStack stack) {
        return stack.m_150930_(Items.f_42528_);
    }

    public void m_6075_() {
        int $$0 = this.m_20146_();
        super.m_6075_();
        this.handleAirSupply($$0);
    }

    public boolean m_6063_() {
        return false;
    }

    public boolean m_6573_(Player $$0) {
        return false;
    }

    public static boolean checkManOWarSpawnRules(EntityType<? extends ManOWar> entity, LevelAccessor world, MobSpawnType spawnType, BlockPos pos, RandomSource rand) {
        int i = world.m_5736_();
        int j = i - 13;
        return pos.m_123342_() >= j && pos.m_123342_() <= i && world.m_6425_(pos.m_7495_()).m_205070_(FluidTags.f_13131_) && world.m_8055_(pos.m_7494_()).m_60713_(Blocks.f_49990_);
    }

    public int m_6062_() {
        return 6000;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 10.0).m_22268_(Attributes.f_22279_, (double)1.2f).m_22268_(Attributes.f_22281_, 3.0);
    }

    public InteractionResult m_6071_(Player $$0, InteractionHand $$1) {
        if (this.m_6162_()) {
            return Bucketable.m_148828_((Player)$$0, (InteractionHand)$$1, (LivingEntity)this).orElse(super.m_6071_($$0, $$1));
        }
        return super.m_6071_($$0, $$1);
    }

    public void m_6123_(Player player) {
        if (player instanceof ServerPlayer && player.m_6469_(DamageSource.m_19370_((LivingEntity)this), 1.0f)) {
            RandomSource rand = player.m_217043_();
            int i = rand.m_188503_(4);
            if (i <= 2) {
                player.m_147207_(new MobEffectInstance(MobEffects.f_19614_, 600, 2), (Entity)this);
            } else {
                player.m_147207_(new MobEffectInstance(MobEffects.f_19614_, 200), (Entity)this);
            }
            if (player.m_21023_(MobEffects.f_19590_)) {
                player.m_6074_();
            }
        }
    }

    protected Entity.MovementEmission m_142319_() {
        return Entity.MovementEmission.EVENTS;
    }

    public void m_7023_(Vec3 vec3) {
        this.m_6478_(MoverType.SELF, this.m_20184_());
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(1, (Goal)new TryFindWaterGoal((PathfinderMob)this));
        this.f_21345_.m_25352_(3, (Goal)new AvoidEntityGoal((PathfinderMob)this, Player.class, 8.0f, 1.0, 1.0));
        this.f_21345_.m_25352_(2, (Goal)new ManOWarRandomMovementGoal(this));
        this.f_21345_.m_25352_(4, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21345_.m_25352_(2, (Goal)new BreedGoal((Animal)this, 1.0));
    }

    public void m_7822_(byte b) {
        if (b == 19) {
            this.tentacleMovement = 0.0f;
        } else {
            super.m_7822_(b);
        }
    }

    public void setMovementVector(float f, float g, float h) {
        this.tx = f;
        this.ty = g;
        this.tz = h;
    }

    public boolean hasMovementVector() {
        return this.tx != 0.0f || this.ty != 0.0f || this.tz != 0.0f;
    }

    @javax.annotation.Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor serverLevelAccessor, DifficultyInstance difficultyInstance, MobSpawnType mobSpawnType, @javax.annotation.Nullable SpawnGroupData spawnGroupData, @javax.annotation.Nullable CompoundTag compoundTag) {
        spawnGroupData = super.m_6518_(serverLevelAccessor, difficultyInstance, mobSpawnType, spawnGroupData, compoundTag);
        if (mobSpawnType == MobSpawnType.BUCKET && spawnGroupData != null && compoundTag.m_128425_("BucketVariantTag", 3)) {
            this.setRawFlag(compoundTag.m_128451_("BucketVariantTag"));
            this.m_6863_(true);
            return spawnGroupData;
        }
        this.setColor(ManOWar.getRandColor(this.f_19796_));
        return super.m_6518_(serverLevelAccessor, difficultyInstance, mobSpawnType, spawnGroupData, compoundTag);
    }

    @Nullable
    public AgeableMob m_142606_(ServerLevel serverLevel, AgeableMob ageableMob) {
        ManOWar manOWar = (ManOWar)BYGEntities.MAN_O_WAR.get().m_20615_((Level)serverLevel);
        manOWar.setColor(ManOWar.getRandColor(serverLevel.m_213780_()));
        return manOWar;
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(COLOR, (Object)0);
        this.f_19804_.m_135372_(FROM_BUCKET, (Object)false);
        super.m_8097_();
    }

    public void m_7380_(CompoundTag compoundTag) {
        super.m_7380_(compoundTag);
        compoundTag.m_128405_("Flag", this.getRawFlag());
        compoundTag.m_128379_("FromBucket", this.m_27487_());
    }

    public void m_7378_(CompoundTag compoundTag) {
        super.m_7378_(compoundTag);
        this.setRawFlag(compoundTag.m_128451_("Flag"));
        this.m_27497_(compoundTag.m_128471_("FromBucket"));
    }

    public void m_8107_() {
        if (!this.m_20069_() && this.f_19861_ && this.f_19863_) {
            this.m_20256_(this.m_20184_().m_82520_((double)((this.f_19796_.m_188501_() * 2.0f - 1.0f) * 0.05f), (double)0.4f, (double)((this.f_19796_.m_188501_() * 2.0f - 1.0f) * 0.05f)));
            this.f_19861_ = false;
            this.f_19812_ = true;
            this.m_5496_(SoundEvents.f_12329_, this.m_6121_(), this.m_6100_());
        }
        super.m_8107_();
        this.xBodyRotO = this.xBodyRot;
        this.zBodyRotO = this.zBodyRot;
        this.oldTentacleMovement = this.tentacleMovement;
        this.oldTentacleAngle = this.tentacleAngle;
        this.tentacleMovement += this.tentacleSpeed;
        if ((double)this.tentacleMovement > Math.PI * 2) {
            if (this.f_19853_.f_46443_) {
                this.tentacleMovement = (float)Math.PI * 2;
            } else {
                this.tentacleMovement = (float)((double)this.tentacleMovement - Math.PI * 2);
                if (this.f_19796_.m_188503_(10) == 0) {
                    this.tentacleSpeed = 1.0f / (this.f_19796_.m_188501_() + 1.0f) * 0.2f;
                }
                this.f_19853_.m_7605_((Entity)this, (byte)19);
            }
        }
        if (this.m_20072_()) {
            if (this.tentacleMovement < (float)Math.PI) {
                float f = this.tentacleMovement / (float)Math.PI;
                this.tentacleAngle = Mth.m_14031_((float)(f * f * (float)Math.PI)) * (float)Math.PI * 0.25f;
                if ((double)f > 0.75) {
                    this.speed = 1.0f;
                    this.rotateSpeed = 1.0f;
                } else {
                    this.rotateSpeed *= 0.8f;
                }
            } else {
                this.tentacleAngle = 0.0f;
                this.speed *= 0.9f;
                this.rotateSpeed *= 0.99f;
            }
            if (!this.f_19853_.f_46443_) {
                this.m_20334_(this.tx * this.speed, this.ty * this.speed, this.tz * this.speed);
            }
            Vec3 vec3 = this.m_20184_();
            double d = vec3.m_165924_();
            this.f_20883_ += (-((float)Mth.m_14136_((double)vec3.f_82479_, (double)vec3.f_82481_)) * 57.295776f - this.f_20883_) * 0.1f;
            this.m_146922_(this.f_20883_);
            this.zBodyRot = (float)((double)this.zBodyRot + Math.PI * (double)this.rotateSpeed * 1.5);
            this.xBodyRot += (-((float)Mth.m_14136_((double)d, (double)vec3.f_82480_)) * 57.295776f - this.xBodyRot) * 0.1f;
        } else {
            this.tentacleAngle = Mth.m_14154_((float)Mth.m_14031_((float)this.tentacleMovement)) * (float)Math.PI * 0.25f;
            if (!this.f_19853_.f_46443_) {
                double e = this.m_20184_().f_82480_;
                if (this.m_21023_(MobEffects.f_19620_)) {
                    e = 0.05 * (double)(this.m_21124_(MobEffects.f_19620_).m_19564_() + 1);
                } else if (!this.m_20068_()) {
                    e -= 0.08;
                }
                this.m_20334_(0.0, e * (double)0.98f, 0.0);
            }
            this.xBodyRot = (float)((double)this.xBodyRot + (double)(-90.0f - this.xBodyRot) * 0.02);
        }
    }

    public void setColor(@Nonnull Colors color) {
        this.setFlags(color);
    }

    public void setFlags(@Nonnull Colors color) {
        this.setRawFlag((color.ordinal() & 0x7F) << 16);
    }

    public int getRawFlag() {
        return (Integer)this.f_19804_.m_135370_(COLOR);
    }

    public void setRawFlag(int flag) {
        this.f_19804_.m_135381_(COLOR, (Object)flag);
    }

    public Colors getColor() {
        return Colors.byIndex(this.getRawFlag() >> 16 & 0x7F);
    }

    public static Colors getRandColor(RandomSource rand) {
        int i = rand.m_188503_(5);
        if (i <= 0) {
            return Colors.MAGENTA;
        }
        if (i <= 2) {
            return Colors.BLUE;
        }
        if (i <= 3) {
            return Colors.PURPLE;
        }
        return Colors.RAINBOW;
    }

    private <E extends IAnimatable> PlayState predicate(AnimationEvent<E> event) {
        AnimationController controller = event.getController();
        controller.transitionLengthTicks = 0.0;
        if (this.m_20069_()) {
            controller.setAnimation(new AnimationBuilder().addAnimation("animation.man_o_war.swim", Boolean.valueOf(true)));
            return PlayState.CONTINUE;
        }
        if (!this.m_20069_()) {
            controller.setAnimation(new AnimationBuilder().addAnimation("animation.man_o_war.beached", Boolean.valueOf(true)));
            return PlayState.CONTINUE;
        }
        return PlayState.STOP;
    }

    public void registerControllers(AnimationData data) {
        data.addAnimationController(new AnimationController((IAnimatable)this, "controller", 0.0f, this::predicate));
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }

    public void m_27563_(ServerLevel level, Animal animal) {
        RandomSource rand = level.m_213780_();
        int i = rand.m_216332_(1, 3);
        for (int j = 0; j < i; ++j) {
            ((ManOWar)animal).setColor(ManOWar.getRandColor(level.m_213780_()));
            super.m_27563_(level, animal);
        }
    }

    public boolean m_6785_(double pDistanceToClosestPlayer) {
        return !this.m_27487_() && !this.m_8077_();
    }

    public boolean m_27487_() {
        return (Boolean)this.f_19804_.m_135370_(FROM_BUCKET);
    }

    public void m_27497_(boolean pFromBucket) {
        this.f_19804_.m_135381_(FROM_BUCKET, (Object)pFromBucket);
    }

    public void m_6872_(ItemStack var1) {
        Bucketable.m_148822_((Mob)this, (ItemStack)var1);
        CompoundTag compoundtag = var1.m_41784_();
        compoundtag.m_128405_("BucketVariantTag", this.getRawFlag());
    }

    public void m_142278_(CompoundTag pTag) {
        Bucketable.m_148825_((Mob)this, (CompoundTag)pTag);
        pTag.m_128405_("BucketVariantTag", this.getRawFlag());
    }

    public ItemStack m_28282_() {
        return BYGItems.MAN_O_WAR_BUCKET.get().m_7968_();
    }

    public SoundEvent m_142623_() {
        return SoundEvents.f_144077_;
    }

    public static <T> T makeIndex(T[] array, int index) {
        return array[index >= array.length ? 0 : index];
    }

    private static class ManOWarRandomMovementGoal
    extends Goal {
        private final ManOWar mano;

        public ManOWarRandomMovementGoal(ManOWar mano2) {
            this.mano = mano2;
        }

        public boolean m_8036_() {
            return true;
        }

        public void m_8037_() {
            int i = this.mano.m_21216_();
            if (i > 100) {
                this.mano.setMovementVector(0.0f, 0.0f, 0.0f);
            } else if (this.mano.m_217043_().m_188503_(50) == 0 || !this.mano.f_19798_ || !this.mano.hasMovementVector()) {
                float f = this.mano.m_217043_().m_188501_() * ((float)Math.PI * 2);
                float g = Mth.m_14089_((float)f) * 0.2f;
                float h = -0.1f + this.mano.m_217043_().m_188501_() * 0.2f;
                float j = Mth.m_14031_((float)f) * 0.2f;
                this.mano.setMovementVector(g, h, j);
            }
        }
    }

    public static enum Colors {
        BLUE,
        PURPLE,
        MAGENTA,
        RAINBOW;


        public static Colors byIndex(int index) {
            return ManOWar.makeIndex(Colors.values(), index);
        }
    }
}

