/*
 * Decompiled with CFR 0.152.
 */
package potionstudios.byg.client;

import java.util.function.BiConsumer;
import java.util.function.Supplier;
import net.minecraft.client.model.BoatModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.particle.ParticleEngine;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import potionstudios.byg.BYG;
import potionstudios.byg.client.gui.screen.HypogealImperiumScreen;
import potionstudios.byg.client.textures.renders.BYGParticleTypes;
import potionstudios.byg.common.container.BYGMenuTypes;
import potionstudios.byg.common.entity.boat.BYGBoat;
import potionstudios.byg.common.entity.boat.BYGBoatRenderer;
import potionstudios.byg.common.particles.FallingLeafParticle;
import potionstudios.byg.common.particles.TheriumGlint;
import potionstudios.byg.mixin.access.client.MenuScreensAccess;

public class BYGClient {
    public static void load() {
        BYG.logDebug("BYG: \"Client Setup\" Event Starting...");
        BYG.logInfo("BYG: \"Client Setup\" Event Complete!");
    }

    public static void threadSafeLoad() {
        MenuScreensAccess.byg_register(BYGMenuTypes.HYPOGEAL_CONTAINER.get(), HypogealImperiumScreen::new);
    }

    public static void registerParticles(ParticleStrategy strategy) {
        strategy.register((ParticleType)BYGParticleTypes.THERIUM_GLINT.get(), TheriumGlint.Provider::new);
        strategy.register((ParticleType)BYGParticleTypes.WITCH_HAZEL_LEAF.get(), FallingLeafParticle.Provider::new);
        strategy.register((ParticleType)BYGParticleTypes.CHERRY_BLOSSOM_FALL_WHITE.get(), FallingLeafParticle.Provider::new);
        strategy.register((ParticleType)BYGParticleTypes.CHERRY_BLOSSOM_FALL_PINK.get(), FallingLeafParticle.Provider::new);
    }

    public static void registerLayerDefinitions(BiConsumer<ModelLayerLocation, Supplier<LayerDefinition>> consumer) {
        for (BYGBoat.BYGType value : BYGBoat.BYGType.values()) {
            consumer.accept(BYGBoatRenderer.createBoatModelName(value), () -> BoatModel.m_233347_((boolean)false));
            consumer.accept(BYGBoatRenderer.createChestBoatModelName(value), () -> BoatModel.m_233347_((boolean)true));
        }
    }

    public static interface ParticleStrategy {
        public <T extends ParticleOptions> void register(ParticleType<T> var1, ParticleEngine.SpriteParticleRegistration<T> var2);
    }
}

