/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lib.client;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Matrix4f;
import com.mojang.math.Quaternion;
import com.mojang.math.Vector3f;
import javax.annotation.Nullable;
import mcjty.lib.base.StyleConfig;
import mcjty.lib.client.CustomRenderTypes;
import mcjty.lib.client.RenderSettings;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import net.minecraftforge.client.model.data.ModelData;
import net.minecraftforge.client.model.generators.ModelBuilder;
import net.minecraftforge.fluids.FluidStack;

public class RenderHelper {
    public static float rot = 0.0f;
    public static final int MAX_BRIGHTNESS = 0xF000F0;
    public static final RenderSettings DEFAULT_SETTINGS = RenderSettings.builder().color(255, 255, 255).alpha(128).build();
    public static final RenderSettings FULLBRIGHT_SETTINGS = RenderSettings.builder().color(255, 255, 255).alpha(0xF000F0).build();

    public static void renderText(Font font, String text, int x, int y, int color, PoseStack poseStack, MultiBufferSource buffer, int lightmapValue) {
        font.m_92811_(text, (float)x, (float)y, color, false, poseStack.m_85850_().m_85861_(), buffer, false, 0, lightmapValue);
    }

    public static void renderModel(BlockRenderDispatcher renderer, PoseStack stack, VertexConsumer buffer, BlockState state, BakedModel model, float r, float g, float b, int combinedLight, int combinedOverlay, ModelData modelData, RenderType renderType) {
        renderer.m_110937_().renderModel(stack.m_85850_(), buffer, state, model, r, g, b, combinedLight, combinedOverlay, modelData, renderType);
    }

    public static void line(VertexConsumer builder, PoseStack matrixStack, float x1, float y1, float z1, float x2, float y2, float z2, float red, float green, float blue, float alpha) {
        builder.m_85982_(matrixStack.m_85850_().m_85861_(), x1, y1, 0.0f).m_85950_(red, green, blue, alpha).m_5752_();
        builder.m_85982_(matrixStack.m_85850_().m_85861_(), x2, y2, 0.0f).m_85950_(red, green, blue, alpha).m_5752_();
    }

    public static void adjustTransformToDirection(PoseStack matrixStack, Direction facing) {
        matrixStack.m_85837_(0.5, 0.5, 0.5);
        switch (facing) {
            case DOWN: {
                matrixStack.m_85845_(Vector3f.f_122223_.m_122240_(90.0f));
                break;
            }
            case UP: {
                matrixStack.m_85845_(Vector3f.f_122223_.m_122240_(-90.0f));
                break;
            }
            case NORTH: {
                matrixStack.m_85845_(Vector3f.f_122225_.m_122240_(-180.0f));
                break;
            }
            case SOUTH: {
                break;
            }
            case WEST: {
                matrixStack.m_85845_(Vector3f.f_122225_.m_122240_(-90.0f));
                break;
            }
            case EAST: {
                matrixStack.m_85845_(Vector3f.f_122225_.m_122240_(90.0f));
            }
        }
        matrixStack.m_85837_(-0.5, -0.5, -0.5);
    }

    public static void renderNorthSouthQuad(PoseStack poseStack, VertexConsumer builder, TextureAtlasSprite sprite, ModelBuilder.FaceRotation rotation, float offset) {
        Matrix4f matrix = poseStack.m_85850_().m_85861_();
        switch (rotation) {
            case ZERO: {
                RenderHelper.vt(builder, matrix, 0.0f, 1.0f, 0.73f, sprite.m_118409_(), sprite.m_118412_());
                RenderHelper.vt(builder, matrix, 1.0f, 1.0f, 0.73f, sprite.m_118410_(), sprite.m_118412_());
                RenderHelper.vt(builder, matrix, 1.0f, 0.0f, 0.73f, sprite.m_118410_(), sprite.m_118411_());
                RenderHelper.vt(builder, matrix, 0.0f, 0.0f, 0.73f, sprite.m_118409_(), sprite.m_118411_());
                break;
            }
            case CLOCKWISE_90: {
                RenderHelper.vt(builder, matrix, 0.0f, 1.0f, 0.73f, sprite.m_118410_(), sprite.m_118411_());
                RenderHelper.vt(builder, matrix, 1.0f, 1.0f, 0.73f, sprite.m_118409_(), sprite.m_118411_());
                RenderHelper.vt(builder, matrix, 1.0f, 0.0f, 0.73f, sprite.m_118409_(), sprite.m_118412_());
                RenderHelper.vt(builder, matrix, 0.0f, 0.0f, 0.73f, sprite.m_118410_(), sprite.m_118412_());
                break;
            }
            case UPSIDE_DOWN: {
                RenderHelper.vt(builder, matrix, 0.0f, 1.0f, 0.73f, sprite.m_118409_(), sprite.m_118411_());
                RenderHelper.vt(builder, matrix, 1.0f, 1.0f, 0.73f, sprite.m_118409_(), sprite.m_118412_());
                RenderHelper.vt(builder, matrix, 1.0f, 0.0f, 0.73f, sprite.m_118410_(), sprite.m_118412_());
                RenderHelper.vt(builder, matrix, 0.0f, 0.0f, 0.73f, sprite.m_118410_(), sprite.m_118411_());
                break;
            }
            case COUNTERCLOCKWISE_90: {
                RenderHelper.vt(builder, matrix, 0.0f, 1.0f, 0.73f, sprite.m_118410_(), sprite.m_118412_());
                RenderHelper.vt(builder, matrix, 1.0f, 1.0f, 0.73f, sprite.m_118410_(), sprite.m_118411_());
                RenderHelper.vt(builder, matrix, 1.0f, 0.0f, 0.73f, sprite.m_118409_(), sprite.m_118411_());
                RenderHelper.vt(builder, matrix, 0.0f, 0.0f, 0.73f, sprite.m_118409_(), sprite.m_118412_());
            }
        }
    }

    private static void renderEntity(PoseStack matrixStack, Entity entity, int xPos, int yPos, float scale) {
        matrixStack.m_85836_();
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        matrixStack.m_85836_();
        matrixStack.m_85837_((double)(xPos + 8), (double)(yPos + 16), 50.0);
        matrixStack.m_85841_(-scale, scale, scale);
        matrixStack.m_85845_(Vector3f.f_122227_.m_122240_(180.0f));
        matrixStack.m_85845_(Vector3f.f_122225_.m_122240_(135.0f));
        matrixStack.m_85845_(Vector3f.f_122224_.m_122240_(135.0f));
        matrixStack.m_85845_(Vector3f.f_122225_.m_122240_(rot));
        entity.m_146926_(0.0f);
        matrixStack.m_85837_(0.0, (double)((float)entity.m_6049_()), 0.0);
        matrixStack.m_85849_();
        matrixStack.m_85837_(0.0, 0.0, 0.0);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int i1 = 240;
        int k1 = 240;
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.m_84507_();
        matrixStack.m_85849_();
    }

    public static boolean renderObject(PoseStack matrixStack, int x, int y, Object itm, boolean highlight) {
        if (itm instanceof Entity) {
            RenderHelper.renderEntity(matrixStack, (Entity)itm, x, y, 10.0f);
            return true;
        }
        ItemRenderer itemRenderer = Minecraft.m_91087_().m_91291_();
        return RenderHelper.renderObject(matrixStack, itemRenderer, x, y, itm, highlight, 100.0f);
    }

    public static boolean renderObject(PoseStack matrixStack, ItemRenderer itemRender, int x, int y, Object itm, boolean highlight, float lvl) {
        itemRender.f_115093_ = lvl;
        if (itm == null) {
            return RenderHelper.renderItemStack(matrixStack, itemRender, ItemStack.f_41583_, x, y, "", highlight);
        }
        if (itm instanceof Item) {
            return RenderHelper.renderItemStack(matrixStack, itemRender, new ItemStack((ItemLike)((Item)itm), 1), x, y, "", highlight);
        }
        if (itm instanceof Block) {
            return RenderHelper.renderItemStack(matrixStack, itemRender, new ItemStack((ItemLike)((Block)itm), 1), x, y, "", highlight);
        }
        if (itm instanceof ItemStack) {
            return RenderHelper.renderItemStackWithCount(matrixStack, itemRender, (ItemStack)itm, x, y, highlight);
        }
        if (itm instanceof FluidStack) {
            return RenderHelper.renderFluidStack((FluidStack)itm, x, y, highlight);
        }
        if (itm instanceof TextureAtlasSprite) {
            return RenderHelper.renderIcon(matrixStack, itemRender, (TextureAtlasSprite)itm, x, y, highlight);
        }
        return RenderHelper.renderItemStack(matrixStack, itemRender, ItemStack.f_41583_, x, y, "", highlight);
    }

    private static boolean renderIcon(PoseStack matrixStack, ItemRenderer itemRender, TextureAtlasSprite itm, int xo, int yo, boolean highlight) {
        return true;
    }

    public static boolean renderFluidStack(FluidStack fluidStack, int x, int y, boolean highlight) {
        Fluid fluid = fluidStack.getFluid();
        if (fluid == null) {
            return false;
        }
        IClientFluidTypeExtensions attributes = IClientFluidTypeExtensions.of((Fluid)fluidStack.getFluid());
        ResourceLocation fluidStill = attributes.getStillTexture(fluidStack);
        TextureAtlasSprite fluidStillSprite = null;
        if (fluidStill != null) {
            fluidStillSprite = (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(fluidStill);
        }
        if (fluidStillSprite == null) {
            return false;
        }
        int fluidColor = attributes.getTintColor(fluidStack);
        RenderSystem.m_157456_((int)0, (ResourceLocation)InventoryMenu.f_39692_);
        RenderHelper.setGLColorFromInt(fluidColor);
        RenderHelper.drawFluidTexture(x, y, fluidStillSprite, 100.0);
        return true;
    }

    private static void drawFluidTexture(double xCoord, double yCoord, TextureAtlasSprite textureSprite, double zLevel) {
        float uMin = textureSprite.m_118409_();
        float uMax = textureSprite.m_118410_();
        float vMin = textureSprite.m_118411_();
        float vMax = textureSprite.m_118412_();
        Tesselator tessellator = Tesselator.m_85913_();
        BufferBuilder vertexBuffer = tessellator.m_85915_();
        vertexBuffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        vertexBuffer.m_5483_(xCoord, yCoord + 16.0, zLevel).m_7421_(uMin, vMax).m_5752_();
        vertexBuffer.m_5483_(xCoord + 16.0, yCoord + 16.0, zLevel).m_7421_(uMax, vMax).m_5752_();
        vertexBuffer.m_5483_(xCoord + 16.0, yCoord, zLevel).m_7421_(uMax, vMin).m_5752_();
        vertexBuffer.m_5483_(xCoord, yCoord, zLevel).m_7421_(uMin, vMin).m_5752_();
        tessellator.m_85914_();
    }

    private static void setGLColorFromInt(int color) {
        float red = (float)(color >> 16 & 0xFF) / 255.0f;
        float green = (float)(color >> 8 & 0xFF) / 255.0f;
        float blue = (float)(color & 0xFF) / 255.0f;
        RenderSystem.m_157429_((float)red, (float)green, (float)blue, (float)1.0f);
    }

    public static boolean renderItemStackWithCount(PoseStack matrixStack, ItemRenderer itemRender, ItemStack itm, int xo, int yo, boolean highlight) {
        int size = itm.m_41613_();
        Object amount = size <= 1 ? "" : (size < 100000 ? String.valueOf(size) : (size < 1000000 ? String.valueOf(size / 1000) + "k" : (size < 1000000000 ? String.valueOf(size / 1000000) + "m" : String.valueOf(size / 1000000000) + "g")));
        return RenderHelper.renderItemStack(matrixStack, itemRender, itm, xo, yo, (String)amount, highlight);
    }

    public static boolean renderItemStack(PoseStack matrixStack, ItemRenderer itemRender, ItemStack itm, int x, int y, String txt, boolean highlight) {
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        boolean rc = false;
        if (highlight) {
            RenderHelper.drawVerticalGradientRect(x, y, x + 16, y + 16, -2130706433, -1);
        }
        if (!itm.m_41619_() && itm.m_41720_() != null) {
            rc = true;
            matrixStack.m_85836_();
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            itemRender.m_115203_(itm, x, y);
            RenderHelper.renderGuiItemDecorations(itemRender, Minecraft.m_91087_().f_91062_, itm, x, y, txt, txt.length() - 2);
            matrixStack.m_85849_();
        }
        return rc;
    }

    private static void renderGuiItemDecorations(ItemRenderer itemRender, Font font, ItemStack stack, int x, int y, @Nullable String text, int scaled) {
        if (!stack.m_41619_()) {
            LocalPlayer localplayer;
            float f;
            PoseStack posestack = new PoseStack();
            if (stack.m_41613_() != 1 || text != null) {
                String s = text == null ? String.valueOf(stack.m_41613_()) : text;
                posestack.m_85837_(0.0, 0.0, (double)(itemRender.f_115093_ + 200.0f));
                MultiBufferSource.BufferSource source = MultiBufferSource.m_109898_((BufferBuilder)Tesselator.m_85913_().m_85915_());
                if (scaled >= 2) {
                    posestack.m_85836_();
                    posestack.m_85841_(0.5f, 0.5f, 0.5f);
                    font.m_92811_(s, (float)((x + 19 - 2) * 2 - 1 - font.m_92895_(s)), (float)(y * 2 + 24), 0xFFFFFF, true, posestack.m_85850_().m_85861_(), (MultiBufferSource)source, false, 0, 0xF000F0);
                    posestack.m_85849_();
                } else if (scaled == 1) {
                    posestack.m_85836_();
                    posestack.m_85841_(0.75f, 0.75f, 0.75f);
                    font.m_92811_(s, (float)(x - 2) * 1.34f + 24.0f - (float)font.m_92895_(s), (float)y * 1.34f + 14.0f, 0xFFFFFF, true, posestack.m_85850_().m_85861_(), (MultiBufferSource)source, false, 0, 0xF000F0);
                    posestack.m_85849_();
                } else {
                    font.m_92811_(s, (float)(x + 19 - 2 - font.m_92895_(s)), (float)(y + 6 + 3), 0xFFFFFF, true, posestack.m_85850_().m_85861_(), (MultiBufferSource)source, false, 0, 0xF000F0);
                }
                source.m_109911_();
            }
            if (stack.m_150947_()) {
                RenderSystem.m_69465_();
                RenderSystem.m_69472_();
                RenderSystem.m_69461_();
                Tesselator tesselator = Tesselator.m_85913_();
                BufferBuilder bufferbuilder = tesselator.m_85915_();
                int i = stack.m_150948_();
                int j = stack.m_150949_();
                RenderHelper.fillRect(bufferbuilder, x + 2, y + 13, 13, 2, 0, 0, 0, 255);
                RenderHelper.fillRect(bufferbuilder, x + 2, y + 13, i, 1, j >> 16 & 0xFF, j >> 8 & 0xFF, j & 0xFF, 255);
                RenderSystem.m_69478_();
                RenderSystem.m_69493_();
                RenderSystem.m_69482_();
            }
            float f2 = f = (localplayer = Minecraft.m_91087_().f_91074_) == null ? 0.0f : localplayer.m_36335_().m_41521_(stack.m_41720_(), Minecraft.m_91087_().m_91296_());
            if (f > 0.0f) {
                RenderSystem.m_69465_();
                RenderSystem.m_69472_();
                RenderSystem.m_69478_();
                RenderSystem.m_69453_();
                Tesselator tesselator1 = Tesselator.m_85913_();
                BufferBuilder bufferbuilder1 = tesselator1.m_85915_();
                RenderHelper.fillRect(bufferbuilder1, x, y + Mth.m_14143_((float)(16.0f * (1.0f - f))), 16, Mth.m_14167_((float)(16.0f * f)), 255, 255, 255, 127);
                RenderSystem.m_69493_();
                RenderSystem.m_69482_();
            }
        }
    }

    private static void fillRect(BufferBuilder pRenderer, int pX, int pY, int pWidth, int pHeight, int pRed, int pGreen, int pBlue, int pAlpha) {
        RenderSystem.m_157427_(GameRenderer::m_172811_);
        pRenderer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
        pRenderer.m_5483_((double)(pX + 0), (double)(pY + 0), 0.0).m_6122_(pRed, pGreen, pBlue, pAlpha).m_5752_();
        pRenderer.m_5483_((double)(pX + 0), (double)(pY + pHeight), 0.0).m_6122_(pRed, pGreen, pBlue, pAlpha).m_5752_();
        pRenderer.m_5483_((double)(pX + pWidth), (double)(pY + pHeight), 0.0).m_6122_(pRed, pGreen, pBlue, pAlpha).m_5752_();
        pRenderer.m_5483_((double)(pX + pWidth), (double)(pY + 0), 0.0).m_6122_(pRed, pGreen, pBlue, pAlpha).m_5752_();
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)pRenderer.m_231175_());
    }

    private static void draw(BufferBuilder renderer, int x, int y, int width, int height, int red, int green, int blue, int alpha) {
        renderer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
        renderer.m_5483_((double)(x + 0), (double)(y + 0), 0.0).m_6122_(red, green, blue, alpha).m_5752_();
        renderer.m_5483_((double)(x + 0), (double)(y + height), 0.0).m_6122_(red, green, blue, alpha).m_5752_();
        renderer.m_5483_((double)(x + width), (double)(y + height), 0.0).m_6122_(red, green, blue, alpha).m_5752_();
        renderer.m_5483_((double)(x + width), (double)(y + 0), 0.0).m_6122_(red, green, blue, alpha).m_5752_();
        Tesselator.m_85913_().m_85914_();
    }

    public static void drawVerticalGradientRect(int x1, int y1, int x2, int y2, int color1, int color2) {
        float zLevel = 0.0f;
        float f = (float)(color1 >> 24 & 0xFF) / 255.0f;
        float f1 = (float)(color1 >> 16 & 0xFF) / 255.0f;
        float f2 = (float)(color1 >> 8 & 0xFF) / 255.0f;
        float f3 = (float)(color1 & 0xFF) / 255.0f;
        float f4 = (float)(color2 >> 24 & 0xFF) / 255.0f;
        float f5 = (float)(color2 >> 16 & 0xFF) / 255.0f;
        float f6 = (float)(color2 >> 8 & 0xFF) / 255.0f;
        float f7 = (float)(color2 & 0xFF) / 255.0f;
        RenderSystem.m_69472_();
        RenderSystem.m_69478_();
        RenderSystem.m_157427_(GameRenderer::m_172811_);
        RenderSystem.m_69411_((int)GlStateManager.SourceFactor.SRC_ALPHA.f_84751_, (int)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA.f_84646_, (int)GlStateManager.SourceFactor.ONE.f_84751_, (int)GlStateManager.DestFactor.ZERO.f_84646_);
        Tesselator tessellator = Tesselator.m_85913_();
        BufferBuilder buffer = tessellator.m_85915_();
        buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
        buffer.m_5483_((double)x2, (double)y1, (double)zLevel).m_85950_(f1, f2, f3, f).m_5752_();
        buffer.m_5483_((double)x1, (double)y1, (double)zLevel).m_85950_(f1, f2, f3, f).m_5752_();
        buffer.m_5483_((double)x1, (double)y2, (double)zLevel).m_85950_(f5, f6, f7, f4).m_5752_();
        buffer.m_5483_((double)x2, (double)y2, (double)zLevel).m_85950_(f5, f6, f7, f4).m_5752_();
        tessellator.m_85914_();
        RenderSystem.m_69461_();
        RenderSystem.m_69493_();
    }

    public static void drawHorizontalGradientRect(PoseStack matrixStack, int x1, int y1, int x2, int y2, int color1, int color2) {
        float zLevel = 0.0f;
        float f = (float)(color1 >> 24 & 0xFF) / 255.0f;
        float f1 = (float)(color1 >> 16 & 0xFF) / 255.0f;
        float f2 = (float)(color1 >> 8 & 0xFF) / 255.0f;
        float f3 = (float)(color1 & 0xFF) / 255.0f;
        float f4 = (float)(color2 >> 24 & 0xFF) / 255.0f;
        float f5 = (float)(color2 >> 16 & 0xFF) / 255.0f;
        float f6 = (float)(color2 >> 8 & 0xFF) / 255.0f;
        float f7 = (float)(color2 & 0xFF) / 255.0f;
        RenderSystem.m_69472_();
        RenderSystem.m_69478_();
        RenderSystem.m_69411_((int)GlStateManager.SourceFactor.SRC_ALPHA.f_84751_, (int)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA.f_84646_, (int)GlStateManager.SourceFactor.ONE.f_84751_, (int)GlStateManager.DestFactor.ZERO.f_84646_);
        RenderSystem.m_157427_(GameRenderer::m_172811_);
        Tesselator tessellator = Tesselator.m_85913_();
        BufferBuilder buffer = tessellator.m_85915_();
        buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
        buffer.m_5483_((double)x1, (double)y1, (double)zLevel).m_85950_(f1, f2, f3, f).m_5752_();
        buffer.m_5483_((double)x1, (double)y2, (double)zLevel).m_85950_(f1, f2, f3, f).m_5752_();
        buffer.m_5483_((double)x2, (double)y2, (double)zLevel).m_85950_(f5, f6, f7, f4).m_5752_();
        buffer.m_5483_((double)x2, (double)y1, (double)zLevel).m_85950_(f5, f6, f7, f4).m_5752_();
        tessellator.m_85914_();
        RenderSystem.m_69461_();
        RenderSystem.m_69493_();
    }

    public static void drawHorizontalGradientRect(PoseStack matrixStack, MultiBufferSource buffer, int x1, int y1, int x2, int y2, int color1, int color2, int lightmap) {
        float zLevel = 0.0f;
        float f = (float)(color1 >> 24 & 0xFF) / 255.0f;
        float f1 = (float)(color1 >> 16 & 0xFF) / 255.0f;
        float f2 = (float)(color1 >> 8 & 0xFF) / 255.0f;
        float f3 = (float)(color1 & 0xFF) / 255.0f;
        float f4 = (float)(color2 >> 24 & 0xFF) / 255.0f;
        float f5 = (float)(color2 >> 16 & 0xFF) / 255.0f;
        float f6 = (float)(color2 >> 8 & 0xFF) / 255.0f;
        float f7 = (float)(color2 & 0xFF) / 255.0f;
        VertexConsumer builder = buffer.m_6299_(CustomRenderTypes.QUADS_NOTEXTURE);
        Matrix4f positionMatrix = matrixStack.m_85850_().m_85861_();
        builder.m_85982_(positionMatrix, (float)x1, (float)y1, zLevel).m_85950_(f1, f2, f3, f).m_85969_(lightmap).m_5752_();
        builder.m_85982_(positionMatrix, (float)x1, (float)y2, zLevel).m_85950_(f1, f2, f3, f).m_85969_(lightmap).m_5752_();
        builder.m_85982_(positionMatrix, (float)x2, (float)y2, zLevel).m_85950_(f5, f6, f7, f4).m_85969_(lightmap).m_5752_();
        builder.m_85982_(positionMatrix, (float)x2, (float)y1, zLevel).m_85950_(f5, f6, f7, f4).m_85969_(lightmap).m_5752_();
    }

    public static void drawHorizontalLine(PoseStack matrixStack, int x1, int y1, int x2, int color) {
        GuiComponent.m_93172_((PoseStack)matrixStack, (int)x1, (int)y1, (int)x2, (int)(y1 + 1), (int)color);
    }

    public static void drawVerticalLine(PoseStack matrixStack, int x1, int y1, int y2, int color) {
        GuiComponent.m_93172_((PoseStack)matrixStack, (int)x1, (int)y1, (int)(x1 + 1), (int)y2, (int)color);
    }

    public static void drawLeftTriangle(PoseStack matrixStack, int x, int y, int color) {
        RenderHelper.drawVerticalLine(matrixStack, x, y, y, color);
        RenderHelper.drawVerticalLine(matrixStack, x + 1, y - 1, y + 1, color);
        RenderHelper.drawVerticalLine(matrixStack, x + 2, y - 2, y + 2, color);
    }

    public static void drawRightTriangle(PoseStack matrixStack, int x, int y, int color) {
        RenderHelper.drawVerticalLine(matrixStack, x, y, y, color);
        RenderHelper.drawVerticalLine(matrixStack, x - 1, y - 1, y + 1, color);
        RenderHelper.drawVerticalLine(matrixStack, x - 2, y - 2, y + 2, color);
    }

    public static void drawUpTriangle(PoseStack matrixStack, int x, int y, int color) {
        RenderHelper.drawHorizontalLine(matrixStack, x, y, x, color);
        RenderHelper.drawHorizontalLine(matrixStack, x - 1, y + 1, x + 1, color);
        RenderHelper.drawHorizontalLine(matrixStack, x - 2, y + 2, x + 2, color);
    }

    public static void drawDownTriangle(PoseStack matrixStack, int x, int y, int color) {
        RenderHelper.drawHorizontalLine(matrixStack, x, y, x, color);
        RenderHelper.drawHorizontalLine(matrixStack, x - 1, y - 1, x + 1, color);
        RenderHelper.drawHorizontalLine(matrixStack, x - 2, y - 2, x + 2, color);
    }

    public static void drawColorLogic(int x, int y, int width, int height, int red, int green, int blue, GlStateManager.LogicOp colorLogic) {
        GlStateManager.m_84110_();
        GlStateManager.m_84107_();
        GlStateManager.m_84532_((int)colorLogic.f_84715_);
        RenderHelper.draw(Tesselator.m_85913_().m_85915_(), x, y, width, height, red, green, blue, 255);
        GlStateManager.m_84108_();
        GlStateManager.m_84109_();
    }

    public static void drawThickButtonBox(PoseStack matrixStack, int x1, int y1, int x2, int y2, int bright, int average, int dark) {
        GuiComponent.m_93172_((PoseStack)matrixStack, (int)(x1 + 2), (int)(y1 + 2), (int)(x2 - 2), (int)(y2 - 2), (int)average);
        RenderHelper.drawHorizontalLine(matrixStack, x1 + 1, y1, x2 - 1, StyleConfig.colorButtonExternalBorder);
        RenderHelper.drawHorizontalLine(matrixStack, x1 + 1, y2 - 1, x2 - 1, StyleConfig.colorButtonExternalBorder);
        RenderHelper.drawVerticalLine(matrixStack, x1, y1 + 1, y2 - 1, StyleConfig.colorButtonExternalBorder);
        RenderHelper.drawVerticalLine(matrixStack, x2 - 1, y1 + 1, y2 - 1, StyleConfig.colorButtonExternalBorder);
        RenderHelper.drawHorizontalLine(matrixStack, x1 + 1, y1 + 1, x2 - 1, bright);
        RenderHelper.drawHorizontalLine(matrixStack, x1 + 2, y1 + 2, x2 - 2, bright);
        RenderHelper.drawVerticalLine(matrixStack, x1 + 1, y1 + 2, y2 - 2, bright);
        RenderHelper.drawVerticalLine(matrixStack, x1 + 2, y1 + 3, y2 - 3, bright);
        RenderHelper.drawHorizontalLine(matrixStack, x1 + 3, y2 - 3, x2 - 2, dark);
        RenderHelper.drawHorizontalLine(matrixStack, x1 + 2, y2 - 2, x2 - 1, dark);
        RenderHelper.drawVerticalLine(matrixStack, x2 - 2, y1 + 2, y2 - 2, dark);
        RenderHelper.drawVerticalLine(matrixStack, x2 - 3, y1 + 3, y2 - 3, dark);
    }

    public static void drawThinButtonBox(PoseStack matrixStack, int x1, int y1, int x2, int y2, int bright, int average, int dark) {
        GuiComponent.m_93172_((PoseStack)matrixStack, (int)(x1 + 1), (int)(y1 + 1), (int)(x2 - 1), (int)(y2 - 1), (int)average);
        RenderHelper.drawHorizontalLine(matrixStack, x1 + 1, y1, x2 - 1, StyleConfig.colorButtonExternalBorder);
        RenderHelper.drawHorizontalLine(matrixStack, x1 + 1, y2 - 1, x2 - 1, StyleConfig.colorButtonExternalBorder);
        RenderHelper.drawVerticalLine(matrixStack, x1, y1 + 1, y2 - 1, StyleConfig.colorButtonExternalBorder);
        RenderHelper.drawVerticalLine(matrixStack, x2 - 1, y1 + 1, y2 - 1, StyleConfig.colorButtonExternalBorder);
        RenderHelper.drawHorizontalLine(matrixStack, x1 + 1, y1 + 1, x2 - 2, bright);
        RenderHelper.drawVerticalLine(matrixStack, x1 + 1, y1 + 2, y2 - 3, bright);
        RenderHelper.drawHorizontalLine(matrixStack, x1 + 1, y2 - 2, x2 - 1, dark);
        RenderHelper.drawVerticalLine(matrixStack, x2 - 2, y1 + 1, y2 - 2, dark);
    }

    public static void drawThinButtonBoxGradient(PoseStack matrixStack, int x1, int y1, int x2, int y2, int bright, int average1, int average2, int dark) {
        RenderHelper.drawVerticalGradientRect(x1 + 1, y1 + 1, x2 - 1, y2 - 1, average2, average1);
        RenderHelper.drawHorizontalLine(matrixStack, x1 + 1, y1, x2 - 1, StyleConfig.colorButtonExternalBorder);
        RenderHelper.drawHorizontalLine(matrixStack, x1 + 1, y2 - 1, x2 - 1, StyleConfig.colorButtonExternalBorder);
        RenderHelper.drawVerticalLine(matrixStack, x1, y1 + 1, y2 - 1, StyleConfig.colorButtonExternalBorder);
        RenderHelper.drawVerticalLine(matrixStack, x2 - 1, y1 + 1, y2 - 1, StyleConfig.colorButtonExternalBorder);
        RenderHelper.drawHorizontalLine(matrixStack, x1 + 1, y1 + 1, x2 - 2, bright);
        RenderHelper.drawVerticalLine(matrixStack, x1 + 1, y1 + 2, y2 - 3, bright);
        RenderHelper.drawHorizontalLine(matrixStack, x1 + 1, y2 - 2, x2 - 1, dark);
        RenderHelper.drawVerticalLine(matrixStack, x2 - 2, y1 + 1, y2 - 2, dark);
    }

    public static void drawFlatButtonBox(PoseStack matrixStack, int x1, int y1, int x2, int y2, int bright, int average, int dark) {
        RenderHelper.drawBeveledBox(matrixStack, x1, y1, x2, y2, bright, dark, average);
    }

    public static void drawFlatButtonBox(PoseStack matrixStack, MultiBufferSource buffer, int x1, int y1, int x2, int y2, int bright, int average, int dark, int lightmap) {
        RenderHelper.drawBeveledBox(matrixStack, buffer, x1, y1, x2, y2, bright, dark, average, lightmap);
    }

    public static void drawFlatButtonBoxGradient(PoseStack matrixStack, int x1, int y1, int x2, int y2, int bright, int average1, int average2, int dark) {
        RenderHelper.drawVerticalGradientRect(x1 + 1, y1 + 1, x2 - 1, y2 - 1, average2, average1);
        RenderHelper.drawHorizontalLine(matrixStack, x1, y1, x2 - 1, bright);
        RenderHelper.drawVerticalLine(matrixStack, x1, y1, y2 - 1, bright);
        RenderHelper.drawVerticalLine(matrixStack, x2 - 1, y1, y2 - 1, dark);
        RenderHelper.drawHorizontalLine(matrixStack, x1, y2 - 1, x2, dark);
    }

    public static void drawBeveledBox(PoseStack matrixStack, int x1, int y1, int x2, int y2, int topleftcolor, int botrightcolor, int fillcolor) {
        if (fillcolor != -1) {
            GuiComponent.m_93172_((PoseStack)matrixStack, (int)(x1 + 1), (int)(y1 + 1), (int)(x2 - 1), (int)(y2 - 1), (int)fillcolor);
        }
        RenderHelper.drawHorizontalLine(matrixStack, x1, y1, x2 - 1, topleftcolor);
        RenderHelper.drawVerticalLine(matrixStack, x1, y1, y2 - 1, topleftcolor);
        RenderHelper.drawVerticalLine(matrixStack, x2 - 1, y1, y2 - 1, botrightcolor);
        RenderHelper.drawHorizontalLine(matrixStack, x1, y2 - 1, x2, botrightcolor);
    }

    public static void drawBeveledBox(PoseStack matrixStack, MultiBufferSource buffer, int x1, int y1, int x2, int y2, int topleftcolor, int botrightcolor, int fillcolor, int lightmap) {
        if (fillcolor != -1) {
            RenderHelper.fill(matrixStack, buffer, x1 + 1, y1 + 1, x2 - 1, y2 - 1, fillcolor, lightmap);
        }
        RenderHelper.fill(matrixStack, buffer, x1, y1, x2 - 1, y1 + 1, topleftcolor, lightmap);
        RenderHelper.fill(matrixStack, buffer, x1, y1, x1 + 1, y2 - 1, topleftcolor, lightmap);
        RenderHelper.fill(matrixStack, buffer, x2 - 1, y1, x2 - 1 + 1, y2 - 1, botrightcolor, lightmap);
        RenderHelper.fill(matrixStack, buffer, x1, y2 - 1, x2, y2 - 1 + 1, botrightcolor, lightmap);
    }

    public static void drawThickBeveledBox(PoseStack matrixStack, int x1, int y1, int x2, int y2, int thickness, int topleftcolor, int botrightcolor, int fillcolor) {
        if (fillcolor != -1) {
            GuiComponent.m_93172_((PoseStack)matrixStack, (int)(x1 + 1), (int)(y1 + 1), (int)(x2 - 1), (int)(y2 - 1), (int)fillcolor);
        }
        GuiComponent.m_93172_((PoseStack)matrixStack, (int)x1, (int)y1, (int)(x2 - 1), (int)(y1 + thickness), (int)topleftcolor);
        GuiComponent.m_93172_((PoseStack)matrixStack, (int)x1, (int)y1, (int)(x1 + thickness), (int)(y2 - 1), (int)topleftcolor);
        GuiComponent.m_93172_((PoseStack)matrixStack, (int)(x2 - thickness), (int)y1, (int)x2, (int)(y2 - 1), (int)botrightcolor);
        GuiComponent.m_93172_((PoseStack)matrixStack, (int)x1, (int)(y2 - thickness), (int)x2, (int)y2, (int)botrightcolor);
    }

    public static void drawFlatBox(PoseStack matrixStack, int x1, int y1, int x2, int y2, int border, int fill) {
        if (fill != -1) {
            GuiComponent.m_93172_((PoseStack)matrixStack, (int)(x1 + 1), (int)(y1 + 1), (int)(x2 - 1), (int)(y2 - 1), (int)fill);
        }
        RenderHelper.drawHorizontalLine(matrixStack, x1, y1, x2 - 1, border);
        RenderHelper.drawVerticalLine(matrixStack, x1, y1, y2 - 1, border);
        RenderHelper.drawVerticalLine(matrixStack, x2 - 1, y1, y2 - 1, border);
        RenderHelper.drawHorizontalLine(matrixStack, x1, y2 - 1, x2, border);
    }

    public static void drawTexturedModalRect(PoseStack poseStack, VertexConsumer builder, int x, int y, int textureX, int textureY, int width, int height, int totw, int toth, float parentU, float parentV) {
        Matrix4f matrix = poseStack.m_85850_().m_85861_();
        float f = 1.0f / (float)totw;
        float f1 = 1.0f / (float)toth;
        float zLevel = 50.0f;
        builder.m_85982_(matrix, (float)(x + 0), (float)(y + height), zLevel).m_7421_(parentU + (float)(textureX + 0) * f, parentV + (float)(textureY + height) * f1).m_5752_();
        builder.m_85982_(matrix, (float)(x + width), (float)(y + height), zLevel).m_7421_(parentU + (float)(textureX + width) * f, parentV + (float)(textureY + height) * f1).m_5752_();
        builder.m_85982_(matrix, (float)(x + width), (float)(y + 0), zLevel).m_7421_(parentU + (float)(textureX + width) * f, parentV + (float)(textureY + 0) * f1).m_5752_();
        builder.m_85982_(matrix, (float)(x + 0), (float)(y + 0), zLevel).m_7421_(parentU + (float)(textureX + 0) * f, parentV + (float)(textureY + 0) * f1).m_5752_();
    }

    public static void drawTexturedModalRect(PoseStack poseStack, int x, int y, int u, int v, int width, int height) {
        Matrix4f matrix = poseStack.m_85850_().m_85861_();
        float zLevel = 0.01f;
        float f = 0.00390625f;
        float f1 = 0.00390625f;
        Tesselator tessellator = Tesselator.m_85913_();
        BufferBuilder buffer = tessellator.m_85915_();
        buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        buffer.m_85982_(matrix, (float)(x + 0), (float)(y + height), zLevel).m_7421_((float)(u + 0) * f, (float)(v + height) * f1).m_5752_();
        buffer.m_85982_(matrix, (float)(x + width), (float)(y + height), zLevel).m_7421_((float)(u + width) * f, (float)(v + height) * f1).m_5752_();
        buffer.m_85982_(matrix, (float)(x + width), (float)(y + 0), zLevel).m_7421_((float)(u + width) * f, (float)(v + 0) * f1).m_5752_();
        buffer.m_85982_(matrix, (float)(x + 0), (float)(y + 0), zLevel).m_7421_((float)(u + 0) * f, (float)(v + 0) * f1).m_5752_();
        tessellator.m_85914_();
    }

    public static void renderSplitBillboard(PoseStack matrixStack, VertexConsumer buffer, float scale, Vec3 offset, ResourceLocation texture) {
        int b1 = 0xF00000;
        int b2 = 240;
        TextureAtlasSprite sprite = (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(texture);
        matrixStack.m_85836_();
        matrixStack.m_85837_(0.5, 0.5 + offset.f_82480_, 0.5);
        RenderHelper.rotateToPlayer(matrixStack);
        Matrix4f matrix = matrixStack.m_85850_().m_85861_();
        float u0 = sprite.m_118409_();
        float v0 = sprite.m_118411_();
        float u1 = sprite.m_118410_();
        float v1 = sprite.m_118412_();
        float um = (u0 + u1) / 2.0f;
        float vm = (v0 + v1) / 2.0f;
        buffer.m_85982_(matrix, -scale, -scale, 0.0f).m_6122_(255, 255, 255, 255).m_7421_(u0, v0).m_7120_(b1, b2).m_5601_(1.0f, 0.0f, 0.0f).m_5752_();
        buffer.m_85982_(matrix, -scale, 0.0f, 0.0f).m_6122_(255, 255, 255, 255).m_7421_(u0, vm).m_7120_(b1, b2).m_5601_(1.0f, 0.0f, 0.0f).m_5752_();
        buffer.m_85982_(matrix, 0.0f, 0.0f, 0.0f).m_6122_(255, 255, 255, 255).m_7421_(um, vm).m_7120_(b1, b2).m_5601_(1.0f, 0.0f, 0.0f).m_5752_();
        buffer.m_85982_(matrix, 0.0f, -scale, 0.0f).m_6122_(255, 255, 255, 255).m_7421_(um, v0).m_7120_(b1, b2).m_5601_(1.0f, 0.0f, 0.0f).m_5752_();
        buffer.m_85982_(matrix, 0.0f, 0.0f, 0.0f).m_6122_(255, 255, 255, 255).m_7421_(um, vm).m_7120_(b1, b2).m_5601_(1.0f, 0.0f, 0.0f).m_5752_();
        buffer.m_85982_(matrix, 0.0f, scale, 0.0f).m_6122_(255, 255, 255, 255).m_7421_(um, v1).m_7120_(b1, b2).m_5601_(1.0f, 0.0f, 0.0f).m_5752_();
        buffer.m_85982_(matrix, scale, scale, 0.0f).m_6122_(255, 255, 255, 255).m_7421_(u1, v1).m_7120_(b1, b2).m_5601_(1.0f, 0.0f, 0.0f).m_5752_();
        buffer.m_85982_(matrix, scale, 0.0f, 0.0f).m_6122_(255, 255, 255, 255).m_7421_(u1, vm).m_7120_(b1, b2).m_5601_(1.0f, 0.0f, 0.0f).m_5752_();
        buffer.m_85982_(matrix, 0.0f, -scale, 0.0f).m_6122_(255, 255, 255, 255).m_7421_(um, v0).m_7120_(b1, b2).m_5601_(1.0f, 0.0f, 0.0f).m_5752_();
        buffer.m_85982_(matrix, 0.0f, 0.0f, 0.0f).m_6122_(255, 255, 255, 255).m_7421_(um, vm).m_7120_(b1, b2).m_5601_(1.0f, 0.0f, 0.0f).m_5752_();
        buffer.m_85982_(matrix, scale, 0.0f, 0.0f).m_6122_(255, 255, 255, 255).m_7421_(u1, vm).m_7120_(b1, b2).m_5601_(1.0f, 0.0f, 0.0f).m_5752_();
        buffer.m_85982_(matrix, scale, -scale, 0.0f).m_6122_(255, 255, 255, 255).m_7421_(u1, v0).m_7120_(b1, b2).m_5601_(1.0f, 0.0f, 0.0f).m_5752_();
        buffer.m_85982_(matrix, -scale, 0.0f, 0.0f).m_6122_(255, 255, 255, 255).m_7421_(u0, vm).m_7120_(b1, b2).m_5601_(1.0f, 0.0f, 0.0f).m_5752_();
        buffer.m_85982_(matrix, -scale, scale, 0.0f).m_6122_(255, 255, 255, 255).m_7421_(u0, v1).m_7120_(b1, b2).m_5601_(1.0f, 0.0f, 0.0f).m_5752_();
        buffer.m_85982_(matrix, 0.0f, scale, 0.0f).m_6122_(255, 255, 255, 255).m_7421_(um, v1).m_7120_(b1, b2).m_5601_(1.0f, 0.0f, 0.0f).m_5752_();
        buffer.m_85982_(matrix, 0.0f, 0.0f, 0.0f).m_6122_(255, 255, 255, 255).m_7421_(um, vm).m_7120_(b1, b2).m_5601_(1.0f, 0.0f, 0.0f).m_5752_();
        matrixStack.m_85849_();
    }

    public static void renderBillboardQuadBright(PoseStack matrixStack, MultiBufferSource buffer, float scale, ResourceLocation texture) {
        RenderHelper.renderBillboardQuadBright(matrixStack, buffer, scale, texture, DEFAULT_SETTINGS);
    }

    public static void renderBillboardQuadBright(PoseStack matrixStack, VertexConsumer builder, float scale, ResourceLocation texture, RenderSettings settings) {
        int b1 = settings.brightness() >> 16 & 0xFFFF;
        int b2 = settings.brightness() & 0xFFFF;
        TextureAtlasSprite sprite = (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(texture);
        matrixStack.m_85836_();
        matrixStack.m_85837_(0.5, 0.5, 0.5);
        RenderHelper.rotateToPlayer(matrixStack);
        Matrix4f matrix = matrixStack.m_85850_().m_85861_();
        builder.m_85982_(matrix, -scale, -scale, 0.0f).m_6122_(settings.r(), settings.g(), settings.b(), settings.a()).m_7421_(sprite.m_118409_(), sprite.m_118411_()).m_7120_(b1, b2).m_5601_(1.0f, 0.0f, 0.0f).m_5752_();
        builder.m_85982_(matrix, -scale, scale, 0.0f).m_6122_(settings.r(), settings.g(), settings.b(), settings.a()).m_7421_(sprite.m_118409_(), sprite.m_118412_()).m_7120_(b1, b2).m_5601_(1.0f, 0.0f, 0.0f).m_5752_();
        builder.m_85982_(matrix, scale, scale, 0.0f).m_6122_(settings.r(), settings.g(), settings.b(), settings.a()).m_7421_(sprite.m_118410_(), sprite.m_118412_()).m_7120_(b1, b2).m_5601_(1.0f, 0.0f, 0.0f).m_5752_();
        builder.m_85982_(matrix, scale, -scale, 0.0f).m_6122_(settings.r(), settings.g(), settings.b(), settings.a()).m_7421_(sprite.m_118410_(), sprite.m_118411_()).m_7120_(b1, b2).m_5601_(1.0f, 0.0f, 0.0f).m_5752_();
        matrixStack.m_85849_();
    }

    public static void renderBillboardQuadBright(PoseStack matrixStack, MultiBufferSource buffer, float scale, ResourceLocation texture, RenderSettings settings) {
        RenderHelper.renderBillboardQuadBright(matrixStack, buffer.m_6299_(settings.renderType()), scale, texture, settings);
    }

    public static void rotateToPlayer(PoseStack matrixStack) {
        Quaternion rotation = Minecraft.m_91087_().f_91063_.m_109153_().m_90591_();
        matrixStack.m_85845_(rotation);
    }

    public static int renderText(PoseStack matrixStack, int x, int y, String txt) {
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        matrixStack.m_85836_();
        matrixStack.m_85837_(0.0, 0.0, 32.0);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.m_84507_();
        GlStateManager.m_84519_();
        Minecraft mc = Minecraft.m_91087_();
        int width = mc.f_91062_.m_92895_(txt);
        mc.f_91062_.m_92750_(matrixStack, txt, (float)x, (float)y, 0xFFFFFF);
        GlStateManager.m_84513_();
        GlStateManager.m_84525_();
        matrixStack.m_85849_();
        return width;
    }

    public static int renderText(PoseStack matrixStack, int x, int y, String txt, int color) {
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        matrixStack.m_85836_();
        matrixStack.m_85837_(0.0, 0.0, 32.0);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.m_84507_();
        GlStateManager.m_84519_();
        Minecraft mc = Minecraft.m_91087_();
        int width = mc.f_91062_.m_92895_(txt);
        mc.f_91062_.m_92883_(matrixStack, txt, (float)x, (float)y, color);
        GlStateManager.m_84513_();
        GlStateManager.m_84525_();
        matrixStack.m_85849_();
        return width;
    }

    public static void drawBeam(PoseStack matrix, VertexConsumer builder, TextureAtlasSprite sprite, Vec3 S, Vec3 E, Vec3 P, float width) {
        Vec3 PS = S.m_82546_(P);
        Vec3 SE = E.m_82546_(S);
        Vec3 normal = PS.m_82537_(SE).m_82541_();
        Vec3 half = normal.m_82542_((double)width, (double)width, (double)width);
        Vec3 p1 = S.m_82549_(half);
        Vec3 p2 = S.m_82546_(half);
        Vec3 p3 = E.m_82549_(half);
        Vec3 p4 = E.m_82546_(half);
        RenderHelper.drawQuad(matrix.m_85850_().m_85861_(), builder, sprite, p1, p3, p4, p2, DEFAULT_SETTINGS);
    }

    public static void drawBeam(PoseStack poseStack, VertexConsumer buffer, TextureAtlasSprite sprite, Vec3 S, Vec3 E, Vec3 P, RenderSettings settings) {
        Vec3 PS = S.m_82546_(P);
        Vec3 SE = E.m_82546_(S);
        Vec3 normal = PS.m_82537_(SE).m_82541_();
        Vec3 half = normal.m_82542_((double)settings.width(), (double)settings.width(), (double)settings.width());
        Vec3 p1 = S.m_82549_(half);
        Vec3 p2 = S.m_82546_(half);
        Vec3 p3 = E.m_82549_(half);
        Vec3 p4 = E.m_82546_(half);
        RenderHelper.drawQuad(poseStack.m_85850_().m_85861_(), buffer, sprite, p1, p3, p4, p2, settings);
    }

    public static void renderQuadGui(PoseStack matrixStack, TextureAtlasSprite sprite, int packedLight, VertexConsumer builder, float zfront, float size) {
        float u0 = sprite.m_118409_();
        float v0 = sprite.m_118411_();
        float u1 = sprite.m_118410_();
        float v1 = sprite.m_118412_();
        Matrix4f matrix = matrixStack.m_85850_().m_85861_();
        RenderHelper.vt(builder, matrix, -size, size, zfront, u0, v0, packedLight);
        RenderHelper.vt(builder, matrix, size, size, zfront, u1, v0, packedLight);
        RenderHelper.vt(builder, matrix, size, -size, zfront, u1, v1, packedLight);
        RenderHelper.vt(builder, matrix, -size, -size, zfront, u0, v1, packedLight);
    }

    public static void drawQuadGui(PoseStack poseStack, VertexConsumer builder, float x1, float x2, float y1, float y2, float z, int color, int packedLightIn) {
        Matrix4f matrix = poseStack.m_85850_().m_85861_();
        float a = (float)(color >> 24 & 0xFF) / 255.0f;
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        builder.m_85982_(matrix, x1, y2, z).m_85950_(r, g, b, a).m_85969_(packedLightIn).m_5752_();
        builder.m_85982_(matrix, x2, y2, z).m_85950_(r, g, b, a).m_85969_(packedLightIn).m_5752_();
        builder.m_85982_(matrix, x2, y1, z).m_85950_(r, g, b, a).m_85969_(packedLightIn).m_5752_();
        builder.m_85982_(matrix, x1, y1, z).m_85950_(r, g, b, a).m_85969_(packedLightIn).m_5752_();
    }

    private static void drawQuad(Matrix4f matrix, VertexConsumer buffer, TextureAtlasSprite sprite, Vec3 p1, Vec3 p2, Vec3 p3, Vec3 p4, RenderSettings settings) {
        int b1 = settings.brightness() >> 16 & 0xFFFF;
        int b2 = settings.brightness() & 0xFFFF;
        RenderHelper.vt(buffer, matrix, (float)p1.m_7096_(), (float)p1.m_7098_(), (float)p1.m_7094_(), sprite.m_118409_(), sprite.m_118411_(), b1, b2, settings.r(), settings.g(), settings.b(), settings.a());
        RenderHelper.vt(buffer, matrix, (float)p2.m_7096_(), (float)p2.m_7098_(), (float)p2.m_7094_(), sprite.m_118410_(), sprite.m_118411_(), b1, b2, settings.r(), settings.g(), settings.b(), settings.a());
        RenderHelper.vt(buffer, matrix, (float)p3.m_7096_(), (float)p3.m_7098_(), (float)p3.m_7094_(), sprite.m_118410_(), sprite.m_118412_(), b1, b2, settings.r(), settings.g(), settings.b(), settings.a());
        RenderHelper.vt(buffer, matrix, (float)p4.m_7096_(), (float)p4.m_7098_(), (float)p4.m_7094_(), sprite.m_118409_(), sprite.m_118412_(), b1, b2, settings.r(), settings.g(), settings.b(), settings.a());
    }

    private static void drawQuadUnit(Matrix4f matrix, VertexConsumer buffer, TextureAtlasSprite sprite, Vec3 p1, Vec3 p2, Vec3 p3, Vec3 p4, double u0Par, double u1Par, double v0Par, double v1Par, RenderSettings settings) {
        int b1 = settings.brightness() >> 16 & 0xFFFF;
        int b2 = settings.brightness() & 0xFFFF;
        u0Par = u0Par < 0.0 ? 1.0 + u0Par % 1.0 : u0Par % 1.0;
        u1Par = u1Par < 0.0 ? -(u1Par % 1.0) : 1.0 - u1Par % 1.0;
        v0Par = v0Par < 0.0 ? 1.0 + v0Par % 1.0 : v0Par % 1.0;
        v1Par = v1Par < 0.0 ? -(v1Par % 1.0) : 1.0 - v1Par % 1.0;
        float du = sprite.m_118410_() - sprite.m_118409_();
        float dv = sprite.m_118412_() - sprite.m_118411_();
        RenderHelper.vt(buffer, matrix, (float)p1.m_7096_(), (float)p1.m_7098_(), (float)p1.m_7094_(), sprite.m_118409_() + (float)((double)du * u0Par), sprite.m_118411_() + (float)((double)dv * v0Par), b1, b2, settings.r(), settings.g(), settings.b(), settings.a());
        RenderHelper.vt(buffer, matrix, (float)p2.m_7096_(), (float)p2.m_7098_(), (float)p2.m_7094_(), sprite.m_118410_() - (float)((double)du * u1Par), sprite.m_118411_() + (float)((double)dv * v0Par), b1, b2, settings.r(), settings.g(), settings.b(), settings.a());
        RenderHelper.vt(buffer, matrix, (float)p3.m_7096_(), (float)p3.m_7098_(), (float)p3.m_7094_(), sprite.m_118410_() - (float)((double)du * u1Par), sprite.m_118412_() - (float)((double)dv * v1Par), b1, b2, settings.r(), settings.g(), settings.b(), settings.a());
        RenderHelper.vt(buffer, matrix, (float)p4.m_7096_(), (float)p4.m_7098_(), (float)p4.m_7094_(), sprite.m_118409_() + (float)((double)du * u0Par), sprite.m_118412_() - (float)((double)dv * v1Par), b1, b2, settings.r(), settings.g(), settings.b(), settings.a());
    }

    private static void drawQuad(Matrix4f matrix, VertexConsumer buffer, TextureAtlasSprite sprite, Vec3 p1, Vec3 p2, Vec3 p3, Vec3 p4, boolean opposite, RenderSettings settings) {
        int b1 = settings.brightness() >> 16 & 0xFFFF;
        int b2 = settings.brightness() & 0xFFFF;
        if (opposite) {
            RenderHelper.vt(buffer, matrix, (float)p1.m_7096_(), (float)p1.m_7098_(), (float)p1.m_7094_(), sprite.m_118409_(), sprite.m_118411_(), b1, b2, settings.r(), settings.g(), settings.b(), settings.a());
            RenderHelper.vt(buffer, matrix, (float)p2.m_7096_(), (float)p2.m_7098_(), (float)p2.m_7094_(), sprite.m_118410_(), sprite.m_118411_(), b1, b2, settings.r(), settings.g(), settings.b(), settings.a());
            RenderHelper.vt(buffer, matrix, (float)p3.m_7096_(), (float)p3.m_7098_(), (float)p3.m_7094_(), sprite.m_118410_(), sprite.m_118412_(), b1, b2, settings.r(), settings.g(), settings.b(), settings.a());
            RenderHelper.vt(buffer, matrix, (float)p4.m_7096_(), (float)p4.m_7098_(), (float)p4.m_7094_(), sprite.m_118409_(), sprite.m_118412_(), b1, b2, settings.r(), settings.g(), settings.b(), settings.a());
        } else {
            RenderHelper.vt(buffer, matrix, (float)p4.m_7096_(), (float)p4.m_7098_(), (float)p4.m_7094_(), sprite.m_118409_(), sprite.m_118412_(), b1, b2, settings.r(), settings.g(), settings.b(), settings.a());
            RenderHelper.vt(buffer, matrix, (float)p3.m_7096_(), (float)p3.m_7098_(), (float)p3.m_7094_(), sprite.m_118410_(), sprite.m_118412_(), b1, b2, settings.r(), settings.g(), settings.b(), settings.a());
            RenderHelper.vt(buffer, matrix, (float)p2.m_7096_(), (float)p2.m_7098_(), (float)p2.m_7094_(), sprite.m_118410_(), sprite.m_118411_(), b1, b2, settings.r(), settings.g(), settings.b(), settings.a());
            RenderHelper.vt(buffer, matrix, (float)p1.m_7096_(), (float)p1.m_7098_(), (float)p1.m_7094_(), sprite.m_118409_(), sprite.m_118411_(), b1, b2, settings.r(), settings.g(), settings.b(), settings.a());
        }
    }

    public static void renderRect(PoseStack poseStack, VertexConsumer buffer, Rect rect, BlockPos p, float r, float g, float b, float a) {
        Matrix4f matrix = poseStack.m_85850_().m_85861_();
        buffer.m_85982_(matrix, (float)((double)p.m_123341_() + rect.v1.f_82479_), (float)((double)p.m_123342_() + rect.v1.f_82480_), (float)((double)p.m_123343_() + rect.v1.f_82481_)).m_85950_(r, g, b, a).m_5752_();
        buffer.m_85982_(matrix, (float)((double)p.m_123341_() + rect.v2.f_82479_), (float)((double)p.m_123342_() + rect.v2.f_82480_), (float)((double)p.m_123343_() + rect.v2.f_82481_)).m_85950_(r, g, b, a).m_5752_();
        buffer.m_85982_(matrix, (float)((double)p.m_123341_() + rect.v2.f_82479_), (float)((double)p.m_123342_() + rect.v2.f_82480_), (float)((double)p.m_123343_() + rect.v2.f_82481_)).m_85950_(r, g, b, a).m_5752_();
        buffer.m_85982_(matrix, (float)((double)p.m_123341_() + rect.v3.f_82479_), (float)((double)p.m_123342_() + rect.v3.f_82480_), (float)((double)p.m_123343_() + rect.v3.f_82481_)).m_85950_(r, g, b, a).m_5752_();
        buffer.m_85982_(matrix, (float)((double)p.m_123341_() + rect.v3.f_82479_), (float)((double)p.m_123342_() + rect.v3.f_82480_), (float)((double)p.m_123343_() + rect.v3.f_82481_)).m_85950_(r, g, b, a).m_5752_();
        buffer.m_85982_(matrix, (float)((double)p.m_123341_() + rect.v4.f_82479_), (float)((double)p.m_123342_() + rect.v4.f_82480_), (float)((double)p.m_123343_() + rect.v4.f_82481_)).m_85950_(r, g, b, a).m_5752_();
        buffer.m_85982_(matrix, (float)((double)p.m_123341_() + rect.v4.f_82479_), (float)((double)p.m_123342_() + rect.v4.f_82480_), (float)((double)p.m_123343_() + rect.v4.f_82481_)).m_85950_(r, g, b, a).m_5752_();
        buffer.m_85982_(matrix, (float)((double)p.m_123341_() + rect.v1.f_82479_), (float)((double)p.m_123342_() + rect.v1.f_82480_), (float)((double)p.m_123343_() + rect.v1.f_82481_)).m_85950_(r, g, b, a).m_5752_();
    }

    public static void drawBox(PoseStack matrixStack, VertexConsumer builder, float x1, float x2, float y1, float y2, float z1, float z2, float r, float g, float b, int packedLightIn) {
        Matrix4f matrix = matrixStack.m_85850_().m_85861_();
        builder.m_85982_(matrix, x1, y1, z2).m_85950_(r, g, b, 1.0f).m_85969_(packedLightIn).m_5752_();
        builder.m_85982_(matrix, x2, y1, z2).m_85950_(r, g, b, 1.0f).m_85969_(packedLightIn).m_5752_();
        builder.m_85982_(matrix, x2, y2, z2).m_85950_(r, g, b, 1.0f).m_85969_(packedLightIn).m_5752_();
        builder.m_85982_(matrix, x1, y2, z2).m_85950_(r, g, b, 1.0f).m_85969_(packedLightIn).m_5752_();
        builder.m_85982_(matrix, x1, y2, z1).m_85950_(r, g, b, 1.0f).m_85969_(packedLightIn).m_5752_();
        builder.m_85982_(matrix, x2, y2, z1).m_85950_(r, g, b, 1.0f).m_85969_(packedLightIn).m_5752_();
        builder.m_85982_(matrix, x2, y1, z1).m_85950_(r, g, b, 1.0f).m_85969_(packedLightIn).m_5752_();
        builder.m_85982_(matrix, x1, y1, z1).m_85950_(r, g, b, 1.0f).m_85969_(packedLightIn).m_5752_();
        builder.m_85982_(matrix, x1, y2, z2).m_85950_(r, g, b, 1.0f).m_85969_(packedLightIn).m_5752_();
        builder.m_85982_(matrix, x2, y2, z2).m_85950_(r, g, b, 1.0f).m_85969_(packedLightIn).m_5752_();
        builder.m_85982_(matrix, x2, y2, z1).m_85950_(r, g, b, 1.0f).m_85969_(packedLightIn).m_5752_();
        builder.m_85982_(matrix, x1, y2, z1).m_85950_(r, g, b, 1.0f).m_85969_(packedLightIn).m_5752_();
        builder.m_85982_(matrix, x1, y1, z1).m_85950_(r, g, b, 1.0f).m_85969_(packedLightIn).m_5752_();
        builder.m_85982_(matrix, x2, y1, z1).m_85950_(r, g, b, 1.0f).m_85969_(packedLightIn).m_5752_();
        builder.m_85982_(matrix, x2, y1, z2).m_85950_(r, g, b, 1.0f).m_85969_(packedLightIn).m_5752_();
        builder.m_85982_(matrix, x1, y1, z2).m_85950_(r, g, b, 1.0f).m_85969_(packedLightIn).m_5752_();
        builder.m_85982_(matrix, x1, y1, z1).m_85950_(r, g, b, 1.0f).m_85969_(packedLightIn).m_5752_();
        builder.m_85982_(matrix, x1, y1, z2).m_85950_(r, g, b, 1.0f).m_85969_(packedLightIn).m_5752_();
        builder.m_85982_(matrix, x1, y2, z2).m_85950_(r, g, b, 1.0f).m_85969_(packedLightIn).m_5752_();
        builder.m_85982_(matrix, x1, y2, z1).m_85950_(r, g, b, 1.0f).m_85969_(packedLightIn).m_5752_();
        builder.m_85982_(matrix, x2, y2, z1).m_85950_(r, g, b, 1.0f).m_85969_(packedLightIn).m_5752_();
        builder.m_85982_(matrix, x2, y2, z2).m_85950_(r, g, b, 1.0f).m_85969_(packedLightIn).m_5752_();
        builder.m_85982_(matrix, x2, y1, z2).m_85950_(r, g, b, 1.0f).m_85969_(packedLightIn).m_5752_();
        builder.m_85982_(matrix, x2, y1, z1).m_85950_(r, g, b, 1.0f).m_85969_(packedLightIn).m_5752_();
    }

    public static void drawBox(PoseStack matrixStack, VertexConsumer builder, TextureAtlasSprite sprite, boolean down, boolean up, boolean north, boolean south, boolean west, boolean east, float x1, float x2, float y1, float y2, float z1, float z2, RenderSettings settings) {
        Matrix4f matrix = matrixStack.m_85850_().m_85861_();
        Vec3 c111 = new Vec3((double)x1, (double)y1, (double)z1);
        Vec3 c112 = new Vec3((double)x1, (double)y1, (double)z2);
        Vec3 c121 = new Vec3((double)x1, (double)y2, (double)z1);
        Vec3 c122 = new Vec3((double)x1, (double)y2, (double)z2);
        Vec3 c211 = new Vec3((double)x2, (double)y1, (double)z1);
        Vec3 c212 = new Vec3((double)x2, (double)y1, (double)z2);
        Vec3 c221 = new Vec3((double)x2, (double)y2, (double)z1);
        Vec3 c222 = new Vec3((double)x2, (double)y2, (double)z2);
        if (down) {
            RenderHelper.drawQuad(matrix, builder, sprite, c211, c212, c112, c111, settings);
        }
        if (up) {
            RenderHelper.drawQuad(matrix, builder, sprite, c121, c122, c222, c221, settings);
        }
        if (north) {
            RenderHelper.drawQuad(matrix, builder, sprite, c121, c221, c211, c111, settings);
        }
        if (south) {
            RenderHelper.drawQuad(matrix, builder, sprite, c112, c212, c222, c122, settings);
        }
        if (west) {
            RenderHelper.drawQuad(matrix, builder, sprite, c112, c122, c121, c111, settings);
        }
        if (east) {
            RenderHelper.drawQuad(matrix, builder, sprite, c211, c221, c222, c212, settings);
        }
    }

    public static void drawBoxUnit(PoseStack matrixStack, VertexConsumer builder, TextureAtlasSprite sprite, boolean down, boolean up, boolean north, boolean south, boolean west, boolean east, float x1, float x2, float y1, float y2, float z1, float z2, RenderSettings settings) {
        Matrix4f matrix = matrixStack.m_85850_().m_85861_();
        Vec3 c111 = new Vec3((double)x1, (double)y1, (double)z1);
        Vec3 c112 = new Vec3((double)x1, (double)y1, (double)z2);
        Vec3 c121 = new Vec3((double)x1, (double)y2, (double)z1);
        Vec3 c122 = new Vec3((double)x1, (double)y2, (double)z2);
        Vec3 c211 = new Vec3((double)x2, (double)y1, (double)z1);
        Vec3 c212 = new Vec3((double)x2, (double)y1, (double)z2);
        Vec3 c221 = new Vec3((double)x2, (double)y2, (double)z1);
        Vec3 c222 = new Vec3((double)x2, (double)y2, (double)z2);
        if (down) {
            RenderHelper.drawQuadUnit(matrix, builder, sprite, c211, c212, c112, c111, x1, x2, z1, z2, settings);
        }
        if (up) {
            RenderHelper.drawQuadUnit(matrix, builder, sprite, c121, c122, c222, c221, x1, x2, z1, z2, settings);
        }
        if (north) {
            RenderHelper.drawQuadUnit(matrix, builder, sprite, c121, c221, c211, c111, x1, x2, y1, y2, settings);
        }
        if (south) {
            RenderHelper.drawQuadUnit(matrix, builder, sprite, c112, c212, c222, c122, x1, x2, y1, y2, settings);
        }
        if (west) {
            RenderHelper.drawQuadUnit(matrix, builder, sprite, c112, c122, c121, c111, y1, y2, z1, z2, settings);
        }
        if (east) {
            RenderHelper.drawQuadUnit(matrix, builder, sprite, c211, c221, c222, c212, y1, y2, z1, z2, settings);
        }
    }

    public static void drawQuad(PoseStack poseStack, VertexConsumer buffer, TextureAtlasSprite sprite, Direction side, boolean opposite, float offset, RenderSettings settings) {
        Matrix4f matrix = poseStack.m_85850_().m_85861_();
        switch (side) {
            case DOWN: {
                RenderHelper.drawQuad(matrix, buffer, sprite, new Vec3(0.0, (double)offset, 1.0), new Vec3(1.0, (double)offset, 1.0), new Vec3(1.0, (double)offset, 0.0), new Vec3(0.0, (double)offset, 0.0), opposite, settings);
                break;
            }
            case UP: {
                RenderHelper.drawQuad(matrix, buffer, sprite, new Vec3(1.0, (double)(1.0f - offset), 1.0), new Vec3(0.0, (double)(1.0f - offset), 1.0), new Vec3(0.0, (double)(1.0f - offset), 0.0), new Vec3(1.0, (double)(1.0f - offset), 0.0), opposite, settings);
                break;
            }
            case NORTH: {
                RenderHelper.drawQuad(matrix, buffer, sprite, new Vec3(0.0, 0.0, (double)offset), new Vec3(1.0, 0.0, (double)offset), new Vec3(1.0, 1.0, (double)offset), new Vec3(0.0, 1.0, (double)offset), opposite, settings);
                break;
            }
            case SOUTH: {
                RenderHelper.drawQuad(matrix, buffer, sprite, new Vec3(0.0, 1.0, (double)(1.0f - offset)), new Vec3(1.0, 1.0, (double)(1.0f - offset)), new Vec3(1.0, 0.0, (double)(1.0f - offset)), new Vec3(0.0, 0.0, (double)(1.0f - offset)), opposite, settings);
                break;
            }
            case WEST: {
                RenderHelper.drawQuad(matrix, buffer, sprite, new Vec3((double)offset, 0.0, 0.0), new Vec3((double)offset, 1.0, 0.0), new Vec3((double)offset, 1.0, 1.0), new Vec3((double)offset, 0.0, 1.0), opposite, settings);
                break;
            }
            case EAST: {
                RenderHelper.drawQuad(matrix, buffer, sprite, new Vec3((double)(1.0f - offset), 0.0, 1.0), new Vec3((double)(1.0f - offset), 1.0, 1.0), new Vec3((double)(1.0f - offset), 1.0, 0.0), new Vec3((double)(1.0f - offset), 0.0, 0.0), opposite, settings);
            }
        }
    }

    public static void vt(VertexConsumer renderer, PoseStack stack, float x, float y, float z, float r, float g, float b, int packedLight) {
        renderer.m_85982_(stack.m_85850_().m_85861_(), x, y, z).m_85950_(r, g, b, 1.0f).m_85969_(packedLight).m_5601_(1.0f, 0.0f, 0.0f).m_5752_();
    }

    public static void vt(VertexConsumer renderer, PoseStack stack, float x, float y, float z, float u, float v, int packedLight) {
        renderer.m_85982_(stack.m_85850_().m_85861_(), x, y, z).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(u, v).m_85969_(packedLight).m_5601_(1.0f, 0.0f, 0.0f).m_5752_();
    }

    public static void vt(VertexConsumer renderer, PoseStack matrix, float x, float y, float z, float u, float v, int lu, int lv, int r, int g, int b, int a) {
        renderer.m_85982_(matrix.m_85850_().m_85861_(), x, y, z).m_6122_(r, g, b, a).m_7421_(u, v).m_7120_(lu, lv).m_5601_(1.0f, 0.0f, 0.0f).m_5752_();
    }

    private static void vt(VertexConsumer renderer, Matrix4f matrix, float x, float y, float z, float u, float v, int packedLight) {
        renderer.m_85982_(matrix, x, y, z).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(u, v).m_85969_(packedLight).m_5601_(1.0f, 0.0f, 0.0f).m_5752_();
    }

    private static void vt(VertexConsumer renderer, Matrix4f matrix, float x, float y, float z, float u, float v) {
        renderer.m_85982_(matrix, x, y, z).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(u, v).m_85969_(0xF000F0).m_5601_(1.0f, 0.0f, 0.0f).m_5752_();
    }

    public static void vt(VertexConsumer renderer, Matrix4f matrix, float x, float y, float z, float u, float v, int lu, int lv, int r, int g, int b, int a) {
        renderer.m_85982_(matrix, x, y, z).m_6122_(r, g, b, a).m_7421_(u, v).m_7120_(lu, lv).m_5601_(1.0f, 0.0f, 0.0f).m_5752_();
    }

    public static void putVertex(VertexConsumer builder, Position normal, double x, double y, double z, float u, float v, TextureAtlasSprite sprite, float r, float g, float b, float a) {
        float iu = sprite.m_118367_((double)u);
        float iv = sprite.m_118393_((double)v);
        builder.m_5483_(x, y, z).m_7421_(iu, iv).m_7120_(0, 0).m_85950_(r, g, b, a).m_5601_((float)normal.m_7096_(), (float)normal.m_7098_(), (float)normal.m_7094_()).m_5752_();
    }

    public static void renderHighLightedBlocksOutline(PoseStack poseStack, VertexConsumer buffer, float mx, float my, float mz, float r, float g, float b, float a) {
        Matrix4f matrix = poseStack.m_85850_().m_85861_();
        buffer.m_85982_(matrix, mx, my, mz).m_85950_(r, g, b, a).m_5752_();
        buffer.m_85982_(matrix, mx + 1.0f, my, mz).m_85950_(r, g, b, a).m_5752_();
        buffer.m_85982_(matrix, mx, my, mz).m_85950_(r, g, b, a).m_5752_();
        buffer.m_85982_(matrix, mx, my + 1.0f, mz).m_85950_(r, g, b, a).m_5752_();
        buffer.m_85982_(matrix, mx, my, mz).m_85950_(r, g, b, a).m_5752_();
        buffer.m_85982_(matrix, mx, my, mz + 1.0f).m_85950_(r, g, b, a).m_5752_();
        buffer.m_85982_(matrix, mx + 1.0f, my + 1.0f, mz + 1.0f).m_85950_(r, g, b, a).m_5752_();
        buffer.m_85982_(matrix, mx, my + 1.0f, mz + 1.0f).m_85950_(r, g, b, a).m_5752_();
        buffer.m_85982_(matrix, mx + 1.0f, my + 1.0f, mz + 1.0f).m_85950_(r, g, b, a).m_5752_();
        buffer.m_85982_(matrix, mx + 1.0f, my, mz + 1.0f).m_85950_(r, g, b, a).m_5752_();
        buffer.m_85982_(matrix, mx + 1.0f, my + 1.0f, mz + 1.0f).m_85950_(r, g, b, a).m_5752_();
        buffer.m_85982_(matrix, mx + 1.0f, my + 1.0f, mz).m_85950_(r, g, b, a).m_5752_();
        buffer.m_85982_(matrix, mx, my + 1.0f, mz).m_85950_(r, g, b, a).m_5752_();
        buffer.m_85982_(matrix, mx, my + 1.0f, mz + 1.0f).m_85950_(r, g, b, a).m_5752_();
        buffer.m_85982_(matrix, mx, my + 1.0f, mz).m_85950_(r, g, b, a).m_5752_();
        buffer.m_85982_(matrix, mx + 1.0f, my + 1.0f, mz).m_85950_(r, g, b, a).m_5752_();
        buffer.m_85982_(matrix, mx + 1.0f, my, mz).m_85950_(r, g, b, a).m_5752_();
        buffer.m_85982_(matrix, mx + 1.0f, my, mz + 1.0f).m_85950_(r, g, b, a).m_5752_();
        buffer.m_85982_(matrix, mx + 1.0f, my, mz).m_85950_(r, g, b, a).m_5752_();
        buffer.m_85982_(matrix, mx + 1.0f, my + 1.0f, mz).m_85950_(r, g, b, a).m_5752_();
        buffer.m_85982_(matrix, mx, my, mz + 1.0f).m_85950_(r, g, b, a).m_5752_();
        buffer.m_85982_(matrix, mx + 1.0f, my, mz + 1.0f).m_85950_(r, g, b, a).m_5752_();
        buffer.m_85982_(matrix, mx, my, mz + 1.0f).m_85950_(r, g, b, a).m_5752_();
        buffer.m_85982_(matrix, mx, my + 1.0f, mz + 1.0f).m_85950_(r, g, b, a).m_5752_();
    }

    public static void fill(PoseStack matrixStack, MultiBufferSource buffer, int x1, int y1, int x2, int y2, int color, int lightmap) {
        int swapper;
        Matrix4f positionMatrix = matrixStack.m_85850_().m_85861_();
        if (x1 < x2) {
            swapper = x1;
            x1 = x2;
            x2 = swapper;
        }
        if (y1 < y2) {
            swapper = y1;
            y1 = y2;
            y2 = swapper;
        }
        float a = (float)(color >> 24 & 0xFF) / 255.0f;
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        VertexConsumer builder = buffer.m_6299_(CustomRenderTypes.QUADS_NOTEXTURE);
        builder.m_85982_(positionMatrix, (float)x1, (float)y2, -1.0f).m_85950_(r, g, b, a).m_85969_(lightmap).m_5752_();
        builder.m_85982_(positionMatrix, (float)x2, (float)y2, -1.0f).m_85950_(r, g, b, a).m_85969_(lightmap).m_5752_();
        builder.m_85982_(positionMatrix, (float)x2, (float)y1, -1.0f).m_85950_(r, g, b, a).m_85969_(lightmap).m_5752_();
        builder.m_85982_(positionMatrix, (float)x1, (float)y1, -1.0f).m_85950_(r, g, b, a).m_85969_(lightmap).m_5752_();
    }

    public static void rotateXP(PoseStack stack, float degrees) {
        stack.m_85845_(Vector3f.f_122223_.m_122240_(degrees));
    }

    public static void rotateYP(PoseStack stack, float degrees) {
        stack.m_85845_(Vector3f.f_122225_.m_122240_(degrees));
    }

    public static void rotateZP(PoseStack stack, float degrees) {
        stack.m_85845_(Vector3f.f_122227_.m_122240_(degrees));
    }

    public record Rect(Vec3 v1, Vec3 v2, Vec3 v3, Vec3 v4) {
    }
}

