/*
 * Decompiled with CFR 0.152.
 */
package com.breakinblocks.plonk.common.util;

import com.mojang.math.Matrix3f;
import com.mojang.math.Matrix4f;

public class MatrixUtils {
    public static Matrix4f difference(Matrix4f a, Matrix4f b) {
        Matrix4f aInv = new Matrix4f(a);
        aInv.m_27657_();
        Matrix4f D = new Matrix4f(aInv);
        D.m_27644_(b);
        return D;
    }

    public static class TransformData {
        public final float tx;
        public final float ty;
        public final float tz;
        public final float sx;
        public final float sy;
        public final float sz;
        public final Matrix3f rot;
        public final double pitch;
        public final double yaw;
        public final double roll;

        public TransformData(Matrix4f mat) {
            mat = new Matrix4f(mat);
            this.tx = mat.f_27615_;
            this.ty = mat.f_27616_;
            this.tz = mat.f_27617_;
            this.sx = this.length3f(mat.f_27603_, mat.f_27607_, mat.f_27611_);
            this.sy = this.length3f(mat.f_27604_, mat.f_27608_, mat.f_27612_);
            this.sz = this.length3f(mat.f_27605_, mat.f_27609_, mat.f_27613_);
            this.rot = this.newMat3(mat.f_27603_ / this.sx, mat.f_27604_ / this.sy, mat.f_27605_ / this.sz, mat.f_27607_ / this.sx, mat.f_27608_ / this.sy, mat.f_27609_ / this.sz, mat.f_27611_ / this.sx, mat.f_27612_ / this.sy, mat.f_27613_ / this.sz);
            this.yaw = Math.toDegrees(Math.atan2(this.rot.f_8136_, this.rot.f_8142_));
            this.pitch = Math.toDegrees(-Math.atan2(this.rot.f_8139_, Math.sqrt(Math.pow(this.rot.f_8137_, 2.0) + Math.pow(this.rot.f_8138_, 2.0))));
            this.roll = Math.toDegrees(Math.atan2(this.rot.f_8137_, this.rot.f_8138_));
        }

        private float length3f(float x, float y, float z) {
            return (float)Math.sqrt(x * x + y * y + z * z);
        }

        private Matrix3f newMat3(float m00, float m01, float m02, float m10, float m11, float m12, float m20, float m21, float m22) {
            Matrix3f m = new Matrix3f();
            m.f_8134_ = m00;
            m.f_8135_ = m01;
            m.f_8136_ = m02;
            m.f_8137_ = m10;
            m.f_8138_ = m11;
            m.f_8139_ = m12;
            m.f_8140_ = m20;
            m.f_8141_ = m21;
            m.f_8142_ = m22;
            return m;
        }

        public String toString() {
            return String.format("tx=%.3f", Float.valueOf(this.tx)) + String.format(" ty=%.3f", Float.valueOf(this.ty)) + String.format(" tz=%.3f", Float.valueOf(this.tz)) + String.format(" sx=%.3f", Float.valueOf(this.sx)) + String.format(" sy=%.3f", Float.valueOf(this.sy)) + String.format(" sz=%.3f", Float.valueOf(this.sz)) + String.format(" pitch=%.3f", this.pitch) + String.format(" yaw=%.3f", this.yaw) + String.format(" roll=%.3f", this.roll);
        }
    }
}

