/*
 * Decompiled with CFR 0.152.
 */
package com.breakinblocks.plonk.common.tile;

import com.breakinblocks.plonk.common.block.BlockPlacedItems;
import com.breakinblocks.plonk.common.config.PlonkConfig;
import com.breakinblocks.plonk.common.registry.RegistryTileEntities;
import com.breakinblocks.plonk.common.util.ItemUtils;
import com.breakinblocks.plonk.common.util.bound.Box;
import com.breakinblocks.plonk.common.util.bound.BoxCollection;
import com.google.common.collect.ImmutableMap;
import java.util.Arrays;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TilePlacedItems
extends BlockEntity
implements WorldlyContainer {
    public static final int Tag_VERSION = 1;
    public static final DirectionProperty FACING = BlockPlacedItems.FACING;
    public static final float HEIGHT_PLATE = 0.03125f;
    public static final float HEIGHT_ITEM = 0.09375f;
    public static final float HEIGHT_BLOCK = 0.5f;
    public static final float BLOCK_PADDING_PERCENTAGE = 0.0f;
    public static final float BLOCK_PADDING_AMOUNT = 0.0f;
    public static final Box BOX_BLOCK = new Box(0.25, 0.0, 0.25, 0.75, 0.5, 0.75);
    public static final Box BOX_ITEM_ONE = new Box(0.0, 0.0, 0.0, 1.0, 0.09375, 1.0);
    public static final Box BOX_ITEM_MANY = new Box(0.25, 0.0, 0.25, 0.75, 0.09375, 0.75);
    public static final String TAG_VERSION = "Version";
    public static final String TAG_TILE_ROTATION = "TileRotation";
    public static final int TILE_ROTATION_COUNT = 4;
    public static final String TAG_ITEM_ROTATION = "ItemRotation";
    public static final String TAG_ITEMS = "Items";
    public static final String TAG_SLOT = "Slot";
    public static final String TAG_RENDER_TYPE = "RenderType";
    public static final int RENDER_TYPE_BLOCK = 1;
    public static final int RENDER_TYPE_ITEM = 0;
    public static final int ITEM_ROTATION_COUNT = 16;
    private static final Logger LOG = LogManager.getLogger();
    boolean needsCleaning = true;
    private int tileRotation = 0;
    private NonNullList<ItemStack> contents = NonNullList.m_122780_((int)this.m_6643_(), (Object)ItemStack.f_41583_);
    private ItemMeta[] contentsMeta = new ItemMeta[this.m_6643_()];
    private ItemStack[] contentsDisplay = new ItemStack[0];
    private BoxCollection contentsBoxes = new BoxCollection.Builder().addBox(0, 0.0, 0.0, 0.0, 1.0, 1.0, 1.0).build();

    protected TilePlacedItems(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        Arrays.fill(this.contentsMeta, ItemMeta.DEFAULT);
    }

    public TilePlacedItems(BlockPos pos, BlockState state) {
        this(RegistryTileEntities.placed_items, pos, state);
    }

    public static void clientTick(Level level, BlockPos pPos, BlockState pState, TilePlacedItems pBlockEntity) {
        pBlockEntity.clientTick();
    }

    public static void serverTick(Level level, BlockPos pPos, BlockState pState, TilePlacedItems pBlockEntity) {
        pBlockEntity.serverTick();
    }

    public boolean clean() {
        int first_empty = -1;
        int last_not_empty = -1;
        int count = 0;
        for (int i = 0; i < this.contents.size(); ++i) {
            if (((ItemStack)this.contents.get(i)).m_41619_()) {
                if (first_empty != -1) continue;
                first_empty = i;
                continue;
            }
            last_not_empty = i;
            ++count;
        }
        if (last_not_empty == -1) {
            Objects.requireNonNull(this.f_58857_);
            this.f_58857_.m_7471_(this.f_58858_, false);
            return true;
        }
        if (this.contentsDisplay.length == count) {
            if (first_empty == -1) {
                return false;
            }
            if (first_empty > last_not_empty) {
                return false;
            }
        }
        boolean shifted = this.updateContents();
        this.updateContentsDisplay();
        return shifted;
    }

    private boolean updateContents() {
        boolean changed = false;
        block0: for (int i = 0; i < this.contents.size() - 1; ++i) {
            if (!((ItemStack)this.contents.get(i)).m_41619_()) continue;
            for (int j = i + 1; j < this.contents.size(); ++j) {
                if (((ItemStack)this.contents.get(j)).m_41619_()) continue;
                this.contents.set(i, (Object)((ItemStack)this.contents.get(j)));
                this.contentsMeta[i] = this.contentsMeta[j];
                this.contentsMeta[j] = ItemMeta.DEFAULT;
                this.contents.set(j, (Object)ItemStack.f_41583_);
                changed = true;
                continue block0;
            }
        }
        return changed;
    }

    private void updateContentsDisplay() {
        int count = 0;
        for (int i = 0; i < this.contents.size(); ++i) {
            if (((ItemStack)this.contents.get(i)).m_41619_()) continue;
            count = i + 1;
        }
        this.contentsDisplay = (ItemStack[])this.contents.stream().limit(count).toArray(ItemStack[]::new);
        this.updateContentsBoxes(count);
    }

    private Box getBox(int count, int renderType) {
        switch (renderType) {
            case 1: {
                return BOX_BLOCK;
            }
        }
        return count == 1 ? BOX_ITEM_ONE : BOX_ITEM_MANY;
    }

    private void updateContentsBoxes(int count) {
        Objects.requireNonNull(this.f_58857_);
        BoxCollection.Builder builder = new BoxCollection.Builder(false, true);
        switch (count) {
            case 1: {
                builder.addBox(1, this.getBox(count, this.contentsMeta[0].renderType));
                break;
            }
            case 2: {
                builder.addBox(1, this.getBox(count, this.contentsMeta[0].renderType).translate(-0.25, 0.0, 0.0));
                builder.addBox(2, this.getBox(count, this.contentsMeta[1].renderType).translate(0.25, 0.0, 0.0));
                break;
            }
            case 4: {
                builder.addBox(4, this.getBox(count, this.contentsMeta[3].renderType).translate(0.25, 0.0, 0.25));
            }
            case 3: {
                builder.addBox(1, this.getBox(count, this.contentsMeta[0].renderType).translate(-0.25, 0.0, -0.25));
                builder.addBox(2, this.getBox(count, this.contentsMeta[1].renderType).translate(0.25, 0.0, -0.25));
                builder.addBox(3, this.getBox(count, this.contentsMeta[2].renderType).translate(-0.25, 0.0, 0.25));
                break;
            }
            default: {
                builder.addBox(0, 0.0, 0.0, 0.0, 1.0, 0.03125, 1.0);
            }
        }
        switch (this.tileRotation % 4) {
            case 0: {
                break;
            }
            case 1: {
                builder.apply(Box::rotateY270);
                break;
            }
            case 2: {
                builder.apply(Box::rotateY180);
                break;
            }
            case 3: {
                builder.apply(Box::rotateY90);
            }
        }
        Direction facing = (Direction)this.f_58857_.m_8055_(this.m_58899_()).m_61143_((Property)FACING);
        switch (facing) {
            case UP: {
                break;
            }
            case DOWN: {
                builder.apply(Box::rotateZ180);
                break;
            }
            case SOUTH: {
                builder.apply(Box::rotateX90);
                break;
            }
            case NORTH: {
                builder.apply(Box::rotateX90).apply(Box::rotateY180);
                break;
            }
            case EAST: {
                builder.apply(Box::rotateX90).apply(Box::rotateY90);
                break;
            }
            case WEST: {
                builder.apply(Box::rotateX90).apply(Box::rotateY270);
            }
        }
        this.contentsBoxes = builder.build();
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        TagUpgrader.upgrade(tag);
        this.tileRotation = tag.m_128451_(TAG_TILE_ROTATION);
        ListTag tagItems = tag.m_128437_(TAG_ITEMS, 10);
        this.contents = NonNullList.m_122780_((int)this.m_6643_(), (Object)ItemStack.f_41583_);
        this.contentsMeta = new ItemMeta[this.m_6643_()];
        Arrays.fill(this.contentsMeta, ItemMeta.DEFAULT);
        for (int i = 0; i < tagItems.size(); ++i) {
            CompoundTag tagItem = tagItems.m_128728_(i);
            int slot = tagItem.m_128445_(TAG_SLOT) & 0xFF;
            int renderType = tagItem.m_128451_(TAG_RENDER_TYPE);
            int itemRotation = tagItem.m_128451_(TAG_ITEM_ROTATION);
            if (slot >= this.contents.size()) continue;
            this.contents.set(slot, (Object)ItemStack.m_41712_((CompoundTag)tagItem));
            this.contentsMeta[slot] = new ItemMeta(renderType, itemRotation);
        }
        this.needsCleaning = true;
    }

    public void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128405_(TAG_VERSION, 1);
        tag.m_128405_(TAG_TILE_ROTATION, this.tileRotation);
        ListTag tagItems = new ListTag();
        for (int slot = 0; slot < this.contents.size(); ++slot) {
            if (((ItemStack)this.contents.get(slot)).m_41619_()) continue;
            CompoundTag tagItem = new CompoundTag();
            tagItem.m_128344_(TAG_SLOT, (byte)slot);
            tagItem.m_128405_(TAG_RENDER_TYPE, this.contentsMeta[slot].renderType);
            tagItem.m_128405_(TAG_ITEM_ROTATION, this.contentsMeta[slot].rotation);
            ((ItemStack)this.contents.get(slot)).m_41739_(tagItem);
            tagItems.add((Object)tagItem);
        }
        tag.m_128365_(TAG_ITEMS, (Tag)tagItems);
    }

    public void clientTick() {
        Objects.requireNonNull(this.f_58857_);
        if (this.needsCleaning) {
            this.updateContentsDisplay();
            this.needsCleaning = false;
        }
    }

    public void serverTick() {
        Objects.requireNonNull(this.f_58857_);
        if (this.needsCleaning) {
            if (this.clean()) {
                this.m_6596_();
            }
            this.needsCleaning = false;
        }
    }

    public void m_6596_() {
        Objects.requireNonNull(this.f_58857_);
        this.f_58857_.m_7260_(this.f_58858_, this.f_58857_.m_8055_(this.f_58858_), this.f_58857_.m_8055_(this.f_58858_), 3);
        super.m_6596_();
    }

    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public CompoundTag m_5995_() {
        return this.m_187482_();
    }

    @OnlyIn(value=Dist.CLIENT)
    public AABB getRenderBoundingBox() {
        return BlockEntity.INFINITE_EXTENT_AABB;
    }

    public int m_6643_() {
        return 4;
    }

    public boolean m_7983_() {
        for (ItemStack stack : this.contents) {
            if (stack.m_41619_()) continue;
            return false;
        }
        return true;
    }

    public ItemStack m_8020_(int slot) {
        return (ItemStack)this.contents.get(slot);
    }

    public ItemStack m_7407_(int index, int count) {
        ItemStack itemstack = ContainerHelper.m_18969_(this.contents, (int)index, (int)count);
        if (!itemstack.m_41619_()) {
            this.needsCleaning = true;
            this.m_6596_();
        }
        return itemstack;
    }

    public ItemStack m_8016_(int index) {
        return ContainerHelper.m_18966_(this.contents, (int)index);
    }

    public void m_6836_(int index, ItemStack stack) {
        this.contents.set(index, (Object)stack);
        if (stack.m_41613_() > this.m_6893_()) {
            stack.m_41764_(this.m_6893_());
        }
        this.needsCleaning = true;
        this.m_6596_();
    }

    public int m_6893_() {
        return PlonkConfig.getInventoryStackLimit();
    }

    public boolean m_6542_(Player player) {
        return false;
    }

    public void m_5856_(Player player) {
    }

    public void m_5785_(Player player) {
    }

    public boolean m_7013_(int slot, ItemStack stack) {
        return PlonkConfig.canPlace(stack);
    }

    public void m_6211_() {
    }

    public int[] m_7071_(Direction side) {
        return new int[]{0, 1, 2, 3};
    }

    public boolean m_7155_(int index, ItemStack itemStackIn, @Nullable Direction direction) {
        return false;
    }

    public boolean m_7157_(int index, ItemStack stack, Direction direction) {
        return true;
    }

    public int getTileRotation() {
        return this.tileRotation;
    }

    public void setTileRotation(int tileRotation) {
        this.tileRotation = tileRotation % 4;
    }

    public double getTileRotationAngle() {
        return 360.0 * (double)this.getTileRotation() / 4.0;
    }

    public void rotateTile() {
        this.tileRotation = (this.tileRotation + 1) % 4;
        this.updateContentsDisplay();
    }

    public void rotateSlot(int slot) {
        if (0 <= slot && slot < this.contentsMeta.length) {
            this.contentsMeta[slot] = this.contentsMeta[slot].rotate();
        }
    }

    public ItemStack[] getContentsDisplay() {
        return this.contentsDisplay;
    }

    public ItemMeta[] getContentsMeta() {
        return this.contentsMeta;
    }

    public BoxCollection getContentsBoxes() {
        return this.contentsBoxes;
    }

    public ItemStack insertStack(ItemStack stack, int renderType) {
        ItemUtils.InsertStackResult result = ItemUtils.insertStackAdv((Container)this, stack);
        if (result.remainder != stack) {
            for (int slot : result.slots) {
                this.contentsMeta[slot] = this.contentsMeta[slot].withRenderType(renderType);
            }
        }
        return result.remainder;
    }

    public static final class ItemMeta {
        public static final ItemMeta DEFAULT = new ItemMeta(0, 0);
        public final int renderType;
        public final int rotation;

        private ItemMeta(int renderType, int rotation) {
            this.renderType = renderType;
            this.rotation = rotation;
        }

        public ItemMeta withRenderType(int renderType) {
            return new ItemMeta(renderType, this.rotation);
        }

        public ItemMeta withRotation(int rotation) {
            return new ItemMeta(this.renderType, rotation);
        }

        public ItemMeta rotate() {
            return this.withRotation((this.rotation + 1) % 16);
        }

        public double getRotationAngle() {
            return 360.0 * (double)this.rotation / 16.0;
        }
    }

    private static class TagUpgrader {
        public static final ImmutableMap<Integer, Upgrade> UPGRADES = ImmutableMap.builder().put((Object)0, TagUpgrader::upgradeFrom0To1).build();

        private TagUpgrader() {
        }

        public static void upgrade(CompoundTag tag) {
            int tileVersion = tag.m_128451_(TilePlacedItems.TAG_VERSION);
            while (tileVersion < 1 && UPGRADES.containsKey((Object)tileVersion)) {
                ((Upgrade)UPGRADES.get((Object)tileVersion)).apply(tag);
                tileVersion = tag.m_128451_(TilePlacedItems.TAG_VERSION);
            }
            if (tileVersion < 1) {
                throw new RuntimeException("Failed to upgrade an existing tile!");
            }
            if (tileVersion > 1) {
                LOG.warn("Placed Items tile version " + tileVersion + " > 1 (current). Potential loss of data.");
            }
        }

        public static void upgradeFrom0To1(CompoundTag tag) {
            String TAG_IS_BLOCK = "IsBlock";
            String TAG_VERSION = TilePlacedItems.TAG_VERSION;
            String TAG_TILE_ROTATION = TilePlacedItems.TAG_TILE_ROTATION;
            String TAG_ITEMS = TilePlacedItems.TAG_ITEMS;
            String TAG_RENDER_TYPE = TilePlacedItems.TAG_RENDER_TYPE;
            String TAG_ITEM_ROTATION = TilePlacedItems.TAG_ITEM_ROTATION;
            tag.m_128405_(TilePlacedItems.TAG_VERSION, 1);
            tag.m_128405_(TilePlacedItems.TAG_TILE_ROTATION, 0);
            ListTag tagItems = tag.m_128437_(TilePlacedItems.TAG_ITEMS, 10);
            for (int i = 0; i < tagItems.size(); ++i) {
                CompoundTag tagItem = tagItems.m_128728_(i);
                if (tagItem.m_128441_("IsBlock")) {
                    boolean isBlock = tagItem.m_128471_("IsBlock");
                    tagItem.m_128405_(TilePlacedItems.TAG_RENDER_TYPE, isBlock ? 1 : 0);
                }
                tagItem.m_128405_(TilePlacedItems.TAG_ITEM_ROTATION, 0);
            }
        }

        private static interface Upgrade {
            public void apply(CompoundTag var1);
        }
    }
}

