/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.client.screen;

import com.direwolf20.buildinggadgets.client.KeyBindings;
import com.direwolf20.buildinggadgets.client.OurSounds;
import com.direwolf20.buildinggadgets.client.renderer.OurRenderTypes;
import com.direwolf20.buildinggadgets.client.screen.CopyGUI;
import com.direwolf20.buildinggadgets.client.screen.MaterialListGUI;
import com.direwolf20.buildinggadgets.client.screen.PasteGUI;
import com.direwolf20.buildinggadgets.client.screen.widgets.GuiIconActionable;
import com.direwolf20.buildinggadgets.client.screen.widgets.IncrementalSliderWidget;
import com.direwolf20.buildinggadgets.common.config.Config;
import com.direwolf20.buildinggadgets.common.items.AbstractGadget;
import com.direwolf20.buildinggadgets.common.items.GadgetBuilding;
import com.direwolf20.buildinggadgets.common.items.GadgetCopyPaste;
import com.direwolf20.buildinggadgets.common.items.GadgetDestruction;
import com.direwolf20.buildinggadgets.common.items.GadgetExchanger;
import com.direwolf20.buildinggadgets.common.items.modes.BuildingModes;
import com.direwolf20.buildinggadgets.common.items.modes.ExchangingModes;
import com.direwolf20.buildinggadgets.common.network.PacketHandler;
import com.direwolf20.buildinggadgets.common.network.packets.PacketAnchor;
import com.direwolf20.buildinggadgets.common.network.packets.PacketChangeRange;
import com.direwolf20.buildinggadgets.common.network.packets.PacketRotateMirror;
import com.direwolf20.buildinggadgets.common.network.packets.PacketToggleBlockPlacement;
import com.direwolf20.buildinggadgets.common.network.packets.PacketToggleConnectedArea;
import com.direwolf20.buildinggadgets.common.network.packets.PacketToggleFluidOnly;
import com.direwolf20.buildinggadgets.common.network.packets.PacketToggleFuzzy;
import com.direwolf20.buildinggadgets.common.network.packets.PacketToggleMode;
import com.direwolf20.buildinggadgets.common.network.packets.PacketToggleRayTraceFluid;
import com.direwolf20.buildinggadgets.common.network.packets.PacketUndo;
import com.direwolf20.buildinggadgets.common.util.GadgetUtils;
import com.direwolf20.buildinggadgets.common.util.lang.GuiTranslation;
import com.direwolf20.buildinggadgets.common.util.lang.MessageTranslation;
import com.direwolf20.buildinggadgets.common.util.lang.RadialTranslation;
import com.direwolf20.buildinggadgets.common.util.lang.Styles;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Matrix4f;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeI18n;

public class ModeRadialMenu
extends Screen {
    private static final ImmutableList<ResourceLocation> signsCopyPaste = ImmutableList.of((Object)new ResourceLocation("buildinggadgets", "textures/gui/mode/copy.png"), (Object)new ResourceLocation("buildinggadgets", "textures/gui/mode/paste.png"));
    private final List<Button> conditionalButtons = new ArrayList<Button>();
    private int timeIn = 0;
    private int slotSelected = -1;
    private int segments;

    public ModeRadialMenu(ItemStack stack) {
        super((Component)Component.m_237113_((String)""));
        if (stack.m_41720_() instanceof AbstractGadget) {
            this.setSocketable(stack);
        }
    }

    private static float mouseAngle(int x, int y, int mx, int my) {
        Vector2f baseVec = new Vector2f(1.0f, 0.0f);
        Vector2f mouseVec = new Vector2f(mx - x, my - y);
        float ang = (float)(Math.acos(baseVec.dot(mouseVec) / (baseVec.length() * mouseVec.length())) * 57.29577951308232);
        return my < y ? 360.0f - ang : ang;
    }

    public void setSocketable(ItemStack stack) {
        if (stack.m_41720_() instanceof GadgetBuilding) {
            this.segments = BuildingModes.values().length;
        } else if (stack.m_41720_() instanceof GadgetExchanger) {
            this.segments = ExchangingModes.values().length;
        } else if (stack.m_41720_() instanceof GadgetCopyPaste) {
            this.segments = GadgetCopyPaste.ToolMode.values().length;
        }
    }

    public void m_7856_() {
        ScreenPosition left;
        this.conditionalButtons.clear();
        ItemStack tool = this.getGadget();
        boolean isDestruction = tool.m_41720_() instanceof GadgetDestruction;
        ScreenPosition right = isDestruction ? ScreenPosition.TOP : ScreenPosition.RIGHT;
        ScreenPosition screenPosition = left = isDestruction ? ScreenPosition.BOTTOM : ScreenPosition.LEFT;
        if (isDestruction) {
            this.m_142416_((GuiEventListener)new PositionedIconActionable(RadialTranslation.DESTRUCTION_OVERLAY, "destroy_overlay", right, send -> {
                if (send.booleanValue()) {
                    PacketHandler.sendToServer(new PacketChangeRange());
                }
                return GadgetDestruction.getOverlay(this.getGadget());
            }));
            this.m_142416_((GuiEventListener)new PositionedIconActionable(RadialTranslation.FLUID_ONLY, "fluid_only", right, send -> {
                if (send.booleanValue()) {
                    PacketHandler.sendToServer(new PacketToggleFluidOnly());
                }
                return GadgetDestruction.getIsFluidOnly(this.getGadget());
            }));
        } else {
            this.m_142416_((GuiEventListener)new PositionedIconActionable(RadialTranslation.ROTATE, "rotate", left, false, send -> {
                if (send.booleanValue()) {
                    PacketHandler.sendToServer(new PacketRotateMirror(PacketRotateMirror.Operation.ROTATE));
                }
                return false;
            }));
            this.m_142416_((GuiEventListener)new PositionedIconActionable(RadialTranslation.MIRROR, "mirror", left, false, send -> {
                if (send.booleanValue()) {
                    PacketHandler.sendToServer(new PacketRotateMirror(PacketRotateMirror.Operation.MIRROR));
                }
                return false;
            }));
        }
        if (!(tool.m_41720_() instanceof GadgetCopyPaste)) {
            PositionedIconActionable button;
            if (!isDestruction || ((Boolean)Config.GADGETS.GADGET_DESTRUCTION.nonFuzzyEnabled.get()).booleanValue()) {
                button = new PositionedIconActionable(RadialTranslation.FUZZY, "fuzzy", right, send -> {
                    if (send.booleanValue()) {
                        PacketHandler.sendToServer(new PacketToggleFuzzy());
                    }
                    return AbstractGadget.getFuzzy(this.getGadget());
                });
                this.m_142416_((GuiEventListener)button);
                this.conditionalButtons.add(button);
            }
            if (!isDestruction) {
                button = new PositionedIconActionable(RadialTranslation.CONNECTED_SURFACE, "connected_area", right, send -> {
                    if (send.booleanValue()) {
                        PacketHandler.sendToServer(new PacketToggleConnectedArea());
                    }
                    return AbstractGadget.getConnectedArea(this.getGadget());
                });
                this.m_142416_((GuiEventListener)button);
                this.conditionalButtons.add(button);
            }
            if (!isDestruction) {
                int widthSlider = 82;
                IncrementalSliderWidget sliderRange = new IncrementalSliderWidget(this.f_96543_ / 2 - widthSlider / 2, this.f_96544_ / 2 + 72, widthSlider, 14, 1.0, ((Integer)Config.GADGETS.maxRange.get()).intValue(), (Component)GuiTranslation.SINGLE_RANGE.componentTranslation(new Object[0]).m_130946_(": "), GadgetUtils.getToolRange(tool), slider -> this.sendRangeUpdate(slider.getValueInt()));
                sliderRange.getComponents().forEach(x$0 -> {
                    AbstractWidget cfr_ignored_0 = (AbstractWidget)this.m_142416_((GuiEventListener)x$0);
                });
            }
        } else {
            this.m_142416_((GuiEventListener)new PositionedIconActionable(RadialTranslation.OPEN_GUI, "copypaste_opengui", right, send -> {
                if (!send.booleanValue()) {
                    return false;
                }
                assert (this.getMinecraft().f_91074_ != null);
                this.getMinecraft().f_91074_.m_6915_();
                if (GadgetCopyPaste.getToolMode(tool) == GadgetCopyPaste.ToolMode.COPY) {
                    this.getMinecraft().m_91152_((Screen)new CopyGUI(tool));
                } else {
                    this.getMinecraft().m_91152_((Screen)new PasteGUI(tool));
                }
                return true;
            }));
            this.m_142416_((GuiEventListener)new PositionedIconActionable(RadialTranslation.OPEN_MATERIAL_LIST, "copypaste_materiallist", right, send -> {
                if (!send.booleanValue()) {
                    return false;
                }
                assert (this.getMinecraft().f_91074_ != null);
                this.getMinecraft().f_91074_.m_6915_();
                this.getMinecraft().m_91152_((Screen)new MaterialListGUI(tool));
                return true;
            }));
        }
        this.m_142416_((GuiEventListener)new PositionedIconActionable(RadialTranslation.RAYTRACE_FLUID, "raytrace_fluid", right, send -> {
            if (send.booleanValue()) {
                PacketHandler.sendToServer(new PacketToggleRayTraceFluid());
            }
            return AbstractGadget.shouldRayTraceFluid(this.getGadget());
        }));
        if (tool.m_41720_() instanceof GadgetBuilding) {
            this.m_142416_((GuiEventListener)new PositionedIconActionable(RadialTranslation.PLACE_ON_TOP, "building_place_atop", right, send -> {
                if (send.booleanValue()) {
                    PacketHandler.sendToServer(new PacketToggleBlockPlacement());
                }
                return GadgetBuilding.shouldPlaceAtop(this.getGadget());
            }));
        }
        this.m_142416_((GuiEventListener)new PositionedIconActionable(RadialTranslation.ANCHOR, "anchor", left, send -> {
            ItemStack stack;
            if (send.booleanValue()) {
                PacketHandler.sendToServer(new PacketAnchor());
            }
            if ((stack = this.getGadget()).m_41720_() instanceof GadgetCopyPaste || stack.m_41720_() instanceof GadgetDestruction) {
                return ((AbstractGadget)stack.m_41720_()).getAnchor(stack) != null;
            }
            return GadgetUtils.getAnchor(stack).isPresent();
        }));
        if (!(tool.m_41720_() instanceof GadgetExchanger)) {
            this.m_142416_((GuiEventListener)new PositionedIconActionable(RadialTranslation.UNDO, "undo", left, false, send -> {
                if (send.booleanValue()) {
                    PacketHandler.sendToServer(new PacketUndo());
                }
                return false;
            }));
        }
        this.updateButtons(tool);
    }

    private void updateButtons(ItemStack tool) {
        PositionedIconActionable button;
        int posRight = 0;
        int posLeft = 0;
        int dim = 24;
        int padding = 10;
        boolean isDestruction = tool.m_41720_() instanceof GadgetDestruction;
        ScreenPosition right = isDestruction ? ScreenPosition.BOTTOM : ScreenPosition.RIGHT;
        for (GuiEventListener widget : this.m_6702_()) {
            int offset;
            boolean isRight;
            if (!(widget instanceof PositionedIconActionable)) continue;
            button = (PositionedIconActionable)widget;
            if (!button.f_93624_) continue;
            boolean bl = isRight = button.position == right;
            if (isRight) {
                posRight += dim + padding;
                offset = 70;
            } else {
                posLeft += dim + padding;
                offset = -70 - dim;
            }
            button.m_93674_(dim);
            button.setHeight(dim);
            if (isDestruction) {
                button.f_93621_ = this.f_96544_ / 2 + (isRight ? 10 : -button.m_93694_() - 10);
                continue;
            }
            button.f_93620_ = this.f_96543_ / 2 + offset;
        }
        posRight = this.resetPos(tool, padding, posRight);
        posLeft = this.resetPos(tool, padding, posLeft);
        for (GuiEventListener widget : this.m_6702_()) {
            int pos;
            if (!(widget instanceof PositionedIconActionable)) continue;
            button = (PositionedIconActionable)widget;
            if (!button.f_93624_) continue;
            boolean isRight = button.position == right;
            int n = pos = isRight ? posRight : posLeft;
            if (isDestruction) {
                button.f_93620_ = pos;
            } else {
                button.f_93621_ = pos;
            }
            if (isRight) {
                posRight += dim + padding;
                continue;
            }
            posLeft += dim + padding;
        }
    }

    private int resetPos(ItemStack tool, int padding, int pos) {
        return tool.m_41720_() instanceof GadgetDestruction ? this.f_96543_ / 2 - (pos - padding) / 2 : this.f_96544_ / 2 - (pos - padding) / 2;
    }

    private ItemStack getGadget() {
        assert (this.getMinecraft().f_91074_ != null);
        return AbstractGadget.getGadget((Player)this.getMinecraft().f_91074_);
    }

    public void m_6305_(PoseStack matrices, int mx, int my, float partialTicks) {
        Object signs;
        int modeIndex;
        float stime = 5.0f;
        float fract = Math.min(stime, (float)this.timeIn + partialTicks) / stime;
        int x = this.f_96543_ / 2;
        int y = this.f_96544_ / 2;
        int radiusMin = 26;
        int radiusMax = 60;
        double dist = new Vec3((double)x, (double)y, 0.0).m_82554_(new Vec3((double)mx, (double)my, 0.0));
        boolean inRange = false;
        if (this.segments != 0) {
            inRange = dist > (double)radiusMin && dist < (double)radiusMax;
            for (GuiEventListener button : this.m_6702_()) {
                if (!(button instanceof PositionedIconActionable)) continue;
                ((PositionedIconActionable)button).setFaded(inRange);
            }
        }
        matrices.m_85836_();
        matrices.m_85837_((double)((1.0f - fract) * (float)x), (double)((1.0f - fract) * (float)y), 0.0);
        matrices.m_85841_(fract, fract, fract);
        super.m_6305_(matrices, mx, my, partialTicks);
        matrices.m_85849_();
        if (this.segments == 0) {
            return;
        }
        float angle = ModeRadialMenu.mouseAngle(x, y, mx, my);
        float totalDeg = 0.0f;
        float degPer = 360.0f / (float)this.segments;
        ArrayList<NameDisplayData> nameData = new ArrayList<NameDisplayData>();
        ItemStack tool = this.getGadget();
        if (tool.m_41619_()) {
            return;
        }
        this.slotSelected = -1;
        if (tool.m_41720_() instanceof GadgetBuilding) {
            modeIndex = GadgetBuilding.getToolMode(tool).ordinal();
            signs = Arrays.stream(BuildingModes.values()).map(e -> new ResourceLocation("buildinggadgets", e.getIcon())).collect(Collectors.toList());
        } else if (tool.m_41720_() instanceof GadgetExchanger) {
            modeIndex = GadgetExchanger.getToolMode(tool).ordinal();
            signs = Arrays.stream(ExchangingModes.values()).map(e -> new ResourceLocation("buildinggadgets", e.getIcon())).collect(Collectors.toList());
        } else {
            modeIndex = GadgetCopyPaste.getToolMode(tool).ordinal();
            signs = signsCopyPaste;
        }
        boolean shouldCenter = (this.segments + 2) % 4 == 0;
        int indexBottom = this.segments / 4;
        int indexTop = indexBottom + this.segments / 2;
        for (int seg = 0; seg < this.segments; ++seg) {
            boolean mouseInSector = this.isCursorInSlice(angle, totalDeg, degPer, inRange);
            float radius = Math.max(0.0f, Math.min(((float)this.timeIn + partialTicks - (float)seg * 6.0f / (float)this.segments) * 40.0f, (float)radiusMax));
            float gs = 0.25f;
            if (seg % 2 == 0) {
                gs += 0.1f;
            }
            float r = gs;
            float g = gs + (seg == modeIndex ? 1.0f : 0.0f);
            float b = gs;
            float a = 0.4f;
            if (mouseInSector) {
                this.slotSelected = seg;
                b = 1.0f;
                g = 1.0f;
                r = 1.0f;
            }
            MultiBufferSource.BufferSource bufferSource = Minecraft.m_91087_().m_91269_().m_110104_();
            VertexConsumer buffer = bufferSource.m_6299_(OurRenderTypes.TRIANGLE_STRIP);
            for (float i = degPer; i >= 0.0f; i -= 1.0f) {
                float rad = (float)((double)((i + totalDeg) / 180.0f) * Math.PI);
                float xp = (float)((double)x + Math.cos(rad) * (double)radius);
                float yp = (float)((double)y + Math.sin(rad) * (double)radius);
                if ((int)i == (int)(degPer / 2.0f)) {
                    nameData.add(new NameDisplayData((int)xp, (int)yp, mouseInSector, shouldCenter && (seg == indexBottom || seg == indexTop)));
                }
                Matrix4f pose = matrices.m_85850_().m_85861_();
                buffer.m_85982_(pose, (float)((double)x + Math.cos(rad) * (double)radius / (double)2.3f), (float)((double)y + Math.sin(rad) * (double)radius / (double)2.3f), 0.0f).m_85950_(r, g, b, a).m_5752_();
                buffer.m_5483_((double)xp, (double)yp, 0.0).m_85950_(r, g, b, a).m_5752_();
            }
            bufferSource.m_109912_(OurRenderTypes.TRIANGLE_STRIP);
            totalDeg += degPer;
        }
        for (int i = 0; i < nameData.size(); ++i) {
            Color color;
            matrices.m_85836_();
            NameDisplayData data = (NameDisplayData)nameData.get(i);
            int xp = data.getX();
            int yp = data.getY();
            String name = tool.m_41720_() instanceof GadgetBuilding ? ForgeI18n.getPattern((String)BuildingModes.values()[i].getTranslationKey()) : (tool.m_41720_() instanceof GadgetExchanger ? ForgeI18n.getPattern((String)ExchangingModes.values()[i].getTranslationKey()) : GadgetCopyPaste.ToolMode.values()[i].getTranslation().format(new Object[0]));
            int xsp = xp - 4;
            int ysp = yp;
            int width = this.f_96547_.m_92895_(name);
            if (xsp < x) {
                xsp -= width - 8;
            }
            if (ysp < y) {
                ysp -= 9;
            }
            Color color2 = color = i == modeIndex ? Color.GREEN : Color.WHITE;
            if (data.isSelected()) {
                this.f_96547_.m_92750_(matrices, name, (float)xsp + (data.isCentralized() ? (float)width / 2.0f - 4.0f : 0.0f), (float)ysp, color.getRGB());
            }
            double mod = 0.7;
            int xdp = (int)((double)(xp - x) * mod + (double)x);
            int ydp = (int)((double)(yp - y) * mod + (double)y);
            RenderSystem.m_157427_(GameRenderer::m_172817_);
            RenderSystem.m_157429_((float)((float)color.getRed() / 255.0f), (float)((float)color.getGreen() / 255.0f), (float)((float)color.getBlue() / 255.0f), (float)1.0f);
            RenderSystem.m_157456_((int)0, (ResourceLocation)((ResourceLocation)signs.get(i)));
            ModeRadialMenu.m_93133_((PoseStack)matrices, (int)(xdp - 8), (int)(ydp - 8), (float)0.0f, (float)0.0f, (int)16, (int)16, (int)16, (int)16);
            matrices.m_85849_();
        }
        float s = 1.8f * fract;
        PoseStack stack = RenderSystem.m_157191_();
        stack.m_85836_();
        stack.m_85841_(s, s, s);
        matrices.m_85849_();
        stack.m_85837_((double)((float)x / s) - (tool.m_41720_() instanceof GadgetCopyPaste ? 8.0 : 8.5), (double)((float)y / s - 8.0f), 0.0);
        this.f_96542_.m_115203_(tool, 0, 0);
        stack.m_85849_();
    }

    private boolean isCursorInSlice(float angle, float totalDeg, float degPer, boolean inRange) {
        return inRange && angle > totalDeg && angle < totalDeg + degPer;
    }

    private void changeMode() {
        if (this.slotSelected >= 0) {
            Item gadget = this.getGadget().m_41720_();
            String mode = gadget instanceof GadgetBuilding ? ForgeI18n.getPattern((String)BuildingModes.values()[this.slotSelected].getTranslationKey()) : (gadget instanceof GadgetExchanger ? ForgeI18n.getPattern((String)ExchangingModes.values()[this.slotSelected].getTranslationKey()) : GadgetCopyPaste.ToolMode.values()[this.slotSelected].getTranslation().format(new Object[0]));
            assert (this.getMinecraft().f_91074_ != null);
            this.getMinecraft().f_91074_.m_5661_((Component)MessageTranslation.MODE_SET.componentTranslation(mode).m_6270_(Styles.AQUA), true);
            PacketHandler.sendToServer(new PacketToggleMode(this.slotSelected));
            OurSounds.playSound((SoundEvent)OurSounds.BEEP.get());
        }
    }

    public boolean m_6375_(double mouseX, double mouseY, int mouseButton) {
        this.changeMode();
        return super.m_6375_(mouseX, mouseY, mouseButton);
    }

    public void m_86600_() {
        if (!InputConstants.m_84830_((long)Minecraft.m_91087_().m_91268_().m_85439_(), (int)KeyBindings.menuSettings.getKey().m_84873_())) {
            this.m_7379_();
            this.changeMode();
        }
        ImmutableSet set = ImmutableSet.of((Object)this.getMinecraft().f_91066_.f_92085_, (Object)this.getMinecraft().f_91066_.f_92086_, (Object)this.getMinecraft().f_91066_.f_92087_, (Object)this.getMinecraft().f_91066_.f_92088_, (Object)this.getMinecraft().f_91066_.f_92090_, (Object)this.getMinecraft().f_91066_.f_92091_, (Object[])new KeyMapping[]{this.getMinecraft().f_91066_.f_92089_});
        for (KeyMapping k : set) {
            KeyMapping.m_90837_((InputConstants.Key)k.getKey(), (boolean)k.m_90857_());
        }
        ++this.timeIn;
        ItemStack tool = this.getGadget();
        boolean builder = tool.m_41720_() instanceof GadgetBuilding;
        if (!builder && !(tool.m_41720_() instanceof GadgetExchanger)) {
            return;
        }
        boolean changed = false;
        for (int i = 0; i < this.conditionalButtons.size(); ++i) {
            boolean curent;
            Button button = this.conditionalButtons.get(i);
            if (builder) {
                curent = GadgetBuilding.getToolMode(tool) == BuildingModes.SURFACE;
            } else {
                boolean bl = curent = i == 0 || GadgetExchanger.getToolMode(tool) == ExchangingModes.SURFACE;
            }
            if (button.f_93624_ == curent) continue;
            button.f_93624_ = curent;
            changed = true;
        }
        if (changed) {
            this.updateButtons(tool);
        }
    }

    public boolean m_7043_() {
        return false;
    }

    private void sendRangeUpdate(int valueNew) {
        if (valueNew != GadgetUtils.getToolRange(this.getGadget())) {
            PacketHandler.sendToServer(new PacketChangeRange(valueNew));
        }
    }

    private static class Vector2f {
        public float x;
        public float y;

        public Vector2f(float x, float y) {
            this.x = x;
            this.y = y;
        }

        public final float dot(Vector2f v1) {
            return this.x * v1.x + this.y * v1.y;
        }

        public final float length() {
            return (float)Math.sqrt(this.x * this.x + this.y * this.y);
        }
    }

    public static enum ScreenPosition {
        RIGHT,
        LEFT,
        BOTTOM,
        TOP;

    }

    private static class PositionedIconActionable
    extends GuiIconActionable {
        private ScreenPosition position;

        PositionedIconActionable(RadialTranslation message, String icon, ScreenPosition position, boolean isSelectable, Predicate<Boolean> action) {
            super(0, 0, icon, (Component)message.componentTranslation(new Object[0]), isSelectable, action);
            this.position = position;
        }

        PositionedIconActionable(RadialTranslation message, String icon, ScreenPosition position, Predicate<Boolean> action) {
            this(message, icon, position, true, action);
        }
    }

    private static final class NameDisplayData {
        private final int x;
        private final int y;
        private final boolean selected;
        private final boolean centralize;

        private NameDisplayData(int x, int y, boolean selected, boolean centralize) {
            this.x = x;
            this.y = y;
            this.selected = selected;
            this.centralize = centralize;
        }

        private int getX() {
            return this.x;
        }

        private int getY() {
            return this.y;
        }

        private boolean isSelected() {
            return this.selected;
        }

        private boolean isCentralized() {
            return this.centralize;
        }
    }
}

