/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.client.renders;

import com.direwolf20.buildinggadgets.client.cache.RemoteInventoryCache;
import com.direwolf20.buildinggadgets.client.renderer.OurRenderTypes;
import com.direwolf20.buildinggadgets.common.tainted.inventory.InventoryLinker;
import com.direwolf20.buildinggadgets.common.tainted.inventory.materials.objects.UniqueItem;
import com.direwolf20.buildinggadgets.common.world.MockBuilderWorld;
import com.direwolf20.buildinggadgets.common.world.MockTileEntityRenderWorld;
import com.google.common.collect.Multiset;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Matrix4f;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.event.RenderLevelStageEvent;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;
import org.apache.commons.lang3.tuple.Pair;

public abstract class BaseRenderer {
    public static final BlockState AIR = Blocks.f_50016_.m_49966_();
    private static final MockTileEntityRenderWorld tileEntityWorld = new MockTileEntityRenderWorld();
    private static final MockBuilderWorld builderWorld = new MockBuilderWorld();
    private static final Set<BlockEntity> invalidTileEntities = new HashSet<BlockEntity>();
    private static final RemoteInventoryCache cacheInventory = new RemoteInventoryCache(false);

    public void render(RenderLevelStageEvent evt, Player player, ItemStack heldItem) {
        if (evt.getStage() != RenderLevelStageEvent.Stage.AFTER_TRANSLUCENT_BLOCKS) {
            return;
        }
        this.bindBlocks();
        if (this.isLinkable()) {
            BaseRenderer.renderLinkedInventoryOutline(evt, heldItem, player);
        }
    }

    private void bindBlocks() {
        RenderSystem.m_157456_((int)0, (ResourceLocation)InventoryMenu.f_39692_);
    }

    private static void renderLinkedInventoryOutline(RenderLevelStageEvent evt, ItemStack item, Player player) {
        Pair<BlockPos, ResourceKey<Level>> dataFromStack = InventoryLinker.getDataFromStack(item);
        if (dataFromStack == null) {
            return;
        }
        if (!player.f_19853_.m_46472_().equals(dataFromStack.getValue())) {
            return;
        }
        BlockPos pos = (BlockPos)dataFromStack.getKey();
        Vec3 renderPos = BaseRenderer.getMc().f_91063_.m_109153_().m_90583_().m_82492_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_()).m_82520_((double)0.005f, (double)0.005f, (double)0.005f);
        MultiBufferSource.BufferSource buffer = Minecraft.m_91087_().m_91269_().m_110104_();
        PoseStack stack = evt.getPoseStack();
        stack.m_85836_();
        stack.m_85837_(-renderPos.m_7096_(), -renderPos.m_7098_(), -renderPos.m_7094_());
        stack.m_85841_(1.01f, 1.01f, 1.01f);
        BaseRenderer.renderBoxSolid(stack.m_85850_().m_85861_(), buffer.m_6299_(OurRenderTypes.BlockOverlay), BlockPos.f_121853_, 0.0f, 1.0f, 0.0f, 0.35f);
        stack.m_85849_();
        RenderSystem.m_69465_();
        buffer.m_109911_();
    }

    int getEnergy(Player player, ItemStack heldItem) {
        LazyOptional energy = heldItem.getCapability(ForgeCapabilities.ENERGY);
        if (player.m_7500_() || !energy.isPresent()) {
            return Integer.MAX_VALUE;
        }
        return energy.map(IEnergyStorage::getEnergyStored).orElse(0);
    }

    protected static void renderMissingBlock(Matrix4f matrix, VertexConsumer builder, BlockPos pos) {
        BaseRenderer.renderBoxSolid(matrix, builder, pos, 1.0f, 0.0f, 0.0f, 0.35f);
    }

    protected static void renderBoxSolid(Matrix4f matrix, VertexConsumer builder, BlockPos pos, float r, float g, float b, float alpha) {
        double x = (double)pos.m_123341_() - 0.001;
        double y = (double)pos.m_123342_() - 0.001;
        double z = (double)pos.m_123343_() - 0.001;
        double xEnd = (double)pos.m_123341_() + 1.0015;
        double yEnd = (double)pos.m_123342_() + 1.0015;
        double zEnd = (double)pos.m_123343_() + 1.0015;
        BaseRenderer.renderBoxSolid(matrix, builder, x, y, z, xEnd, yEnd, zEnd, r, g, b, alpha);
    }

    protected static void renderBoxSolid(Matrix4f matrix, VertexConsumer builder, double x, double y, double z, double xEnd, double yEnd, double zEnd, float red, float green, float blue, float alpha) {
        float startX = (float)x;
        float startY = (float)y;
        float startZ = (float)z;
        float endX = (float)xEnd;
        float endY = (float)yEnd;
        float endZ = (float)zEnd;
        builder.m_85982_(matrix, startX, startY, startZ).m_85950_(red, green, blue, alpha).m_5752_();
        builder.m_85982_(matrix, endX, startY, startZ).m_85950_(red, green, blue, alpha).m_5752_();
        builder.m_85982_(matrix, endX, startY, endZ).m_85950_(red, green, blue, alpha).m_5752_();
        builder.m_85982_(matrix, startX, startY, endZ).m_85950_(red, green, blue, alpha).m_5752_();
        builder.m_85982_(matrix, startX, endY, startZ).m_85950_(red, green, blue, alpha).m_5752_();
        builder.m_85982_(matrix, startX, endY, endZ).m_85950_(red, green, blue, alpha).m_5752_();
        builder.m_85982_(matrix, endX, endY, endZ).m_85950_(red, green, blue, alpha).m_5752_();
        builder.m_85982_(matrix, endX, endY, startZ).m_85950_(red, green, blue, alpha).m_5752_();
        builder.m_85982_(matrix, startX, startY, startZ).m_85950_(red, green, blue, alpha).m_5752_();
        builder.m_85982_(matrix, startX, endY, startZ).m_85950_(red, green, blue, alpha).m_5752_();
        builder.m_85982_(matrix, endX, endY, startZ).m_85950_(red, green, blue, alpha).m_5752_();
        builder.m_85982_(matrix, endX, startY, startZ).m_85950_(red, green, blue, alpha).m_5752_();
        builder.m_85982_(matrix, startX, startY, endZ).m_85950_(red, green, blue, alpha).m_5752_();
        builder.m_85982_(matrix, endX, startY, endZ).m_85950_(red, green, blue, alpha).m_5752_();
        builder.m_85982_(matrix, endX, endY, endZ).m_85950_(red, green, blue, alpha).m_5752_();
        builder.m_85982_(matrix, startX, endY, endZ).m_85950_(red, green, blue, alpha).m_5752_();
        builder.m_85982_(matrix, endX, startY, startZ).m_85950_(red, green, blue, alpha).m_5752_();
        builder.m_85982_(matrix, endX, endY, startZ).m_85950_(red, green, blue, alpha).m_5752_();
        builder.m_85982_(matrix, endX, endY, endZ).m_85950_(red, green, blue, alpha).m_5752_();
        builder.m_85982_(matrix, endX, startY, endZ).m_85950_(red, green, blue, alpha).m_5752_();
        builder.m_85982_(matrix, startX, startY, startZ).m_85950_(red, green, blue, alpha).m_5752_();
        builder.m_85982_(matrix, startX, startY, endZ).m_85950_(red, green, blue, alpha).m_5752_();
        builder.m_85982_(matrix, startX, endY, endZ).m_85950_(red, green, blue, alpha).m_5752_();
        builder.m_85982_(matrix, startX, endY, startZ).m_85950_(red, green, blue, alpha).m_5752_();
    }

    public boolean isLinkable() {
        return false;
    }

    static Minecraft getMc() {
        return Minecraft.m_91087_();
    }

    static MockBuilderWorld getBuilderWorld() {
        return builderWorld;
    }

    static RemoteInventoryCache getCacheInventory() {
        return cacheInventory;
    }

    public static void setInventoryCache(Multiset<UniqueItem> cache) {
        cacheInventory.setCache(cache);
    }

    public static void updateInventoryCache() {
        cacheInventory.forceUpdate();
    }
}

