/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.friendlyfire;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.annotations.Expose;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import net.darkhax.friendlyfire.Constants;

public class Config {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().excludeFieldsWithoutExposeAnnotation().create();
    @Expose
    public boolean protectPetsFromOwner = true;
    @Expose
    public boolean protectPetsFromPets = true;
    @Expose
    public boolean protectChildren = true;
    @Expose
    public boolean reflectDamage = false;

    public static Config load(File configFile) {
        Config config = new Config();
        if (configFile.exists()) {
            try (FileReader reader = new FileReader(configFile);){
                config = (Config)GSON.fromJson((Reader)reader, Config.class);
                Constants.LOG.info("Loaded config file.");
            }
            catch (Exception e) {
                Constants.LOG.error("Could not read config file {}. Defaults will be used.", (Object)configFile.getAbsolutePath(), (Object)e);
            }
        } else {
            Constants.LOG.info("Creating a new config file at {}.", (Object)configFile.getAbsolutePath());
            configFile.getParentFile().mkdirs();
        }
        try (FileWriter writer = new FileWriter(configFile);){
            GSON.toJson((Object)config, (Appendable)writer);
            Constants.LOG.info("Saved config file.");
        }
        catch (Exception e) {
            Constants.LOG.error("Could not write config file '{}'!", (Object)configFile.getAbsolutePath(), (Object)e);
        }
        return config;
    }
}

