/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item.equipment.bauble;

import com.google.common.base.Predicates;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import vazkii.botania.api.internal.ManaBurst;
import vazkii.botania.api.mana.TinyPlanetExcempt;
import vazkii.botania.client.render.AccessoryRenderRegistry;
import vazkii.botania.client.render.AccessoryRenderer;
import vazkii.botania.common.block.BotaniaBlocks;
import vazkii.botania.common.item.equipment.bauble.BaubleItem;
import vazkii.botania.common.proxy.Proxy;

public class TinyPlanetItem
extends BaubleItem {
    public TinyPlanetItem(Item.Properties props) {
        super(props);
        Proxy.INSTANCE.runOnClient(() -> () -> AccessoryRenderRegistry.register(this, new Renderer()));
    }

    @Override
    public void onWornTick(ItemStack stack, LivingEntity living) {
        double x = living.m_20185_();
        double y = living.m_20186_() + (double)living.m_20192_();
        double z = living.m_20189_();
        TinyPlanetItem.applyEffect(living.f_19853_, x, y, z);
    }

    public static void applyEffect(Level world, double x, double y, double z) {
        int range = 8;
        List entities = world.m_6443_(ThrowableProjectile.class, new AABB(x - (double)range, y - (double)range, z - (double)range, x + (double)range, y + (double)range, z + (double)range), (Predicate)Predicates.instanceOf(ManaBurst.class));
        for (ThrowableProjectile entity : entities) {
            TinyPlanetExcempt excempt;
            Item item;
            ManaBurst burst = (ManaBurst)entity;
            ItemStack lens = burst.getSourceLens();
            if (lens != null && (item = lens.m_41720_()) instanceof TinyPlanetExcempt && !(excempt = (TinyPlanetExcempt)item).shouldPull(lens)) continue;
            int orbitTime = burst.getOrbitTime();
            if (orbitTime == 0) {
                burst.setMinManaLoss(burst.getMinManaLoss() * 3);
            }
            float radius = Math.min(7.5f, (float)(Math.max(40, orbitTime) - 40) / 40.0f + 1.5f);
            int angle = orbitTime % 360;
            float xTarget = (float)(x + Math.cos((double)(angle * 10) * Math.PI / 180.0) * (double)radius);
            float yTarget = (float)y;
            float zTarget = (float)(z + Math.sin((double)(angle * 10) * Math.PI / 180.0) * (double)radius);
            Vec3 targetVec = new Vec3((double)xTarget, (double)yTarget, (double)zTarget);
            Vec3 currentVec = entity.m_20182_();
            Vec3 moveVector = targetVec.m_82546_(currentVec);
            entity.m_20256_(moveVector);
            burst.setOrbitTime(burst.getOrbitTime() + 1);
        }
    }

    public static class Renderer
    implements AccessoryRenderer {
        @Override
        public void doRender(HumanoidModel<?> bipedModel, ItemStack stack, LivingEntity living, PoseStack ms, MultiBufferSource buffers, int light, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
            bipedModel.f_102808_.m_104299_(ms);
            ms.m_85837_(-0.25, -0.4, 0.0);
            ms.m_85841_(0.5f, -0.5f, -0.5f);
            Minecraft.m_91087_().m_91289_().m_110912_(BotaniaBlocks.tinyPlanet.m_49966_(), ms, buffers, light, OverlayTexture.f_118083_);
        }
    }
}

