/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.crafting.recipe;

import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.SimpleRecipeSerializer;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import vazkii.botania.common.item.BotaniaItems;
import vazkii.botania.common.item.ManaBlasterItem;

public class ManaBlasterClipRecipe
extends CustomRecipe {
    public static final SimpleRecipeSerializer<ManaBlasterClipRecipe> SERIALIZER = new SimpleRecipeSerializer(ManaBlasterClipRecipe::new);

    public ManaBlasterClipRecipe(ResourceLocation id) {
        super(id);
    }

    public boolean matches(@NotNull CraftingContainer inv, @NotNull Level world) {
        boolean foundGun = false;
        boolean foundClip = false;
        for (int i = 0; i < inv.m_6643_(); ++i) {
            ItemStack stack = inv.m_8020_(i);
            if (stack.m_41619_()) continue;
            if (stack.m_41720_() instanceof ManaBlasterItem && !ManaBlasterItem.hasClip(stack) && !foundGun) {
                foundGun = true;
                continue;
            }
            if (stack.m_150930_(BotaniaItems.clip) && !foundClip) {
                foundClip = true;
                continue;
            }
            return false;
        }
        return foundGun && foundClip;
    }

    @NotNull
    public ItemStack assemble(@NotNull CraftingContainer inv) {
        ItemStack gun = ItemStack.f_41583_;
        for (int i = 0; i < inv.m_6643_(); ++i) {
            ItemStack stack = inv.m_8020_(i);
            if (stack.m_41619_() || !(stack.m_41720_() instanceof ManaBlasterItem)) continue;
            gun = stack;
        }
        if (gun.m_41619_()) {
            return ItemStack.f_41583_;
        }
        ItemStack lens = ManaBlasterItem.getLens(gun);
        ItemStack gunCopy = gun.m_41777_();
        ManaBlasterItem.setLens(gunCopy, ItemStack.f_41583_);
        ManaBlasterItem.setClip(gunCopy, true);
        ManaBlasterItem.setLensAtPos(gunCopy, lens, 0);
        return gunCopy;
    }

    public boolean m_8004_(int width, int height) {
        return width * height >= 2;
    }

    @NotNull
    public RecipeSerializer<?> m_7707_() {
        return SERIALIZER;
    }
}

