/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.crafting;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import net.minecraft.core.NonNullList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import vazkii.botania.api.recipe.TerrestrialAgglomerationRecipe;
import vazkii.botania.common.crafting.BotaniaRecipeTypes;
import vazkii.botania.common.crafting.RecipeSerializerBase;
import vazkii.botania.common.crafting.recipe.RecipeUtils;

public class RecipeTerraPlate
implements TerrestrialAgglomerationRecipe {
    private final ResourceLocation id;
    private final int mana;
    private final NonNullList<Ingredient> inputs;
    private final ItemStack output;

    public RecipeTerraPlate(ResourceLocation id, int mana, NonNullList<Ingredient> inputs, ItemStack output) {
        this.id = id;
        this.mana = mana;
        this.inputs = inputs;
        this.output = output;
    }

    @Override
    public int getMana() {
        return this.mana;
    }

    public boolean m_5818_(Container inv, @NotNull Level world) {
        int nonEmptySlots = 0;
        for (int i = 0; i < inv.m_6643_(); ++i) {
            if (inv.m_8020_(i).m_41619_()) continue;
            if (inv.m_8020_(i).m_41613_() > 1) {
                return false;
            }
            ++nonEmptySlots;
        }
        IntOpenHashSet usedSlots = new IntOpenHashSet(inv.m_6643_());
        return RecipeUtils.matches(this.inputs, inv, (IntSet)usedSlots) && usedSlots.size() == nonEmptySlots;
    }

    @NotNull
    public ItemStack m_5874_(@NotNull Container inv) {
        return this.output.m_41777_();
    }

    @NotNull
    public ItemStack m_8043_() {
        return this.output;
    }

    @NotNull
    public NonNullList<Ingredient> m_7527_() {
        return this.inputs;
    }

    @NotNull
    public ResourceLocation m_6423_() {
        return this.id;
    }

    @NotNull
    public RecipeSerializer<RecipeTerraPlate> m_7707_() {
        return BotaniaRecipeTypes.TERRA_PLATE_SERIALIZER;
    }

    public static class Serializer
    extends RecipeSerializerBase<RecipeTerraPlate> {
        @NotNull
        public RecipeTerraPlate fromJson(@NotNull ResourceLocation recipeId, @NotNull JsonObject json) {
            int mana = GsonHelper.m_13927_((JsonObject)json, (String)"mana");
            JsonArray ingrs = GsonHelper.m_13933_((JsonObject)json, (String)"ingredients");
            Object[] ingredients = new Ingredient[ingrs.size()];
            for (int i = 0; i < ingrs.size(); ++i) {
                ingredients[i] = Ingredient.m_43917_((JsonElement)ingrs.get(i));
            }
            ItemStack output = ShapedRecipe.m_151274_((JsonObject)GsonHelper.m_13930_((JsonObject)json, (String)"result"));
            return new RecipeTerraPlate(recipeId, mana, (NonNullList<Ingredient>)NonNullList.m_122783_((Object)Ingredient.f_43901_, (Object[])ingredients), output);
        }

        public RecipeTerraPlate fromNetwork(@NotNull ResourceLocation recipeId, FriendlyByteBuf buffer) {
            int mana = buffer.m_130242_();
            Object[] ingredients = new Ingredient[buffer.m_130242_()];
            for (int i = 0; i < ingredients.length; ++i) {
                ingredients[i] = Ingredient.m_43940_((FriendlyByteBuf)buffer);
            }
            ItemStack output = buffer.m_130267_();
            return new RecipeTerraPlate(recipeId, mana, (NonNullList<Ingredient>)NonNullList.m_122783_((Object)Ingredient.f_43901_, (Object[])ingredients), output);
        }

        public void toNetwork(FriendlyByteBuf buffer, RecipeTerraPlate recipe) {
            buffer.m_130130_(recipe.mana);
            buffer.m_130130_(recipe.m_7527_().size());
            for (Ingredient ingr : recipe.m_7527_()) {
                ingr.m_43923_(buffer);
            }
            buffer.m_130055_(recipe.output);
        }
    }
}

