/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.client.render.block_entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Vector3f;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import vazkii.botania.common.block.block_entity.CocoonBlockEntity;

public class CocoonBlockEntityRenderer
implements BlockEntityRenderer<CocoonBlockEntity> {
    private final BlockRenderDispatcher blockRenderDispatcher;

    public CocoonBlockEntityRenderer(BlockEntityRendererProvider.Context ctx) {
        this.blockRenderDispatcher = ctx.m_173584_();
    }

    public void render(@NotNull CocoonBlockEntity cocoon, float partialTicks, PoseStack ms, MultiBufferSource buffers, int light, int overlay) {
        float rot = 0.0f;
        float modval = 60.0f - (float)cocoon.timePassed / 2400.0f * 30.0f;
        if ((float)cocoon.timePassed % modval < 10.0f) {
            float mod = ((float)cocoon.timePassed + partialTicks) % modval;
            float v = mod / 5.0f * (float)Math.PI * 2.0f;
            rot = (float)Math.sin(v) * (float)Math.log((float)cocoon.timePassed + partialTicks);
        }
        ms.m_85836_();
        ms.m_85837_(0.5, 0.0, 0.0);
        ms.m_85845_(Vector3f.f_122223_.m_122240_(rot));
        ms.m_85837_(-0.5, 0.0, 0.0);
        BlockState state = cocoon.m_58900_();
        BakedModel model = this.blockRenderDispatcher.m_110910_(state);
        VertexConsumer buffer = buffers.m_6299_(ItemBlockRenderTypes.m_109282_((BlockState)state));
        this.blockRenderDispatcher.m_110937_().m_111067_(ms.m_85850_(), buffer, state, model, 1.0f, 1.0f, 1.0f, light, overlay);
        ms.m_85849_();
    }
}

