/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.client.model;

import com.google.common.base.Preconditions;
import com.mojang.math.Transformation;
import com.mojang.math.Vector3f;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.BlockModel;
import net.minecraft.client.renderer.block.model.ItemModelGenerator;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.AtlasSet;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.core.Direction;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vazkii.botania.client.model.DelegatedModel;
import vazkii.botania.common.item.ManaBlasterItem;
import vazkii.botania.common.lib.ResourceLocationHelper;
import vazkii.botania.mixin.client.ModelBakeryAccessor;

public class ManaBlasterModel
implements BakedModel {
    private static final ModelResourceLocation DESU = new ModelResourceLocation("botania:desu_gun", "inventory");
    private static final ModelResourceLocation DESU_CLIP = new ModelResourceLocation("botania:desu_gun_clip", "inventory");
    private final BakedModel originalModel;
    private final BakedModel originalModelClip;
    private final Map<Pair<Item, Boolean>, BakedModel> cache = new HashMap<Pair<Item, Boolean>, BakedModel>();
    private final ItemOverrides itemHandler = new ItemOverrides(){

        @NotNull
        public BakedModel m_173464_(BakedModel model, ItemStack stack, @Nullable ClientLevel worldIn, @Nullable LivingEntity entityIn, int seed) {
            boolean clip = ManaBlasterItem.hasClip(stack);
            if (ManaBlasterItem.isSugoiKawaiiDesuNe(stack)) {
                return Minecraft.m_91087_().m_91304_().m_119422_(clip ? DESU_CLIP : DESU);
            }
            ItemStack lens = ManaBlasterItem.getLens(stack);
            if (!lens.m_41619_()) {
                return ManaBlasterModel.this.cache.getOrDefault(Pair.of((Object)lens.m_41720_(), (Object)clip), Minecraft.m_91087_().m_91304_().m_119409_());
            }
            return clip ? ManaBlasterModel.this.originalModelClip : ManaBlasterModel.this.originalModel;
        }
    };

    public ManaBlasterModel(ModelBakery bakery, BakedModel originalModel, BakedModel originalModelClip) {
        this.originalModel = (BakedModel)Preconditions.checkNotNull((Object)originalModel);
        this.originalModelClip = (BakedModel)Preconditions.checkNotNull((Object)originalModelClip);
        for (Item item : Registry.f_122827_) {
            ItemStack lens = item.m_7968_();
            if (!ManaBlasterItem.isValidLens(lens)) continue;
            CompositeBakedModel baked = new CompositeBakedModel(bakery, lens, originalModel);
            CompositeBakedModel bakedClip = new CompositeBakedModel(bakery, lens, originalModelClip);
            this.cache.put((Pair<Item, Boolean>)Pair.of((Object)item, (Object)false), baked);
            this.cache.put((Pair<Item, Boolean>)Pair.of((Object)item, (Object)true), bakedClip);
        }
    }

    @NotNull
    public ItemOverrides m_7343_() {
        return this.itemHandler;
    }

    @NotNull
    public List<BakedQuad> m_213637_(@Nullable BlockState state, @Nullable Direction side, @NotNull RandomSource rand) {
        return this.originalModel.m_213637_(state, side, rand);
    }

    public boolean m_7541_() {
        return this.originalModel.m_7541_();
    }

    public boolean m_7539_() {
        return this.originalModel.m_7539_();
    }

    public boolean m_7521_() {
        return this.originalModel.m_7521_();
    }

    @NotNull
    public TextureAtlasSprite m_6160_() {
        return this.originalModel.m_6160_();
    }

    @NotNull
    public ItemTransforms m_7442_() {
        return this.originalModel.m_7442_();
    }

    public boolean m_7547_() {
        return this.originalModel.m_7547_();
    }

    private static class CompositeBakedModel
    extends DelegatedModel {
        private final List<BakedQuad> genQuads = new ArrayList<BakedQuad>();
        private final Map<Direction, List<BakedQuad>> faceQuads = new EnumMap<Direction, List<BakedQuad>>(Direction.class);

        CompositeBakedModel(ModelBakery bakery, ItemStack lens, BakedModel gun) {
            super(gun);
            Direction[] bm;
            ResourceLocation lensId = Registry.f_122827_.m_7981_((Object)lens.m_41720_());
            UnbakedModel lensUnbaked = bakery.m_119341_((ResourceLocation)new ModelResourceLocation(lensId, "inventory"));
            ModelState transform = new ModelState(){

                public Transformation m_6189_() {
                    return new Transformation(new Vector3f(-0.4f, 0.2f, 0.0f), Vector3f.f_122225_.m_122270_(1.5707964f), new Vector3f(0.625f, 0.625f, 0.625f), null);
                }
            };
            ResourceLocation name = ResourceLocationHelper.prefix("gun_with_" + lensId.toString().replace(':', '_'));
            Function<Material, TextureAtlasSprite> textureGetter = arg_0 -> ((AtlasSet)((ModelBakeryAccessor)bakery).getSpriteAtlasManager()).m_117971_(arg_0);
            BakedModel lensBaked = lensUnbaked instanceof BlockModel && (bm = (Direction[])lensUnbaked).m_111490_() == ModelBakery.f_119232_ ? new ItemModelGenerator().m_111670_(textureGetter, (BlockModel)bm).m_111449_(bakery, (BlockModel)bm, textureGetter, transform, name, false) : lensUnbaked.m_7611_(bakery, textureGetter, transform, name);
            for (Direction e : Direction.values()) {
                this.faceQuads.put(e, new ArrayList());
            }
            RandomSource rand = RandomSource.m_216327_();
            rand.m_188584_(0L);
            this.genQuads.addAll(lensBaked.m_213637_(null, null, rand));
            for (Direction e : Direction.values()) {
                rand.m_188584_(0L);
                this.faceQuads.get(e).addAll(lensBaked.m_213637_(null, e, rand));
            }
            rand.m_188584_(0L);
            this.genQuads.addAll(gun.m_213637_(null, null, rand));
            for (Direction e : Direction.values()) {
                rand.m_188584_(0L);
                this.faceQuads.get(e).addAll(gun.m_213637_(null, e, rand));
            }
        }

        @Override
        @NotNull
        public List<BakedQuad> m_213637_(BlockState state, Direction face, @NotNull RandomSource rand) {
            return face == null ? this.genQuads : this.faceQuads.get(face);
        }
    }
}

