/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.client.core.handler;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.DyeColor;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.api.BotaniaAPIClient;
import vazkii.botania.api.block.FloatingFlower;
import vazkii.botania.client.core.handler.RenderLexicon;
import vazkii.botania.client.model.ManaBlasterModel;
import vazkii.botania.client.model.TinyPotatoModel;
import vazkii.botania.client.render.block_entity.CorporeaCrystalCubeBlockEntityRenderer;
import vazkii.botania.client.render.block_entity.ManaPumpBlockEntityRenderer;
import vazkii.botania.common.lib.ResourceLocationHelper;
import vazkii.botania.mixin.client.ModelBakeryAccessor;
import vazkii.botania.xplat.ClientXplatAbstractions;

public class MiscellaneousModels {
    public static final MiscellaneousModels INSTANCE = new MiscellaneousModels();
    public boolean registeredModels = false;
    public final Material alfPortalTex = MiscellaneousModels.mainAtlas("block/alfheim_portal_swirl");
    public final Material lightRelayWorldIcon = MiscellaneousModels.mainAtlas("block/light_relay");
    public final Material lightRelayDetectorWorldIcon = MiscellaneousModels.mainAtlas("block/detector_light_relay");
    public final Material lightRelayForkWorldIcon = MiscellaneousModels.mainAtlas("block/fork_light_relay");
    public final Material lightRelayToggleWorldIcon = MiscellaneousModels.mainAtlas("block/toggle_light_relay");
    public final Material alchemyCatalystOverlay = MiscellaneousModels.mainAtlas("block/alchemy_catalyst_overlay");
    public final Material conjurationCatalystOverlay = MiscellaneousModels.mainAtlas("block/conjuration_catalyst_overlay");
    public final Material enchanterOverlay = MiscellaneousModels.mainAtlas("block/enchanter_overlay");
    public final Material manaVoidOverlay = MiscellaneousModels.mainAtlas("block/mana_void_overlay");
    public final Material manaWater = MiscellaneousModels.mainAtlas("block/mana_water");
    public final Material terraPlateOverlay = MiscellaneousModels.mainAtlas("block/terra_plate_overlay");
    public final Material corporeaWorldIcon = MiscellaneousModels.mainAtlas("item/corporea_spark");
    public final Material corporeaWorldIconMaster = MiscellaneousModels.mainAtlas("item/corporea_spark_master");
    public final Material corporeaWorldIconCreative = MiscellaneousModels.mainAtlas("item/corporea_spark_creative");
    public final Material corporeaIconStar = MiscellaneousModels.mainAtlas("item/corporea_spark_star");
    public final Material sparkWorldIcon = MiscellaneousModels.mainAtlas("item/spark");
    public final Material[] sparkUpgradeIcons = new Material[]{MiscellaneousModels.mainAtlas("item/spark_upgrade_rune_dispersive"), MiscellaneousModels.mainAtlas("item/spark_upgrade_rune_dominant"), MiscellaneousModels.mainAtlas("item/spark_upgrade_rune_recessive"), MiscellaneousModels.mainAtlas("item/spark_upgrade_rune_isolated")};
    public final BakedModel[] tiaraWingIcons = new BakedModel[9];
    public final BakedModel[] thirdEyeLayers = new BakedModel[3];
    public BakedModel goldfishModel;
    public BakedModel phiFlowerModel;
    public BakedModel nerfBatModel;
    public BakedModel bloodPendantChain;
    public BakedModel bloodPendantGem;
    public BakedModel snowflakePendantGem;
    public BakedModel itemFinderGem;
    public BakedModel pyroclastGem;
    public BakedModel crimsonGem;
    public BakedModel cirrusGem;
    public BakedModel nimbusGem;
    public BakedModel terrasteelHelmWillModel;
    public BakedModel elvenSpreaderCore;
    public BakedModel gaiaSpreaderCore;
    public BakedModel manaSpreaderCore;
    public BakedModel redstoneSpreaderCore;
    public BakedModel manaSpreaderScaffolding;
    public BakedModel elvenSpreaderScaffolding;
    public BakedModel gaiaSpreaderScaffolding;
    public final HashMap<DyeColor, BakedModel> spreaderPaddings = new HashMap();
    public final BakedModel[] kingKeyWeaponModels = new BakedModel[12];

    public void onModelRegister(ResourceManager rm, Consumer<ResourceLocation> consumer) {
        int i;
        Set<Material> materials = ModelBakeryAccessor.getMaterials();
        materials.addAll(Arrays.asList(this.alfPortalTex, this.lightRelayWorldIcon, this.lightRelayDetectorWorldIcon, this.lightRelayForkWorldIcon, this.lightRelayToggleWorldIcon, this.alchemyCatalystOverlay, this.conjurationCatalystOverlay, this.enchanterOverlay, this.manaVoidOverlay, this.manaWater, this.terraPlateOverlay, this.corporeaWorldIcon, this.corporeaWorldIconMaster, this.corporeaWorldIconCreative, this.corporeaIconStar, this.sparkWorldIcon));
        materials.addAll(Arrays.asList(this.sparkUpgradeIcons));
        materials.add(RenderLexicon.TEXTURE);
        materials.add(RenderLexicon.ELVEN_TEXTURE);
        consumer.accept(ResourceLocationHelper.prefix("icon/goldfish"));
        consumer.accept(ResourceLocationHelper.prefix("icon/phiflower"));
        consumer.accept(ResourceLocationHelper.prefix("icon/nerfbat"));
        consumer.accept(ResourceLocationHelper.prefix("icon/blood_pendant_chain"));
        consumer.accept(ResourceLocationHelper.prefix("icon/blood_pendant_gem"));
        for (i = 0; i < 12; ++i) {
            consumer.accept(ResourceLocationHelper.prefix("icon/gate_weapon_" + i));
        }
        consumer.accept(ResourceLocationHelper.prefix("icon/will_flame"));
        for (i = 0; i < this.thirdEyeLayers.length; ++i) {
            consumer.accept(ResourceLocationHelper.prefix("icon/third_eye_" + i));
        }
        consumer.accept(ResourceLocationHelper.prefix("icon/lava_pendant_gem"));
        consumer.accept(ResourceLocationHelper.prefix("icon/super_lava_pendant_gem"));
        consumer.accept(ResourceLocationHelper.prefix("icon/itemfinder_gem"));
        consumer.accept(ResourceLocationHelper.prefix("icon/cloud_pendant_gem"));
        consumer.accept(ResourceLocationHelper.prefix("icon/super_cloud_pendant_gem"));
        consumer.accept(ResourceLocationHelper.prefix("icon/ice_pendant_gem"));
        for (i = 0; i < this.tiaraWingIcons.length; ++i) {
            consumer.accept(ResourceLocationHelper.prefix("icon/tiara_wing_" + (i + 1)));
        }
        consumer.accept((ResourceLocation)new ModelResourceLocation("botania:mana_gun_clip", "inventory"));
        consumer.accept((ResourceLocation)new ModelResourceLocation("botania:desu_gun", "inventory"));
        consumer.accept((ResourceLocation)new ModelResourceLocation("botania:desu_gun_clip", "inventory"));
        consumer.accept(ResourceLocationHelper.prefix("block/corporea_crystal_cube_glass"));
        consumer.accept(ResourceLocationHelper.prefix("block/pump_head"));
        consumer.accept(ResourceLocationHelper.prefix("block/elven_spreader_core"));
        consumer.accept(ResourceLocationHelper.prefix("block/gaia_spreader_core"));
        consumer.accept(ResourceLocationHelper.prefix("block/mana_spreader_core"));
        consumer.accept(ResourceLocationHelper.prefix("block/redstone_spreader_core"));
        consumer.accept(ResourceLocationHelper.prefix("block/mana_spreader_scaffolding"));
        consumer.accept(ResourceLocationHelper.prefix("block/elven_spreader_scaffolding"));
        consumer.accept(ResourceLocationHelper.prefix("block/gaia_spreader_scaffolding"));
        for (DyeColor color : DyeColor.values()) {
            consumer.accept(ResourceLocationHelper.prefix("block/" + color.toString() + "_spreader_padding"));
        }
        MiscellaneousModels.registerIslands();
        MiscellaneousModels.registerTaters(rm, consumer);
        if (!this.registeredModels) {
            this.registeredModels = true;
        }
    }

    private static void registerIslands() {
        BotaniaAPIClient.instance().registerIslandTypeModel(FloatingFlower.IslandType.GRASS, ResourceLocationHelper.prefix("block/islands/island_grass"));
        BotaniaAPIClient.instance().registerIslandTypeModel(FloatingFlower.IslandType.PODZOL, ResourceLocationHelper.prefix("block/islands/island_podzol"));
        BotaniaAPIClient.instance().registerIslandTypeModel(FloatingFlower.IslandType.MYCEL, ResourceLocationHelper.prefix("block/islands/island_mycel"));
        BotaniaAPIClient.instance().registerIslandTypeModel(FloatingFlower.IslandType.SNOW, ResourceLocationHelper.prefix("block/islands/island_snow"));
        BotaniaAPIClient.instance().registerIslandTypeModel(FloatingFlower.IslandType.DRY, ResourceLocationHelper.prefix("block/islands/island_dry"));
        BotaniaAPIClient.instance().registerIslandTypeModel(FloatingFlower.IslandType.GOLDEN, ResourceLocationHelper.prefix("block/islands/island_golden"));
        BotaniaAPIClient.instance().registerIslandTypeModel(FloatingFlower.IslandType.VIVID, ResourceLocationHelper.prefix("block/islands/island_vivid"));
        BotaniaAPIClient.instance().registerIslandTypeModel(FloatingFlower.IslandType.SCORCHED, ResourceLocationHelper.prefix("block/islands/island_scorched"));
        BotaniaAPIClient.instance().registerIslandTypeModel(FloatingFlower.IslandType.INFUSED, ResourceLocationHelper.prefix("block/islands/island_infused"));
        BotaniaAPIClient.instance().registerIslandTypeModel(FloatingFlower.IslandType.MUTATED, ResourceLocationHelper.prefix("block/islands/island_mutated"));
    }

    private static void registerTaters(ResourceManager rm, Consumer<ResourceLocation> consumer) {
        for (ResourceLocation model : rm.m_214159_("models/tiny_potato", s -> s.m_135815_().endsWith(".json")).keySet()) {
            if (!"botania".equals(model.m_135827_())) continue;
            String path = model.m_135815_();
            path = path.substring("models/".length(), path.length() - ".json".length());
            consumer.accept(new ResourceLocation("botania", path));
        }
    }

    public void onModelBake(ModelBakery loader, Map<ResourceLocation, BakedModel> map) {
        int i;
        if (!this.registeredModels) {
            BotaniaAPI.LOGGER.error("Additional models failed to register! Aborting baking models to avoid early crashing.");
            return;
        }
        ModelResourceLocation abstruseName = new ModelResourceLocation("botania:abstruse_platform", "");
        BakedModel abstruse = map.get(abstruseName);
        ModelResourceLocation spectralName = new ModelResourceLocation("botania:spectral_platform", "");
        BakedModel spectral = map.get(spectralName);
        ModelResourceLocation infrangibleName = new ModelResourceLocation("botania:infrangible_platform", "");
        BakedModel infrangible = map.get(infrangibleName);
        map.put((ResourceLocation)abstruseName, ClientXplatAbstractions.INSTANCE.wrapPlatformModel(abstruse));
        map.put((ResourceLocation)spectralName, ClientXplatAbstractions.INSTANCE.wrapPlatformModel(spectral));
        map.put((ResourceLocation)infrangibleName, ClientXplatAbstractions.INSTANCE.wrapPlatformModel(infrangible));
        ModelResourceLocation key = new ModelResourceLocation("botania:mana_gun", "inventory");
        BakedModel originalModel = map.get(key);
        ModelResourceLocation clipKey = new ModelResourceLocation("botania:mana_gun_clip", "inventory");
        BakedModel originalModelClip = map.get(clipKey);
        map.put((ResourceLocation)key, new ManaBlasterModel(loader, originalModel, originalModelClip));
        ModelResourceLocation tinyPotato = new ModelResourceLocation("botania:tiny_potato", "inventory");
        BakedModel originalPotato = map.get(tinyPotato);
        map.put((ResourceLocation)tinyPotato, new TinyPotatoModel(originalPotato));
        CorporeaCrystalCubeBlockEntityRenderer.cubeModel = map.get(ResourceLocationHelper.prefix("block/corporea_crystal_cube_glass"));
        ManaPumpBlockEntityRenderer.headModel = map.get(ResourceLocationHelper.prefix("block/pump_head"));
        this.elvenSpreaderCore = map.get(ResourceLocationHelper.prefix("block/elven_spreader_core"));
        this.gaiaSpreaderCore = map.get(ResourceLocationHelper.prefix("block/gaia_spreader_core"));
        this.manaSpreaderCore = map.get(ResourceLocationHelper.prefix("block/mana_spreader_core"));
        this.redstoneSpreaderCore = map.get(ResourceLocationHelper.prefix("block/redstone_spreader_core"));
        this.manaSpreaderScaffolding = map.get(ResourceLocationHelper.prefix("block/mana_spreader_scaffolding"));
        this.elvenSpreaderScaffolding = map.get(ResourceLocationHelper.prefix("block/elven_spreader_scaffolding"));
        this.gaiaSpreaderScaffolding = map.get(ResourceLocationHelper.prefix("block/gaia_spreader_scaffolding"));
        for (DyeColor color : DyeColor.values()) {
            this.spreaderPaddings.put(color, map.get(ResourceLocationHelper.prefix("block/" + color.m_41065_() + "_spreader_padding")));
        }
        this.goldfishModel = map.get(ResourceLocationHelper.prefix("icon/goldfish"));
        this.phiFlowerModel = map.get(ResourceLocationHelper.prefix("icon/phiflower"));
        this.nerfBatModel = map.get(ResourceLocationHelper.prefix("icon/nerfbat"));
        this.bloodPendantChain = map.get(ResourceLocationHelper.prefix("icon/blood_pendant_chain"));
        this.bloodPendantGem = map.get(ResourceLocationHelper.prefix("icon/blood_pendant_gem"));
        for (i = 0; i < 12; ++i) {
            this.kingKeyWeaponModels[i] = map.get(ResourceLocationHelper.prefix("icon/gate_weapon_" + i));
        }
        this.terrasteelHelmWillModel = map.get(ResourceLocationHelper.prefix("icon/will_flame"));
        for (i = 0; i < this.thirdEyeLayers.length; ++i) {
            this.thirdEyeLayers[i] = map.get(ResourceLocationHelper.prefix("icon/third_eye_" + i));
        }
        this.pyroclastGem = map.get(ResourceLocationHelper.prefix("icon/lava_pendant_gem"));
        this.crimsonGem = map.get(ResourceLocationHelper.prefix("icon/super_lava_pendant_gem"));
        this.itemFinderGem = map.get(ResourceLocationHelper.prefix("icon/itemfinder_gem"));
        this.cirrusGem = map.get(ResourceLocationHelper.prefix("icon/cloud_pendant_gem"));
        this.nimbusGem = map.get(ResourceLocationHelper.prefix("icon/super_cloud_pendant_gem"));
        this.snowflakePendantGem = map.get(ResourceLocationHelper.prefix("icon/ice_pendant_gem"));
        for (i = 0; i < this.tiaraWingIcons.length; ++i) {
            this.tiaraWingIcons[i] = map.get(ResourceLocationHelper.prefix("icon/tiara_wing_" + (i + 1)));
        }
    }

    private static Material mainAtlas(String name) {
        return new Material(InventoryMenu.f_39692_, ResourceLocationHelper.prefix(name));
    }

    private MiscellaneousModels() {
    }
}

