/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.item;

import com.google.common.base.Strings;
import com.mojang.bridge.game.Language;
import com.simibubi.create.content.AllSections;
import com.simibubi.create.content.contraptions.goggles.GogglesItem;
import com.simibubi.create.content.contraptions.goggles.IHaveGoggleInformation;
import com.simibubi.create.foundation.item.ItemDescription;
import com.simibubi.create.foundation.utility.Components;
import com.simibubi.create.foundation.utility.Couple;
import com.simibubi.create.foundation.utility.FontHelper;
import com.simibubi.create.foundation.utility.Lang;
import java.text.BreakIterator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.client.resources.language.LanguageInfo;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class TooltipHelper {
    public static final int maxWidthPerLine = 200;
    public static final Map<String, ItemDescription> cachedTooltips = new HashMap<String, ItemDescription>();
    public static Language cachedLanguage;
    private static boolean gogglesMode;
    private static final Map<Item, Supplier<String>> tooltipReferrals;

    public static MutableComponent holdShift(ItemDescription.Palette color, boolean highlighted) {
        return Lang.translateDirect("tooltip.holdForDescription", Lang.translateDirect("tooltip.keyShift", new Object[0]).m_130940_(ChatFormatting.GRAY)).m_130940_(ChatFormatting.DARK_GRAY);
    }

    public static void addHint(List<Component> tooltip, String hintKey, Object ... messageParams) {
        Component spacing = IHaveGoggleInformation.componentSpacing;
        tooltip.add((Component)spacing.m_6879_().m_7220_((Component)Lang.translateDirect(hintKey + ".title", new Object[0])).m_130940_(ChatFormatting.GOLD));
        MutableComponent hint = Lang.translateDirect(hintKey, new Object[0]);
        List<Component> cutComponent = TooltipHelper.cutTextComponent((Component)hint, ChatFormatting.GRAY, ChatFormatting.WHITE);
        for (Component component : cutComponent) {
            tooltip.add((Component)spacing.m_6879_().m_7220_(component));
        }
    }

    public static void referTo(ItemLike item, Supplier<? extends ItemLike> itemWithTooltip) {
        tooltipReferrals.put(item.m_5456_(), () -> ((ItemLike)itemWithTooltip.get()).m_5456_().m_5524_());
    }

    public static void referTo(ItemLike item, String string) {
        tooltipReferrals.put(item.m_5456_(), () -> string);
    }

    @Deprecated
    public static List<String> cutString(Component s, ChatFormatting defaultColor, ChatFormatting highlightColor) {
        return TooltipHelper.cutString(s.getString(), defaultColor, highlightColor, 0);
    }

    @Deprecated
    public static List<String> cutString(String s, ChatFormatting defaultColor, ChatFormatting highlightColor, int indent) {
        String markedUp = s.replaceAll("_([^_]+)_", highlightColor + "$1" + defaultColor);
        LinkedList<String> words = new LinkedList<String>();
        BreakIterator iterator = BreakIterator.getLineInstance(Minecraft.m_91087_().getLocale());
        iterator.setText(markedUp);
        int start = iterator.first();
        int end = iterator.next();
        while (end != -1) {
            String word = markedUp.substring(start, end);
            words.add(word);
            start = end;
            end = iterator.next();
        }
        Font font = Minecraft.m_91087_().f_91062_;
        List<String> lines = FontHelper.cutString(font, markedUp, 200);
        String lineStart = Strings.repeat((String)" ", (int)indent);
        ArrayList<String> formattedLines = new ArrayList<String>(lines.size());
        String format = defaultColor.toString();
        for (String line : lines) {
            String formattedLine = format + lineStart + line;
            formattedLines.add(formattedLine);
        }
        return formattedLines;
    }

    public static List<Component> cutStringTextComponent(String c, ChatFormatting defaultColor, ChatFormatting highlightColor) {
        return TooltipHelper.cutTextComponent((Component)Components.literal(c), defaultColor, highlightColor, 0);
    }

    public static List<Component> cutTextComponent(Component c, ChatFormatting defaultColor, ChatFormatting highlightColor) {
        return TooltipHelper.cutTextComponent(c, defaultColor, highlightColor, 0);
    }

    public static List<Component> cutStringTextComponent(String c, ChatFormatting defaultColor, ChatFormatting highlightColor, int indent) {
        return TooltipHelper.cutTextComponent((Component)Components.literal(c), defaultColor, highlightColor, indent);
    }

    public static List<Component> cutTextComponent(Component c, ChatFormatting defaultColor, ChatFormatting highlightColor, int indent) {
        String s;
        String markedUp = s = c.getString();
        LinkedList<String> words = new LinkedList<String>();
        BreakIterator iterator = BreakIterator.getLineInstance(Minecraft.m_91087_().getLocale());
        iterator.setText(markedUp);
        int start = iterator.first();
        int end = iterator.next();
        while (end != -1) {
            String word = markedUp.substring(start, end);
            words.add(word);
            start = end;
            end = iterator.next();
        }
        Font font = Minecraft.m_91087_().f_91062_;
        LinkedList<String> lines = new LinkedList<String>();
        StringBuilder currentLine = new StringBuilder();
        int width = 0;
        for (String word : words) {
            int newWidth = font.m_92895_(word.replaceAll("_", ""));
            if (width + newWidth > 200) {
                if (width > 0) {
                    String line = currentLine.toString();
                    lines.add(line);
                    currentLine = new StringBuilder();
                    width = 0;
                } else {
                    lines.add(word);
                    continue;
                }
            }
            currentLine.append(word);
            width += newWidth;
        }
        if (width > 0) {
            lines.add(currentLine.toString());
        }
        MutableComponent lineStart = Components.literal(Strings.repeat((String)" ", (int)indent));
        lineStart.m_130940_(defaultColor);
        ArrayList<Component> formattedLines = new ArrayList<Component>(lines.size());
        Couple<ChatFormatting> f = Couple.create(highlightColor, defaultColor);
        boolean currentlyHighlighted = false;
        for (String string : lines) {
            String[] split;
            MutableComponent currentComponent = lineStart.m_6879_();
            for (String part : split = string.split("_")) {
                currentComponent.m_7220_((Component)Components.literal(part).m_130940_(f.get(currentlyHighlighted)));
                currentlyHighlighted = !currentlyHighlighted;
            }
            formattedLines.add((Component)currentComponent);
            currentlyHighlighted = !currentlyHighlighted;
        }
        return formattedLines;
    }

    private static void checkLocale() {
        LanguageInfo currentLanguage = Minecraft.m_91087_().m_91102_().m_118983_();
        if (cachedLanguage != currentLanguage) {
            cachedTooltips.clear();
            cachedLanguage = currentLanguage;
        }
    }

    public static boolean hasTooltip(ItemStack stack, Player player) {
        String key;
        TooltipHelper.checkLocale();
        boolean hasGoggles = GogglesItem.isWearingGoggles(player);
        if (hasGoggles != gogglesMode) {
            gogglesMode = hasGoggles;
            cachedTooltips.clear();
        }
        if (cachedTooltips.containsKey(key = TooltipHelper.getTooltipTranslationKey(stack))) {
            return cachedTooltips.get(key) != ItemDescription.MISSING;
        }
        return TooltipHelper.findTooltip(stack);
    }

    public static ItemDescription getTooltip(ItemStack stack) {
        ItemDescription itemDescription;
        TooltipHelper.checkLocale();
        String key = TooltipHelper.getTooltipTranslationKey(stack);
        if (cachedTooltips.containsKey(key) && (itemDescription = cachedTooltips.get(key)) != ItemDescription.MISSING) {
            return itemDescription;
        }
        return null;
    }

    private static boolean findTooltip(ItemStack stack) {
        String key = TooltipHelper.getTooltipTranslationKey(stack);
        if (I18n.m_118936_((String)key)) {
            cachedTooltips.put(key, TooltipHelper.buildToolTip(key, stack));
            return true;
        }
        cachedTooltips.put(key, ItemDescription.MISSING);
        return false;
    }

    private static ItemDescription buildToolTip(String translationKey, ItemStack stack) {
        int i;
        AllSections module = AllSections.of(stack);
        ItemDescription tooltip = new ItemDescription(module.getTooltipPalette());
        String summaryKey = translationKey + ".summary";
        if (I18n.m_118936_((String)summaryKey)) {
            tooltip = tooltip.withSummary((Component)Components.literal(I18n.m_118938_((String)summaryKey, (Object[])new Object[0])));
        }
        for (i = 1; i < 100; ++i) {
            String conditionKey = translationKey + ".condition" + i;
            String behaviourKey = translationKey + ".behaviour" + i;
            if (!I18n.m_118936_((String)conditionKey)) break;
            if (i == 1) {
                tooltip.getLinesOnShift().add(Components.immutableEmpty());
            }
            tooltip.withBehaviour(I18n.m_118938_((String)conditionKey, (Object[])new Object[0]), I18n.m_118938_((String)behaviourKey, (Object[])new Object[0]));
        }
        for (i = 1; i < 100; ++i) {
            String controlKey = translationKey + ".control" + i;
            String actionKey = translationKey + ".action" + i;
            if (!I18n.m_118936_((String)controlKey)) break;
            tooltip.withControl(I18n.m_118938_((String)controlKey, (Object[])new Object[0]), I18n.m_118938_((String)actionKey, (Object[])new Object[0]));
        }
        return tooltip.createTabs();
    }

    public static String getTooltipTranslationKey(ItemStack stack) {
        Item item = stack.m_41720_();
        if (tooltipReferrals.containsKey(item)) {
            return tooltipReferrals.get(item).get() + ".tooltip";
        }
        return item.m_5671_(stack) + ".tooltip";
    }

    static {
        tooltipReferrals = new HashMap<Item, Supplier<String>>();
    }
}

