/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.entity.monster;

import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import twilightforest.data.tags.EntityTagGenerator;
import twilightforest.entity.IHostileMount;
import twilightforest.entity.ai.goal.ChargeAttackGoal;
import twilightforest.init.TFDamageSources;
import twilightforest.init.TFSounds;

public class PinchBeetle
extends Monster
implements IHostileMount {
    public PinchBeetle(EntityType<? extends PinchBeetle> type, Level world) {
        super(type, world);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(2, (Goal)new ChargeAttackGoal((PathfinderMob)this, 1.5f, false));
        this.f_21345_.m_25352_(4, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, false));
        this.f_21345_.m_25352_(6, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(7, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
    }

    public static AttributeSupplier.Builder registerAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22276_, 40.0).m_22268_(Attributes.f_22279_, 0.23).m_22268_(Attributes.f_22281_, 4.0).m_22268_(Attributes.f_22284_, 2.0);
    }

    protected SoundEvent m_7975_(DamageSource source) {
        return (SoundEvent)TFSounds.PINCH_BEETLE_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)TFSounds.PINCH_BEETLE_DEATH.get();
    }

    protected void m_7355_(BlockPos pos, BlockState state) {
        this.m_5496_((SoundEvent)TFSounds.PINCH_BEETLE_STEP.get(), 0.15f, 1.0f);
    }

    public void m_8107_() {
        super.m_8107_();
        this.f_19815_ = this.m_6972_(this.m_20089_());
        if (!this.m_20197_().isEmpty()) {
            this.m_21563_().m_24960_((Entity)this.m_20197_().get(0), 100.0f, 100.0f);
            Object e = this.m_20197_().get(0);
            if (e instanceof LivingEntity) {
                LivingEntity entity = (LivingEntity)e;
                this.m_6710_(entity);
            }
            if ((e = this.m_20197_().get(0)) instanceof Player) {
                Player player = (Player)e;
                if (player.m_150110_().f_35934_) {
                    player.m_8127_();
                    this.m_6710_(null);
                }
            }
        }
    }

    public void m_147240_(double x, double y, double z) {
        if (this.m_20197_().isEmpty()) {
            super.m_147240_(x, y, z);
        }
    }

    public boolean m_7327_(Entity entity) {
        Entity v;
        if (this.m_20197_().isEmpty() && ((v = entity.m_20202_()) == null || !v.m_6095_().m_204039_(EntityTagGenerator.RIDES_OBSTRUCT_SNATCHING))) {
            entity.m_8127_();
            entity.m_7998_((Entity)this, true);
        }
        entity.m_6469_(TFDamageSources.clamped((LivingEntity)this), (float)this.m_21133_(Attributes.f_22281_));
        return super.m_7327_(entity);
    }

    public float m_20236_(Pose pose) {
        return 0.25f;
    }

    public void m_7332_(Entity passenger) {
        if (!this.m_20197_().isEmpty()) {
            Vec3 riderPos = this.getRiderPosition();
            ((Entity)this.m_20197_().get(0)).m_6034_(riderPos.m_7096_(), riderPos.m_7098_(), riderPos.m_7094_());
        }
    }

    public double m_6049_() {
        return -0.1;
    }

    public double m_6048_() {
        return 0.75;
    }

    private Vec3 getRiderPosition() {
        if (!this.m_20197_().isEmpty()) {
            float distance = 0.75f;
            double dx = Math.cos((double)(this.m_146908_() + 90.0f) * Math.PI / 180.0) * (double)distance;
            double dz = Math.sin((double)(this.m_146908_() + 90.0f) * Math.PI / 180.0) * (double)distance;
            return new Vec3(this.m_20185_() + dx, this.m_20186_() + this.m_6048_() + ((Entity)this.m_20197_().get(0)).m_6049_(), this.m_20189_() + dz);
        }
        return new Vec3(this.m_20185_(), this.m_20186_(), this.m_20189_());
    }

    public boolean canRiderInteract() {
        return true;
    }

    public EntityDimensions m_6972_(Pose pose) {
        if (!this.m_20197_().isEmpty()) {
            return EntityDimensions.m_20395_((float)2.25f, (float)1.25f);
        }
        return super.m_6972_(pose);
    }

    public MobType m_6336_() {
        return MobType.f_21642_;
    }
}

