/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.client.model.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import twilightforest.entity.monster.SlimeBeetle;

@OnlyIn(value=Dist.CLIENT)
public class SlimeBeetleModel
extends HierarchicalModel<SlimeBeetle> {
    public final ModelPart root;
    public final ModelPart head;
    public ModelPart rightLeg1;
    public ModelPart rightLeg2;
    public ModelPart rightLeg3;
    public ModelPart leftLeg1;
    public ModelPart leftLeg2;
    public ModelPart leftLeg3;
    public ModelPart rightAntenna;
    public ModelPart leftAntenna;
    public ModelPart rightEye;
    public ModelPart leftEye;
    public ModelPart tailBottom;
    public ModelPart tailTop;
    public ModelPart slime;
    public ModelPart slimeCenter;

    public SlimeBeetleModel(ModelPart root) {
        this.root = root;
        this.head = root.m_171324_("head");
        this.rightLeg1 = root.m_171324_("right_leg_1");
        this.rightLeg2 = root.m_171324_("right_leg_2");
        this.rightLeg3 = root.m_171324_("right_leg_3");
        this.leftLeg1 = root.m_171324_("left_leg_1");
        this.leftLeg2 = root.m_171324_("left_leg_2");
        this.leftLeg3 = root.m_171324_("left_leg_3");
        this.rightAntenna = this.head.m_171324_("right_antenna");
        this.leftAntenna = this.head.m_171324_("left_antenna");
        this.rightEye = this.head.m_171324_("right_eye");
        this.leftEye = this.head.m_171324_("left_eye");
        this.tailBottom = root.m_171324_("tail_bottom");
        this.tailTop = this.tailBottom.m_171324_("tail_top");
        this.slimeCenter = this.tailTop.m_171324_("slime_center");
        this.slime = this.slimeCenter.m_171324_("slime");
    }

    public static LayerDefinition create() {
        MeshDefinition mesh = new MeshDefinition();
        PartDefinition partRoot = mesh.m_171576_();
        PartDefinition head = partRoot.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(-4.0f, -3.0f, -6.0f, 8.0f, 6.0f, 6.0f), PartPose.m_171419_((float)0.0f, (float)17.0f, (float)-8.0f));
        head.m_171599_("right_antenna", CubeListBuilder.m_171558_().m_171514_(38, 4).m_171481_(-12.0f, -0.5f, -0.5f, 12.0f, 1.0f, 1.0f), PartPose.m_171423_((float)-0.5f, (float)-1.5f, (float)-5.0f, (float)0.0f, (float)-0.7853982f, (float)0.7853982f));
        head.m_171599_("left_antenna", CubeListBuilder.m_171558_().m_171514_(38, 6).m_171481_(0.0f, -0.5f, -0.5f, 12.0f, 1.0f, 1.0f), PartPose.m_171423_((float)0.5f, (float)-1.5f, (float)-5.0f, (float)0.0f, (float)0.7853982f, (float)-0.7853982f));
        head.m_171599_("right_eye", CubeListBuilder.m_171558_().m_171514_(0, 12).m_171481_(-2.0f, -1.0f, -2.0f, 3.0f, 3.0f, 3.0f), PartPose.m_171419_((float)-2.5f, (float)-1.0f, (float)-4.5f));
        head.m_171599_("left_eye", CubeListBuilder.m_171558_().m_171514_(16, 12).m_171481_(-1.0f, -1.0f, -2.0f, 3.0f, 3.0f, 3.0f), PartPose.m_171419_((float)2.5f, (float)-1.0f, (float)-4.5f));
        partRoot.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(32, 8).m_171481_(-4.0f, 0.0f, -4.0f, 8.0f, 10.0f, 8.0f), PartPose.m_171423_((float)0.0f, (float)17.0f, (float)-8.0f, (float)1.5707964f, (float)0.0f, (float)0.0f));
        partRoot.m_171599_("right_leg_1", CubeListBuilder.m_171558_().m_171514_(40, 0).m_171481_(-10.0f, -1.0f, -1.0f, 10.0f, 2.0f, 2.0f), PartPose.m_171423_((float)-2.0f, (float)20.0f, (float)-6.0f, (float)0.0f, (float)-0.43633232f, (float)-0.43633232f));
        partRoot.m_171599_("right_leg_2", CubeListBuilder.m_171558_().m_171514_(40, 0).m_171481_(-10.0f, -1.0f, -1.0f, 10.0f, 2.0f, 2.0f), PartPose.m_171423_((float)-2.0f, (float)20.0f, (float)-4.0f, (float)0.0f, (float)0.21816616f, (float)-0.43633232f));
        partRoot.m_171599_("right_leg_3", CubeListBuilder.m_171558_().m_171514_(40, 0).m_171481_(-10.0f, -1.0f, -1.0f, 10.0f, 2.0f, 2.0f), PartPose.m_171423_((float)-2.0f, (float)20.0f, (float)-2.0f, (float)0.0f, (float)0.7853982f, (float)-0.43633232f));
        partRoot.m_171599_("left_leg_1", CubeListBuilder.m_171558_().m_171480_().m_171514_(40, 0).m_171481_(0.0f, -1.0f, -1.0f, 10.0f, 2.0f, 2.0f), PartPose.m_171423_((float)2.0f, (float)20.0f, (float)-6.0f, (float)0.0f, (float)0.43633232f, (float)0.43633232f));
        partRoot.m_171599_("left_leg_2", CubeListBuilder.m_171558_().m_171480_().m_171514_(40, 0).m_171481_(0.0f, -1.0f, -1.0f, 10.0f, 2.0f, 2.0f), PartPose.m_171423_((float)2.0f, (float)20.0f, (float)-4.0f, (float)0.0f, (float)-0.21816616f, (float)0.43633232f));
        partRoot.m_171599_("left_leg_3", CubeListBuilder.m_171558_().m_171480_().m_171514_(40, 0).m_171481_(0.0f, -1.0f, -1.0f, 10.0f, 2.0f, 2.0f), PartPose.m_171423_((float)2.0f, (float)20.0f, (float)-2.0f, (float)0.0f, (float)-0.7853982f, (float)0.43633232f));
        PartDefinition tailBottom = partRoot.m_171599_("tail_bottom", CubeListBuilder.m_171558_().m_171514_(0, 34).m_171481_(-3.0f, -3.0f, 0.0f, 6.0f, 6.0f, 6.0f), PartPose.m_171419_((float)0.0f, (float)18.0f, (float)2.0f));
        PartDefinition tailTop = tailBottom.m_171599_("tail_top", CubeListBuilder.m_171558_().m_171514_(32, 28).m_171481_(-3.0f, -9.0f, -1.0f, 6.0f, 6.0f, 6.0f), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)3.0f));
        PartDefinition center = tailTop.m_171599_("slime_center", CubeListBuilder.m_171558_().m_171514_(0, 18).m_171481_(-4.0f, -10.0f, -5.0f, 8.0f, 8.0f, 8.0f), PartPose.m_171419_((float)0.0f, (float)-9.0f, (float)2.0f));
        center.m_171599_("slime", CubeListBuilder.m_171558_().m_171514_(16, 40).m_171481_(-6.0f, -12.0f, -7.0f, 12.0f, 12.0f, 12.0f), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)mesh, (int)64, (int)64);
    }

    public ModelPart m_142109_() {
        return this.root;
    }

    public void m_7695_(PoseStack stack, VertexConsumer builder, int light, int overlay, float red, float green, float blue, float alpha) {
        this.slime.f_104207_ = false;
        this.m_142109_().m_104306_(stack, builder, light, overlay, red, green, blue, alpha);
    }

    public void renderTail(PoseStack stack, VertexConsumer builder, int light, int overlay, float red, float green, float blue, float alpha) {
        this.tailBottom.m_104306_(stack, builder, light, overlay, red, green, blue, alpha);
    }

    public void setupAnim(SlimeBeetle entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        float legZ;
        this.head.f_104204_ = netHeadYaw / 57.295776f;
        this.head.f_104203_ = headPitch / 57.295776f;
        this.leftLeg1.f_104205_ = legZ = 0.28559935f;
        this.rightLeg1.f_104205_ = -legZ;
        this.leftLeg2.f_104205_ = legZ * 0.74f;
        this.rightLeg2.f_104205_ = -legZ * 0.74f;
        this.leftLeg3.f_104205_ = legZ;
        this.rightLeg3.f_104205_ = -legZ;
        float var9 = -0.0f;
        float var10 = 0.3926991f;
        this.leftLeg1.f_104204_ = var10 * 2.0f + var9;
        this.rightLeg1.f_104204_ = -var10 * 2.0f - var9;
        this.leftLeg2.f_104204_ = var10 + var9;
        this.rightLeg2.f_104204_ = -var10 - var9;
        this.leftLeg3.f_104204_ = -var10 * 2.0f + var9;
        this.rightLeg3.f_104204_ = var10 * 2.0f - var9;
        float var11 = -(Mth.m_14089_((float)(limbSwing * 0.6662f * 2.0f + 0.0f)) * 0.4f) * limbSwingAmount;
        float var12 = -(Mth.m_14089_((float)(limbSwing * 0.6662f * 2.0f + (float)Math.PI)) * 0.4f) * limbSwingAmount;
        float var14 = -(Mth.m_14089_((float)(limbSwing * 0.6662f * 2.0f + 4.712389f)) * 0.4f) * limbSwingAmount;
        float var15 = Math.abs(Mth.m_14031_((float)(limbSwing * 0.6662f + 0.0f)) * 0.4f) * limbSwingAmount;
        float var16 = Math.abs(Mth.m_14031_((float)(limbSwing * 0.6662f + (float)Math.PI)) * 0.4f) * limbSwingAmount;
        float var18 = Math.abs(Mth.m_14031_((float)(limbSwing * 0.6662f + 4.712389f)) * 0.4f) * limbSwingAmount;
        this.leftLeg1.f_104204_ += var11;
        this.rightLeg1.f_104204_ += -var11;
        this.leftLeg2.f_104204_ += var12;
        this.rightLeg2.f_104204_ += -var12;
        this.leftLeg3.f_104204_ += var14;
        this.rightLeg3.f_104204_ += -var14;
        this.leftLeg1.f_104205_ += var15;
        this.rightLeg1.f_104205_ += -var15;
        this.leftLeg2.f_104205_ += var16;
        this.rightLeg2.f_104205_ += -var16;
        this.leftLeg3.f_104205_ += var18;
        this.rightLeg3.f_104205_ += -var18;
        this.tailBottom.f_104203_ = Mth.m_14089_((float)(ageInTicks * 0.3335f)) * 0.15f;
        this.tailTop.f_104203_ = Mth.m_14089_((float)(ageInTicks * 0.4445f)) * 0.2f;
        this.slimeCenter.f_104203_ = Mth.m_14089_((float)(ageInTicks * 0.5555f + 0.25f)) * 0.25f;
    }
}

