/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.client.model.block.doors;

import com.mojang.datafixers.util.Pair;
import com.mojang.math.Transformation;
import com.mojang.math.Vector3f;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.BlockElement;
import net.minecraft.client.renderer.block.model.BlockElementFace;
import net.minecraft.client.renderer.block.model.BlockFaceUV;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.client.RenderTypeGroup;
import net.minecraftforge.client.model.SimpleModelState;
import net.minecraftforge.client.model.geometry.IGeometryBakingContext;
import net.minecraftforge.client.model.geometry.IUnbakedGeometry;
import net.minecraftforge.client.model.geometry.UnbakedGeometryHelper;
import twilightforest.client.model.block.doors.CastleDoorModel;
import twilightforest.client.model.block.doors.ConnectionLogic;

public class UnbakedCastleDoorModel
implements IUnbakedGeometry<UnbakedCastleDoorModel> {
    private final BlockElement[][] baseElements = new BlockElement[6][4];
    private final BlockElement[][][] faceElements = new BlockElement[6][4][5];

    public UnbakedCastleDoorModel() {
        Vec3i center = new Vec3i(8, 8, 8);
        for (Direction face : Direction.values()) {
            Direction[] planeDirections = ConnectionLogic.AXIS_PLANE_DIRECTIONS[face.m_122434_().ordinal()];
            for (int quad = 0; quad < 4; ++quad) {
                Vec3i corner = face.m_122436_().m_121955_(planeDirections[quad].m_122436_()).m_121955_(planeDirections[(quad + 1) % 4].m_122436_()).m_7918_(1, 1, 1).m_142393_(8);
                BlockElement element = new BlockElement(new Vector3f((float)Math.min(center.m_123341_(), corner.m_123341_()), (float)Math.min(center.m_123342_(), corner.m_123342_()), (float)Math.min(center.m_123343_(), corner.m_123343_())), new Vector3f((float)Math.max(center.m_123341_(), corner.m_123341_()), (float)Math.max(center.m_123342_(), corner.m_123342_()), (float)Math.max(center.m_123343_(), corner.m_123343_())), Map.of(), null, true);
                this.baseElements[face.m_122411_()][quad] = new BlockElement(element.f_111308_, element.f_111309_, Map.of(face, new BlockElementFace(face, -1, "", new BlockFaceUV(ConnectionLogic.NONE.remapUVs(element.m_111320_(face)), 0), 0)), null, true);
                for (ConnectionLogic connectionType : ConnectionLogic.values()) {
                    this.faceElements[face.m_122411_()][quad][connectionType.ordinal()] = new BlockElement(element.f_111308_, element.f_111309_, Map.of(face, new BlockElementFace(face, 0, "", new BlockFaceUV(connectionType.remapUVs(element.m_111320_(face)), 0), 15)), null, true);
                }
            }
        }
    }

    public BakedModel bake(IGeometryBakingContext context, ModelBakery bakery, Function<Material, TextureAtlasSprite> spriteGetter, ModelState modelState, ItemOverrides overrides, ResourceLocation modelLocation) {
        Transformation transformation = context.getRootTransform();
        if (!transformation.isIdentity()) {
            modelState = new SimpleModelState(modelState.m_6189_().m_121096_(transformation), modelState.m_7538_());
        }
        List[] baseQuads = (List[])Array.newInstance(List.class, 6);
        TextureAtlasSprite baseTexture = spriteGetter.apply(context.getMaterial("base"));
        for (int dir = 0; dir < 6; ++dir) {
            baseQuads[dir] = new ArrayList();
            for (BlockElement element : this.baseElements[dir]) {
                baseQuads[dir].add(UnbakedGeometryHelper.bakeElementFace((BlockElement)element, (BlockElementFace)((BlockElementFace)element.f_111310_.values().iterator().next()), (TextureAtlasSprite)baseTexture, (Direction)Direction.values()[dir], (ModelState)modelState, (ResourceLocation)modelLocation));
            }
        }
        TextureAtlasSprite[] sprites = new TextureAtlasSprite[]{spriteGetter.apply(context.getMaterial("overlay")), spriteGetter.apply(context.getMaterial("overlay_connected"))};
        BakedQuad[][][] quads = new BakedQuad[6][4][5];
        for (int dir = 0; dir < 6; ++dir) {
            for (int quad = 0; quad < 4; ++quad) {
                for (int type = 0; type < 5; ++type) {
                    BlockElement element = this.faceElements[dir][quad][type];
                    quads[dir][quad][type] = UnbakedGeometryHelper.bakeElementFace((BlockElement)element, (BlockElementFace)((BlockElementFace)element.f_111310_.values().iterator().next()), (TextureAtlasSprite)ConnectionLogic.values()[type].chooseTexture(sprites), (Direction)Direction.values()[dir], (ModelState)modelState, (ResourceLocation)modelLocation);
                }
            }
        }
        ResourceLocation renderTypeHint = context.getRenderTypeHint();
        RenderTypeGroup renderTypes = renderTypeHint != null ? context.getRenderType(renderTypeHint) : RenderTypeGroup.EMPTY;
        return new CastleDoorModel(baseQuads, quads, spriteGetter.apply(context.getMaterial("particle")), overrides, context.getTransforms(), renderTypes);
    }

    public Collection<Material> getMaterials(IGeometryBakingContext context, Function<ResourceLocation, UnbakedModel> modelGetter, Set<Pair<String, String>> missingTextureErrors) {
        ArrayList<Material> materials = new ArrayList<Material>();
        materials.add(context.getMaterial("base"));
        materials.add(context.getMaterial("particle"));
        materials.add(context.getMaterial("overlay"));
        materials.add(context.getMaterial("overlay_connected"));
        return materials;
    }
}

