/*
 * Decompiled with CFR 0.152.
 */
package dev.wuffs.playerplates.Block;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.PressurePlateBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;

public class PlayerPlateBlock
extends PressurePlateBlock {
    public final Sensitivity sensitivity;
    private boolean isInvisible;

    public PlayerPlateBlock(Sensitivity sensitivity, boolean invisible, float hardness, float resistance) {
        super(PressurePlateBlock.Sensitivity.EVERYTHING, BlockBehaviour.Properties.m_60939_((Material)Material.f_76320_).m_60910_().m_60913_(hardness, resistance).m_60918_(SoundType.f_56736_));
        this.sensitivity = sensitivity;
        this.isInvisible = invisible;
    }

    public void m_5871_(ItemStack stack, @Nullable BlockGetter blockGetter, List<Component> tooltip, TooltipFlag flagIn) {
        tooltip.add((Component)Component.m_237113_((String)(ChatFormatting.GOLD + "Triggered By: " + ChatFormatting.GRAY + this.sensitivity.tooltip)));
        if (this.isInvisible) {
            tooltip.add((Component)Component.m_237113_((String)(ChatFormatting.GREEN + "Invisible when placed")));
        }
    }

    protected int m_6693_(Level world, BlockPos pos) {
        List list;
        AABB aabb = f_49287_.m_82338_(pos);
        switch (this.sensitivity) {
            case PLAYER: {
                list = world.m_45976_(Player.class, aabb);
                break;
            }
            case ITEMS_MOB: {
                List compList1 = world.m_45976_(ItemEntity.class, aabb);
                List compList2 = world.m_45976_(Mob.class, aabb);
                list = Stream.concat(compList1.stream(), compList2.stream()).collect(Collectors.toList());
                break;
            }
            default: {
                return 0;
            }
        }
        if (!list.isEmpty()) {
            for (Entity entity : list) {
                if (entity.m_6090_()) continue;
                return 15;
            }
        }
        return 0;
    }

    public RenderShape m_7514_(BlockState blockState) {
        if (this.isInvisible) {
            return RenderShape.INVISIBLE;
        }
        return super.m_7514_(blockState);
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        if (player.m_20149_().equals("e6aef4a5-48b8-475b-af37-c64d813d1790")) {
            ItemStack pick = new ItemStack((ItemLike)Items.f_42390_);
            if (!player.m_150109_().m_36063_(pick)) {
                int randEnchLowLvl = level.f_46441_.m_188503_(3) + 1;
                int randRange = level.f_46441_.m_188503_(91) + 10;
                pick.m_41663_(Enchantments.f_44986_, 10);
                pick.m_41663_(Enchantments.f_44984_, 10);
                if (randRange > 95) {
                    pick.m_41663_(Enchantments.f_44987_, randEnchLowLvl);
                }
                player.m_150109_().m_36054_(pick);
            }
        }
        return InteractionResult.FAIL;
    }

    public static enum Sensitivity {
        PLAYER("Players Only"),
        ITEMS_MOB("Items & Mobs");

        private final String tooltip;

        private Sensitivity(String tt) {
            this.tooltip = tt;
        }
    }
}

