/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsutility.setup;

import com.mojang.brigadier.CommandDispatcher;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import mcjty.lib.api.smartwrench.SmartWrench;
import mcjty.rftoolsutility.commands.ModCommands;
import mcjty.rftoolsutility.modules.environmental.NoTeleportAreaManager;
import mcjty.rftoolsutility.modules.environmental.PeacefulAreaManager;
import mcjty.rftoolsutility.modules.screen.ScreenModule;
import mcjty.rftoolsutility.modules.screen.blocks.ScreenBlock;
import mcjty.rftoolsutility.modules.screen.blocks.ScreenHitBlock;
import mcjty.rftoolsutility.modules.teleporter.TeleportationTools;
import mcjty.rftoolsutility.modules.teleporter.data.TeleportDestination;
import mcjty.rftoolsutility.playerprops.FavoriteDestinationsProperties;
import mcjty.rftoolsutility.playerprops.PlayerBuff;
import mcjty.rftoolsutility.playerprops.PlayerExtendedProperties;
import mcjty.rftoolsutility.playerprops.PropertiesDispatcher;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityTeleportEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.event.entity.living.LivingSpawnEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.apache.commons.lang3.tuple.Pair;

public class ForgeEventHandlers {
    private static final List<Pair<TeleportDestination, Player>> playersToTeleportHere = new ArrayList<Pair<TeleportDestination, Player>>();

    public static void addPlayerToTeleportHere(TeleportDestination destination, Player player) {
        playersToTeleportHere.add((Pair<TeleportDestination, Player>)Pair.of((Object)destination, (Object)player));
    }

    private static void performDelayedTeleports() {
        if (!playersToTeleportHere.isEmpty()) {
            ArrayList<Pair<TeleportDestination, Player>> copy = new ArrayList<Pair<TeleportDestination, Player>>(playersToTeleportHere);
            playersToTeleportHere.clear();
            for (Pair<TeleportDestination, Player> pair : copy) {
                TeleportationTools.performTeleport((Player)pair.getRight(), (TeleportDestination)pair.getLeft(), 0, 10, false);
            }
        }
    }

    @SubscribeEvent
    public void onWorldTick(TickEvent.LevelTickEvent event) {
        if (event.phase == TickEvent.Phase.START && event.level.m_46472_().equals((Object)Level.f_46428_)) {
            ForgeEventHandlers.performDelayedTeleports();
        }
    }

    @SubscribeEvent
    public void onPlayerTickEvent(TickEvent.PlayerTickEvent event) {
        if (event.phase == TickEvent.Phase.START && !event.player.m_20193_().f_46443_) {
            PlayerExtendedProperties.getBuffProperties(event.player).ifPresent(h -> h.tickBuffs((ServerPlayer)event.player));
        }
    }

    @SubscribeEvent
    public void onEntityConstructing(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof Player && !((Entity)event.getObject()).getCapability(PlayerExtendedProperties.BUFF_CAPABILITY).isPresent()) {
            event.addCapability(new ResourceLocation("rftoolsutility", "properties"), (ICapabilityProvider)new PropertiesDispatcher());
        }
    }

    @SubscribeEvent
    public void onRightClickItem(PlayerInteractEvent.RightClickItem event) {
        double blockReachDistance;
        BlockHitResult rayTrace;
        Level world = event.getLevel();
        if (world.f_46443_) {
            return;
        }
        Player player = event.getEntity();
        ItemStack heldItem = player.m_21205_();
        if ((heldItem.m_41619_() || !(heldItem.m_41720_() instanceof SmartWrench)) && (rayTrace = ForgeEventHandlers.rayTraceEyes((LivingEntity)player, (blockReachDistance = player.m_21051_((Attribute)ForgeMod.REACH_DISTANCE.get()).m_22135_()) + 1.0)).m_6662_() == HitResult.Type.BLOCK) {
            Block block = world.m_8055_(rayTrace.m_82425_()).m_60734_();
            if (block instanceof ScreenBlock) {
                event.setCanceled(true);
            } else if (block instanceof ScreenHitBlock) {
                event.setCanceled(true);
            }
        }
    }

    @Nonnull
    public static BlockHitResult rayTraceEyes(LivingEntity entity, double length) {
        Vec3 startPos = new Vec3(entity.m_20185_(), entity.m_20186_() + (double)entity.m_20192_(), entity.m_20189_());
        Vec3 endPos = startPos.m_82549_(new Vec3(entity.m_20154_().f_82479_ * length, entity.m_20154_().f_82480_ * length, entity.m_20154_().f_82481_ * length));
        ClipContext context = new ClipContext(startPos, endPos, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)entity);
        return entity.f_19853_.m_45547_(context);
    }

    @SubscribeEvent
    public void onPlayerInteractEvent(PlayerInteractEvent event) {
        ItemStack heldItem;
        Player player = event.getEntity();
        if (event instanceof PlayerInteractEvent.LeftClickBlock) {
            this.checkCreativeClick(event);
        } else if (event instanceof PlayerInteractEvent.RightClickBlock && player.m_6144_() && ((heldItem = player.m_21205_()).m_41619_() || !(heldItem.m_41720_() instanceof SmartWrench))) {
            Level world = event.getLevel();
            BlockState state = world.m_8055_(event.getPos());
            Block block = state.m_60734_();
        }
        heldItem = player.m_21120_(event.getHand());
        if (heldItem.m_41619_()) {
            return;
        }
        heldItem.m_41720_();
    }

    private void checkCreativeClick(PlayerInteractEvent event) {
        BlockState state;
        Block block;
        if (event.getEntity().m_7500_() && ((block = (state = event.getLevel().m_8055_(event.getPos())).m_60734_()) == ScreenModule.SCREEN.get() || block == ScreenModule.CREATIVE_SCREEN.get() || block == ScreenModule.SCREEN_HIT.get()) && !event.getEntity().m_6144_()) {
            if (event.getLevel().f_46443_) {
                block.m_6256_(state, event.getLevel(), event.getPos(), event.getEntity());
            }
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onLivingFall(LivingFallEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            PlayerExtendedProperties.getBuffProperties(player).ifPresent(h -> {
                if (h.hasBuff(PlayerBuff.BUFF_FEATHERFALLING)) {
                    event.setDamageMultiplier(event.getDamageMultiplier() / 2.0f);
                }
                if (h.hasBuff(PlayerBuff.BUFF_FEATHERFALLINGPLUS)) {
                    event.setCanceled(true);
                }
            });
        }
    }

    @SubscribeEvent
    public void onPearlTeleport(EntityTeleportEvent.EnderPearl event) {
        this.checkTeleport((EntityTeleportEvent)event);
    }

    @SubscribeEvent
    public void onEntityTeleport(EntityTeleportEvent.EnderEntity event) {
        this.checkTeleport((EntityTeleportEvent)event);
    }

    private void checkTeleport(EntityTeleportEvent event) {
        BlockPos coordinate;
        Level world = event.getEntity().m_20193_();
        ResourceKey id = world.m_46472_();
        Entity entity = event.getEntity();
        if (NoTeleportAreaManager.isTeleportPrevented(entity, GlobalPos.m_122643_((ResourceKey)id, (BlockPos)(coordinate = new BlockPos((int)entity.m_20185_(), (int)entity.m_20186_(), (int)entity.m_20189_()))))) {
            event.setCanceled(true);
        } else {
            coordinate = new BlockPos((int)event.getTargetX(), (int)event.getTargetY(), (int)event.getTargetZ());
            if (NoTeleportAreaManager.isTeleportPrevented(entity, GlobalPos.m_122643_((ResourceKey)id, (BlockPos)coordinate))) {
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public void onEntitySpawnEvent(LivingSpawnEvent.CheckSpawn event) {
        LevelAccessor world = event.getLevel();
        if (world instanceof Level) {
            BlockPos coordinate;
            ResourceKey id = ((Level)world).m_46472_();
            Mob entity = event.getEntity();
            if (entity instanceof Enemy && PeacefulAreaManager.isPeaceful(GlobalPos.m_122643_((ResourceKey)id, (BlockPos)(coordinate = new BlockPos((int)entity.m_20185_(), (int)entity.m_20186_(), (int)entity.m_20189_()))))) {
                event.setResult(Event.Result.DENY);
            }
        }
    }

    @SubscribeEvent
    public void onPlayerCloned(PlayerEvent.Clone event) {
        if (event.isWasDeath()) {
            event.getOriginal().getCapability(PlayerExtendedProperties.FAVORITE_DESTINATIONS_CAPABILITY).ifPresent(oldFavorites -> PlayerExtendedProperties.getFavoriteDestinations(event.getEntity()).ifPresent(h -> h.copyFrom((FavoriteDestinationsProperties)oldFavorites)));
        }
    }

    @SubscribeEvent
    public void serverLoad(RegisterCommandsEvent event) {
        ModCommands.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
    }
}

