/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsutility.modules.teleporter.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import javax.annotation.Nonnull;
import mcjty.lib.client.RenderHelper;
import mcjty.lib.client.RenderSettings;
import mcjty.rftoolsutility.modules.teleporter.TeleporterModule;
import mcjty.rftoolsutility.modules.teleporter.blocks.MatterTransmitterTileEntity;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderers;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.entity.BlockEntityType;

public class BeamRenderer
implements BlockEntityRenderer<MatterTransmitterTileEntity> {
    public static final ResourceLocation BEAM_OK = new ResourceLocation("rftoolsutility", "block/machineteleporter");
    public static final ResourceLocation BEAM_WARN = new ResourceLocation("rftoolsutility", "block/machineteleporterwarn");
    public static final ResourceLocation BEAM_UNKNOWN = new ResourceLocation("rftoolsutility", "block/machineteleporterunknown");

    public BeamRenderer(BlockEntityRendererProvider.Context context) {
    }

    public void render(MatterTransmitterTileEntity tileEntity, float v, @Nonnull PoseStack matrixStack, @Nonnull MultiBufferSource buffer, int i, int ix) {
        if (tileEntity.isDialed() && !tileEntity.isBeamHidden()) {
            ResourceLocation beamIcon = switch (tileEntity.getStatus()) {
                case 0 -> BEAM_OK;
                case 1 -> BEAM_WARN;
                default -> BEAM_UNKNOWN;
            };
            TextureAtlasSprite sprite = (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(TextureAtlas.f_118259_).apply(beamIcon);
            VertexConsumer builder = buffer.m_6299_(RenderType.m_110466_());
            float o = 0.15f;
            RenderHelper.drawBox((PoseStack)matrixStack, (VertexConsumer)builder, (TextureAtlasSprite)sprite, (boolean)false, (boolean)false, (boolean)true, (boolean)true, (boolean)true, (boolean)true, (float)(1.0f - o), (float)o, (float)0.0f, (float)4.0f, (float)(1.0f - o), (float)o, (RenderSettings)RenderHelper.FULLBRIGHT_SETTINGS);
        }
    }

    public static void register() {
        BlockEntityRenderers.m_173590_((BlockEntityType)((BlockEntityType)TeleporterModule.TYPE_MATTER_TRANSMITTER.get()), BeamRenderer::new);
    }
}

