/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsutility.modules.screen.items;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mcjty.lib.builder.InfoLine;
import mcjty.lib.builder.TooltipBuilder;
import mcjty.lib.client.GuiTools;
import mcjty.lib.tileentity.GenericTileEntity;
import mcjty.lib.varia.ComponentFactory;
import mcjty.lib.varia.Logging;
import mcjty.lib.varia.ModuleTools;
import mcjty.lib.varia.Tools;
import mcjty.rftoolsbase.api.various.ITabletSupport;
import mcjty.rftoolsutility.RFToolsUtility;
import mcjty.rftoolsutility.modules.screen.ScreenModule;
import mcjty.rftoolsutility.modules.screen.blocks.ScreenContainer;
import mcjty.rftoolsutility.modules.screen.blocks.ScreenTileEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.util.Lazy;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class ScreenLinkItem
extends Item
implements ITabletSupport {
    private final Lazy<TooltipBuilder> tooltipBuilder = () -> new TooltipBuilder().info(new InfoLine[]{TooltipBuilder.key((String)"message.rftoolsutility.shiftmessage")}).infoShift(new InfoLine[]{TooltipBuilder.header(), TooltipBuilder.gold(), TooltipBuilder.parameter((String)"info", this::getInfoString)});

    protected String getInfoString(ItemStack stack) {
        return ModuleTools.getTargetString((ItemStack)stack);
    }

    public ScreenLinkItem() {
        super(RFToolsUtility.setup.defaultProperties().m_41499_(1));
    }

    public void m_7373_(@Nonnull ItemStack itemStack, @Nullable Level world, @Nonnull List<Component> list, @Nonnull TooltipFlag flag) {
        super.m_7373_(itemStack, world, list, flag);
        ((TooltipBuilder)this.tooltipBuilder.get()).makeTooltip(Tools.getId((Item)this), itemStack, list, flag);
    }

    public Item getInstalledTablet() {
        return (Item)ScreenModule.TABLET_SCREEN.get();
    }

    public void openGui(@Nonnull Player player, @Nonnull ItemStack tabletItem, @Nonnull ItemStack containingItem) {
        BlockPos pos = ModuleTools.getPositionFromModule((ItemStack)containingItem);
        ResourceKey dimensionType = ModuleTools.getDimensionFromModule((ItemStack)containingItem);
        GuiTools.openRemoteGui((Player)player, (ResourceKey)dimensionType, (BlockPos)pos, te -> new MenuProvider(){
            final /* synthetic */ BlockEntity val$te;
            final /* synthetic */ BlockPos val$pos;
            {
                this.val$te = blockEntity;
                this.val$pos = blockPos;
            }

            @Nonnull
            public Component m_5446_() {
                return ComponentFactory.literal((String)"Remote Screen");
            }

            public AbstractContainerMenu m_7208_(int id, @Nonnull Inventory inventory, @Nonnull Player player) {
                boolean creative = false;
                if (this.val$te instanceof ScreenTileEntity) {
                    creative = ((ScreenTileEntity)this.val$te).isCreative();
                }
                ScreenContainer container = creative ? ScreenContainer.createRemoteCreative(id, this.val$pos, (GenericTileEntity)this.val$te, player) : ScreenContainer.createRemote(id, this.val$pos, (GenericTileEntity)this.val$te, player);
                this.val$te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).ifPresent(h -> container.setupInventories((IItemHandler)h, inventory));
                return container;
            }
        });
    }

    @Nonnull
    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, @Nonnull InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (!world.f_46443_) {
            this.openGui(player, stack, stack);
            return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)stack);
        }
        return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)stack);
    }

    @Nonnull
    public InteractionResult m_6225_(UseOnContext context) {
        ItemStack stack = context.m_43722_();
        Level world = context.m_43725_();
        BlockPos pos = context.m_8083_();
        Direction facing = context.m_43719_();
        Player player = context.m_43723_();
        BlockEntity te = world.m_7702_(pos);
        CompoundTag tagCompound = stack.m_41784_();
        if (te instanceof ScreenTileEntity) {
            tagCompound.m_128359_("monitordim", world.m_46472_().m_135782_().toString());
            tagCompound.m_128405_("monitorx", pos.m_123341_());
            tagCompound.m_128405_("monitory", pos.m_123342_());
            tagCompound.m_128405_("monitorz", pos.m_123343_());
            BlockState state = player.m_20193_().m_8055_(pos);
            Block block = state.m_60734_();
            String name = "<invalid>";
            if (!world.m_8055_(pos).m_60795_()) {
                name = Tools.getReadableName((Level)world, (BlockPos)pos);
            }
            tagCompound.m_128359_("monitorname", name);
            if (world.f_46443_) {
                Logging.message((Player)player, (String)("Screen link is set to block '" + name + "'"));
            }
        } else {
            tagCompound.m_128473_("monitordim");
            tagCompound.m_128473_("monitorx");
            tagCompound.m_128473_("monitory");
            tagCompound.m_128473_("monitorz");
            tagCompound.m_128473_("monitorname");
            if (world.f_46443_) {
                Logging.message((Player)player, (String)"Screen link is cleared");
            }
        }
        stack.m_41751_(tagCompound);
        return InteractionResult.SUCCESS;
    }
}

