/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsutility.modules.environmental.recipes;

import javax.annotation.Nonnull;
import mcjty.lib.crafting.BaseShapedRecipe;
import mcjty.rftoolsutility.modules.environmental.EnvironmentalModule;
import mcjty.rftoolsutility.modules.spawner.items.SyringeItem;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.Level;

public class SyringeBasedRecipe
extends BaseShapedRecipe {
    private final ResourceLocation mobId;
    private final int syringeIndex;

    public SyringeBasedRecipe(ResourceLocation id, String group, int width, int height, NonNullList<Ingredient> ingredients, ItemStack result, ResourceLocation mobId, int syringeIndex) {
        super(id, group, width, height, SyringeBasedRecipe.addMob(ingredients, mobId, syringeIndex), result);
        this.mobId = mobId;
        this.syringeIndex = syringeIndex;
    }

    public SyringeBasedRecipe(ShapedRecipe other, ResourceLocation mobId, int syringeIndex) {
        super(other.m_6423_(), other.m_6076_(), other.m_44220_(), other.m_44221_(), SyringeBasedRecipe.addMob((NonNullList<Ingredient>)other.m_7527_(), mobId, syringeIndex), other.m_8043_());
        this.mobId = mobId;
        this.syringeIndex = syringeIndex;
    }

    private static NonNullList<Ingredient> addMob(NonNullList<Ingredient> input, ResourceLocation mobId, int syringeIndex) {
        NonNullList output = NonNullList.m_122780_((int)input.size(), (Object)Ingredient.f_43901_);
        for (int i = 0; i < input.size(); ++i) {
            Ingredient ingredient = (Ingredient)input.get(i);
            if (syringeIndex == i) {
                if (!ingredient.m_43947_() && ingredient.m_43908_().length > 0 && ingredient.m_43908_()[0].m_41720_() instanceof SyringeItem) {
                    ItemStack syringe = SyringeItem.createMobSyringe(mobId);
                    ingredient = Ingredient.m_43927_((ItemStack[])new ItemStack[]{syringe});
                } else {
                    throw new RuntimeException("Bad recipe. Index " + syringeIndex + " does not point to syringe!");
                }
            }
            output.set(i, (Object)ingredient);
        }
        return output;
    }

    public boolean m_5818_(@Nonnull CraftingContainer inv, @Nonnull Level level) {
        boolean matches = super.m_5818_(inv, level);
        if (matches) {
            for (int i = 0; i < inv.m_39347_() * inv.m_39346_(); ++i) {
                ItemStack stack = inv.m_8020_(i);
                if (!(stack.m_41720_() instanceof SyringeItem)) continue;
                String mob = SyringeItem.getMobId(stack);
                if (mob == null || !mob.equals(this.mobId.toString())) {
                    return false;
                }
                int amount = SyringeItem.getLevel(stack);
                if (amount >= 100) continue;
                return false;
            }
        }
        return matches;
    }

    public ResourceLocation getMobId() {
        return this.mobId;
    }

    @Nonnull
    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)EnvironmentalModule.SYRINGE_SERIALIZER.get();
    }

    public int getSyringeIndex() {
        return this.syringeIndex;
    }
}

