/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.gui.me.common;

import appeng.client.gui.AESubScreen;
import appeng.client.gui.me.common.MEStorageScreen;
import appeng.client.gui.widgets.AECheckbox;
import appeng.client.gui.widgets.TabButton;
import appeng.core.localization.GuiText;
import appeng.integration.abstraction.JEIFacade;
import appeng.integration.abstraction.REIFacade;
import appeng.menu.me.common.MEStorageMenu;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.ItemStack;

public class TerminalSettingsScreen<C extends MEStorageMenu>
extends AESubScreen<C, MEStorageScreen<C>> {
    private final AECheckbox pinAutoCraftedItemsCheckbox;
    private final AECheckbox notifyForFinishedCraftingJobsCheckbox;
    private final AECheckbox clearGridOnCloseCheckbox;
    private final AECheckbox useInternalSearchRadio;
    private final AECheckbox useExternalSearchRadio;
    private final AECheckbox rememberCheckbox;
    private final AECheckbox autoFocusCheckbox;
    private final AECheckbox syncWithExternalCheckbox;
    private final AECheckbox clearExternalCheckbox;
    private final AECheckbox searchTooltipsCheckbox;

    public TerminalSettingsScreen(MEStorageScreen<C> parent) {
        super(parent, "/screens/terminals/terminal_settings.json");
        boolean hasExternalSearch;
        MutableComponent externalSearchMod;
        this.addBackButton();
        if (JEIFacade.instance().isEnabled()) {
            externalSearchMod = Component.m_237113_((String)"JEI");
            hasExternalSearch = true;
        } else if (REIFacade.instance().isEnabled()) {
            externalSearchMod = Component.m_237113_((String)"REI");
            hasExternalSearch = true;
        } else {
            externalSearchMod = Component.m_237113_((String)"JEI/REI");
            hasExternalSearch = false;
        }
        this.pinAutoCraftedItemsCheckbox = this.widgets.addCheckbox("pinAutoCraftedItemsCheckbox", (Component)GuiText.TerminalSettingsPinAutoCraftedItems.text(), this::save);
        this.notifyForFinishedCraftingJobsCheckbox = this.widgets.addCheckbox("notifyForFinishedCraftingJobsCheckbox", (Component)GuiText.TerminalSettingsNotifyForFinishedJobs.text(), this::save);
        this.clearGridOnCloseCheckbox = this.widgets.addCheckbox("clearGridOnCloseCheckbox", (Component)GuiText.TerminalSettingsClearGridOnClose.text(), this::save);
        this.useInternalSearchRadio = this.widgets.addCheckbox("useInternalSearchRadio", (Component)GuiText.SearchSettingsUseInternalSearch.text(), this::switchToAeSearch);
        this.useInternalSearchRadio.setRadio(true);
        this.useExternalSearchRadio = this.widgets.addCheckbox("useExternalSearchRadio", (Component)GuiText.SearchSettingsUseExternalSearch.text(externalSearchMod), this::switchToExternalSearch);
        this.useExternalSearchRadio.setRadio(true);
        this.useExternalSearchRadio.f_93623_ = hasExternalSearch;
        this.searchTooltipsCheckbox = this.widgets.addCheckbox("searchTooltipsCheckbox", (Component)GuiText.SearchSettingsSearchTooltips.text(), this::save);
        this.rememberCheckbox = this.widgets.addCheckbox("rememberCheckbox", (Component)GuiText.SearchSettingsRememberSearch.text(), this::save);
        this.autoFocusCheckbox = this.widgets.addCheckbox("autoFocusCheckbox", (Component)GuiText.SearchSettingsAutoFocus.text(), this::save);
        this.syncWithExternalCheckbox = this.widgets.addCheckbox("syncWithExternalCheckbox", (Component)GuiText.SearchSettingsSyncWithExternal.text(externalSearchMod), this::save);
        this.clearExternalCheckbox = this.widgets.addCheckbox("clearExternalCheckbox", (Component)GuiText.SearchSettingsClearExternal.text(externalSearchMod), this::save);
        this.updateState();
    }

    private void switchToAeSearch() {
        this.useInternalSearchRadio.setSelected(true);
        this.useExternalSearchRadio.setSelected(false);
        this.save();
    }

    private void switchToExternalSearch() {
        this.useInternalSearchRadio.setSelected(false);
        this.useExternalSearchRadio.setSelected(true);
        this.save();
    }

    private void addBackButton() {
        ItemStack icon = ((MEStorageMenu)this.f_97732_).getHost().getMainMenuIcon();
        Component label = icon.m_41786_();
        ItemRenderer itemRenderer = Minecraft.m_91087_().m_91291_();
        TabButton button = new TabButton(icon, label, itemRenderer, btn -> this.returnToParent());
        this.widgets.add("back", (AbstractWidget)button);
    }

    private void updateState() {
        this.pinAutoCraftedItemsCheckbox.setSelected(this.config.isPinAutoCraftedItems());
        this.notifyForFinishedCraftingJobsCheckbox.setSelected(this.config.isNotifyForFinishedCraftingJobs());
        this.clearGridOnCloseCheckbox.setSelected(this.config.isClearGridOnClose());
        this.useInternalSearchRadio.setSelected(!this.config.isUseExternalSearch());
        this.useExternalSearchRadio.setSelected(this.config.isUseExternalSearch());
        this.rememberCheckbox.setSelected(this.config.isRememberLastSearch());
        this.autoFocusCheckbox.setSelected(this.config.isAutoFocusSearch());
        this.syncWithExternalCheckbox.setSelected(this.config.isSyncWithExternalSearch());
        this.clearExternalCheckbox.setSelected(this.config.isClearExternalSearchOnOpen());
        this.searchTooltipsCheckbox.setSelected(this.config.isSearchTooltips());
        this.rememberCheckbox.f_93624_ = this.useInternalSearchRadio.isSelected();
        this.autoFocusCheckbox.f_93624_ = this.useInternalSearchRadio.isSelected();
        this.syncWithExternalCheckbox.f_93624_ = this.useInternalSearchRadio.isSelected();
        this.clearExternalCheckbox.f_93624_ = this.useExternalSearchRadio.isSelected();
    }

    private void save() {
        this.config.setUseExternalSearch(this.useExternalSearchRadio.isSelected());
        this.config.setRememberLastSearch(this.rememberCheckbox.isSelected());
        this.config.setAutoFocusSearch(this.autoFocusCheckbox.isSelected());
        this.config.setSyncWithExternalSearch(this.syncWithExternalCheckbox.isSelected());
        this.config.setClearExternalSearchOnOpen(this.clearExternalCheckbox.isSelected());
        this.config.setSearchTooltips(this.searchTooltipsCheckbox.isSelected());
        this.config.setPinAutoCraftedItems(this.pinAutoCraftedItemsCheckbox.isSelected());
        this.config.setNotifyForFinishedCraftingJobs(this.notifyForFinishedCraftingJobsCheckbox.isSelected());
        this.config.setClearGridOnClose(this.clearGridOnCloseCheckbox.isSelected());
        this.updateState();
    }
}

