/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedstorage.common;

import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.items.IItemHandler;
import net.p3pp3rf1y.sophisticatedcore.SophisticatedCore;
import net.p3pp3rf1y.sophisticatedcore.network.SyncPlayerSettingsMessage;
import net.p3pp3rf1y.sophisticatedcore.settings.SettingsManager;
import net.p3pp3rf1y.sophisticatedcore.util.InventoryHelper;
import net.p3pp3rf1y.sophisticatedcore.util.ItemBase;
import net.p3pp3rf1y.sophisticatedcore.util.WorldHelper;
import net.p3pp3rf1y.sophisticatedstorage.Config;
import net.p3pp3rf1y.sophisticatedstorage.block.LimitedBarrelBlock;
import net.p3pp3rf1y.sophisticatedstorage.block.WoodStorageBlockBase;
import net.p3pp3rf1y.sophisticatedstorage.block.WoodStorageBlockEntity;
import net.p3pp3rf1y.sophisticatedstorage.client.gui.StorageTranslationHelper;
import net.p3pp3rf1y.sophisticatedstorage.init.ModItems;

public class CommonEventHandler {
    private static final int AVERAGE_MAX_ITEM_ENTITY_DROP_COUNT = 20;

    public void registerHandlers() {
        IEventBus eventBus = MinecraftForge.EVENT_BUS;
        eventBus.addListener(this::onPlayerLoggedIn);
        eventBus.addListener(this::onPlayerChangedDimension);
        eventBus.addListener(this::onPlayerRespawn);
        eventBus.addListener(this::onBlockBreak);
        eventBus.addListener(this::onLimitedBarrelClicked);
    }

    private void onLimitedBarrelClicked(PlayerInteractEvent.LeftClickBlock event) {
        Player player = event.getEntity();
        if (!player.m_7500_()) {
            return;
        }
        BlockPos pos = event.getPos();
        Level level = event.getLevel();
        BlockState state = level.m_8055_(pos);
        Block block = state.m_60734_();
        if (!(block instanceof LimitedBarrelBlock)) {
            return;
        }
        LimitedBarrelBlock limitedBarrel = (LimitedBarrelBlock)block;
        if (limitedBarrel.tryToTakeItem(state, level, pos, player)) {
            event.setCanceled(true);
        }
    }

    private void onPlayerChangedDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
        this.sendPlayerSettingsToClient(event.getEntity());
    }

    private void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        this.sendPlayerSettingsToClient(event.getEntity());
    }

    private void sendPlayerSettingsToClient(Player player) {
        String playerTagName = "sophisticatedStorageSettings";
        SophisticatedCore.PACKET_HANDLER.sendToClient((ServerPlayer)player, (Object)new SyncPlayerSettingsMessage(playerTagName, SettingsManager.getPlayerSettingsTag((Player)player, (String)playerTagName)));
    }

    private void onPlayerRespawn(PlayerEvent.PlayerRespawnEvent event) {
        this.sendPlayerSettingsToClient(event.getEntity());
    }

    private void onBlockBreak(BlockEvent.BreakEvent event) {
        Player player = event.getPlayer();
        if (!(event.getState().m_60734_() instanceof WoodStorageBlockBase) || player.m_6144_()) {
            return;
        }
        Level level = player.m_9236_();
        WorldHelper.getBlockEntity((BlockGetter)level, (BlockPos)event.getPos(), WoodStorageBlockEntity.class).ifPresent(wbe -> {
            if (wbe.isPacked()) {
                return;
            }
            AtomicInteger droppedItemEntityCount = new AtomicInteger(0);
            InventoryHelper.iterate((IItemHandler)wbe.getStorageWrapper().getInventoryHandler(), (slot, stack) -> {
                if (stack.m_41619_()) {
                    return;
                }
                droppedItemEntityCount.addAndGet((int)Math.ceil((double)stack.m_41613_() / (double)Math.min(stack.m_41741_(), 20)));
            });
            if (droppedItemEntityCount.get() > (Integer)Config.COMMON.tooManyItemEntityDrops.get()) {
                event.setCanceled(true);
                ItemBase packingTapeItem = (ItemBase)ModItems.PACKING_TAPE.get();
                MutableComponent packingTapeItemName = packingTapeItem.m_7626_(new ItemStack((ItemLike)packingTapeItem)).m_6881_().m_130940_(ChatFormatting.GREEN);
                player.m_213846_(StorageTranslationHelper.INSTANCE.translStatusMessage("too_many_item_entity_drops", new Object[]{event.getState().m_60734_().m_49954_().m_130940_(ChatFormatting.GREEN), Component.m_237113_((String)String.valueOf(droppedItemEntityCount.get())).m_130940_(ChatFormatting.RED), packingTapeItemName}));
            }
        });
    }
}

