/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedstorage.client.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Vector3f;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.core.Direction;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.p3pp3rf1y.sophisticatedcore.util.CountAbbreviator;
import net.p3pp3rf1y.sophisticatedstorage.block.LimitedBarrelBlock;
import net.p3pp3rf1y.sophisticatedstorage.block.LimitedBarrelBlockEntity;
import net.p3pp3rf1y.sophisticatedstorage.block.StorageBlockBase;
import net.p3pp3rf1y.sophisticatedstorage.client.render.DisplayItemRenderer;

public class LimitedBarrelRenderer
implements BlockEntityRenderer<LimitedBarrelBlockEntity> {
    private static final double BLOCK_SIDE_OFFSET = 0.5;
    private static final float MULTIPLE_ITEMS_FONT_SCALE = 0.0078125f;
    private static final float SINGLE_ITEM_FONT_SCALE = 0.015625f;
    private final DisplayItemRenderer displayItemRenderer = new DisplayItemRenderer(0.5, 0.5){

        @Override
        protected void rotateToFront(PoseStack poseStack, BlockState state, Direction facing) {
            poseStack.m_85845_(1.getNorthBasedRotation((Direction)state.m_61143_((Property)LimitedBarrelBlock.HORIZONTAL_FACING)));
            LimitedBarrelBlock.VerticalFacing verticalFacing = (LimitedBarrelBlock.VerticalFacing)((Object)state.m_61143_(LimitedBarrelBlock.VERTICAL_FACING));
            if (verticalFacing != LimitedBarrelBlock.VerticalFacing.NO) {
                poseStack.m_85845_(1.getNorthBasedRotation(verticalFacing.getDirection()));
            }
        }

        @Override
        protected void rotateFrontOffset(BlockState state, Direction facing, Vector3f frontOffset) {
            LimitedBarrelBlock.VerticalFacing verticalFacing = (LimitedBarrelBlock.VerticalFacing)((Object)state.m_61143_(LimitedBarrelBlock.VERTICAL_FACING));
            if (verticalFacing != LimitedBarrelBlock.VerticalFacing.NO) {
                frontOffset.m_122251_(1.getNorthBasedRotation(verticalFacing.getDirection()));
            }
            frontOffset.m_122251_(1.getNorthBasedRotation((Direction)state.m_61143_((Property)LimitedBarrelBlock.HORIZONTAL_FACING)));
        }
    };

    public void render(LimitedBarrelBlockEntity blockEntity, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
        if (blockEntity.isPacked()) {
            return;
        }
        this.renderItemCounts(blockEntity, poseStack);
        if (blockEntity.hasDynamicRenderer()) {
            this.displayItemRenderer.renderDisplayItems(blockEntity, poseStack, bufferSource, packedLight, packedOverlay, !blockEntity.hasFullyDynamicRenderer());
        }
    }

    private void renderItemCounts(LimitedBarrelBlockEntity blockEntity, PoseStack poseStack) {
        BlockState blockState = blockEntity.m_58900_();
        if (!(blockState.m_60734_() instanceof StorageBlockBase) || !blockEntity.shouldShowCounts()) {
            return;
        }
        Font font = Minecraft.m_91087_().f_91062_;
        List<Integer> slotCounts = blockEntity.getSlotCounts();
        float countDisplayYOffset = -(slotCounts.size() == 1 ? 0.27f : 0.132f);
        Direction horizontalFacing = (Direction)blockState.m_61143_((Property)LimitedBarrelBlock.HORIZONTAL_FACING);
        poseStack.m_85836_();
        poseStack.m_85837_(0.5, 0.5, 0.5);
        poseStack.m_85845_(DisplayItemRenderer.getNorthBasedRotation(horizontalFacing.m_122424_()));
        LimitedBarrelBlock.VerticalFacing verticalFacing = (LimitedBarrelBlock.VerticalFacing)((Object)blockState.m_61143_(LimitedBarrelBlock.VERTICAL_FACING));
        if (verticalFacing != LimitedBarrelBlock.VerticalFacing.NO) {
            poseStack.m_85845_(DisplayItemRenderer.getNorthBasedRotation(verticalFacing.getDirection().m_122424_()));
        }
        poseStack.m_85837_(0.5, -0.5, 0.5);
        for (int displayItemIndex = 0; displayItemIndex < slotCounts.size(); ++displayItemIndex) {
            int count = slotCounts.get(displayItemIndex);
            if (count <= 0) continue;
            poseStack.m_85836_();
            Vector3f frontOffset = DisplayItemRenderer.getDisplayItemIndexFrontOffset(displayItemIndex, slotCounts.size());
            double xTranslation = -frontOffset.m_122239_();
            float yTranslation = frontOffset.m_122260_() + countDisplayYOffset;
            double zTranslation = 0.001;
            poseStack.m_85837_(xTranslation, (double)yTranslation, zTranslation);
            float scale = slotCounts.size() == 1 ? 0.015625f : 0.0078125f;
            poseStack.m_85841_(scale, -scale, scale);
            String countString = CountAbbreviator.abbreviate((int)count, (int)(slotCounts.size() == 1 ? 6 : 5));
            float countDisplayXOffset = (float)(-font.m_92895_(countString)) / 2.0f;
            poseStack.m_85837_((double)countDisplayXOffset, 0.0, 0.0);
            font.m_92883_(poseStack, countString, 0.0f, 0.0f, DyeColor.LIGHT_GRAY.m_41071_());
            poseStack.m_85849_();
        }
        poseStack.m_85849_();
    }

    public int m_142163_() {
        return 32;
    }
}

