/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedstorage.client.render;

import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Either;
import com.mojang.math.Vector3f;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.BlockModel;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.client.model.IQuadTransformer;
import net.minecraftforge.client.model.data.ModelData;
import net.minecraftforge.client.model.geometry.IGeometryLoader;
import net.p3pp3rf1y.sophisticatedstorage.block.BarrelType;
import net.p3pp3rf1y.sophisticatedstorage.block.LimitedBarrelBlock;
import net.p3pp3rf1y.sophisticatedstorage.block.StorageTier;
import net.p3pp3rf1y.sophisticatedstorage.block.WoodStorageBlockBase;
import net.p3pp3rf1y.sophisticatedstorage.client.StorageTextureManager;
import net.p3pp3rf1y.sophisticatedstorage.client.render.BarrelBakedModelBase;
import net.p3pp3rf1y.sophisticatedstorage.client.render.BarrelDynamicModelBase;
import net.p3pp3rf1y.sophisticatedstorage.client.render.BarrelModelPart;
import net.p3pp3rf1y.sophisticatedstorage.client.render.DisplayItemRenderer;

public class LimitedBarrelDynamicModel
extends BarrelDynamicModelBase<LimitedBarrelDynamicModel> {
    public LimitedBarrelDynamicModel(Map<String, Map<BarrelModelPart, UnbakedModel>> woodModels) {
        super(woodModels);
    }

    @Override
    protected BarrelBakedModelBase instantiateBakedModel(ImmutableMap<String, Map<BarrelModelPart, BakedModel>> woodModelParts) {
        return new LimitedBarrelBakedModel((Map<String, Map<BarrelModelPart, BakedModel>>)woodModelParts);
    }

    private static class LimitedBarrelBakedModel
    extends BarrelBakedModelBase {
        public LimitedBarrelBakedModel(Map<String, Map<BarrelModelPart, BakedModel>> woodModelParts) {
            super(woodModelParts);
        }

        @Override
        protected BarrelModelPart getBasePart(@Nullable BlockState state) {
            return BarrelModelPart.BASE;
        }

        @Override
        protected BarrelModelPart getMainPart(@Nullable BlockState state) {
            return BarrelModelPart.LIMITED_MAIN;
        }

        @Override
        protected BarrelModelPart getMainPart() {
            return BarrelModelPart.LIMITED_MAIN;
        }

        @Override
        protected int getInWorldBlockHash(BlockState state, ModelData data) {
            int hash = super.getInWorldBlockHash(state, data);
            hash = hash * 31 + ((Direction)state.m_61143_((Property)LimitedBarrelBlock.HORIZONTAL_FACING)).m_122416_();
            hash = hash * 31 + ((LimitedBarrelBlock.VerticalFacing)((Object)state.m_61143_(LimitedBarrelBlock.VERTICAL_FACING))).getIndex();
            return hash;
        }

        @Override
        protected List<BakedQuad> rotateDisplayItemQuads(List<BakedQuad> quads, BlockState state) {
            LimitedBarrelBlock.VerticalFacing verticalFacing = (LimitedBarrelBlock.VerticalFacing)((Object)state.m_61143_(LimitedBarrelBlock.VERTICAL_FACING));
            if (verticalFacing != LimitedBarrelBlock.VerticalFacing.NO) {
                quads = ((IQuadTransformer)DIRECTION_ROTATES.get(verticalFacing.getDirection())).process(quads);
            }
            quads = ((IQuadTransformer)DIRECTION_ROTATES.get(state.m_61143_((Property)LimitedBarrelBlock.HORIZONTAL_FACING))).process(quads);
            return quads;
        }

        @Override
        protected int calculateMoveBackToSideHash(BlockState state, Direction dir, float distFromCenter, int displayItemIndex, int displayItemCount) {
            int hash = super.calculateMoveBackToSideHash(state, dir, distFromCenter, displayItemIndex, displayItemCount);
            hash = hash * 31 + ((Direction)state.m_61143_((Property)LimitedBarrelBlock.HORIZONTAL_FACING)).m_122416_();
            hash = hash * 31 + ((LimitedBarrelBlock.VerticalFacing)((Object)state.m_61143_(LimitedBarrelBlock.VERTICAL_FACING))).getIndex();
            return hash;
        }

        @Override
        protected void rotateDisplayItemFrontOffset(BlockState state, Direction dir, Vector3f frontOffset) {
            LimitedBarrelBlock.VerticalFacing verticalFacing = (LimitedBarrelBlock.VerticalFacing)((Object)state.m_61143_(LimitedBarrelBlock.VERTICAL_FACING));
            if (verticalFacing != LimitedBarrelBlock.VerticalFacing.NO) {
                frontOffset.m_122251_(DisplayItemRenderer.getNorthBasedRotation(verticalFacing.getDirection()));
            }
            frontOffset.m_122251_(DisplayItemRenderer.getNorthBasedRotation((Direction)state.m_61143_((Property)LimitedBarrelBlock.HORIZONTAL_FACING)));
        }

        @Override
        protected int calculateDirectionMoveHash(BlockState state, ItemStack displayItem, int displayItemIndex, int displayItemCount) {
            int hash = super.calculateDirectionMoveHash(state, displayItem, displayItemIndex, displayItemCount);
            hash = 31 * hash + ((Direction)state.m_61143_((Property)LimitedBarrelBlock.HORIZONTAL_FACING)).m_122416_();
            hash = 31 * hash + ((LimitedBarrelBlock.VerticalFacing)((Object)state.m_61143_(LimitedBarrelBlock.VERTICAL_FACING))).getIndex();
            return hash;
        }
    }

    public static final class Loader
    implements IGeometryLoader<LimitedBarrelDynamicModel> {
        public static final Loader INSTANCE = new Loader();

        public LimitedBarrelDynamicModel read(JsonObject modelContents, JsonDeserializationContext deserializationContext) {
            ImmutableMap.Builder woodModelsBuilder = ImmutableMap.builder();
            StorageTier tier = StorageTier.valueOf(modelContents.getAsJsonPrimitive("tier").getAsString().toUpperCase(Locale.ROOT));
            BarrelType barrelType = BarrelType.valueOf(modelContents.getAsJsonPrimitive("barrelType").getAsString().toUpperCase(Locale.ROOT));
            WoodStorageBlockBase.CUSTOM_TEXTURE_WOOD_TYPES.keySet().forEach(woodType -> {
                ImmutableMap.Builder modelsBuilder = ImmutableMap.builder();
                for (BarrelModelPart barrelPart : BarrelModelPart.getLimitedBarrelParts()) {
                    HashMap<String, Either<Material, String>> materials = new HashMap<String, Either<Material, String>>();
                    for (StorageTextureManager.BarrelMaterial barrelMaterial : barrelPart.getBarrelMaterials(barrelType, tier)) {
                        BarrelDynamicModelBase.putMaterial(materials, StorageTextureManager.INSTANCE::getLimitedBarrelMaterial, woodType, StorageTextureManager.BarrelFace.TOP, barrelMaterial);
                        BarrelDynamicModelBase.putMaterial(materials, StorageTextureManager.INSTANCE::getLimitedBarrelMaterial, woodType, StorageTextureManager.BarrelFace.BOTTOM, barrelMaterial);
                        BarrelDynamicModelBase.putMaterial(materials, StorageTextureManager.INSTANCE::getLimitedBarrelMaterial, woodType, StorageTextureManager.BarrelFace.SIDE, barrelMaterial);
                    }
                    modelsBuilder.put((Object)barrelPart, (Object)new BlockModel(barrelPart.modelName, Collections.emptyList(), materials, true, null, ItemTransforms.f_111786_, Collections.emptyList()));
                }
                woodModelsBuilder.put((Object)woodType.m_61846_(), (Object)modelsBuilder.build());
            });
            return new LimitedBarrelDynamicModel((Map<String, Map<BarrelModelPart, UnbakedModel>>)woodModelsBuilder.build());
        }
    }
}

