/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedstorage.client.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Vector3f;
import java.util.Map;
import java.util.Optional;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.resources.model.Material;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.WoodType;
import net.minecraft.world.phys.Vec3;
import net.p3pp3rf1y.sophisticatedstorage.block.ChestBlock;
import net.p3pp3rf1y.sophisticatedstorage.block.ChestBlockEntity;
import net.p3pp3rf1y.sophisticatedstorage.block.StorageWrapper;
import net.p3pp3rf1y.sophisticatedstorage.client.ClientEventHandler;
import net.p3pp3rf1y.sophisticatedstorage.client.StorageTextureManager;
import net.p3pp3rf1y.sophisticatedstorage.client.render.DisplayItemRenderer;
import net.p3pp3rf1y.sophisticatedstorage.client.render.LockRenderer;
import net.p3pp3rf1y.sophisticatedstorage.init.ModBlocks;

public class ChestRenderer
implements BlockEntityRenderer<ChestBlockEntity> {
    private static final String BOTTOM = "bottom";
    private static final String LID = "lid";
    private static final String LOCK = "lock";
    private final ModelPart lidPart;
    private final ModelPart bottomPart;
    private final ModelPart lockPart;
    private final DisplayItemRenderer displayItemRenderer = new DisplayItemRenderer(0.4378125, 0.431875);

    public ChestRenderer(BlockEntityRendererProvider.Context context) {
        ModelPart modelpart = context.m_173582_(ClientEventHandler.CHEST_LAYER);
        this.bottomPart = modelpart.m_171324_(BOTTOM);
        this.lidPart = modelpart.m_171324_(LID);
        this.lockPart = modelpart.m_171324_(LOCK);
    }

    public static LayerDefinition createSingleBodyLayer(boolean addLock) {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        partdefinition.m_171599_(BOTTOM, CubeListBuilder.m_171558_().m_171514_(0, 19).m_171481_(1.0f, 0.0f, 1.0f, 14.0f, 10.0f, 14.0f), PartPose.f_171404_);
        partdefinition.m_171599_(LID, CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(1.0f, 0.0f, 0.0f, 14.0f, 5.0f, 14.0f), PartPose.m_171419_((float)0.0f, (float)9.0f, (float)1.0f));
        if (addLock) {
            partdefinition.m_171599_(LOCK, CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(7.0f, -1.0f, 15.0f, 2.0f, 4.0f, 1.0f), PartPose.m_171419_((float)0.0f, (float)8.0f, (float)0.0f));
        }
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public void render(ChestBlockEntity chestEntity, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
        VertexConsumer vertexconsumer;
        BlockState blockstate = chestEntity.m_58900_();
        StorageTextureManager matManager = StorageTextureManager.INSTANCE;
        Optional<WoodType> woodType = chestEntity.getWoodType();
        Map<StorageTextureManager.ChestMaterial, Material> chestMaterials = matManager.getWoodChestMaterials(woodType.orElse(WoodType.f_61833_));
        if (chestMaterials == null) {
            return;
        }
        poseStack.m_85836_();
        Direction facing = (Direction)blockstate.m_61143_((Property)ChestBlock.FACING);
        float f = facing.m_122435_();
        poseStack.m_85837_(0.5, 0.5, 0.5);
        poseStack.m_85845_(Vector3f.f_122225_.m_122240_(-f));
        poseStack.m_85837_(-0.5, -0.5, -0.5);
        float lidAngle = chestEntity.getOpenNess(partialTick);
        lidAngle = 1.0f - lidAngle;
        float finalLidAngle = lidAngle = 1.0f - lidAngle * lidAngle * lidAngle;
        StorageWrapper storageWrapper = chestEntity.getStorageWrapper();
        boolean hasMainColor = storageWrapper.hasMainColor();
        boolean hasAccentColor = storageWrapper.hasAccentColor();
        if (woodType.isPresent() || !hasMainColor || !hasAccentColor) {
            vertexconsumer = chestMaterials.get((Object)StorageTextureManager.ChestMaterial.BASE).m_119194_(bufferSource, RenderType::m_110452_);
            this.renderBottomAndLid(poseStack, vertexconsumer, finalLidAngle, packedLight, packedOverlay);
        }
        if (hasMainColor) {
            vertexconsumer = chestMaterials.get((Object)StorageTextureManager.ChestMaterial.TINTABLE_MAIN).m_119194_(bufferSource, RenderType::m_110452_);
            this.renderBottomAndLidWithTint(poseStack, vertexconsumer, lidAngle, packedLight, packedOverlay, storageWrapper.getMainColor());
        }
        if (hasAccentColor) {
            vertexconsumer = chestMaterials.get((Object)StorageTextureManager.ChestMaterial.TINTABLE_ACCENT).m_119194_(bufferSource, RenderType::m_110452_);
            this.renderBottomAndLidWithTint(poseStack, vertexconsumer, lidAngle, packedLight, packedOverlay, storageWrapper.getAccentColor());
        }
        Material tierMaterial = this.getTierMaterial(chestMaterials, blockstate.m_60734_());
        VertexConsumer vertexconsumer2 = tierMaterial.m_119194_(bufferSource, RenderType::m_110452_);
        this.renderBottomAndLid(poseStack, vertexconsumer2, lidAngle, packedLight, packedOverlay);
        if (storageWrapper.getRenderInfo().getItemDisplayRenderInfo().getDisplayItem().isEmpty()) {
            this.renderLock(poseStack, vertexconsumer2, lidAngle, packedLight, packedOverlay);
        }
        poseStack.m_85849_();
        if (chestEntity.isPacked()) {
            VertexConsumer consumer = chestMaterials.get((Object)StorageTextureManager.ChestMaterial.PACKED).m_119194_(bufferSource, RenderType::m_110452_);
            poseStack.m_85836_();
            poseStack.m_85837_(-0.005, -0.005, -0.005);
            poseStack.m_85841_(1.01f, 1.01f, 1.01f);
            this.renderBottomAndLid(poseStack, consumer, finalLidAngle, packedLight, packedOverlay);
            poseStack.m_85849_();
        } else if (this.shouldRenderDisplayItem(chestEntity.m_58899_())) {
            LockRenderer.renderLock(chestEntity, facing, poseStack, bufferSource, packedLight, packedOverlay, 0.3125f, 0.4375f);
            this.displayItemRenderer.renderDisplayItem(chestEntity, poseStack, bufferSource, packedLight, packedOverlay);
        }
    }

    private boolean shouldRenderDisplayItem(BlockPos chestPos) {
        Camera camera = Minecraft.m_91087_().f_91063_.m_109153_();
        return Vec3.m_82512_((Vec3i)chestPos).m_82509_((Position)camera.m_90583_(), 32.0);
    }

    private void renderBottomAndLid(PoseStack poseStack, VertexConsumer consumer, float lidAngle, int packedLight, int packedOverlay) {
        this.lidPart.f_104203_ = -(lidAngle * 1.5707964f);
        this.lidPart.m_104301_(poseStack, consumer, packedLight, packedOverlay);
        this.bottomPart.m_104301_(poseStack, consumer, packedLight, packedOverlay);
    }

    private void renderBottomAndLidWithTint(PoseStack poseStack, VertexConsumer consumer, float lidAngle, int packedLight, int packedOverlay, int tint) {
        float tintRed = (float)(tint >> 16 & 0xFF) / 255.0f;
        float tingGreen = (float)(tint >> 8 & 0xFF) / 255.0f;
        float tintBlue = (float)(tint & 0xFF) / 255.0f;
        this.lidPart.f_104203_ = -(lidAngle * 1.5707964f);
        this.lidPart.m_104306_(poseStack, consumer, packedLight, packedOverlay, tintRed, tingGreen, tintBlue, 1.0f);
        this.bottomPart.m_104306_(poseStack, consumer, packedLight, packedOverlay, tintRed, tingGreen, tintBlue, 1.0f);
    }

    private void renderLock(PoseStack poseStack, VertexConsumer consumer, float lidAngle, int packedLight, int packedOverlay) {
        this.lockPart.f_104203_ = -(lidAngle * 1.5707964f);
        this.lockPart.m_104301_(poseStack, consumer, packedLight, packedOverlay);
    }

    private Material getTierMaterial(Map<StorageTextureManager.ChestMaterial, Material> chestMaterials, Block block) {
        if (block == ModBlocks.IRON_CHEST.get()) {
            return chestMaterials.get((Object)StorageTextureManager.ChestMaterial.IRON_TIER);
        }
        if (block == ModBlocks.GOLD_CHEST.get()) {
            return chestMaterials.get((Object)StorageTextureManager.ChestMaterial.GOLD_TIER);
        }
        if (block == ModBlocks.DIAMOND_CHEST.get()) {
            return chestMaterials.get((Object)StorageTextureManager.ChestMaterial.DIAMOND_TIER);
        }
        if (block == ModBlocks.NETHERITE_CHEST.get()) {
            return chestMaterials.get((Object)StorageTextureManager.ChestMaterial.NETHERITE_TIER);
        }
        return chestMaterials.get((Object)StorageTextureManager.ChestMaterial.WOOD_TIER);
    }
}

