/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedstorage.client.render;

import java.util.ArrayList;
import java.util.function.BiFunction;
import net.minecraft.resources.ResourceLocation;
import net.p3pp3rf1y.sophisticatedstorage.SophisticatedStorage;
import net.p3pp3rf1y.sophisticatedstorage.block.BarrelType;
import net.p3pp3rf1y.sophisticatedstorage.block.StorageTier;
import net.p3pp3rf1y.sophisticatedstorage.client.StorageTextureManager;

public enum BarrelModelPart {
    BASE(Constants.CUBE_BOTTOM_TOP, (barrelType, storageTier) -> {
        StorageTextureManager.BarrelMaterial[] barrelMaterialArray;
        switch (barrelType) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case REGULAR: {
                StorageTextureManager.BarrelMaterial[] barrelMaterialArray2 = new StorageTextureManager.BarrelMaterial[1];
                barrelMaterialArray = barrelMaterialArray2;
                barrelMaterialArray2[0] = StorageTextureManager.BarrelMaterial.BASE;
                break;
            }
            case LIMITED_1: {
                StorageTextureManager.BarrelMaterial[] barrelMaterialArray3 = new StorageTextureManager.BarrelMaterial[2];
                barrelMaterialArray3[0] = StorageTextureManager.BarrelMaterial.BASE;
                barrelMaterialArray = barrelMaterialArray3;
                barrelMaterialArray3[1] = StorageTextureManager.BarrelMaterial.BASE_1;
                break;
            }
            case LIMITED_2: {
                StorageTextureManager.BarrelMaterial[] barrelMaterialArray4 = new StorageTextureManager.BarrelMaterial[2];
                barrelMaterialArray4[0] = StorageTextureManager.BarrelMaterial.BASE;
                barrelMaterialArray = barrelMaterialArray4;
                barrelMaterialArray4[1] = StorageTextureManager.BarrelMaterial.BASE_2;
                break;
            }
            case LIMITED_3: {
                StorageTextureManager.BarrelMaterial[] barrelMaterialArray5 = new StorageTextureManager.BarrelMaterial[2];
                barrelMaterialArray5[0] = StorageTextureManager.BarrelMaterial.BASE;
                barrelMaterialArray = barrelMaterialArray5;
                barrelMaterialArray5[1] = StorageTextureManager.BarrelMaterial.BASE_3;
                break;
            }
            case LIMITED_4: {
                StorageTextureManager.BarrelMaterial[] barrelMaterialArray6 = new StorageTextureManager.BarrelMaterial[2];
                barrelMaterialArray6[0] = StorageTextureManager.BarrelMaterial.BASE;
                barrelMaterialArray = barrelMaterialArray6;
                barrelMaterialArray6[1] = StorageTextureManager.BarrelMaterial.BASE_4;
            }
        }
        return barrelMaterialArray;
    }),
    BASE_OPEN(Constants.CUBE_BOTTOM_TOP, false, StorageTextureManager.BarrelMaterial.BASE, StorageTextureManager.BarrelMaterial.BASE_OPEN),
    METAL_BANDS(SophisticatedStorage.getRL("block/barrel_metal_bands"), StorageTextureManager.BarrelMaterial.METAL_BANDS),
    ACCENT(SophisticatedStorage.getRL("block/barrel_tintable_accent"), (barrelType, storageTier) -> {
        StorageTextureManager.BarrelMaterial[] barrelMaterialArray;
        switch (barrelType) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case REGULAR: {
                StorageTextureManager.BarrelMaterial[] barrelMaterialArray2 = new StorageTextureManager.BarrelMaterial[1];
                barrelMaterialArray = barrelMaterialArray2;
                barrelMaterialArray2[0] = StorageTextureManager.BarrelMaterial.TINTABLE_ACCENT;
                break;
            }
            case LIMITED_1: {
                StorageTextureManager.BarrelMaterial[] barrelMaterialArray3 = new StorageTextureManager.BarrelMaterial[2];
                barrelMaterialArray3[0] = StorageTextureManager.BarrelMaterial.TINTABLE_ACCENT;
                barrelMaterialArray = barrelMaterialArray3;
                barrelMaterialArray3[1] = StorageTextureManager.BarrelMaterial.TINTABLE_ACCENT_1;
                break;
            }
            case LIMITED_2: {
                StorageTextureManager.BarrelMaterial[] barrelMaterialArray4 = new StorageTextureManager.BarrelMaterial[2];
                barrelMaterialArray4[0] = StorageTextureManager.BarrelMaterial.TINTABLE_ACCENT;
                barrelMaterialArray = barrelMaterialArray4;
                barrelMaterialArray4[1] = StorageTextureManager.BarrelMaterial.TINTABLE_ACCENT_2;
                break;
            }
            case LIMITED_3: {
                StorageTextureManager.BarrelMaterial[] barrelMaterialArray5 = new StorageTextureManager.BarrelMaterial[2];
                barrelMaterialArray5[0] = StorageTextureManager.BarrelMaterial.TINTABLE_ACCENT;
                barrelMaterialArray = barrelMaterialArray5;
                barrelMaterialArray5[1] = StorageTextureManager.BarrelMaterial.TINTABLE_ACCENT_3;
                break;
            }
            case LIMITED_4: {
                StorageTextureManager.BarrelMaterial[] barrelMaterialArray6 = new StorageTextureManager.BarrelMaterial[2];
                barrelMaterialArray6[0] = StorageTextureManager.BarrelMaterial.TINTABLE_ACCENT;
                barrelMaterialArray = barrelMaterialArray6;
                barrelMaterialArray6[1] = StorageTextureManager.BarrelMaterial.TINTABLE_ACCENT_4;
            }
        }
        return barrelMaterialArray;
    }),
    MAIN(SophisticatedStorage.getRL("block/barrel_tintable_main"), false, StorageTextureManager.BarrelMaterial.TINTABLE_MAIN),
    LIMITED_MAIN(SophisticatedStorage.getRL("block/limited_barrel_tintable_main"), false, true, (barrelType, storageTier) -> {
        StorageTextureManager.BarrelMaterial[] barrelMaterialArray;
        switch (barrelType) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case REGULAR: {
                StorageTextureManager.BarrelMaterial[] barrelMaterialArray2 = new StorageTextureManager.BarrelMaterial[1];
                barrelMaterialArray = barrelMaterialArray2;
                barrelMaterialArray2[0] = StorageTextureManager.BarrelMaterial.TINTABLE_MAIN;
                break;
            }
            case LIMITED_1: {
                StorageTextureManager.BarrelMaterial[] barrelMaterialArray3 = new StorageTextureManager.BarrelMaterial[2];
                barrelMaterialArray3[0] = StorageTextureManager.BarrelMaterial.TINTABLE_MAIN;
                barrelMaterialArray = barrelMaterialArray3;
                barrelMaterialArray3[1] = StorageTextureManager.BarrelMaterial.TINTABLE_MAIN_1;
                break;
            }
            case LIMITED_2: {
                StorageTextureManager.BarrelMaterial[] barrelMaterialArray4 = new StorageTextureManager.BarrelMaterial[2];
                barrelMaterialArray4[0] = StorageTextureManager.BarrelMaterial.TINTABLE_MAIN;
                barrelMaterialArray = barrelMaterialArray4;
                barrelMaterialArray4[1] = StorageTextureManager.BarrelMaterial.TINTABLE_MAIN_2;
                break;
            }
            case LIMITED_3: {
                StorageTextureManager.BarrelMaterial[] barrelMaterialArray5 = new StorageTextureManager.BarrelMaterial[2];
                barrelMaterialArray5[0] = StorageTextureManager.BarrelMaterial.TINTABLE_MAIN;
                barrelMaterialArray = barrelMaterialArray5;
                barrelMaterialArray5[1] = StorageTextureManager.BarrelMaterial.TINTABLE_MAIN_3;
                break;
            }
            case LIMITED_4: {
                StorageTextureManager.BarrelMaterial[] barrelMaterialArray6 = new StorageTextureManager.BarrelMaterial[2];
                barrelMaterialArray6[0] = StorageTextureManager.BarrelMaterial.TINTABLE_MAIN;
                barrelMaterialArray = barrelMaterialArray6;
                barrelMaterialArray6[1] = StorageTextureManager.BarrelMaterial.TINTABLE_MAIN_4;
            }
        }
        return barrelMaterialArray;
    }),
    MAIN_OPEN(SophisticatedStorage.getRL("block/barrel_tintable_main_open"), false, StorageTextureManager.BarrelMaterial.TINTABLE_MAIN, StorageTextureManager.BarrelMaterial.TINTABLE_MAIN_OPEN),
    TIER(Constants.CUBE_BOTTOM_TOP, (barrelType, storageTier) -> {
        StorageTextureManager.BarrelMaterial[] barrelMaterialArray;
        switch (storageTier) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case WOOD: {
                StorageTextureManager.BarrelMaterial[] barrelMaterialArray2 = new StorageTextureManager.BarrelMaterial[1];
                barrelMaterialArray = barrelMaterialArray2;
                barrelMaterialArray2[0] = StorageTextureManager.BarrelMaterial.WOOD_TIER;
                break;
            }
            case IRON: {
                StorageTextureManager.BarrelMaterial[] barrelMaterialArray3 = new StorageTextureManager.BarrelMaterial[1];
                barrelMaterialArray = barrelMaterialArray3;
                barrelMaterialArray3[0] = StorageTextureManager.BarrelMaterial.IRON_TIER;
                break;
            }
            case GOLD: {
                StorageTextureManager.BarrelMaterial[] barrelMaterialArray4 = new StorageTextureManager.BarrelMaterial[1];
                barrelMaterialArray = barrelMaterialArray4;
                barrelMaterialArray4[0] = StorageTextureManager.BarrelMaterial.GOLD_TIER;
                break;
            }
            case DIAMOND: {
                StorageTextureManager.BarrelMaterial[] barrelMaterialArray5 = new StorageTextureManager.BarrelMaterial[1];
                barrelMaterialArray = barrelMaterialArray5;
                barrelMaterialArray5[0] = StorageTextureManager.BarrelMaterial.DIAMOND_TIER;
                break;
            }
            case NETHERITE: {
                StorageTextureManager.BarrelMaterial[] barrelMaterialArray6 = new StorageTextureManager.BarrelMaterial[1];
                barrelMaterialArray = barrelMaterialArray6;
                barrelMaterialArray6[0] = StorageTextureManager.BarrelMaterial.NETHERITE_TIER;
            }
        }
        return barrelMaterialArray;
    }),
    PACKED(Constants.CUBE_BOTTOM_TOP, StorageTextureManager.BarrelMaterial.PACKED),
    LOCK(SophisticatedStorage.getRL("block/barrel_lock"), StorageTextureManager.BarrelMaterial.LOCK);

    public final ResourceLocation modelName;
    private final boolean regularBarrelPart;
    private final boolean limitedBarrelPart;
    private final BiFunction<BarrelType, StorageTier, StorageTextureManager.BarrelMaterial[]> getBarrelMaterials;
    private static final BarrelModelPart[] REGULAR_BARREL_PARTS;
    private static final BarrelModelPart[] LIMITED_BARREL_PARTS;

    private BarrelModelPart(ResourceLocation modelName, StorageTextureManager.BarrelMaterial ... barrelMaterials) {
        this(modelName, true, barrelMaterials);
    }

    private BarrelModelPart(ResourceLocation modelName, boolean limitedBarrelPart, StorageTextureManager.BarrelMaterial ... barrelMaterials) {
        this(modelName, true, limitedBarrelPart, (BarrelType bt, StorageTier st) -> barrelMaterials);
    }

    private BarrelModelPart(ResourceLocation modelName, BiFunction<BarrelType, StorageTier, StorageTextureManager.BarrelMaterial[]> getBarrelMaterials) {
        this(modelName, true, true, getBarrelMaterials);
    }

    private BarrelModelPart(ResourceLocation modelName, boolean regularBarrelPart, boolean limitedBarrelPart, BiFunction<BarrelType, StorageTier, StorageTextureManager.BarrelMaterial[]> getBarrelMaterials) {
        this.modelName = modelName;
        this.regularBarrelPart = regularBarrelPart;
        this.limitedBarrelPart = limitedBarrelPart;
        this.getBarrelMaterials = getBarrelMaterials;
    }

    public StorageTextureManager.BarrelMaterial[] getBarrelMaterials(BarrelType barrelType, StorageTier tier) {
        return this.getBarrelMaterials.apply(barrelType, tier);
    }

    public static BarrelModelPart[] getRegularBarrelParts() {
        return REGULAR_BARREL_PARTS;
    }

    public static BarrelModelPart[] getLimitedBarrelParts() {
        return LIMITED_BARREL_PARTS;
    }

    static {
        ArrayList<BarrelModelPart> regularBarrelParts = new ArrayList<BarrelModelPart>();
        ArrayList<BarrelModelPart> limitedBarrelParts = new ArrayList<BarrelModelPart>();
        for (BarrelModelPart part : BarrelModelPart.values()) {
            if (part.limitedBarrelPart) {
                limitedBarrelParts.add(part);
            }
            if (!part.regularBarrelPart) continue;
            regularBarrelParts.add(part);
        }
        REGULAR_BARREL_PARTS = regularBarrelParts.toArray(new BarrelModelPart[0]);
        LIMITED_BARREL_PARTS = limitedBarrelParts.toArray(new BarrelModelPart[0]);
    }

    private static class Constants {
        private static final ResourceLocation CUBE_BOTTOM_TOP = new ResourceLocation("minecraft:block/cube_bottom_top");
        private static final String BLOCK_BARREL_TINTABLE_ACCENT = "block/barrel_tintable_accent";
        private static final String BLOCK_BARREL_TINTABLE_MAIN = "block/barrel_tintable_main";
        private static final String BLOCK_LIMITED_BARREL_TINTABLE_MAIN = "block/limited_barrel_tintable_main";
        private static final String BLOCK_BARREL_LOCK = "block/barrel_lock";

        private Constants() {
        }
    }
}

