/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedstorage.client.render;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import com.mojang.math.Transformation;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.state.properties.WoodType;
import net.minecraftforge.client.model.geometry.IGeometryBakingContext;
import net.minecraftforge.client.model.geometry.IUnbakedGeometry;
import net.p3pp3rf1y.sophisticatedstorage.client.StorageTextureManager;
import net.p3pp3rf1y.sophisticatedstorage.client.render.BarrelBakedModelBase;
import net.p3pp3rf1y.sophisticatedstorage.client.render.BarrelModelPart;

public abstract class BarrelDynamicModelBase<T extends BarrelDynamicModelBase<T>>
implements IUnbakedGeometry<T> {
    public static final Map<MaterialKey, Material> TEXTURES = new HashMap<MaterialKey, Material>();
    public static final Map<Integer, BakedModel> BAKED_PART_MODELS = new HashMap<Integer, BakedModel>();
    protected final Map<String, Map<BarrelModelPart, UnbakedModel>> woodModels;

    public static Collection<Material> getTextures() {
        return TEXTURES.values();
    }

    protected BarrelDynamicModelBase(Map<String, Map<BarrelModelPart, UnbakedModel>> woodModels) {
        this.woodModels = woodModels;
    }

    public BakedModel bake(IGeometryBakingContext context, ModelBakery bakery, Function<Material, TextureAtlasSprite> spriteGetter, ModelState modelTransform, ItemOverrides overrides, ResourceLocation modelLocation) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        this.woodModels.forEach((woodName, partModels) -> {
            ImmutableMap.Builder partBuilder = ImmutableMap.builder();
            partModels.forEach((part, model) -> {
                int hash = this.getBakedModelHash((UnbakedModel)model, bakery, modelTransform);
                BakedModel bakedModel = BAKED_PART_MODELS.computeIfAbsent(hash, h -> model.m_7611_(bakery, spriteGetter, modelTransform, modelLocation));
                if (bakedModel != null) {
                    partBuilder.put((Object)part, (Object)bakedModel);
                }
            });
            builder.put(woodName, (Object)partBuilder.build());
        });
        ImmutableMap woodModelParts = builder.build();
        return this.instantiateBakedModel((ImmutableMap<String, Map<BarrelModelPart, BakedModel>>)woodModelParts);
    }

    private int getBakedModelHash(UnbakedModel model, ModelBakery bakery, ModelState modelTransform) {
        int hash = 0;
        for (Object dependency : model.m_7970_()) {
            hash = 31 * hash + dependency.hashCode();
        }
        HashSet missingTextures = new HashSet();
        for (Material material : model.m_5500_(arg_0 -> ((ModelBakery)bakery).m_119341_(arg_0), missingTextures)) {
            hash = 31 * hash + material.m_119203_().hashCode();
        }
        for (Pair missingTexture : missingTextures) {
            hash = 31 * hash + ((String)missingTexture.getFirst()).hashCode();
        }
        hash = 31 * hash + Boolean.valueOf(modelTransform.m_7538_()).hashCode();
        Transformation rotation = modelTransform.m_6189_();
        hash = 31 * hash + rotation.m_121104_().hashCode();
        hash = 31 * hash + rotation.m_175940_().hashCode();
        hash = 31 * hash + rotation.m_121105_().hashCode();
        hash = 31 * hash + rotation.m_121105_().m_175217_().hashCode();
        hash = 31 * hash + rotation.m_175941_().hashCode();
        return hash;
    }

    protected abstract BarrelBakedModelBase instantiateBakedModel(ImmutableMap<String, Map<BarrelModelPart, BakedModel>> var1);

    public Collection<Material> getMaterials(IGeometryBakingContext context, Function<ResourceLocation, UnbakedModel> modelGetter, Set<Pair<String, String>> missingTextureErrors) {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        this.woodModels.forEach((woodName, partModels) -> partModels.forEach((part, model) -> builder.addAll((Iterable)model.m_5500_(modelGetter, missingTextureErrors))));
        return builder.build();
    }

    protected static void putMaterial(Map<String, Either<Material, String>> materials, IBarrelMaterialGetter barrelMaterialGetter, WoodType woodType, StorageTextureManager.BarrelFace barrelFace, StorageTextureManager.BarrelMaterial barrelMaterial) {
        BarrelDynamicModelBase.putMaterial(materials, barrelMaterialGetter, woodType, barrelFace, barrelMaterial, barrelFace.name().toLowerCase(Locale.ROOT));
    }

    protected static void putMaterial(Map<String, Either<Material, String>> materials, IBarrelMaterialGetter barrelMaterialGetter, WoodType woodType, StorageTextureManager.BarrelFace barrelFace, StorageTextureManager.BarrelMaterial barrelMaterial, String textureName) {
        MaterialKey key = new MaterialKey(woodType, barrelFace, barrelMaterial);
        if (!TEXTURES.containsKey(key)) {
            Optional<Material> mat = barrelMaterialGetter.get(woodType, barrelFace, barrelMaterial);
            if (mat.isEmpty()) {
                return;
            }
            TEXTURES.put(key, mat.get());
        }
        Material material = TEXTURES.get(key);
        materials.put(textureName, (Either<Material, String>)Either.left((Object)material));
    }

    public static interface IBarrelMaterialGetter {
        public Optional<Material> get(WoodType var1, StorageTextureManager.BarrelFace var2, StorageTextureManager.BarrelMaterial var3);
    }

    private record MaterialKey(WoodType woodType, StorageTextureManager.BarrelFace barrelFace, StorageTextureManager.BarrelMaterial barrelMaterial) {
        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MaterialKey that = (MaterialKey)o;
            return this.woodType.equals(that.woodType) && this.barrelFace == that.barrelFace && this.barrelMaterial == that.barrelMaterial;
        }

        @Override
        public int hashCode() {
            return Objects.hash(new Object[]{this.woodType, this.barrelFace, this.barrelMaterial});
        }
    }
}

