/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedstorage.client.render;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableMap;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Quaternion;
import com.mojang.math.Transformation;
import com.mojang.math.Vector3f;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.FaceBakery;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.block.model.ItemTransform;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.WoodType;
import net.minecraftforge.client.ChunkRenderTypeSet;
import net.minecraftforge.client.model.IDynamicBakedModel;
import net.minecraftforge.client.model.IQuadTransformer;
import net.minecraftforge.client.model.QuadTransformers;
import net.minecraftforge.client.model.data.ModelData;
import net.minecraftforge.client.model.data.ModelProperty;
import net.p3pp3rf1y.sophisticatedcore.inventory.ItemStackKey;
import net.p3pp3rf1y.sophisticatedcore.renderdata.RenderInfo;
import net.p3pp3rf1y.sophisticatedcore.util.WorldHelper;
import net.p3pp3rf1y.sophisticatedstorage.block.BarrelBlock;
import net.p3pp3rf1y.sophisticatedstorage.block.BarrelBlockEntity;
import net.p3pp3rf1y.sophisticatedstorage.client.render.BarrelModelPart;
import net.p3pp3rf1y.sophisticatedstorage.client.render.DisplayItemRenderer;
import net.p3pp3rf1y.sophisticatedstorage.item.StorageBlockItem;
import net.p3pp3rf1y.sophisticatedstorage.item.WoodStorageBlockItem;

public abstract class BarrelBakedModelBase
implements IDynamicBakedModel {
    private static final IQuadTransformer MOVE_TO_CORNER = QuadTransformers.applying((Transformation)new Transformation(new Vector3f(-0.5f, -0.5f, -0.5f), null, null, null));
    public static final Map<Direction, IQuadTransformer> DIRECTION_ROTATES = Map.of(Direction.UP, BarrelBakedModelBase.getDirectionRotationTransform(Direction.UP), Direction.DOWN, BarrelBakedModelBase.getDirectionRotationTransform(Direction.DOWN), Direction.NORTH, BarrelBakedModelBase.getDirectionRotationTransform(Direction.NORTH), Direction.SOUTH, BarrelBakedModelBase.getDirectionRotationTransform(Direction.SOUTH), Direction.WEST, BarrelBakedModelBase.getDirectionRotationTransform(Direction.WEST), Direction.EAST, BarrelBakedModelBase.getDirectionRotationTransform(Direction.EAST));
    private static final LoadingCache<Direction, Cache<Integer, IQuadTransformer>> DIRECTION_MOVES_3D_ITEMS = CacheBuilder.newBuilder().expireAfterAccess(10L, TimeUnit.MINUTES).build((CacheLoader)new CacheLoader<Direction, Cache<Integer, IQuadTransformer>>(){

        public Cache<Integer, IQuadTransformer> load(Direction key) {
            return CacheBuilder.newBuilder().expireAfterAccess(10L, TimeUnit.MINUTES).build();
        }
    });
    private static final IQuadTransformer SCALE_BIG_2D_ITEM = QuadTransformers.applying((Transformation)new Transformation(null, null, new Vector3f(0.5f, 0.5f, 0.5f), null));
    private static final IQuadTransformer SCALE_SMALL_3D_ITEM = QuadTransformers.applying((Transformation)new Transformation(null, null, new Vector3f(0.5f, 0.5f, 0.5f), null));
    private static final IQuadTransformer SCALE_SMALL_2D_ITEM = QuadTransformers.applying((Transformation)new Transformation(null, null, new Vector3f(0.25f, 0.25f, 0.25f), null));
    private static final Cache<Integer, IQuadTransformer> DIRECTION_MOVE_BACK_TO_SIDE = CacheBuilder.newBuilder().expireAfterAccess(10L, TimeUnit.MINUTES).build();
    private static final ModelProperty<String> WOOD_NAME = new ModelProperty();
    private static final ModelProperty<Boolean> IS_PACKED = new ModelProperty();
    private static final ModelProperty<Boolean> SHOWS_LOCK = new ModelProperty();
    private static final ModelProperty<Boolean> HAS_MAIN_COLOR = new ModelProperty();
    private static final ModelProperty<Boolean> HAS_ACCENT_COLOR = new ModelProperty();
    private static final ModelProperty<List<RenderInfo.DisplayItem>> DISPLAY_ITEMS = new ModelProperty();
    public static final Cache<Integer, List<BakedQuad>> BAKED_QUADS_CACHE = CacheBuilder.newBuilder().expireAfterAccess(15L, TimeUnit.MINUTES).build();
    private static final Map<Integer, IQuadTransformer> DISPLAY_ROTATIONS = new HashMap<Integer, IQuadTransformer>();
    private static final Vector3f DEFAULT_ROTATION = new Vector3f(0.0f, 0.0f, 0.0f);
    private static final ItemTransforms ITEM_TRANSFORMS = BarrelBakedModelBase.createItemTransforms();
    protected final Map<String, Map<BarrelModelPart, BakedModel>> woodModelParts;
    private final ItemOverrides barrelItemOverrides = new BarrelItemOverrides(this);
    private Item barrelItem = Items.f_41852_;
    @Nullable
    private String barrelWoodName = null;
    private boolean barrelHasMainColor = false;
    private boolean barrelHasAccentColor = false;
    private boolean barrelIsPacked = false;

    private static ItemTransforms createItemTransforms() {
        return new ItemTransforms(new ItemTransform(new Vector3f(75.0f, 45.0f, 0.0f), new Vector3f(0.0f, 0.15625f, 0.0f), new Vector3f(0.375f, 0.375f, 0.375f), DEFAULT_ROTATION), new ItemTransform(new Vector3f(75.0f, 45.0f, 0.0f), new Vector3f(0.0f, 0.15625f, 0.0f), new Vector3f(0.375f, 0.375f, 0.375f), DEFAULT_ROTATION), new ItemTransform(new Vector3f(0.0f, 225.0f, 0.0f), new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(0.4f, 0.4f, 0.4f), DEFAULT_ROTATION), new ItemTransform(new Vector3f(0.0f, 45.0f, 0.0f), new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(0.4f, 0.4f, 0.4f), DEFAULT_ROTATION), new ItemTransform(new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(0.0f, 0.890625f, 0.0f), new Vector3f(1.0f, 1.0f, 1.0f), DEFAULT_ROTATION), new ItemTransform(new Vector3f(30.0f, 225.0f, 0.0f), new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(0.625f, 0.625f, 0.625f), DEFAULT_ROTATION), new ItemTransform(new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(0.0f, 0.1875f, 0.0f), new Vector3f(0.25f, 0.25f, 0.25f), DEFAULT_ROTATION), new ItemTransform(new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(0.5f, 0.5f, 0.5f), DEFAULT_ROTATION), ImmutableMap.of());
    }

    protected BarrelBakedModelBase(Map<String, Map<BarrelModelPart, BakedModel>> woodModelParts) {
        this.woodModelParts = woodModelParts;
    }

    private static IQuadTransformer getDirectionRotationTransform(Direction dir) {
        return QuadTransformers.applying((Transformation)new Transformation(null, DisplayItemRenderer.getNorthBasedRotation(dir), null, null));
    }

    private IQuadTransformer getDirectionMoveBackToSide(BlockState state, Direction dir, float distFromCenter, int displayItemIndex, int displayItemCount) {
        int hash = this.calculateMoveBackToSideHash(state, dir, distFromCenter, displayItemIndex, displayItemCount);
        IQuadTransformer transform = (IQuadTransformer)DIRECTION_MOVE_BACK_TO_SIDE.getIfPresent((Object)hash);
        if (transform == null) {
            Vec3i normal = dir.m_122436_();
            Vector3f offset = new Vector3f(distFromCenter, distFromCenter, distFromCenter);
            offset.m_122263_((float)normal.m_123341_(), (float)normal.m_123342_(), (float)normal.m_123343_());
            Vector3f frontOffset = DisplayItemRenderer.getDisplayItemIndexFrontOffset(displayItemIndex, displayItemCount);
            frontOffset.m_122272_(-0.5f, -0.5f, -0.5f);
            this.rotateDisplayItemFrontOffset(state, dir, frontOffset);
            frontOffset.m_122272_(0.5f, 0.5f, 0.5f);
            offset.m_122253_(frontOffset);
            transform = QuadTransformers.applying((Transformation)new Transformation(offset, null, null, null));
            DIRECTION_MOVE_BACK_TO_SIDE.put((Object)hash, (Object)transform);
        }
        return transform;
    }

    protected void rotateDisplayItemFrontOffset(BlockState state, Direction dir, Vector3f frontOffset) {
        frontOffset.m_122251_(DisplayItemRenderer.getNorthBasedRotation(dir));
    }

    protected int calculateMoveBackToSideHash(BlockState state, Direction dir, float distFromCenter, int displayItemIndex, int displayItemCount) {
        int hash = Float.hashCode(distFromCenter);
        hash = 31 * hash + displayItemIndex;
        hash = 31 * hash + displayItemCount;
        return hash;
    }

    public ChunkRenderTypeSet getRenderTypes(BlockState state, RandomSource rand, ModelData data) {
        return ChunkRenderTypeSet.of((RenderType[])new RenderType[]{RenderType.m_110463_()});
    }

    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, RandomSource rand, ModelData extraData, @Nullable RenderType renderType) {
        boolean isPacked;
        boolean hasAccentColor;
        boolean hasMainColor;
        int hash = this.createHash(state, side, extraData);
        List quads = (List)BAKED_QUADS_CACHE.getIfPresent((Object)hash);
        if (quads != null) {
            return quads;
        }
        String woodName = null;
        if (state != null) {
            hasMainColor = Boolean.TRUE.equals(extraData.get(HAS_MAIN_COLOR));
            hasAccentColor = Boolean.TRUE.equals(extraData.get(HAS_ACCENT_COLOR));
            if (extraData.has(WOOD_NAME)) {
                woodName = (String)extraData.get(WOOD_NAME);
            }
            isPacked = this.isPacked(extraData);
        } else {
            woodName = this.barrelWoodName;
            hasMainColor = this.barrelHasMainColor;
            hasAccentColor = this.barrelHasAccentColor;
            isPacked = this.barrelIsPacked;
        }
        ArrayList<BakedQuad> ret = new ArrayList<BakedQuad>();
        Map<BarrelModelPart, BakedModel> modelParts = this.getWoodModelParts(woodName);
        if (modelParts.isEmpty()) {
            return Collections.emptyList();
        }
        if (!hasMainColor || !hasAccentColor) {
            this.addPartQuads(state, side, rand, ret, modelParts, this.getBasePart(state), renderType);
        }
        this.addTintableModelQuads(state, side, rand, ret, hasMainColor, hasAccentColor, modelParts, renderType);
        this.addTierQuads(state, side, rand, ret, modelParts, renderType);
        if (isPacked) {
            this.addPartQuads(state, side, rand, ret, modelParts, BarrelModelPart.PACKED, renderType);
        } else {
            if (this.showsLocked(extraData)) {
                this.addPartQuads(state, side, rand, ret, modelParts, BarrelModelPart.LOCK, renderType);
            }
            this.addDisplayItemQuads(state, side, rand, ret, extraData);
        }
        BAKED_QUADS_CACHE.put((Object)hash, ret);
        return ret;
    }

    protected abstract BarrelModelPart getBasePart(@Nullable BlockState var1);

    private boolean isPacked(ModelData extraData) {
        return extraData.has(IS_PACKED) && Boolean.TRUE.equals(extraData.get(IS_PACKED));
    }

    private boolean showsLocked(ModelData extraData) {
        return extraData.has(SHOWS_LOCK) && Boolean.TRUE.equals(extraData.get(SHOWS_LOCK));
    }

    private void addTierQuads(@Nullable BlockState state, @Nullable Direction side, RandomSource rand, List<BakedQuad> ret, Map<BarrelModelPart, BakedModel> modelParts, @Nullable RenderType renderType) {
        this.addPartQuads(state, side, rand, ret, modelParts, BarrelModelPart.TIER, renderType);
    }

    private int createHash(@Nullable BlockState state, @Nullable Direction side, ModelData data) {
        int hash = state != null ? this.getInWorldBlockHash(state, data) : this.getItemBlockHash();
        hash = hash * 31 + (side == null ? 0 : side.m_122411_() + 1);
        hash = this.getDisplayItemsHash(data, hash);
        return hash;
    }

    private int getItemBlockHash() {
        int hash = this.barrelItem.hashCode();
        hash = hash * 31 + (this.barrelWoodName != null ? this.barrelWoodName.hashCode() + 1 : 0);
        hash = hash * 31 + (this.barrelHasMainColor ? 1 : 0);
        hash = hash * 31 + (this.barrelHasAccentColor ? 1 : 0);
        hash = hash * 31 + (this.barrelIsPacked ? 1 : 0);
        return hash;
    }

    protected int getInWorldBlockHash(BlockState state, ModelData data) {
        int hash = state.m_60734_().hashCode();
        hash = hash * 31 + (data.has(WOOD_NAME) ? ((String)data.get(WOOD_NAME)).hashCode() + 1 : 0);
        hash = hash * 31 + (data.has(HAS_MAIN_COLOR) && Boolean.TRUE.equals(data.get(HAS_MAIN_COLOR)) ? 1 : 0);
        hash = hash * 31 + (data.has(HAS_ACCENT_COLOR) && Boolean.TRUE.equals(data.get(HAS_ACCENT_COLOR)) ? 1 : 0);
        hash = hash * 31 + (this.isPacked(data) ? 1 : 0);
        hash = hash * 31 + (this.showsLocked(data) ? 1 : 0);
        return hash;
    }

    private int getDisplayItemsHash(ModelData data, int hash) {
        if (data.has(DISPLAY_ITEMS)) {
            List displayItems = (List)data.get(DISPLAY_ITEMS);
            for (RenderInfo.DisplayItem displayItem : displayItems) {
                hash = hash * 31 + this.getDisplayItemHash(displayItem);
            }
        }
        return hash;
    }

    private int getDisplayItemHash(RenderInfo.DisplayItem displayItem) {
        int hash = displayItem.getRotation();
        hash = hash * 31 + ItemStackKey.getHashCode((ItemStack)displayItem.getItem());
        hash = hash * 31 + displayItem.getSlotIndex();
        return hash;
    }

    private void addDisplayItemQuads(@Nullable BlockState state, @Nullable Direction side, RandomSource rand, List<BakedQuad> ret, ModelData data) {
        Block block;
        if (state == null || side != null || !((block = state.m_60734_()) instanceof BarrelBlock)) {
            return;
        }
        BarrelBlock barrelBlock = (BarrelBlock)block;
        List displayItems = (List)data.get(DISPLAY_ITEMS);
        if (displayItems != null && !displayItems.isEmpty()) {
            Minecraft minecraft = Minecraft.m_91087_();
            ItemRenderer itemRenderer = minecraft.m_91291_();
            int index = 0;
            for (RenderInfo.DisplayItem displayItem : displayItems) {
                ItemStack item = displayItem.getItem();
                if (barrelBlock.hasFixedIndexDisplayItems()) {
                    index = displayItem.getSlotIndex();
                }
                if (item.m_41619_()) continue;
                BakedModel model = itemRenderer.m_174264_(item, null, (LivingEntity)minecraft.f_91074_, 0);
                if (!model.m_7521_()) {
                    int rotation = displayItem.getRotation();
                    for (Direction face : Direction.values()) {
                        this.addRenderedItemSide(state, rand, ret, item, model, rotation, face, index, barrelBlock.getDisplayItemsCount(displayItems));
                    }
                    this.addRenderedItemSide(state, rand, ret, item, model, rotation, null, index, barrelBlock.getDisplayItemsCount(displayItems));
                }
                ++index;
            }
        }
    }

    private void addRenderedItemSide(BlockState state, RandomSource rand, List<BakedQuad> ret, ItemStack displayItem, BakedModel model, int rotation, @Nullable Direction dir, int displayItemIndex, int displayItemCount) {
        Direction direction;
        Block block;
        List quads = model.m_213637_(null, dir, rand);
        quads = MOVE_TO_CORNER.process(quads);
        quads = QuadTransformers.applying((Transformation)this.toTransformation(model.m_7442_().m_111808_(ItemTransforms.TransformType.FIXED))).process(quads);
        if (!model.m_7539_()) {
            quads = displayItemCount == 1 ? SCALE_BIG_2D_ITEM.process(quads) : SCALE_SMALL_2D_ITEM.process(quads);
        } else if (displayItemCount > 1) {
            quads = SCALE_SMALL_3D_ITEM.process(quads);
        }
        if (rotation != 0) {
            quads = this.getDisplayRotation(rotation).process(quads);
        }
        if ((block = state.m_60734_()) instanceof BarrelBlock) {
            BarrelBlock barrelBlock = (BarrelBlock)block;
            direction = barrelBlock.getFacing(state);
        } else {
            direction = Direction.NORTH;
        }
        Direction facing = direction;
        quads = this.rotateDisplayItemQuads(quads, state);
        if (model.m_7539_()) {
            IQuadTransformer transformer = this.getDirectionMove(displayItem, model, state, facing, displayItemIndex, displayItemCount, displayItemCount == 1 ? 1.0f : 0.5f);
            quads = transformer.process(quads);
            this.recalculateDirections(quads);
        } else {
            quads = this.getDirectionMove(displayItem, model, state, facing, displayItemIndex, displayItemCount, 1.0f).process(quads);
            this.recalculateDirections(quads);
        }
        this.updateTintIndexes(quads, displayItemIndex);
        ret.addAll(quads);
    }

    private Transformation toTransformation(ItemTransform transform) {
        if (transform.equals((Object)ItemTransform.f_111754_)) {
            return Transformation.m_121093_();
        }
        return new Transformation(transform.f_111756_, this.quatFromXYZ(transform.f_111755_, true), transform.f_111757_, null);
    }

    public Quaternion quatFromXYZ(Vector3f xyz, boolean degrees) {
        return new Quaternion(xyz.m_122239_(), xyz.m_122260_(), xyz.m_122269_(), degrees);
    }

    protected abstract List<BakedQuad> rotateDisplayItemQuads(List<BakedQuad> var1, BlockState var2);

    private void updateTintIndexes(List<BakedQuad> quads, int displayItemIndex) {
        int offset = (displayItemIndex + 1) * 10;
        quads.forEach(quad -> {
            if (quad.f_111293_ >= 0) {
                quad.f_111293_ += offset;
            }
        });
    }

    private void recalculateDirections(List<BakedQuad> quads) {
        quads.forEach(quad -> {
            quad.f_111294_ = FaceBakery.m_111612_((int[])quad.m_111303_());
        });
    }

    private IQuadTransformer getDirectionMove(ItemStack displayItem, BakedModel model, BlockState state, Direction direction, int displayItemIndex, int displayItemCount, float itemScale) {
        int hash = this.calculateDirectionMoveHash(state, displayItem, displayItemIndex, displayItemCount);
        Cache directionCache = (Cache)DIRECTION_MOVES_3D_ITEMS.getUnchecked((Object)direction);
        IQuadTransformer transformer = (IQuadTransformer)directionCache.getIfPresent((Object)hash);
        if (transformer == null) {
            double offset = 0.0;
            if (model.m_7539_()) {
                offset = DisplayItemRenderer.getDisplayItemOffset(displayItem, model, itemScale);
            }
            transformer = this.getDirectionMoveBackToSide(state, direction, (float)(0.5 + offset), displayItemIndex, displayItemCount);
            directionCache.put((Object)hash, (Object)transformer);
        }
        return transformer;
    }

    protected int calculateDirectionMoveHash(BlockState state, ItemStack displayItem, int displayItemIndex, int displayItemCount) {
        int hashCode = ItemStackKey.getHashCode((ItemStack)displayItem);
        hashCode = hashCode * 31 + displayItemIndex;
        hashCode = hashCode * 31 + displayItemCount;
        return hashCode;
    }

    private IQuadTransformer getDisplayRotation(int rotation) {
        return DISPLAY_ROTATIONS.computeIfAbsent(rotation, r -> QuadTransformers.applying((Transformation)new Transformation(null, Vector3f.f_122227_.m_122240_((float)rotation), null, null)));
    }

    private void addTintableModelQuads(@Nullable BlockState state, @Nullable Direction side, RandomSource rand, List<BakedQuad> ret, boolean hasMainColor, boolean hasAccentColor, Map<BarrelModelPart, BakedModel> modelParts, @Nullable RenderType renderType) {
        if (hasMainColor) {
            this.addPartQuads(state, side, rand, ret, modelParts, this.getMainPart(state), renderType);
        }
        if (hasAccentColor) {
            this.addPartQuads(state, side, rand, ret, modelParts, BarrelModelPart.ACCENT, renderType);
        }
        if (hasMainColor || hasAccentColor) {
            this.addPartQuads(state, side, rand, ret, modelParts, BarrelModelPart.METAL_BANDS, renderType);
        }
    }

    protected abstract BarrelModelPart getMainPart(@Nullable BlockState var1);

    protected abstract BarrelModelPart getMainPart();

    private void addPartQuads(@Nullable BlockState state, @Nullable Direction side, RandomSource rand, List<BakedQuad> ret, Map<BarrelModelPart, BakedModel> modelParts, BarrelModelPart part, @Nullable RenderType renderType) {
        if (modelParts.containsKey((Object)part)) {
            ret.addAll(modelParts.get((Object)part).getQuads(state, side, rand, ModelData.EMPTY, renderType));
        }
    }

    private Map<BarrelModelPart, BakedModel> getWoodModelParts(@Nullable String barrelWoodName) {
        if (barrelWoodName == null || !this.woodModelParts.containsKey(barrelWoodName)) {
            return this.woodModelParts.values().iterator().next();
        }
        return this.woodModelParts.get(barrelWoodName);
    }

    public boolean m_7541_() {
        return false;
    }

    public boolean m_7539_() {
        return true;
    }

    public boolean m_7547_() {
        return true;
    }

    public boolean m_7521_() {
        return false;
    }

    public TextureAtlasSprite m_6160_() {
        return this.getWoodModelParts(null).get((Object)BarrelModelPart.BASE).m_6160_();
    }

    public ItemTransforms m_7442_() {
        return ITEM_TRANSFORMS;
    }

    public TextureAtlasSprite getParticleIcon(ModelData data) {
        if (data.has(HAS_MAIN_COLOR) && Boolean.TRUE.equals(data.get(HAS_MAIN_COLOR))) {
            return this.getWoodModelParts(null).get((Object)this.getMainPart()).getParticleIcon(data);
        }
        if (data.has(WOOD_NAME)) {
            String name = (String)data.get(WOOD_NAME);
            if (!this.woodModelParts.containsKey(name)) {
                return this.m_6160_();
            }
            return this.getWoodModelParts(name).get((Object)BarrelModelPart.BASE).getParticleIcon(data);
        }
        return this.m_6160_();
    }

    @Nonnull
    public ModelData getModelData(BlockAndTintGetter world, BlockPos pos, BlockState state, ModelData tileData) {
        return WorldHelper.getBlockEntity((BlockGetter)world, (BlockPos)pos, BarrelBlockEntity.class).map(be -> {
            ModelData.Builder builder = ModelData.builder();
            boolean hasMainColor = be.getStorageWrapper().hasMainColor();
            builder.with(HAS_MAIN_COLOR, (Object)hasMainColor);
            boolean hasAccentColor = be.getStorageWrapper().hasAccentColor();
            builder.with(HAS_ACCENT_COLOR, (Object)hasAccentColor);
            if (!be.hasFullyDynamicRenderer()) {
                builder.with(DISPLAY_ITEMS, (Object)be.getStorageWrapper().getRenderInfo().getItemDisplayRenderInfo().getDisplayItems());
            }
            builder.with(IS_PACKED, (Object)be.isPacked());
            builder.with(SHOWS_LOCK, (Object)(be.isLocked() && be.shouldShowLock() ? 1 : 0));
            Optional<WoodType> woodType = be.getWoodType();
            if (woodType.isPresent() || !hasMainColor || !hasAccentColor) {
                builder.with(WOOD_NAME, (Object)woodType.orElse(WoodType.f_61833_).m_61846_());
            }
            return builder.build();
        }).orElse(ModelData.EMPTY);
    }

    public ItemOverrides m_7343_() {
        return this.barrelItemOverrides;
    }

    public BakedModel applyTransform(ItemTransforms.TransformType transformType, PoseStack poseStack, boolean applyLeftHandTransform) {
        if (transformType == ItemTransforms.TransformType.NONE) {
            return this;
        }
        ITEM_TRANSFORMS.m_111808_(transformType).m_111763_(applyLeftHandTransform, poseStack);
        return this;
    }

    private static class BarrelItemOverrides
    extends ItemOverrides {
        private final BarrelBakedModelBase barrelBakedModel;

        public BarrelItemOverrides(BarrelBakedModelBase barrelBakedModel) {
            this.barrelBakedModel = barrelBakedModel;
        }

        @Nullable
        public BakedModel m_173464_(BakedModel model, ItemStack stack, @Nullable ClientLevel level, @Nullable LivingEntity entity, int seed) {
            this.barrelBakedModel.barrelHasMainColor = StorageBlockItem.getMainColorFromStack(stack).isPresent();
            this.barrelBakedModel.barrelHasAccentColor = StorageBlockItem.getAccentColorFromStack(stack).isPresent();
            this.barrelBakedModel.barrelWoodName = WoodStorageBlockItem.getWoodType(stack).map(WoodType::m_61846_).orElse((String)(this.barrelBakedModel.barrelHasAccentColor && this.barrelBakedModel.barrelHasMainColor ? null : WoodType.f_61833_.m_61846_()));
            this.barrelBakedModel.barrelIsPacked = WoodStorageBlockItem.isPacked(stack);
            this.barrelBakedModel.barrelItem = stack.m_41720_();
            return this.barrelBakedModel;
        }
    }
}

