/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedstorage.client;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Collection;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.resources.model.Material;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.level.block.state.properties.WoodType;
import net.p3pp3rf1y.sophisticatedstorage.client.render.BarrelBakedModelBase;
import net.p3pp3rf1y.sophisticatedstorage.client.render.BarrelDynamicModelBase;

public class StorageTextureManager
extends SimpleJsonResourceReloadListener {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    public static final StorageTextureManager INSTANCE = new StorageTextureManager();
    private static final String PARENT_TAG = "parent";
    private static final String TYPE_TAG = "type";
    private static final String TEXTURES_TAG = "textures";
    private static final WoodType defaultChestWoodType = WoodType.f_61833_;
    private static final String CHEST_SUFFIX = "_chest";
    private static final String BARREL_SUFFIX = "_barrel";
    private static final Pattern LIMITED_BARREL_PATTERN = Pattern.compile("limited_([a-z_]+)_barrel");
    private static final Map<String, Supplier<ITextureParser>> TEXTURE_PARSERS = new HashMap<String, Supplier<ITextureParser>>();
    private final Map<WoodType, Map<ChestMaterial, Material>> woodChestMaterials = new HashMap<WoodType, Map<ChestMaterial, Material>>();
    private final Map<WoodType, Map<BarrelFace, Map<BarrelMaterial, Material>>> barrelMaterials = new HashMap<WoodType, Map<BarrelFace, Map<BarrelMaterial, Material>>>();
    private final Map<WoodType, Map<BarrelFace, Map<BarrelMaterial, Material>>> limitedBarrelMaterials = new HashMap<WoodType, Map<BarrelFace, Map<BarrelMaterial, Material>>>();

    private StorageTextureManager() {
        super(GSON, "storage_texture_definitions");
    }

    protected Map<ResourceLocation, JsonElement> m_5944_(ResourceManager pResourceManager, ProfilerFiller pProfiler) {
        this.clear();
        BarrelBakedModelBase.BAKED_QUADS_CACHE.invalidateAll();
        BarrelDynamicModelBase.TEXTURES.clear();
        BarrelDynamicModelBase.BAKED_PART_MODELS.clear();
        Map fileContents = super.m_5944_(pResourceManager, pProfiler);
        HashMap<ResourceLocation, StorageTextureDefinition> storageTextureDefinitions = new HashMap<ResourceLocation, StorageTextureDefinition>();
        fileContents.forEach((resourceLocation, json) -> this.loadDefinition((Map<ResourceLocation, StorageTextureDefinition>)storageTextureDefinitions, (ResourceLocation)resourceLocation, (JsonElement)json, fileContents));
        storageTextureDefinitions.forEach((fileName, definition) -> {
            Matcher matcher;
            String type = definition.getType();
            String filePath = fileName.m_135815_();
            if (type.equals("chest")) {
                if (filePath.endsWith(CHEST_SUFFIX)) {
                    WoodType.m_61843_().filter(wt -> wt.m_61846_().equals(filePath.substring(0, filePath.lastIndexOf(CHEST_SUFFIX)))).findFirst().ifPresent(wt -> {
                        EnumMap chestMaterials = new EnumMap(ChestMaterial.class);
                        definition.getTextures().forEach((textureName, rl) -> ChestMaterial.fromString(textureName).ifPresent(cm -> chestMaterials.put((ChestMaterial)((Object)((Object)((Object)cm))), new Material(Sheets.f_110740_, rl))));
                        this.woodChestMaterials.put((WoodType)wt, chestMaterials);
                    });
                }
            } else if (type.equals("barrel") && filePath.endsWith(BARREL_SUFFIX)) {
                this.parseBarrelTextures((StorageTextureDefinition)definition, filePath, this.barrelMaterials, fn -> fn.substring(0, fn.lastIndexOf(BARREL_SUFFIX)));
            } else if (type.equals("limited_barrel") && (matcher = LIMITED_BARREL_PATTERN.matcher(filePath)).find()) {
                this.parseBarrelTextures((StorageTextureDefinition)definition, filePath, this.limitedBarrelMaterials, fn -> matcher.group(1));
            }
        });
        return fileContents;
    }

    private void parseBarrelTextures(StorageTextureDefinition definition, String filePath, Map<WoodType, Map<BarrelFace, Map<BarrelMaterial, Material>>> materialsMap, UnaryOperator<String> getWoodName) {
        WoodType.m_61843_().filter(wt -> wt.m_61846_().equals(getWoodName.apply(filePath))).findFirst().ifPresent(wt -> definition.getTextureParts().forEach(part -> BarrelFace.fromString(part).ifPresent(barrelFace -> {
            EnumMap barrelFaceMaterials = new EnumMap(BarrelMaterial.class);
            definition.getTextures((String)part).forEach((textureName, rl) -> BarrelMaterial.fromString(textureName).ifPresent(cm -> barrelFaceMaterials.put((BarrelMaterial)((Object)((Object)((Object)((Object)cm)))), new Material(InventoryMenu.f_39692_, rl))));
            materialsMap.computeIfAbsent((WoodType)wt, k -> new EnumMap(BarrelFace.class)).put(barrelFace, barrelFaceMaterials);
        })));
    }

    private void clear() {
        this.woodChestMaterials.clear();
        this.barrelMaterials.clear();
        this.limitedBarrelMaterials.clear();
    }

    protected void apply(Map<ResourceLocation, JsonElement> pObject, ResourceManager pResourceManager, ProfilerFiller pProfiler) {
    }

    @Nullable
    public Map<ChestMaterial, Material> getWoodChestMaterials(WoodType woodType) {
        return this.woodChestMaterials.getOrDefault(woodType, this.woodChestMaterials.get(defaultChestWoodType));
    }

    public Optional<Material> getBarrelMaterial(WoodType woodType, BarrelFace barrelFace, BarrelMaterial barrelMaterial) {
        return this.getMaterial(this.barrelMaterials, woodType, barrelFace, barrelMaterial);
    }

    private Optional<Material> getMaterial(Map<WoodType, Map<BarrelFace, Map<BarrelMaterial, Material>>> materials, WoodType woodType, BarrelFace barrelFace, BarrelMaterial barrelMaterial) {
        Map<BarrelFace, Map<BarrelMaterial, Material>> woodMaterials = materials.get(woodType);
        if (woodMaterials == null) {
            return Optional.empty();
        }
        Map<BarrelMaterial, Material> faceMaterials = woodMaterials.get((Object)barrelFace);
        if (faceMaterials == null) {
            return Optional.empty();
        }
        return Optional.ofNullable(faceMaterials.get((Object)barrelMaterial));
    }

    public Optional<Material> getLimitedBarrelMaterial(WoodType woodType, BarrelFace barrelFace, BarrelMaterial barrelMaterial) {
        return this.getMaterial(this.limitedBarrelMaterials, woodType, barrelFace, barrelMaterial);
    }

    private Optional<StorageTextureDefinition> loadDefinition(Map<ResourceLocation, StorageTextureDefinition> storageTextureDefinitions, ResourceLocation resourceLocation, JsonElement json, Map<ResourceLocation, JsonElement> fileContents) {
        JsonElement parentJson;
        ResourceLocation parent;
        if (storageTextureDefinitions.containsKey(resourceLocation)) {
            return Optional.of(storageTextureDefinitions.get(resourceLocation));
        }
        if (!json.isJsonObject()) {
            return Optional.empty();
        }
        JsonObject jsonContents = json.getAsJsonObject();
        String type = "";
        StorageTextureDefinition parentDefinition = null;
        if (jsonContents.has(PARENT_TAG) && jsonContents.get(PARENT_TAG).isJsonPrimitive() && (parentDefinition = (StorageTextureDefinition)this.loadDefinition(storageTextureDefinitions, parent = new ResourceLocation(jsonContents.get(PARENT_TAG).getAsString()), parentJson = fileContents.get(parent), fileContents).orElse(null)) != null) {
            type = parentDefinition.getType();
        }
        if (jsonContents.has(TYPE_TAG) && jsonContents.get(TYPE_TAG).isJsonPrimitive()) {
            type = jsonContents.get(TYPE_TAG).getAsString();
        }
        if (!TEXTURE_PARSERS.containsKey(type)) {
            return Optional.empty();
        }
        ITextureParser textureParser = TEXTURE_PARSERS.get(type).get();
        if (parentDefinition != null) {
            textureParser.copyFromParentDefinition(parentDefinition);
        }
        Optional<StorageTextureDefinition> result = textureParser.parseDefinition(type, jsonContents);
        result.ifPresent(def -> storageTextureDefinitions.put(resourceLocation, (StorageTextureDefinition)def));
        return result;
    }

    public Collection<Material> getUniqueChestMaterials() {
        HashSet<Material> uniqueMaterials = new HashSet<Material>();
        this.woodChestMaterials.values().forEach(chestMaterials -> uniqueMaterials.addAll(chestMaterials.values()));
        return uniqueMaterials;
    }

    static {
        TEXTURE_PARSERS.put("chest", ChestTextureParser::new);
        TEXTURE_PARSERS.put("barrel", BarrelTextureParser::new);
        TEXTURE_PARSERS.put("limited_barrel", BarrelTextureParser::new);
    }

    public static class StorageTextureDefinition {
        private static final String ALL_SIDES_TEXTURES = "allSides";
        private final String type;
        private final Map<String, Map<String, ResourceLocation>> textures;

        public StorageTextureDefinition(String type, Map<String, Map<String, ResourceLocation>> multiplePartTextures, boolean multipleTextureIgnoredParameter) {
            this.type = type;
            this.textures = multiplePartTextures;
        }

        public StorageTextureDefinition(String type, Map<String, ResourceLocation> textures) {
            this.type = type;
            this.textures = new HashMap<String, Map<String, ResourceLocation>>();
            this.textures.put(ALL_SIDES_TEXTURES, textures);
        }

        public String getType() {
            return this.type;
        }

        public Map<String, ResourceLocation> getTextures() {
            return this.textures.getOrDefault(ALL_SIDES_TEXTURES, new HashMap());
        }

        public Map<String, ResourceLocation> getTextures(String part) {
            return this.textures.getOrDefault(part, new HashMap());
        }

        public Set<String> getTextureParts() {
            return this.textures.keySet();
        }
    }

    public static enum BarrelFace {
        TOP,
        BOTTOM,
        SIDE;


        public static Optional<BarrelFace> fromString(String faceName) {
            for (BarrelFace value : BarrelFace.values()) {
                if (!value.name().toLowerCase(Locale.ROOT).equals(faceName)) continue;
                return Optional.of(value);
            }
            return Optional.empty();
        }
    }

    public static enum BarrelMaterial {
        BASE,
        BASE_1,
        BASE_2,
        BASE_3,
        BASE_4,
        BASE_OPEN,
        HANDLE,
        METAL_BANDS,
        WOOD_TIER,
        IRON_TIER,
        GOLD_TIER,
        DIAMOND_TIER,
        NETHERITE_TIER,
        TINTABLE_MAIN,
        TINTABLE_MAIN_1,
        TINTABLE_MAIN_2,
        TINTABLE_MAIN_3,
        TINTABLE_MAIN_4,
        TINTABLE_MAIN_OPEN,
        TINTABLE_ACCENT,
        TINTABLE_ACCENT_1,
        TINTABLE_ACCENT_2,
        TINTABLE_ACCENT_3,
        TINTABLE_ACCENT_4,
        PACKED,
        LOCK;


        public static Optional<BarrelMaterial> fromString(String textureName) {
            for (BarrelMaterial value : BarrelMaterial.values()) {
                if (!value.name().toLowerCase(Locale.ROOT).equals(textureName)) continue;
                return Optional.of(value);
            }
            return Optional.empty();
        }
    }

    private static interface ITextureParser {
        public void copyFromParentDefinition(StorageTextureDefinition var1);

        public Optional<StorageTextureDefinition> parseDefinition(String var1, JsonObject var2);
    }

    public static enum ChestMaterial {
        BASE,
        WOOD_TIER,
        IRON_TIER,
        GOLD_TIER,
        DIAMOND_TIER,
        NETHERITE_TIER,
        TINTABLE_MAIN,
        TINTABLE_ACCENT,
        PACKED;


        public static Optional<ChestMaterial> fromString(String materialName) {
            for (ChestMaterial value : ChestMaterial.values()) {
                if (!value.name().toLowerCase(Locale.ROOT).equals(materialName)) continue;
                return Optional.of(value);
            }
            return Optional.empty();
        }
    }

    private static class BarrelTextureParser
    implements ITextureParser {
        private final Map<String, Map<String, ResourceLocation>> textures = new HashMap<String, Map<String, ResourceLocation>>();

        private BarrelTextureParser() {
        }

        @Override
        public void copyFromParentDefinition(StorageTextureDefinition parentDefinition) {
            this.textures.put("top", new HashMap<String, ResourceLocation>(parentDefinition.getTextures("top")));
            this.textures.put("bottom", new HashMap<String, ResourceLocation>(parentDefinition.getTextures("bottom")));
            this.textures.put("side", new HashMap<String, ResourceLocation>(parentDefinition.getTextures("side")));
        }

        @Override
        public Optional<StorageTextureDefinition> parseDefinition(String type, JsonObject jsonContents) {
            if (jsonContents.has(StorageTextureManager.TEXTURES_TAG) && jsonContents.get(StorageTextureManager.TEXTURES_TAG).isJsonObject()) {
                JsonObject jsonTextures = jsonContents.get(StorageTextureManager.TEXTURES_TAG).getAsJsonObject();
                jsonTextures.keySet().forEach(partName -> {
                    if (jsonTextures.get(partName).isJsonObject()) {
                        JsonObject part = jsonTextures.get(partName).getAsJsonObject();
                        Map partTextures = this.textures.computeIfAbsent((String)partName, pn -> new HashMap());
                        part.keySet().forEach(textureName -> partTextures.put(textureName, new ResourceLocation(part.get(textureName).getAsString())));
                    }
                });
            }
            return Optional.of(new StorageTextureDefinition(type, this.textures, true));
        }
    }

    private static class ChestTextureParser
    implements ITextureParser {
        private final Map<String, ResourceLocation> textures = new HashMap<String, ResourceLocation>();

        private ChestTextureParser() {
        }

        @Override
        public void copyFromParentDefinition(StorageTextureDefinition parentDefinition) {
            this.textures.putAll(parentDefinition.getTextures());
        }

        @Override
        public Optional<StorageTextureDefinition> parseDefinition(String type, JsonObject jsonContents) {
            if (jsonContents.has(StorageTextureManager.TEXTURES_TAG) && jsonContents.get(StorageTextureManager.TEXTURES_TAG).isJsonObject()) {
                JsonObject jsonTextures = jsonContents.get(StorageTextureManager.TEXTURES_TAG).getAsJsonObject();
                jsonTextures.keySet().forEach(name -> {
                    if (jsonTextures.get(name).isJsonPrimitive()) {
                        this.textures.put((String)name, new ResourceLocation(jsonTextures.get(name).getAsString()));
                    }
                });
            }
            return Optional.of(new StorageTextureDefinition(type, this.textures));
        }
    }
}

