/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedstorage.block;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.p3pp3rf1y.sophisticatedcore.inventory.InventoryHandler;
import net.p3pp3rf1y.sophisticatedcore.settings.memory.MemorySettingsCategory;
import net.p3pp3rf1y.sophisticatedcore.util.InventoryHelper;
import net.p3pp3rf1y.sophisticatedcore.util.NBTHelper;
import net.p3pp3rf1y.sophisticatedcore.util.RandHelper;
import net.p3pp3rf1y.sophisticatedcore.util.WorldHelper;
import net.p3pp3rf1y.sophisticatedstorage.block.BarrelBlockEntity;
import net.p3pp3rf1y.sophisticatedstorage.block.ICountDisplay;
import net.p3pp3rf1y.sophisticatedstorage.block.StorageWrapper;
import net.p3pp3rf1y.sophisticatedstorage.init.ModBlocks;

public class LimitedBarrelBlockEntity
extends BarrelBlockEntity
implements ICountDisplay {
    private static final String SLOT_COUNTS_TAG = "slotCounts";
    private long lastDepositTime = -100L;
    private final List<Integer> slotCounts = new ArrayList<Integer>();
    private boolean showCounts = true;

    public LimitedBarrelBlockEntity(BlockPos pos, BlockState state) {
        super(pos, state, (BlockEntityType<? extends BarrelBlockEntity>)((BlockEntityType)ModBlocks.LIMITED_BARREL_BLOCK_ENTITY_TYPE.get()));
        this.registerClientNotificationOnCountChange();
    }

    private void registerClientNotificationOnCountChange() {
        this.getStorageWrapper().getInventoryHandler().addListener(slot -> WorldHelper.notifyBlockUpdate((BlockEntity)this));
    }

    @Override
    protected void onUpgradeCachesInvalidated() {
        super.onUpgradeCachesInvalidated();
        this.registerClientNotificationOnCountChange();
    }

    @Override
    public boolean shouldShowCounts() {
        return this.showCounts;
    }

    @Override
    public void toggleCountVisibility() {
        this.showCounts = !this.showCounts;
        this.m_6596_();
        WorldHelper.notifyBlockUpdate((BlockEntity)this);
    }

    @Override
    public List<Integer> getSlotCounts() {
        return this.slotCounts;
    }

    public void depositItem(Player player, InteractionHand hand, ItemStack stackInHand, int slot) {
        long gameTime = this.m_58904_().m_46467_();
        boolean doubleClick = gameTime - this.lastDepositTime < 10L;
        this.lastDepositTime = gameTime;
        StorageWrapper storageWrapper = this.getStorageWrapper();
        InventoryHandler invHandler = storageWrapper.getInventoryHandler();
        ItemStack stackInSlot = invHandler.getStackInSlot(slot);
        ItemStack result = stackInHand;
        MemorySettingsCategory memorySettings = (MemorySettingsCategory)this.getStorageWrapper().getSettingsHandler().getTypeCategory(MemorySettingsCategory.class);
        if (doubleClick) {
            this.depositFromAllOfPlayersInventory(player, slot, invHandler, stackInSlot, memorySettings);
            return;
        }
        if (stackInSlot.m_41619_() && (!memorySettings.isSlotSelected(slot) || memorySettings.matchesFilter(slot, result))) {
            result = result.m_41777_();
            invHandler.setStackInSlot(slot, result.m_41620_(Math.min(result.m_41613_(), invHandler.getStackLimit(slot, result))));
            if (this.isLocked()) {
                memorySettings.selectSlot(slot);
            }
        } else if (ItemHandlerHelper.canItemStacksStack((ItemStack)stackInSlot, (ItemStack)result)) {
            result = invHandler.insertItem(slot, result, false);
        }
        if (result.m_41613_() != stackInHand.m_41613_()) {
            player.m_21008_(hand, result);
        }
    }

    private void depositFromAllOfPlayersInventory(Player player, int slot, InventoryHandler invHandler, ItemStack stackInSlot, MemorySettingsCategory memorySettings) {
        Predicate<ItemStack> memoryItemMatches = itemStack -> memorySettings.isSlotSelected(slot) && memorySettings.matchesFilter(slot, itemStack);
        player.getCapability(ForgeCapabilities.ITEM_HANDLER, null).ifPresent(playerInventory -> InventoryHelper.iterate((IItemHandler)playerInventory, (playerSlot, playerStack) -> {
            if (stackInSlot.m_41619_() && memoryItemMatches.test((ItemStack)playerStack) || !playerStack.m_41619_() && ItemHandlerHelper.canItemStacksStack((ItemStack)stackInSlot, (ItemStack)playerStack)) {
                int remainingCapacity = invHandler.getStackLimit(slot, playerStack) - invHandler.getStackInSlot(slot).m_41613_();
                if (remainingCapacity <= 0) {
                    return;
                }
                int toExtract = Math.min(remainingCapacity, playerStack.m_41613_());
                ItemStack extracted = playerInventory.extractItem(playerSlot.intValue(), toExtract, true);
                if (extracted.m_41613_() > 0) {
                    invHandler.insertItem(slot, playerInventory.extractItem(playerSlot.intValue(), extracted.m_41613_(), false), false);
                }
            }
        }));
    }

    boolean tryToTakeItem(Player player, int slot) {
        InventoryHandler inventoryHandler = this.getStorageWrapper().getInventoryHandler();
        ItemStack stackInSlot = inventoryHandler.getStackInSlot(slot);
        if (stackInSlot.m_41619_()) {
            return false;
        }
        int countToTake = player.m_6144_() ? Math.min(stackInSlot.m_41741_(), stackInSlot.m_41613_()) : 1;
        ItemStack stackTaken = inventoryHandler.extractItem(slot, countToTake, false);
        if (player.m_150109_().m_36054_(stackTaken)) {
            this.m_58904_().m_5594_(null, this.m_58899_(), SoundEvents.f_12019_, SoundSource.PLAYERS, 0.2f, (RandHelper.getRandomMinusOneToOne((RandomSource)this.m_58904_().f_46441_) * 0.7f + 1.0f) * 2.0f);
        } else {
            player.m_36176_(stackTaken, false);
        }
        return true;
    }

    @Override
    void updateOpenBlockState(BlockState state, boolean open) {
    }

    @Override
    public CompoundTag m_5995_() {
        CompoundTag updateTag = super.m_5995_();
        ArrayList sc = new ArrayList();
        InventoryHelper.iterate((IItemHandler)this.getStorageWrapper().getInventoryHandler(), (slot, stack) -> sc.add((int)slot, stack.m_41613_()));
        updateTag.m_128408_(SLOT_COUNTS_TAG, sc);
        return updateTag;
    }

    @Override
    public void loadSynchronizedData(CompoundTag tag) {
        super.loadSynchronizedData(tag);
        if (!tag.m_128441_(SLOT_COUNTS_TAG)) {
            return;
        }
        int[] countsArray = tag.m_128465_(SLOT_COUNTS_TAG);
        if (this.slotCounts.size() != countsArray.length) {
            this.slotCounts.clear();
            for (int i = 0; i < countsArray.length; ++i) {
                this.slotCounts.add(i, countsArray[i]);
            }
        } else {
            for (int i = 0; i < countsArray.length; ++i) {
                this.slotCounts.set(i, countsArray[i]);
            }
        }
        this.showCounts = NBTHelper.getBoolean((CompoundTag)tag, (String)"showCounts").orElse(true);
    }

    @Override
    protected void saveSynchronizedData(CompoundTag tag) {
        super.saveSynchronizedData(tag);
        if (!this.showCounts) {
            tag.m_128379_("showCounts", this.showCounts);
        }
    }
}

