/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedstorage.block;

import com.mojang.math.Quaternion;
import com.mojang.math.Vector3f;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.p3pp3rf1y.sophisticatedcore.renderdata.RenderInfo;
import net.p3pp3rf1y.sophisticatedcore.settings.SettingsHandler;
import net.p3pp3rf1y.sophisticatedcore.settings.itemdisplay.ItemDisplaySettingsCategory;
import net.p3pp3rf1y.sophisticatedcore.settings.memory.MemorySettingsCategory;
import net.p3pp3rf1y.sophisticatedcore.settings.nosort.NoSortSettingsCategory;
import net.p3pp3rf1y.sophisticatedcore.util.WorldHelper;
import net.p3pp3rf1y.sophisticatedstorage.block.BarrelBlock;
import net.p3pp3rf1y.sophisticatedstorage.block.LimitedBarrelBlockEntity;
import net.p3pp3rf1y.sophisticatedstorage.block.StorageBlockEntity;
import net.p3pp3rf1y.sophisticatedstorage.block.StorageWrapper;
import net.p3pp3rf1y.sophisticatedstorage.block.WoodStorageBlockEntity;
import net.p3pp3rf1y.sophisticatedstorage.client.gui.StorageTranslationHelper;
import net.p3pp3rf1y.sophisticatedstorage.common.gui.LimitedBarrelContainerMenu;
import net.p3pp3rf1y.sophisticatedstorage.common.gui.StorageContainerMenu;
import net.p3pp3rf1y.sophisticatedstorage.init.ModBlocks;

public class LimitedBarrelBlock
extends BarrelBlock {
    public static final DirectionProperty HORIZONTAL_FACING = BlockStateProperties.f_61374_;
    public static final EnumProperty<VerticalFacing> VERTICAL_FACING = EnumProperty.m_61587_((String)"vertical_facing", VerticalFacing.class);
    private final Supplier<Integer> getBaseStackSizeMultiplier;

    public LimitedBarrelBlock(int numberOfInventorySlots, Supplier<Integer> getBaseStackSizeMultiplier, Supplier<Integer> numberOfUpgradeSlotsSupplier, BlockBehaviour.Properties properties) {
        super(() -> numberOfInventorySlots, numberOfUpgradeSlotsSupplier, properties, (StateDefinition<Block, BlockState> stateDef) -> (BlockState)((BlockState)((BlockState)((BlockState)stateDef.m_61090_()).m_61124_((Property)HORIZONTAL_FACING, (Comparable)Direction.NORTH)).m_61124_(VERTICAL_FACING, (Comparable)((Object)VerticalFacing.NO))).m_61124_((Property)TICKING, (Comparable)Boolean.valueOf(false)));
        this.getBaseStackSizeMultiplier = getBaseStackSizeMultiplier;
    }

    @Override
    public BlockState rotate(BlockState state, LevelAccessor world, BlockPos pos, Rotation direction) {
        if (state.m_61143_(VERTICAL_FACING) != VerticalFacing.NO) {
            return state;
        }
        return (BlockState)state.m_61124_((Property)HORIZONTAL_FACING, (Comparable)direction.m_55954_((Direction)state.m_61143_((Property)HORIZONTAL_FACING)));
    }

    @Override
    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return state.m_60717_(mirror.m_54846_((Direction)state.m_61143_((Property)HORIZONTAL_FACING)));
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{HORIZONTAL_FACING, VERTICAL_FACING, TICKING});
    }

    @Override
    @Nullable
    public BlockState m_5573_(BlockPlaceContext blockPlaceContext) {
        Direction direction = blockPlaceContext.m_7820_().m_122424_();
        Direction horizontalDirection = blockPlaceContext.m_8125_().m_122424_();
        return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)HORIZONTAL_FACING, (Comparable)horizontalDirection)).m_61124_(VERTICAL_FACING, (Comparable)((Object)VerticalFacing.fromDirection(direction)));
    }

    @Override
    public Direction getFacing(BlockState state) {
        VerticalFacing verticalFacing = (VerticalFacing)((Object)state.m_61143_(VERTICAL_FACING));
        return verticalFacing == VerticalFacing.NO ? (Direction)state.m_61143_((Property)HORIZONTAL_FACING) : verticalFacing.getDirection();
    }

    @Override
    public int getBaseStackSizeMultiplier() {
        return this.getBaseStackSizeMultiplier.get();
    }

    public void m_5871_(ItemStack stack, @Nullable BlockGetter level, List<Component> tooltip, TooltipFlag flat) {
        int numberOfInventorySlots = this.getNumberOfInventorySlots();
        String translationKey = numberOfInventorySlots == 1 ? "limited_barrel_singular" : "limited_barrel_plural";
        tooltip.add((Component)Component.m_237110_((String)StorageTranslationHelper.INSTANCE.translBlockTooltipKey(translationKey), (Object[])new Object[]{String.valueOf(numberOfInventorySlots), String.valueOf(this.getBaseStackSizeMultiplier())}).m_130940_(ChatFormatting.DARK_GRAY));
    }

    @Override
    @Nullable
    public StorageBlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new LimitedBarrelBlockEntity(pos, state);
    }

    @Override
    protected BlockEntityType<? extends StorageBlockEntity> getBlockEntityType() {
        return (BlockEntityType)ModBlocks.LIMITED_BARREL_BLOCK_ENTITY_TYPE.get();
    }

    @Override
    protected boolean tryItemInteraction(Player player, InteractionHand hand, WoodStorageBlockEntity b, ItemStack stackInHand, Direction facing, BlockHitResult hitResult) {
        if (super.tryItemInteraction(player, hand, b, stackInHand, facing, hitResult)) {
            return true;
        }
        if (hitResult.m_82434_() != facing || player.m_6144_()) {
            return false;
        }
        int slot = this.getInteractionSlot(b.m_58899_(), b.m_58900_(), hitResult);
        if (b instanceof LimitedBarrelBlockEntity) {
            LimitedBarrelBlockEntity limitedBarrelBlockEntity = (LimitedBarrelBlockEntity)b;
            if (b.isPacked()) {
                return false;
            }
            limitedBarrelBlockEntity.depositItem(player, hand, stackInHand, slot);
        }
        return true;
    }

    private int getInteractionSlot(BlockPos pos, BlockState state, BlockHitResult hitResult) {
        boolean right;
        int invSlots = this.getNumberOfInventorySlots();
        if (invSlots == 1) {
            return 0;
        }
        Vector3f blockCoords = new Vector3f(hitResult.m_82450_().m_82492_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_()));
        blockCoords.m_122272_(-0.5f, -0.5f, -0.5f);
        VerticalFacing verticalFacing = (VerticalFacing)((Object)state.m_61143_(VERTICAL_FACING));
        if (verticalFacing != VerticalFacing.NO) {
            blockCoords.m_122251_(LimitedBarrelBlock.getNorthBasedRotation((Direction)state.m_61143_((Property)HORIZONTAL_FACING)));
            blockCoords.m_122251_(LimitedBarrelBlock.getNorthBasedRotation(verticalFacing.getDirection().m_122424_()));
        } else {
            blockCoords.m_122251_(LimitedBarrelBlock.getNorthBasedRotation(((Direction)state.m_61143_((Property)HORIZONTAL_FACING)).m_122424_()));
        }
        blockCoords.m_122272_(0.5f, 0.5f, 0.5f);
        boolean top = blockCoords.m_122260_() > 0.5f;
        boolean bl = right = blockCoords.m_122239_() > 0.5f;
        if (invSlots == 2) {
            return top ? 0 : 1;
        }
        if (invSlots == 3) {
            if (top) {
                return 0;
            }
            return right ? 2 : 1;
        }
        if (top) {
            return right ? 1 : 0;
        }
        return right ? 3 : 2;
    }

    @Override
    protected StorageContainerMenu instantiateContainerMenu(int w, Player pl, BlockPos pos) {
        return new LimitedBarrelContainerMenu(w, pl, pos);
    }

    public static Quaternion getNorthBasedRotation(Direction dir) {
        return switch (dir) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.DOWN -> {
                Quaternion quaternion = Vector3f.f_122223_.m_122240_(90.0f);
                quaternion.m_80148_(Vector3f.f_122225_.m_122240_(180.0f));
                yield quaternion;
            }
            case Direction.UP -> {
                Quaternion quaternion = Vector3f.f_122223_.m_122240_(-90.0f);
                quaternion.m_80148_(Vector3f.f_122225_.m_122240_(180.0f));
                yield quaternion;
            }
            case Direction.NORTH -> Quaternion.f_80118_.m_80161_();
            case Direction.SOUTH -> Vector3f.f_122225_.m_122240_(180.0f);
            case Direction.WEST -> Vector3f.f_122225_.m_122240_(-90.0f);
            case Direction.EAST -> Vector3f.f_122225_.m_122240_(90.0f);
        };
    }

    private Optional<BlockHitResult> getHitResult(Player player) {
        Optional<BlockHitResult> optional;
        HitResult hitResult = player.m_19907_(player.getReachDistance(), 0.0f, false);
        if (hitResult instanceof BlockHitResult) {
            BlockHitResult blockHitResult = (BlockHitResult)hitResult;
            optional = Optional.of(blockHitResult);
        } else {
            optional = Optional.empty();
        }
        return optional;
    }

    public void m_6256_(BlockState state, Level level, BlockPos pos, Player player) {
        if (level.m_5776_()) {
            return;
        }
        this.tryToTakeItem(state, level, pos, player);
    }

    public boolean tryToTakeItem(BlockState state, Level level, BlockPos pos, Player player) {
        return WorldHelper.getBlockEntity((BlockGetter)level, (BlockPos)pos, LimitedBarrelBlockEntity.class).map(be -> this.tryToTakeItem(state, level, pos, player, (LimitedBarrelBlockEntity)be)).orElse(false);
    }

    private boolean tryToTakeItem(BlockState state, Level level, BlockPos pos, Player player, LimitedBarrelBlockEntity be) {
        return this.getHitResult(player).map(blockHitResult -> {
            if (!blockHitResult.m_82425_().equals((Object)pos) || level.m_8055_(pos) != state || blockHitResult.m_82434_() != this.getFacing(state)) {
                return false;
            }
            return !be.isPacked() && be.tryToTakeItem(player, this.getInteractionSlot(pos, state, (BlockHitResult)blockHitResult));
        }).orElse(false);
    }

    public boolean isLookingAtFront(Player player, BlockPos pos, BlockState state) {
        return this.getHitResult(player).map(blockHitResult -> blockHitResult.m_82425_().equals((Object)pos) && blockHitResult.m_82434_() == this.getFacing(state)).orElse(false);
    }

    @Override
    public void m_6402_(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        super.m_6402_(level, pos, state, placer, stack);
        WorldHelper.getBlockEntity((BlockGetter)level, (BlockPos)pos, LimitedBarrelBlockEntity.class).ifPresent(be -> {
            StorageWrapper storageWrapper = be.getStorageWrapper();
            SettingsHandler settingsHandler = storageWrapper.getSettingsHandler();
            ((ItemDisplaySettingsCategory)settingsHandler.getTypeCategory(ItemDisplaySettingsCategory.class)).selectSlots(0, storageWrapper.getNumberOfInventorySlots());
            ((NoSortSettingsCategory)settingsHandler.getTypeCategory(NoSortSettingsCategory.class)).selectSlots(0, storageWrapper.getNumberOfInventorySlots());
            ((MemorySettingsCategory)settingsHandler.getTypeCategory(MemorySettingsCategory.class)).setIgnoreNbt(false);
        });
    }

    @Override
    public int getDisplayItemsCount(List<RenderInfo.DisplayItem> displayItems) {
        return this.getNumberOfInventorySlots();
    }

    @Override
    public boolean hasFixedIndexDisplayItems() {
        return true;
    }

    public static enum VerticalFacing implements StringRepresentable
    {
        NO("no", Direction.NORTH, 0),
        UP("up", Direction.UP, 1),
        DOWN("down", Direction.DOWN, 2);

        private final String serializedName;
        private final Direction direction;
        private final int index;

        private VerticalFacing(String serializedName, Direction direction, int index) {
            this.serializedName = serializedName;
            this.direction = direction;
            this.index = index;
        }

        public int getIndex() {
            return this.index;
        }

        public Direction getDirection() {
            return this.direction;
        }

        public String m_7912_() {
            return this.serializedName;
        }

        public static VerticalFacing fromDirection(Direction direction) {
            if (direction.m_122434_().m_122479_()) {
                return NO;
            }
            if (direction == Direction.UP) {
                return UP;
            }
            return DOWN;
        }
    }
}

