/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedstorage;

import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import net.p3pp3rf1y.sophisticatedcore.upgrades.FilteredUpgradeConfig;
import net.p3pp3rf1y.sophisticatedcore.upgrades.cooking.AutoCookingUpgradeConfig;
import net.p3pp3rf1y.sophisticatedcore.upgrades.cooking.CookingUpgradeConfig;
import net.p3pp3rf1y.sophisticatedcore.upgrades.magnet.MagnetUpgradeConfig;
import net.p3pp3rf1y.sophisticatedcore.upgrades.pump.PumpUpgradeConfig;
import net.p3pp3rf1y.sophisticatedcore.upgrades.stack.StackUpgradeConfig;
import net.p3pp3rf1y.sophisticatedcore.upgrades.voiding.VoidUpgradeConfig;
import net.p3pp3rf1y.sophisticatedcore.upgrades.xppump.XpPumpUpgradeConfig;
import org.apache.commons.lang3.tuple.Pair;

public class Config {
    public static final Client CLIENT;
    public static final ForgeConfigSpec CLIENT_SPEC;
    public static final Common COMMON;
    public static final ForgeConfigSpec COMMON_SPEC;

    private Config() {
    }

    static {
        Pair commonSpec = new ForgeConfigSpec.Builder().configure(Common::new);
        COMMON_SPEC = (ForgeConfigSpec)commonSpec.getRight();
        COMMON = (Common)commonSpec.getLeft();
        Pair clientSpec = new ForgeConfigSpec.Builder().configure(Client::new);
        CLIENT_SPEC = (ForgeConfigSpec)clientSpec.getRight();
        CLIENT = (Client)clientSpec.getLeft();
    }

    public static class Common {
        public final StorageConfig woodBarrel;
        public final StorageConfig ironBarrel;
        public final StorageConfig goldBarrel;
        public final StorageConfig diamondBarrel;
        public final StorageConfig netheriteBarrel;
        public final LimitedBarrelConfig limitedBarrel1;
        public final LimitedBarrelConfig ironLimitedBarrel1;
        public final LimitedBarrelConfig goldLimitedBarrel1;
        public final LimitedBarrelConfig diamondLimitedBarrel1;
        public final LimitedBarrelConfig netheriteLimitedBarrel1;
        public final LimitedBarrelConfig limitedBarrel2;
        public final LimitedBarrelConfig ironLimitedBarrel2;
        public final LimitedBarrelConfig goldLimitedBarrel2;
        public final LimitedBarrelConfig diamondLimitedBarrel2;
        public final LimitedBarrelConfig netheriteLimitedBarrel2;
        public final LimitedBarrelConfig limitedBarrel3;
        public final LimitedBarrelConfig ironLimitedBarrel3;
        public final LimitedBarrelConfig goldLimitedBarrel3;
        public final LimitedBarrelConfig diamondLimitedBarrel3;
        public final LimitedBarrelConfig netheriteLimitedBarrel3;
        public final LimitedBarrelConfig limitedBarrel4;
        public final LimitedBarrelConfig ironLimitedBarrel4;
        public final LimitedBarrelConfig goldLimitedBarrel4;
        public final LimitedBarrelConfig diamondLimitedBarrel4;
        public final LimitedBarrelConfig netheriteLimitedBarrel4;
        public final StorageConfig woodChest;
        public final StorageConfig ironChest;
        public final StorageConfig goldChest;
        public final StorageConfig diamondChest;
        public final StorageConfig netheriteChest;
        public final StorageConfig shulkerBox;
        public final StorageConfig ironShulkerBox;
        public final StorageConfig goldShulkerBox;
        public final StorageConfig diamondShulkerBox;
        public final StorageConfig netheriteShulkerBox;
        public final StackUpgradeConfig stackUpgrade;
        public final FilteredUpgradeConfig compactingUpgrade;
        public final FilteredUpgradeConfig advancedCompactingUpgrade;
        public final FilteredUpgradeConfig depositUpgrade;
        public final FilteredUpgradeConfig advancedDepositUpgrade;
        public final FilteredUpgradeConfig feedingUpgrade;
        public final FilteredUpgradeConfig advancedFeedingUpgrade;
        public final FilteredUpgradeConfig filterUpgrade;
        public final FilteredUpgradeConfig advancedFilterUpgrade;
        public final MagnetUpgradeConfig magnetUpgrade;
        public final MagnetUpgradeConfig advancedMagnetUpgrade;
        public final FilteredUpgradeConfig pickupUpgrade;
        public final FilteredUpgradeConfig advancedPickupUpgrade;
        public final VoidUpgradeConfig voidUpgrade;
        public final VoidUpgradeConfig advancedVoidUpgrade;
        public final CookingUpgradeConfig smeltingUpgrade;
        public final CookingUpgradeConfig smokingUpgrade;
        public final CookingUpgradeConfig blastingUpgrade;
        public final AutoCookingUpgradeConfig autoSmeltingUpgrade;
        public final AutoCookingUpgradeConfig autoSmokingUpgrade;
        public final AutoCookingUpgradeConfig autoBlastingUpgrade;
        public final PumpUpgradeConfig pumpUpgrade;
        public final XpPumpUpgradeConfig xpPumpUpgrade;
        public final ForgeConfigSpec.IntValue tooManyItemEntityDrops;

        public void onConfigReload(ModConfigEvent.Reloading event) {
            this.stackUpgrade.clearNonStackableItems();
        }

        public Common(ForgeConfigSpec.Builder builder) {
            builder.comment("Common Settings").push("common");
            this.woodBarrel = new StorageConfig(builder, "Wood Barrel", 27, 1);
            this.ironBarrel = new StorageConfig(builder, "Iron Barrel", 54, 1);
            this.goldBarrel = new StorageConfig(builder, "Gold Barrel", 81, 2);
            this.diamondBarrel = new StorageConfig(builder, "Diamond Barrel", 108, 3);
            this.netheriteBarrel = new StorageConfig(builder, "Netherite Barrel", 132, 4);
            this.limitedBarrel1 = new LimitedBarrelConfig(builder, "Limited Barrel I", 32, 1);
            this.ironLimitedBarrel1 = new LimitedBarrelConfig(builder, "Limited Iron Barrel I", 64, 1);
            this.goldLimitedBarrel1 = new LimitedBarrelConfig(builder, "Limited Gold Barrel I", 96, 2);
            this.diamondLimitedBarrel1 = new LimitedBarrelConfig(builder, "Limited Diamond Barrel I", 128, 3);
            this.netheriteLimitedBarrel1 = new LimitedBarrelConfig(builder, "Limited Netherite Barrel I", 160, 4);
            this.limitedBarrel2 = new LimitedBarrelConfig(builder, "Limited Barrel II", 16, 1);
            this.ironLimitedBarrel2 = new LimitedBarrelConfig(builder, "Limited Iron Barrel II", 32, 1);
            this.goldLimitedBarrel2 = new LimitedBarrelConfig(builder, "Limited Gold Barrel II", 48, 2);
            this.diamondLimitedBarrel2 = new LimitedBarrelConfig(builder, "Limited Diamond Barrel II", 64, 3);
            this.netheriteLimitedBarrel2 = new LimitedBarrelConfig(builder, "Limited Netherite Barrel II", 80, 4);
            this.limitedBarrel3 = new LimitedBarrelConfig(builder, "Limited Barrel III", 10, 1);
            this.ironLimitedBarrel3 = new LimitedBarrelConfig(builder, "Limited Iron Barrel III", 20, 1);
            this.goldLimitedBarrel3 = new LimitedBarrelConfig(builder, "Limited Gold Barrel III", 30, 2);
            this.diamondLimitedBarrel3 = new LimitedBarrelConfig(builder, "Limited Diamond Barrel III", 40, 3);
            this.netheriteLimitedBarrel3 = new LimitedBarrelConfig(builder, "Limited Netherite Barrel III", 50, 4);
            this.limitedBarrel4 = new LimitedBarrelConfig(builder, "Limited Barrel IV", 8, 1);
            this.ironLimitedBarrel4 = new LimitedBarrelConfig(builder, "Limited Iron Barrel IV", 16, 1);
            this.goldLimitedBarrel4 = new LimitedBarrelConfig(builder, "Limited Gold Barrel IV", 24, 2);
            this.diamondLimitedBarrel4 = new LimitedBarrelConfig(builder, "Limited Diamond Barrel IV", 32, 3);
            this.netheriteLimitedBarrel4 = new LimitedBarrelConfig(builder, "Limited Netherite Barrel IV", 40, 4);
            this.woodChest = new StorageConfig(builder, "Wood Chest", 27, 1);
            this.ironChest = new StorageConfig(builder, "Iron Chest", 54, 1);
            this.goldChest = new StorageConfig(builder, "Gold Chest", 81, 2);
            this.diamondChest = new StorageConfig(builder, "Diamond Chest", 108, 3);
            this.netheriteChest = new StorageConfig(builder, "Netherite Chest", 132, 4);
            this.shulkerBox = new StorageConfig(builder, "Shulker Box", 27, 1);
            this.ironShulkerBox = new StorageConfig(builder, "Iron Shulker Box", 54, 1);
            this.goldShulkerBox = new StorageConfig(builder, "Gold Shulker Box", 81, 2);
            this.diamondShulkerBox = new StorageConfig(builder, "Diamond Shulker Box", 108, 3);
            this.netheriteShulkerBox = new StorageConfig(builder, "Netherite Shulker Box", 132, 4);
            this.stackUpgrade = new StackUpgradeConfig(builder);
            this.compactingUpgrade = new FilteredUpgradeConfig(builder, "Compacting Upgrade", "compactingUpgrade", 9, 3);
            this.advancedCompactingUpgrade = new FilteredUpgradeConfig(builder, "Advanced Compacting Upgrade", "advancedCompactingUpgrade", 16, 4);
            this.depositUpgrade = new FilteredUpgradeConfig(builder, "Deposit Upgrade", "depositUpgrade", 9, 3);
            this.advancedDepositUpgrade = new FilteredUpgradeConfig(builder, "Advanced Deposit Upgrade", "advancedDepositUpgrade", 16, 4);
            this.feedingUpgrade = new FilteredUpgradeConfig(builder, "Feeding Upgrade", "feedingUpgrade", 9, 3);
            this.advancedFeedingUpgrade = new FilteredUpgradeConfig(builder, "Advanced Feeding Upgrade", "advancedFeedingUpgrade", 16, 4);
            this.filterUpgrade = new FilteredUpgradeConfig(builder, "Filter Upgrade", "filterUpgrade", 9, 3);
            this.advancedFilterUpgrade = new FilteredUpgradeConfig(builder, "Advanced Filter Upgrade", "advancedFilterUpgrade", 16, 4);
            this.magnetUpgrade = new MagnetUpgradeConfig(builder, "Magnet Upgrade", "magnetUpgrade", 9, 3, 3);
            this.advancedMagnetUpgrade = new MagnetUpgradeConfig(builder, "Advanced Magnet Upgrade", "advancedMagnetUpgrade", 16, 4, 5);
            this.pickupUpgrade = new FilteredUpgradeConfig(builder, "Pickup Upgrade", "pickupUpgrade", 9, 3);
            this.advancedPickupUpgrade = new FilteredUpgradeConfig(builder, "Advanced Pickup Upgrade", "advancedPickupUpgrade", 16, 4);
            this.voidUpgrade = new VoidUpgradeConfig(builder, "Void Upgrade", "voidUpgrade", 9, 3);
            this.advancedVoidUpgrade = new VoidUpgradeConfig(builder, "Advanced Void Upgrade", "advancedVoidUpgrade", 16, 4);
            this.smeltingUpgrade = CookingUpgradeConfig.getInstance((ForgeConfigSpec.Builder)builder, (String)"Smelting Upgrade", (String)"smeltingUpgrade");
            this.smokingUpgrade = CookingUpgradeConfig.getInstance((ForgeConfigSpec.Builder)builder, (String)"Smoking Upgrade", (String)"smokingUpgrade");
            this.blastingUpgrade = CookingUpgradeConfig.getInstance((ForgeConfigSpec.Builder)builder, (String)"Blasting Upgrade", (String)"blastingUpgrade");
            this.autoSmeltingUpgrade = new AutoCookingUpgradeConfig(builder, "Auto-Smelting Upgrade", "autoSmeltingUpgrade");
            this.autoSmokingUpgrade = new AutoCookingUpgradeConfig(builder, "Auto-Smoking Upgrade", "autoSmokingUpgrade");
            this.autoBlastingUpgrade = new AutoCookingUpgradeConfig(builder, "Auto-Blasting Upgrade", "autoBlastingUpgrade");
            this.pumpUpgrade = new PumpUpgradeConfig(builder);
            this.xpPumpUpgrade = new XpPumpUpgradeConfig(builder);
            this.tooManyItemEntityDrops = builder.comment("Threshold of number of item entities dropped from chest / barrel above which break is canceled (unless shift key is pressed) and message is displayed explaining to player many drops and packing tape use").defineInRange("tooManyItemEntityDrops", 200, 0, 1000);
            builder.pop();
        }

        public static class StorageConfig {
            public final ForgeConfigSpec.IntValue inventorySlotCount;
            public final ForgeConfigSpec.IntValue upgradeSlotCount;

            public StorageConfig(ForgeConfigSpec.Builder builder, String storagePrefix, int inventorySlotCountDefault, int upgradeSlotCountDefault) {
                builder.comment(storagePrefix + " Settings").push(storagePrefix.replace(" ", ""));
                this.inventorySlotCount = builder.comment("Number of inventory slots in the storage").defineInRange("inventorySlotCount", inventorySlotCountDefault, 1, 180);
                this.upgradeSlotCount = builder.comment("Number of upgrade slots in the storage").defineInRange("upgradeSlotCount", upgradeSlotCountDefault, 0, 10);
                builder.pop();
            }
        }

        public static class LimitedBarrelConfig {
            public final ForgeConfigSpec.IntValue baseSlotLimitMultiplier;
            public final ForgeConfigSpec.IntValue upgradeSlotCount;

            public LimitedBarrelConfig(ForgeConfigSpec.Builder builder, String storagePrefix, int baseSlotLimitMultiplierDefault, int upgradeSlotCountDefault) {
                builder.comment(storagePrefix + " Settings").push(storagePrefix.replace(" ", ""));
                this.baseSlotLimitMultiplier = builder.comment("Multiplier that's used to calculate base slot limit").defineInRange("baseSlotLimitMultiplier", baseSlotLimitMultiplierDefault, 1, 256);
                this.upgradeSlotCount = builder.comment("Number of upgrade slots in the storage").defineInRange("upgradeSlotCount", upgradeSlotCountDefault, 0, 10);
                builder.pop();
            }
        }
    }

    public static class Client {
        public final ForgeConfigSpec.BooleanValue showHigherTierTintedVariants;

        public Client(ForgeConfigSpec.Builder builder) {
            builder.comment("Client-side Settings").push("client");
            this.showHigherTierTintedVariants = builder.comment("Determines whether JEI and creative tab will show tinted storage items for iron and higher tiers. Can help with easily removing many of these items from there.").worldRestart().define("showHigherTierTintedVariants", true);
            builder.pop();
        }
    }
}

