/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.naturesaura.misc;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.registries.ForgeRegistries;

public final class ColoredBlockHelper {
    public static final List<Block> WOOL = ColoredBlockHelper.collectBlocks("wool");
    public static final List<Block> TERRACOTTA = ColoredBlockHelper.collectBlocks("terracotta");
    public static final List<Block> CONCRETE_POWDER = ColoredBlockHelper.collectBlocks("concrete_powder");
    public static final List<Block> CONCRETE = ColoredBlockHelper.collectBlocks("concrete");
    public static final List<Block> GLASS = ColoredBlockHelper.collectBlocks("stained_glass");
    public static final List<Block> GLASS_PANE = ColoredBlockHelper.collectBlocks("glass_pane");
    public static final List<Block> CARPET = ColoredBlockHelper.collectBlocks("carpet");
    public static final List<List<Block>> LISTS = Arrays.asList(WOOL, TERRACOTTA, CONCRETE_POWDER, CONCRETE, GLASS, GLASS_PANE, CARPET);

    private static List<Block> collectBlocks(String name) {
        ArrayList<Block> blocks = new ArrayList<Block>();
        for (DyeColor color : DyeColor.values()) {
            blocks.add((Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(color.m_41065_() + "_" + name)));
        }
        return Collections.unmodifiableList(blocks);
    }

    public static List<Block> getBlocksContaining(Block block) {
        for (List<Block> list : LISTS) {
            if (!list.contains(block)) continue;
            return list;
        }
        return null;
    }
}

