/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.naturesaura.items.tools;

import de.ellpeck.naturesaura.Helper;
import de.ellpeck.naturesaura.NaturesAura;
import de.ellpeck.naturesaura.reg.IModItem;
import de.ellpeck.naturesaura.reg.ModArmorMaterial;
import de.ellpeck.naturesaura.reg.ModRegistry;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;

public class ItemArmor
extends ArmorItem
implements IModItem {
    private static final AttributeModifier SKY_MOVEMENT_MODIFIER = new AttributeModifier(UUID.fromString("c1f96acc-e117-4dc1-a351-e196a4de6071"), "naturesaura:sky_movement_speed", (double)0.15f, AttributeModifier.Operation.MULTIPLY_TOTAL);
    private static final Map<ArmorMaterial, Item[]> SETS = new HashMap<ArmorMaterial, Item[]>();
    private final String baseName;

    public ItemArmor(String baseName, ArmorMaterial materialIn, EquipmentSlot equipmentSlotIn) {
        super(materialIn, equipmentSlotIn, new Item.Properties().m_41491_(NaturesAura.CREATIVE_TAB));
        this.baseName = baseName;
        ModRegistry.ALL_ITEMS.add(this);
    }

    public static boolean isFullSetEquipped(LivingEntity entity, ArmorMaterial material) {
        Item[] set = SETS.computeIfAbsent(material, m -> (Item[])ForgeRegistries.ITEMS.getValues().stream().filter(i -> i instanceof ItemArmor && ((ItemArmor)i).m_40401_() == material).sorted(Comparator.comparingInt(i -> ((ItemArmor)i).m_40402_().ordinal())).toArray(Item[]::new));
        for (int i = 0; i < 4; ++i) {
            EquipmentSlot slot = EquipmentSlot.values()[i + 2];
            ItemStack stack = entity.m_6844_(slot);
            if (stack.m_41720_() == set[i] || slot == EquipmentSlot.CHEST && stack.m_41720_() == Items.f_42741_) continue;
            return false;
        }
        return true;
    }

    @Override
    public String getBaseName() {
        return this.baseName;
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundTag nbt) {
        return Helper.makeRechargeProvider(stack, false);
    }

    @Mod.EventBusSubscriber
    private static final class EventHandler {
        private EventHandler() {
        }

        @SubscribeEvent
        public static void onAttack(LivingAttackEvent event) {
            LivingEntity entity = event.getEntity();
            if (!entity.f_19853_.f_46443_) {
                if (ItemArmor.isFullSetEquipped(entity, ModArmorMaterial.INFUSED)) {
                    Entity source = event.getSource().m_7639_();
                    if (source instanceof LivingEntity) {
                        ((LivingEntity)source).m_7292_(new MobEffectInstance(MobEffects.f_19615_, 40));
                    }
                } else if (ItemArmor.isFullSetEquipped(entity, ModArmorMaterial.DEPTH)) {
                    for (LivingEntity other : entity.f_19853_.m_45976_(LivingEntity.class, new AABB(entity.m_20182_(), Vec3.f_82478_).m_82400_(2.0))) {
                        Player otherPlayer;
                        if (other == entity || other instanceof Player && (otherPlayer = (Player)other).m_7307_((Entity)entity)) continue;
                        other.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 60, 255));
                    }
                }
            }
        }

        @SubscribeEvent
        public static void update(TickEvent.PlayerTickEvent event) {
            Player player = event.player;
            AttributeInstance speed = player.m_21051_(Attributes.f_22279_);
            String key = "naturesaura:sky_equipped";
            CompoundTag nbt = player.getPersistentData();
            boolean equipped = ItemArmor.isFullSetEquipped((LivingEntity)player, ModArmorMaterial.SKY);
            if (equipped && !nbt.m_128471_(key)) {
                nbt.m_128379_(key, true);
                player.f_19793_ = 1.1f;
                if (!speed.m_22109_(SKY_MOVEMENT_MODIFIER)) {
                    speed.m_22125_(SKY_MOVEMENT_MODIFIER);
                }
            } else if (!equipped && nbt.m_128471_(key)) {
                nbt.m_128379_(key, false);
                player.f_19793_ = 0.6f;
                speed.m_22130_(SKY_MOVEMENT_MODIFIER);
            }
        }
    }
}

