/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.naturesaura.data;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import de.ellpeck.naturesaura.blocks.BlockFlowerPot;
import de.ellpeck.naturesaura.blocks.BlockGoldenLeaves;
import de.ellpeck.naturesaura.blocks.ModBlocks;
import de.ellpeck.naturesaura.blocks.Slab;
import de.ellpeck.naturesaura.items.ModItems;
import de.ellpeck.naturesaura.reg.IModItem;
import de.ellpeck.naturesaura.reg.ModRegistry;
import java.io.IOException;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nonnull;
import net.minecraft.advancements.critereon.StatePropertiesPredicate;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.loot.BlockLoot;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FlowerPotBlock;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.LootTables;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemCountFunction;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.predicates.ConditionUserBuilder;
import net.minecraft.world.level.storage.loot.predicates.LootItemBlockStatePropertyCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemRandomChanceCondition;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;
import net.minecraftforge.registries.ForgeRegistries;

public class BlockLootProvider
implements DataProvider {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private final DataGenerator generator;
    private final Map<Block, Function<Block, LootTable.Builder>> lootFunctions = new HashMap<Block, Function<Block, LootTable.Builder>>();

    public BlockLootProvider(DataGenerator generator) {
        this.generator = generator;
        for (IModItem item : ModRegistry.ALL_ITEMS) {
            if (!(item instanceof Block)) continue;
            Block block = (Block)item;
            if (block instanceof Slab) {
                this.lootFunctions.put(block, LootTableHooks::genSlab);
                continue;
            }
            if (block instanceof BlockFlowerPot) {
                this.lootFunctions.put(block, LootTableHooks::genFlowerPot);
                continue;
            }
            this.lootFunctions.put(block, LootTableHooks::genRegular);
        }
        this.lootFunctions.put(ModBlocks.ANCIENT_LEAVES, LootTableHooks::genSilkOnly);
        this.lootFunctions.put(ModBlocks.DECAYED_LEAVES, LootTableHooks::genSilkOnly);
        this.lootFunctions.put(ModBlocks.GOLDEN_LEAVES, b -> LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_(((LootPoolSingletonContainer.Builder)LootTableHooks.survivesExplosion(b, LootItem.m_79579_((ItemLike)ModItems.GOLD_LEAF))).m_79080_((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.m_81769_((Block)b).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67694_((Property)BlockGoldenLeaves.STAGE, 3)))).m_79080_(LootItemRandomChanceCondition.m_81927_((float)0.75f))));
        this.lootFunctions.put(ModBlocks.NETHER_WART_MUSHROOM, b -> LootTableHooks.genSilkOr(b, LootItem.m_79579_((ItemLike)Items.f_42588_).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)2.0f)))));
        this.lootFunctions.put(ModBlocks.NETHER_GRASS, b -> LootTableHooks.genSilkOr(b, LootItem.m_79579_((ItemLike)Blocks.f_50134_)));
    }

    private static Path getPath(Path root, ResourceLocation res) {
        return root.resolve("data/" + res.m_135827_() + "/loot_tables/blocks/" + res.m_135815_() + ".json");
    }

    public void m_213708_(CachedOutput cache) throws IOException {
        for (Map.Entry<Block, Function<Block, LootTable.Builder>> function : this.lootFunctions.entrySet()) {
            Block block = function.getKey();
            Function<Block, LootTable.Builder> func = function.getValue();
            LootTable table = func.apply(block).m_79165_(LootContextParamSets.f_81421_).m_79167_();
            Path path = BlockLootProvider.getPath(this.generator.m_123916_(), ForgeRegistries.BLOCKS.getKey((Object)block));
            DataProvider.m_236072_((CachedOutput)cache, (JsonElement)LootTables.m_79200_((LootTable)table), (Path)path);
        }
    }

    @Nonnull
    public String m_6055_() {
        return "Nature's Aura Loot";
    }

    private static class LootTableHooks
    extends BlockLoot {
        private LootTableHooks() {
        }

        public static LootTable.Builder genLeaves(Block block, Block drop) {
            return BlockLoot.m_124157_((Block)block, (Block)drop, (float[])new float[]{0.05f, 0.0625f, 0.083333336f, 0.1f});
        }

        public static LootTable.Builder genSlab(Block block) {
            return BlockLoot.m_124290_((Block)block);
        }

        public static LootTable.Builder genRegular(Block block) {
            return BlockLoot.m_124126_((ItemLike)block);
        }

        public static LootTable.Builder genSilkOnly(Block block) {
            return BlockLoot.m_124250_((ItemLike)block);
        }

        public static LootTable.Builder genSilkOr(Block block, LootPoolEntryContainer.Builder<?> builder) {
            return BlockLoot.m_124283_((Block)block, builder);
        }

        public static LootTable.Builder genFlowerPot(Block block) {
            return BlockLoot.m_124270_((ItemLike)((FlowerPotBlock)block).m_53560_());
        }

        public static <T extends ConditionUserBuilder<T>> T survivesExplosion(Block block, ConditionUserBuilder<T> then) {
            return (T)BlockLoot.m_236224_((ItemLike)block, then);
        }
    }
}

