/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.naturesaura.chunk.effect;

import de.ellpeck.naturesaura.ModConfig;
import de.ellpeck.naturesaura.api.NaturesAuraAPI;
import de.ellpeck.naturesaura.api.aura.chunk.IAuraChunk;
import de.ellpeck.naturesaura.api.aura.chunk.IDrainSpotEffect;
import de.ellpeck.naturesaura.api.aura.type.IAuraType;
import de.ellpeck.naturesaura.api.misc.WeightedOre;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.random.WeightedRandom;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.util.FakePlayerFactory;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.tuple.Pair;

public class OreSpawnEffect
implements IDrainSpotEffect {
    public static final Set<BlockState> SPAWN_EXCEPTIONS = new HashSet<BlockState>();
    public static final ResourceLocation NAME = new ResourceLocation("naturesaura", "ore_spawn");
    private int amount;
    private int dist;

    private boolean calcValues(Level level, BlockPos pos, Integer spot) {
        if (spot <= 0) {
            return false;
        }
        Pair<Integer, Integer> auraAndSpots = IAuraChunk.getAuraAndSpotAmountInArea(level, pos, 30);
        int aura = (Integer)auraAndSpots.getLeft();
        if (aura <= 2000000) {
            return false;
        }
        this.amount = Math.min(20, Mth.m_14167_((float)((float)Math.abs(aura) / 300000.0f / (float)((Integer)auraAndSpots.getRight()).intValue())));
        if (this.amount <= 0) {
            return false;
        }
        this.dist = Mth.m_14045_((int)(Math.abs(aura) / 150000), (int)5, (int)20);
        return true;
    }

    @Override
    public IDrainSpotEffect.ActiveType isActiveHere(Player player, LevelChunk chunk, IAuraChunk auraChunk, BlockPos pos, Integer spot) {
        if (!this.calcValues(player.f_19853_, pos, spot)) {
            return IDrainSpotEffect.ActiveType.INACTIVE;
        }
        if (player.m_20275_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_()) > (double)(this.dist * this.dist)) {
            return IDrainSpotEffect.ActiveType.INACTIVE;
        }
        if (!NaturesAuraAPI.instance().isEffectPowderActive(player.f_19853_, player.m_20183_(), NAME)) {
            return IDrainSpotEffect.ActiveType.INHIBITED;
        }
        return IDrainSpotEffect.ActiveType.ACTIVE;
    }

    @Override
    public ItemStack getDisplayIcon() {
        return new ItemStack((ItemLike)Blocks.f_50089_);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void update(Level level, LevelChunk chunk, IAuraChunk auraChunk, BlockPos pos, Integer spot) {
        if (level.m_46467_() % 40L != 0L) {
            return;
        }
        if (!this.calcValues(level, pos, spot)) {
            return;
        }
        type = auraChunk.getType();
        if (type.isSimilar(NaturesAuraAPI.TYPE_OVERWORLD)) {
            requiredBlock = Blocks.f_50069_;
            ores = NaturesAuraAPI.OVERWORLD_ORES;
        } else {
            requiredBlock = Blocks.f_50134_;
            ores = NaturesAuraAPI.NETHER_ORES;
        }
        totalWeight = WeightedRandom.m_146312_(ores);
        powders = NaturesAuraAPI.instance().getActiveEffectPowders(level, new AABB(pos).m_82400_((double)this.dist), OreSpawnEffect.NAME);
        if (powders.isEmpty()) {
            return;
        }
        for (i = 0; i < this.amount; ++i) {
            powder = powders.get(i % powders.size());
            powderPos = (Vec3)powder.m_14418_();
            range = (Integer)powder.m_14419_();
            x = Mth.m_14107_((double)(powderPos.f_82479_ + level.f_46441_.m_188583_() * (double)range));
            orePos = new BlockPos(x, y = Mth.m_14107_((double)(powderPos.f_82480_ + level.f_46441_.m_188583_() * (double)range)), z = Mth.m_14107_((double)(powderPos.f_82481_ + level.f_46441_.m_188583_() * (double)range)));
            if (!(orePos.m_203198_(powderPos.f_82479_, powderPos.f_82480_, powderPos.f_82481_) <= (double)(range * range)) || !(orePos.m_123331_((Vec3i)pos) <= (double)(this.dist * this.dist)) || !level.m_46749_(orePos) || (state = level.m_8055_(orePos)).m_60734_() != requiredBlock) continue;
            block1: while (true) {
                if ((ore = (WeightedOre)WeightedRandom.m_216825_((RandomSource)level.f_46441_, ores, (int)totalWeight).orElse(null)) == null || (tag = TagKey.m_203882_((ResourceKey)ForgeRegistries.Keys.BLOCKS, (ResourceLocation)ore.tag)) == null) {
                    continue;
                }
                var22_22 = ForgeRegistries.BLOCKS.tags().getTag(tag).iterator();
                while (true) {
                    if (var22_22.hasNext()) ** break;
                    continue block1;
                    toPlace = (Block)var22_22.next();
                    if (toPlace == null || toPlace == Blocks.f_50016_) continue;
                    player = FakePlayerFactory.getMinecraft((ServerLevel)((ServerLevel)level));
                    player.m_21008_(InteractionHand.MAIN_HAND, ItemStack.f_41583_);
                    ray = new BlockHitResult(Vec3.m_82512_((Vec3i)pos), Direction.UP, pos, false);
                    context = new BlockPlaceContext(new UseOnContext((Player)player, InteractionHand.MAIN_HAND, ray));
                    stateToPlace = toPlace.m_5573_(context);
                    if (!OreSpawnEffect.SPAWN_EXCEPTIONS.contains(stateToPlace)) break block1;
                }
                break;
            }
            level.m_46597_(orePos, stateToPlace);
            level.m_46796_(2001, orePos, Block.m_49956_((BlockState)stateToPlace));
            toDrain = (20000 - ore.m_142631_().m_146281_() * 2) * 2;
            highestSpot = IAuraChunk.getHighestSpot(level, orePos, 30, pos);
            IAuraChunk.getAuraChunk(level, highestSpot).drainAura(highestSpot, toDrain);
        }
    }

    @Override
    public boolean appliesHere(LevelChunk chunk, IAuraChunk auraChunk, IAuraType type) {
        return (Boolean)ModConfig.instance.oreEffect.get() != false && (type.isSimilar(NaturesAuraAPI.TYPE_OVERWORLD) || type.isSimilar(NaturesAuraAPI.TYPE_NETHER));
    }

    @Override
    public ResourceLocation getName() {
        return NAME;
    }
}

