/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.naturesaura.chunk;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import de.ellpeck.naturesaura.api.NaturesAuraAPI;
import de.ellpeck.naturesaura.api.aura.chunk.IAuraChunk;
import de.ellpeck.naturesaura.api.aura.chunk.IDrainSpotEffect;
import de.ellpeck.naturesaura.api.aura.type.IAuraType;
import de.ellpeck.naturesaura.api.misc.ILevelData;
import de.ellpeck.naturesaura.misc.LevelData;
import de.ellpeck.naturesaura.packet.PacketAuraChunk;
import de.ellpeck.naturesaura.packet.PacketHandler;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.chunk.LevelChunk;
import org.apache.commons.lang3.mutable.MutableInt;
import org.apache.commons.lang3.mutable.MutableObject;
import org.apache.commons.lang3.tuple.Pair;

public class AuraChunk
implements IAuraChunk {
    private final LevelChunk chunk;
    private final IAuraType type;
    private final Map<BlockPos, MutableInt> drainSpots = new ConcurrentHashMap<BlockPos, MutableInt>();
    private final Table<BlockPos, Integer, Pair<Integer, Integer>> auraAndSpotAmountCache = HashBasedTable.create();
    private final Table<BlockPos, Integer, Pair<BlockPos, Integer>[]> limitSpotCache = HashBasedTable.create();
    private final List<IDrainSpotEffect> effects = new ArrayList<IDrainSpotEffect>();
    private boolean needsSync;

    public AuraChunk(LevelChunk chunk, IAuraType type) {
        this.chunk = chunk;
        this.type = type;
        for (Supplier<IDrainSpotEffect> supplier : NaturesAuraAPI.DRAIN_SPOT_EFFECTS.values()) {
            IDrainSpotEffect effect = supplier.get();
            if (!effect.appliesHere(this.chunk, this, this.type)) continue;
            this.effects.add(effect);
        }
    }

    @Override
    public int drainAura(BlockPos pos, int amount, boolean aimForZero, boolean simulate) {
        int curr;
        if (amount <= 0) {
            return 0;
        }
        MutableInt spot = this.getActualDrainSpot(pos, !simulate);
        int n = curr = spot != null ? spot.intValue() : 0;
        if (curr < 0 && curr - amount > 0) {
            return this.drainAura(pos.m_7494_(), amount, aimForZero, simulate);
        }
        if (aimForZero && curr > 0 && curr - amount < 0) {
            amount = curr;
        }
        if (!simulate) {
            spot.subtract(amount);
            if (spot.intValue() == 0) {
                this.drainSpots.remove(pos);
            }
            this.markDirty();
        }
        return amount;
    }

    @Override
    public int drainAura(BlockPos pos, int amount) {
        return this.drainAura(pos, amount, false, false);
    }

    @Override
    public int storeAura(BlockPos pos, int amount, boolean aimForZero, boolean simulate) {
        int curr;
        if (amount <= 0) {
            return 0;
        }
        MutableInt spot = this.getActualDrainSpot(pos, !simulate);
        int n = curr = spot != null ? spot.intValue() : 0;
        if (curr > 0 && curr + amount < 0) {
            return this.storeAura(pos.m_7494_(), amount, aimForZero, simulate);
        }
        if (aimForZero && curr < 0 && curr + amount > 0) {
            amount = -curr;
        }
        if (!simulate) {
            spot.add(amount);
            if (spot.intValue() == 0) {
                this.drainSpots.remove(pos);
            }
            this.markDirty();
        }
        return amount;
    }

    @Override
    public int storeAura(BlockPos pos, int amount) {
        return this.storeAura(pos, amount, true, false);
    }

    private MutableInt getActualDrainSpot(BlockPos pos, boolean make) {
        MutableInt spot = this.drainSpots.get(pos);
        if (spot == null && make) {
            spot = new MutableInt();
            this.addDrainSpot(pos, spot);
        }
        return spot;
    }

    @Override
    public int getDrainSpot(BlockPos pos) {
        MutableInt spot = this.getActualDrainSpot(pos, false);
        return spot == null ? 0 : spot.intValue();
    }

    private void addDrainSpot(BlockPos pos, MutableInt spot) {
        int expX = pos.m_123341_() >> 4;
        int expZ = pos.m_123343_() >> 4;
        ChunkPos myPos = this.chunk.m_7697_();
        if (expX != myPos.f_45578_ || expZ != myPos.f_45579_) {
            throw new IllegalArgumentException("Tried to add drain spot " + pos + " to chunk at " + myPos.f_45578_ + ", " + myPos.f_45579_ + " when it should've been added to chunk at " + expX + ", " + expZ);
        }
        this.drainSpots.put(pos, spot);
    }

    public void setSpots(Map<BlockPos, MutableInt> spots) {
        this.drainSpots.clear();
        for (Map.Entry<BlockPos, MutableInt> entry : spots.entrySet()) {
            this.addDrainSpot(entry.getKey(), entry.getValue());
        }
        this.addOrRemoveAsActive();
    }

    @Override
    public IAuraType getType() {
        return this.type;
    }

    @Override
    public void markDirty() {
        this.chunk.m_8092_(true);
        this.needsSync = true;
        this.auraAndSpotAmountCache.clear();
        this.limitSpotCache.clear();
        this.addOrRemoveAsActive();
    }

    public void update() {
        Level level = this.chunk.m_62953_();
        for (Map.Entry<BlockPos, MutableInt> entry : this.drainSpots.entrySet()) {
            BlockPos pos = entry.getKey();
            MutableInt amount = entry.getValue();
            for (IDrainSpotEffect effect : this.effects) {
                effect.update(level, this.chunk, this, pos, amount.intValue());
            }
        }
        if (this.needsSync) {
            ChunkPos pos = this.chunk.m_7697_();
            PacketHandler.sendToAllLoaded(level, new BlockPos(pos.f_45578_ * 16, 0, pos.f_45579_ * 16), this.makePacket());
            this.needsSync = false;
        }
    }

    public PacketAuraChunk makePacket() {
        ChunkPos pos = this.chunk.m_7697_();
        return new PacketAuraChunk(pos.f_45578_, pos.f_45579_, this.drainSpots);
    }

    public void getSpots(BlockPos pos, int radius, BiConsumer<BlockPos, Integer> consumer) {
        for (Map.Entry<BlockPos, MutableInt> entry : this.drainSpots.entrySet()) {
            BlockPos drainPos = entry.getKey();
            if (!(drainPos.m_123331_((Vec3i)pos) <= (double)(radius * radius))) continue;
            consumer.accept(drainPos, entry.getValue().intValue());
        }
    }

    public Pair<Integer, Integer> getAuraAndSpotAmount(BlockPos pos, int radius) {
        Pair ret = (Pair)this.auraAndSpotAmountCache.get((Object)pos, (Object)radius);
        if (ret == null) {
            MutableInt aura = new MutableInt();
            MutableInt spots = new MutableInt();
            this.getSpots(pos, radius, (p, i) -> {
                aura.add((Number)i);
                spots.increment();
            });
            ret = Pair.of((Object)aura.intValue(), (Object)spots.intValue());
            this.auraAndSpotAmountCache.put((Object)pos, (Object)radius, (Object)ret);
        }
        return ret;
    }

    public Pair<BlockPos, Integer>[] getLowestAndHighestSpots(BlockPos pos, int radius) {
        Pair[] ret = (Pair[])this.limitSpotCache.get((Object)pos, (Object)radius);
        if (ret == null) {
            MutableObject lowestSpot = new MutableObject();
            MutableObject highestSpot = new MutableObject();
            MutableInt lowestAmount = new MutableInt(Integer.MAX_VALUE);
            MutableInt highestAmount = new MutableInt(Integer.MIN_VALUE);
            this.getSpots(pos, radius, (p, i) -> {
                if (i > highestAmount.intValue()) {
                    highestAmount.setValue((Number)i);
                    highestSpot.setValue(p);
                }
                if (i < lowestAmount.intValue()) {
                    lowestAmount.setValue((Number)i);
                    lowestSpot.setValue(p);
                }
            });
            ret = new Pair[]{Pair.of((Object)((BlockPos)lowestSpot.getValue()), (Object)lowestAmount.intValue()), Pair.of((Object)((BlockPos)highestSpot.getValue()), (Object)highestAmount.intValue())};
            this.limitSpotCache.put((Object)pos, (Object)radius, (Object)ret);
        }
        return ret;
    }

    public void getActiveEffectIcons(Player player, Map<ResourceLocation, Tuple<ItemStack, Boolean>> icons) {
        for (IDrainSpotEffect effect : this.effects) {
            Tuple<ItemStack, Boolean> alreadyThere = icons.get(effect.getName());
            if (alreadyThere != null && ((Boolean)alreadyThere.m_14419_()).booleanValue()) continue;
            for (Map.Entry<BlockPos, MutableInt> entry : this.drainSpots.entrySet()) {
                ItemStack stack;
                MutableInt amount;
                BlockPos pos = entry.getKey();
                IDrainSpotEffect.ActiveType state = effect.isActiveHere(player, this.chunk, this, pos, (amount = entry.getValue()).intValue());
                if (state == IDrainSpotEffect.ActiveType.INACTIVE || (stack = effect.getDisplayIcon()).m_41619_()) continue;
                icons.put(effect.getName(), (Tuple<ItemStack, Boolean>)new Tuple((Object)stack, (Object)(state == IDrainSpotEffect.ActiveType.INHIBITED ? 1 : 0)));
            }
        }
    }

    public CompoundTag serializeNBT() {
        ListTag list = new ListTag();
        for (Map.Entry<BlockPos, MutableInt> entry : this.drainSpots.entrySet()) {
            CompoundTag tag = new CompoundTag();
            tag.m_128356_("pos", entry.getKey().m_121878_());
            tag.m_128405_("amount", entry.getValue().intValue());
            list.add((Object)tag);
        }
        CompoundTag compound = new CompoundTag();
        compound.m_128365_("drain_spots", (Tag)list);
        return compound;
    }

    public void deserializeNBT(CompoundTag compound) {
        this.drainSpots.clear();
        ListTag list = compound.m_128437_("drain_spots", 10);
        for (Tag base : list) {
            CompoundTag tag = (CompoundTag)base;
            this.addDrainSpot(BlockPos.m_122022_((long)tag.m_128454_("pos")), new MutableInt(tag.m_128451_("amount")));
        }
        this.addOrRemoveAsActive();
    }

    private void addOrRemoveAsActive() {
        long chunkPos = this.chunk.m_7697_().m_45588_();
        LevelData data = (LevelData)ILevelData.getLevelData(this.chunk.m_62953_());
        if (this.drainSpots.size() > 0) {
            data.auraChunksWithSpots.put(chunkPos, (Object)this);
        } else {
            data.auraChunksWithSpots.remove(chunkPos);
        }
    }
}

