/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.naturesaura.blocks.tiles;

import de.ellpeck.naturesaura.Helper;
import de.ellpeck.naturesaura.api.NaturesAuraAPI;
import de.ellpeck.naturesaura.api.aura.chunk.IAuraChunk;
import de.ellpeck.naturesaura.api.aura.type.IAuraType;
import de.ellpeck.naturesaura.blocks.multi.Multiblocks;
import de.ellpeck.naturesaura.blocks.tiles.BlockEntityImpl;
import de.ellpeck.naturesaura.blocks.tiles.ITickableBlockEntity;
import de.ellpeck.naturesaura.blocks.tiles.ModBlockEntities;
import de.ellpeck.naturesaura.packet.PacketHandler;
import de.ellpeck.naturesaura.packet.PacketParticles;
import de.ellpeck.naturesaura.recipes.AnimalSpawnerRecipe;
import de.ellpeck.naturesaura.recipes.ModRecipes;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;

public class BlockEntityAnimalSpawner
extends BlockEntityImpl
implements ITickableBlockEntity {
    private AnimalSpawnerRecipe currentRecipe;
    private double spawnX;
    private double spawnZ;
    private int time;
    private Entity entityClient;

    public BlockEntityAnimalSpawner(BlockPos pos, BlockState state) {
        super(ModBlockEntities.ANIMAL_SPAWNER, pos, state);
    }

    @Override
    public void tick() {
        block12: {
            block13: {
                block14: {
                    if (this.f_58857_.f_46443_) break block13;
                    if (this.f_58857_.m_46467_() % 10L != 0L) {
                        return;
                    }
                    if (!Multiblocks.ANIMAL_SPAWNER.isComplete(this.f_58857_, this.f_58858_)) {
                        if (this.currentRecipe != null) {
                            this.currentRecipe = null;
                            this.time = 0;
                            this.sendToClients();
                        }
                        return;
                    }
                    if (this.currentRecipe == null) break block14;
                    int drain = Mth.m_14167_((float)((float)this.currentRecipe.aura / (float)this.currentRecipe.time * 10.0f));
                    if (!this.canUseRightNow(drain)) {
                        return;
                    }
                    BlockPos spot = IAuraChunk.getHighestSpot(this.f_58857_, this.f_58858_, 35, this.f_58858_);
                    IAuraChunk.getAuraChunk(this.f_58857_, spot).drainAura(spot, drain);
                    this.time += 10;
                    if (this.time < this.currentRecipe.time) break block12;
                    Entity entity = this.currentRecipe.makeEntity(this.f_58857_, new BlockPos(this.spawnX, (double)(this.f_58858_.m_123342_() + 1), this.spawnZ));
                    this.f_58857_.m_7967_(entity);
                    this.currentRecipe = null;
                    this.time = 0;
                    this.sendToClients();
                    break block12;
                }
                List items = this.f_58857_.m_45976_(ItemEntity.class, new AABB(this.f_58858_).m_82400_(2.0));
                for (AnimalSpawnerRecipe recipe : this.f_58857_.m_7465_().m_44056_(ModRecipes.ANIMAL_SPAWNER_TYPE, null, null)) {
                    ItemStack stack;
                    ItemEntity item2;
                    if (recipe.ingredients.length != items.size()) continue;
                    ArrayList<Ingredient> required = new ArrayList<Ingredient>(Arrays.asList(recipe.ingredients));
                    Iterator iterator = items.iterator();
                    block1: while (iterator.hasNext() && (item2 = (ItemEntity)iterator.next()).m_6084_() && !item2.m_32063_() && !(stack = item2.m_32055_()).m_41619_()) {
                        for (Ingredient ingredient : required) {
                            if (!ingredient.test(stack) || Helper.getIngredientAmount(ingredient) != stack.m_41613_()) continue;
                            required.remove(ingredient);
                            continue block1;
                        }
                    }
                    if (!required.isEmpty()) continue;
                    for (ItemEntity item2 : items) {
                        item2.m_142687_(Entity.RemovalReason.KILLED);
                        PacketHandler.sendToAllAround(this.f_58857_, this.f_58858_, 32, new PacketParticles((float)item2.m_20185_(), (float)item2.m_20186_(), (float)item2.m_20189_(), PacketParticles.Type.ANIMAL_SPAWNER, new int[0]));
                    }
                    this.currentRecipe = recipe;
                    this.spawnX = (double)this.f_58858_.m_123341_() + 0.5 + (double)(this.f_58857_.f_46441_.m_188501_() * 4.0f) - 2.0;
                    this.spawnZ = (double)this.f_58858_.m_123343_() + 0.5 + (double)(this.f_58857_.f_46441_.m_188501_() * 4.0f) - 2.0;
                    this.sendToClients();
                    break block12;
                }
                break block12;
            }
            if (this.f_58857_.m_46467_() % 5L != 0L) {
                return;
            }
            if (this.currentRecipe == null) {
                this.entityClient = null;
                return;
            }
            NaturesAuraAPI.instance().spawnParticleStream((float)this.f_58858_.m_123341_() + (float)this.f_58857_.f_46441_.m_188583_() * 5.0f, (float)(this.f_58858_.m_123342_() + 1) + this.f_58857_.f_46441_.m_188501_() * 5.0f, (float)this.f_58858_.m_123343_() + (float)this.f_58857_.f_46441_.m_188583_() * 5.0f, (float)this.f_58858_.m_123341_() + this.f_58857_.f_46441_.m_188501_(), (float)this.f_58858_.m_123342_() + this.f_58857_.f_46441_.m_188501_(), (float)this.f_58858_.m_123343_() + this.f_58857_.f_46441_.m_188501_(), this.f_58857_.f_46441_.m_188501_() * 0.07f + 0.07f, IAuraType.forLevel(this.f_58857_).getColor(), this.f_58857_.f_46441_.m_188501_() + 0.5f);
            if (this.entityClient == null) {
                this.entityClient = this.currentRecipe.makeEntity(this.f_58857_, BlockPos.f_121853_);
                this.entityClient.m_6034_(this.spawnX, (double)(this.f_58858_.m_123342_() + 1), this.spawnZ);
            }
            AABB bounds = this.entityClient.m_20191_();
            for (int i = this.f_58857_.f_46441_.m_188503_(5) + 5; i >= 0; --i) {
                NaturesAuraAPI.instance().spawnMagicParticle(bounds.f_82288_ + (double)this.f_58857_.f_46441_.m_188501_() * (bounds.f_82291_ - bounds.f_82288_), bounds.f_82289_ + (double)this.f_58857_.f_46441_.m_188501_() * (bounds.f_82292_ - bounds.f_82289_), bounds.f_82290_ + (double)this.f_58857_.f_46441_.m_188501_() * (bounds.f_82293_ - bounds.f_82290_), 0.0, 0.0, 0.0, 3135699, 2.0f, 60, 0.0f, false, true);
            }
        }
    }

    @Override
    public void writeNBT(CompoundTag compound, BlockEntityImpl.SaveType type) {
        super.writeNBT(compound, type);
        if (type != BlockEntityImpl.SaveType.BLOCK && this.currentRecipe != null) {
            compound.m_128359_("recipe", this.currentRecipe.name.toString());
            compound.m_128347_("spawn_x", this.spawnX);
            compound.m_128347_("spawn_z", this.spawnZ);
            compound.m_128405_("time", this.time);
        }
    }

    @Override
    public void readNBT(CompoundTag compound, BlockEntityImpl.SaveType type) {
        super.readNBT(compound, type);
        if (type != BlockEntityImpl.SaveType.BLOCK) {
            if (compound.m_128441_("recipe")) {
                if (this.m_58898_()) {
                    ResourceLocation name = new ResourceLocation(compound.m_128461_("recipe"));
                    this.currentRecipe = this.f_58857_.m_7465_().m_44043_(name).orElse(null);
                }
                this.spawnX = compound.m_128459_("spawn_x");
                this.spawnZ = compound.m_128459_("spawn_z");
                this.time = compound.m_128451_("time");
            } else {
                this.currentRecipe = null;
                this.time = 0;
            }
        }
    }

    @Override
    public boolean allowsLowerLimiter() {
        return true;
    }
}

