/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.naturesaura;

import de.ellpeck.naturesaura.Helper;
import de.ellpeck.naturesaura.NaturesAura;
import de.ellpeck.naturesaura.api.NaturesAuraAPI;
import de.ellpeck.naturesaura.api.aura.chunk.IAuraChunk;
import de.ellpeck.naturesaura.api.aura.container.IAuraContainer;
import de.ellpeck.naturesaura.api.misc.ILevelData;
import de.ellpeck.naturesaura.api.multiblock.IMultiblock;
import de.ellpeck.naturesaura.blocks.multi.Multiblock;
import de.ellpeck.naturesaura.misc.LevelData;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.apache.commons.lang3.mutable.MutableFloat;
import org.apache.commons.lang3.mutable.MutableInt;
import org.apache.commons.lang3.mutable.MutableObject;
import org.apache.commons.lang3.tuple.Pair;

public class InternalHooks
implements NaturesAuraAPI.IInternalHooks {
    @Override
    public boolean extractAuraFromPlayer(Player player, int amount, boolean simulate) {
        return this.auraPlayerInteraction(player, amount, true, simulate);
    }

    @Override
    public boolean insertAuraIntoPlayer(Player player, int amount, boolean simulate) {
        return this.auraPlayerInteraction(player, amount, false, simulate);
    }

    private boolean auraPlayerInteraction(Player player, int amount, boolean extract, boolean simulate) {
        if (extract && player.m_7500_()) {
            return true;
        }
        ItemStack stack = Helper.getEquippedItem(s -> s.getCapability(NaturesAuraAPI.CAP_AURA_CONTAINER).isPresent(), player);
        if (!stack.m_41619_()) {
            IAuraContainer container = (IAuraContainer)stack.getCapability(NaturesAuraAPI.CAP_AURA_CONTAINER).orElse(null);
            if (extract) {
                return container.drainAura(amount, simulate) > 0;
            }
            return container.storeAura(amount, simulate) > 0;
        }
        return false;
    }

    @Override
    public void spawnMagicParticle(double posX, double posY, double posZ, double motionX, double motionY, double motionZ, int color, float scale, int maxAge, float gravity, boolean collision, boolean fade) {
        NaturesAura.proxy.spawnMagicParticle(posX, posY, posZ, motionX, motionY, motionZ, color, scale, maxAge, gravity, collision, fade);
    }

    @Override
    public void spawnParticleStream(float startX, float startY, float startZ, float endX, float endY, float endZ, float speed, int color, float scale) {
        Vec3 dir = new Vec3((double)(endX - startX), (double)(endY - startY), (double)(endZ - startZ));
        double length = dir.m_82553_();
        if (length > 0.0) {
            dir = dir.m_82541_();
            this.spawnMagicParticle(startX, startY, startZ, dir.f_82479_ * (double)speed, dir.f_82480_ * (double)speed, dir.f_82481_ * (double)speed, color, scale, (int)(length / (double)speed), 0.0f, false, false);
        }
    }

    @Override
    public void setParticleDepth(boolean depth) {
        NaturesAura.proxy.setParticleDepth(depth);
    }

    @Override
    public void setParticleSpawnRange(int range) {
        NaturesAura.proxy.setParticleSpawnRange(range);
    }

    @Override
    public void setParticleCulling(boolean cull) {
        NaturesAura.proxy.setParticleCulling(cull);
    }

    @Override
    public IMultiblock createMultiblock(ResourceLocation name, String[][] pattern, Object ... rawMatchers) {
        return new Multiblock(name, pattern, rawMatchers);
    }

    @Override
    public List<Tuple<Vec3, Integer>> getActiveEffectPowders(Level level, AABB area, ResourceLocation name) {
        ArrayList<Tuple<Vec3, Integer>> found = new ArrayList<Tuple<Vec3, Integer>>();
        for (Tuple powder : ((LevelData)ILevelData.getLevelData((Level)level)).effectPowders.get((Object)name)) {
            if (!area.m_82390_((Vec3)powder.m_14418_())) continue;
            found.add((Tuple<Vec3, Integer>)powder);
        }
        return found;
    }

    @Override
    public boolean isEffectPowderActive(Level level, BlockPos pos, ResourceLocation name) {
        Vec3 posVec = new Vec3((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5);
        List<Tuple<Vec3, Integer>> powders = this.getActiveEffectPowders(level, new AABB(pos).m_82400_(64.0), name);
        for (Tuple<Vec3, Integer> powder : powders) {
            AABB bounds = Helper.aabb((Vec3)powder.m_14418_()).m_82400_((double)((Integer)powder.m_14419_()).intValue());
            if (!bounds.m_82390_(posVec)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void getAuraSpotsInArea(Level level, BlockPos pos, int radius, BiConsumer<BlockPos, Integer> consumer) {
        Helper.getAuraChunksWithSpotsInArea(level, pos, radius, chunk -> chunk.getSpots(pos, radius, consumer));
    }

    @Override
    public int getSpotAmountInArea(Level level, BlockPos pos, int radius) {
        MutableInt result = new MutableInt();
        Helper.getAuraChunksWithSpotsInArea(level, pos, radius, chunk -> result.add((Number)chunk.getAuraAndSpotAmount(pos, radius).getRight()));
        return result.intValue();
    }

    @Override
    public int getAuraInArea(Level level, BlockPos pos, int radius) {
        MutableInt result = new MutableInt(1000000);
        Helper.getAuraChunksWithSpotsInArea(level, pos, radius, chunk -> result.add((Number)chunk.getAuraAndSpotAmount(pos, radius).getLeft()));
        return result.intValue();
    }

    @Override
    public Pair<Integer, Integer> getAuraAndSpotAmountInArea(Level level, BlockPos pos, int radius) {
        MutableInt spots = new MutableInt();
        MutableInt aura = new MutableInt(1000000);
        Helper.getAuraChunksWithSpotsInArea(level, pos, radius, chunk -> {
            Pair<Integer, Integer> auraAndSpots = chunk.getAuraAndSpotAmount(pos, radius);
            aura.add((Number)auraAndSpots.getLeft());
            spots.add((Number)auraAndSpots.getRight());
        });
        return Pair.of((Object)aura.intValue(), (Object)spots.intValue());
    }

    @Override
    public int triangulateAuraInArea(Level level, BlockPos pos, int radius) {
        MutableFloat result = new MutableFloat(1000000.0f);
        IAuraChunk.getSpotsInArea(level, pos, radius, (blockPos, spot) -> {
            float percentage = 1.0f - (float)Math.sqrt(pos.m_123331_((Vec3i)blockPos)) / (float)radius;
            result.add((float)spot.intValue() * percentage);
        });
        return result.intValue();
    }

    @Override
    public BlockPos getLowestAuraDrainSpot(Level level, BlockPos pos, int radius, BlockPos defaultSpot) {
        MutableInt lowestAmount = new MutableInt(Integer.MAX_VALUE);
        MutableObject lowestSpot = new MutableObject();
        Helper.getAuraChunksWithSpotsInArea(level, pos, radius, c -> {
            Pair<BlockPos, Integer> spot = c.getLowestAndHighestSpots(pos, radius)[0];
            if ((Integer)spot.getRight() < lowestAmount.intValue()) {
                lowestAmount.setValue((Number)spot.getRight());
                lowestSpot.setValue((Object)((BlockPos)spot.getLeft()));
            }
        });
        BlockPos lowest = (BlockPos)lowestSpot.getValue();
        if (lowest == null || lowestAmount.intValue() >= 0) {
            lowest = defaultSpot;
        }
        return lowest;
    }

    @Override
    public BlockPos getHighestAuraDrainSpot(Level level, BlockPos pos, int radius, BlockPos defaultSpot) {
        MutableInt highestAmount = new MutableInt(Integer.MIN_VALUE);
        MutableObject highestSpot = new MutableObject();
        Helper.getAuraChunksWithSpotsInArea(level, pos, radius, c -> {
            Pair<BlockPos, Integer> spot = c.getLowestAndHighestSpots(pos, radius)[1];
            if ((Integer)spot.getRight() > highestAmount.intValue()) {
                highestAmount.setValue((Number)spot.getRight());
                highestSpot.setValue((Object)((BlockPos)spot.getLeft()));
            }
        });
        BlockPos highest = (BlockPos)highestSpot.getValue();
        if (highest == null || highestAmount.intValue() <= 0) {
            highest = defaultSpot;
        }
        return highest;
    }
}

