/*
 * Decompiled with CFR 0.152.
 */
package nz.co.mirality.colony4cc.pocket;

import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.api.pocket.AbstractPocketUpgrade;
import dan200.computercraft.api.pocket.IPocketAccess;
import dan200.computercraft.core.computer.ComputerSide;
import dan200.computercraft.shared.pocket.core.PocketServerComputer;
import dan200.computercraft.shared.pocket.peripherals.PocketModem;
import dan200.computercraft.shared.pocket.peripherals.PocketModemPeripheral;
import java.util.Map;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import nz.co.mirality.colony4cc.peripheral.PocketColonyPeripheral;
import nz.co.mirality.colony4cc.pocket.PocketColony;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PocketColonyWireless
extends AbstractPocketUpgrade {
    public static final ComputerSide COLONY_SIDE = ComputerSide.BOTTOM;
    private final PocketColony colony;
    private final PocketModem modem;
    private final boolean advanced;

    public PocketColonyWireless(@NotNull ResourceLocation id, @NotNull ItemStack stack, boolean advanced) {
        super(id, stack);
        this.colony = new PocketColony(id, ItemStack.f_41583_);
        this.modem = new PocketModem(id, ItemStack.f_41583_, advanced);
        this.advanced = advanced;
    }

    @Nullable
    public IPeripheral createPeripheral(@NotNull IPocketAccess access) {
        return new PocketModemPeripheral(this.advanced);
    }

    @NotNull
    public IPeripheral createColonyPeripheral(@NotNull IPocketAccess access) {
        return new PocketColonyPeripheral();
    }

    public void update(@NotNull IPocketAccess access, @Nullable IPeripheral peripheral) {
        if (peripheral instanceof PocketModemPeripheral) {
            HijackedPocketAccess hijacked = new HijackedPocketAccess(access);
            this.modem.update((IPocketAccess)hijacked, peripheral);
        }
        if ((peripheral = ((PocketServerComputer)access).getPeripheral(COLONY_SIDE)) instanceof PocketColonyPeripheral) {
            this.colony.update(access, peripheral);
        }
    }

    private static class HijackedPocketAccess
    implements IPocketAccess {
        private final IPocketAccess access;
        private int light;

        public HijackedPocketAccess(IPocketAccess access) {
            this.access = access;
            this.light = access.getLight();
        }

        @Nullable
        public Entity getEntity() {
            return this.access.getEntity();
        }

        public int getColour() {
            return this.access.getColour();
        }

        public void setColour(int i) {
            this.access.setColour(i);
        }

        public int getLight() {
            return this.light;
        }

        public void setLight(int i) {
            this.light = i;
        }

        @NotNull
        public CompoundTag getUpgradeNBTData() {
            return this.access.getUpgradeNBTData();
        }

        public void updateUpgradeNBTData() {
            this.access.updateUpgradeNBTData();
        }

        public void invalidatePeripheral() {
        }

        @NotNull
        public Map<ResourceLocation, IPeripheral> getUpgrades() {
            return this.access.getUpgrades();
        }
    }
}

