/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.smartbrainlib.api.core.behaviour.custom.move;

import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.util.DefaultRandomPos;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.Vec3;
import net.tslat.smartbrainlib.api.core.behaviour.ExtendedBehaviour;
import net.tslat.smartbrainlib.util.BrainUtils;

public class FleeTarget<E extends PathfinderMob>
extends ExtendedBehaviour<E> {
    private static final List<Pair<MemoryModuleType<?>, MemoryStatus>> MEMORY_REQUIREMENTS = ObjectArrayList.of((Object[])new Pair[]{Pair.of((Object)MemoryModuleType.f_26372_, (Object)MemoryStatus.VALUE_PRESENT)});
    private int fleeDistance = 20;
    private float speedModifier = 1.0f;
    private Path runPath = null;

    @Override
    protected List<Pair<MemoryModuleType<?>, MemoryStatus>> getMemoryRequirements() {
        return MEMORY_REQUIREMENTS;
    }

    public FleeTarget<E> fleeDistance(int blocks) {
        this.fleeDistance = blocks;
        return this;
    }

    public FleeTarget<E> speedModifier(float mod) {
        this.speedModifier = mod;
        return this;
    }

    protected boolean checkExtraStartConditions(ServerLevel level, E entity) {
        LivingEntity target = BrainUtils.getTargetOfEntity(entity);
        double distToTarget = entity.m_20280_((Entity)target);
        Vec3 runPos = DefaultRandomPos.m_148407_(entity, (int)this.fleeDistance, (int)10, (Vec3)target.m_20182_());
        if (runPos == null || target.m_20275_(runPos.f_82479_, runPos.f_82480_, runPos.f_82481_) < distToTarget) {
            return false;
        }
        this.runPath = entity.m_21573_().m_26524_(runPos.f_82479_, runPos.f_82480_, runPos.f_82481_, 0);
        return this.runPath != null;
    }

    @Override
    protected boolean shouldKeepRunning(E entity) {
        return entity.m_21573_().m_26570_() == this.runPath && !entity.m_21573_().m_26571_();
    }

    @Override
    protected boolean m_7773_(long gameTime) {
        return false;
    }

    @Override
    protected void start(E entity) {
        entity.m_21573_().m_26536_(this.runPath, (double)this.speedModifier);
        BrainUtils.clearMemory(entity, MemoryModuleType.f_26372_);
    }

    @Override
    protected void stop(E entity) {
        if (entity.m_21573_().m_26570_() == this.runPath) {
            entity.m_21573_().m_26517_(1.0);
        }
        this.runPath = null;
    }
}

