/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfml.ast;

import ca.teamdman.sfm.common.program.ResourceType;
import ca.teamdman.sfm.common.registry.SFMResourceTypes;
import ca.teamdman.sfml.ast.ASTNode;
import java.util.function.Predicate;
import net.minecraft.resources.ResourceLocation;

public record ResourceIdentifier<STACK, CAP>(String type, String domain, String value) implements ASTNode,
Predicate<Object>
{
    public static final ResourceIdentifier<?, ?> MATCH_ALL = new ResourceIdentifier("*", "*");

    public ResourceIdentifier(String value) {
        this("item", "minecraft", value);
    }

    public ResourceIdentifier(String namespace, String value) {
        this("item", namespace, value);
    }

    public static <STACK, CAP> ResourceIdentifier<STACK, CAP> fromString(String string) {
        String[] parts = string.split(":");
        if (parts.length == 1) {
            return new ResourceIdentifier<STACK, CAP>(parts[0]);
        }
        if (parts.length == 2) {
            return new ResourceIdentifier<STACK, CAP>(parts[0], parts[1]);
        }
        if (parts.length == 3) {
            return new ResourceIdentifier<STACK, CAP>(parts[0], parts[1], parts[2]);
        }
        throw new IllegalArgumentException("bad resource id");
    }

    public ResourceLocation getLocation() {
        return new ResourceLocation(this.domain, this.value);
    }

    @Override
    public boolean test(Object other) {
        return this.getType().test(this, other);
    }

    public ResourceType<STACK, CAP> getType() {
        return (ResourceType)SFMResourceTypes.DEFERRED_TYPES.get().getValue(new ResourceLocation("sfm", this.type));
    }

    @Override
    public String toString() {
        return this.type + ":" + this.domain + ":" + this.value;
    }
}

