/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfml.ast;

import ca.teamdman.sfml.ast.ASTNode;
import java.util.Locale;
import java.util.function.BiPredicate;

public enum ComparisonOperator implements ASTNode,
BiPredicate<Integer, Integer>
{
    GREATER((a, b) -> a > b),
    LESSER((a, b) -> a < b),
    EQUALS(Integer::equals),
    LESSER_OR_EQUAL((a, b) -> a <= b),
    GREATER_OR_EQUAL((a, b) -> a >= b),
    NEVER((a, b) -> false);

    private final BiPredicate<Integer, Integer> PRED;

    private ComparisonOperator(BiPredicate<Integer, Integer> pred) {
        this.PRED = pred;
    }

    public static ComparisonOperator from(String text) {
        return switch (text.toUpperCase(Locale.ROOT)) {
            case "GT" -> GREATER;
            case "LT" -> LESSER;
            case "EQ" -> EQUALS;
            case "LE" -> LESSER_OR_EQUAL;
            case "GE" -> GREATER_OR_EQUAL;
            default -> NEVER;
        };
    }

    @Override
    public boolean test(Integer a, Integer b) {
        return this.PRED.test(a, b);
    }
}

