/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.common.program;

import ca.teamdman.sfm.common.program.ResourceType;
import ca.teamdman.sfml.ast.LabelAccess;
import java.util.stream.Stream;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.registries.ForgeRegistries;

public class ItemResourceType
extends ResourceType<ItemStack, IItemHandler> {
    public ItemResourceType() {
        super(ForgeCapabilities.ITEM_HANDLER);
    }

    @Override
    public boolean containsKey(ResourceLocation location) {
        return ForgeRegistries.ITEMS.containsKey(location);
    }

    @Override
    public ResourceLocation getKey(ItemStack itemStack) {
        return ForgeRegistries.ITEMS.getKey((Object)itemStack.m_41720_());
    }

    @Override
    public int getCount(ItemStack stack) {
        return stack.m_41613_();
    }

    @Override
    public ItemStack getStackInSlot(IItemHandler cap, int slot) {
        return cap.getStackInSlot(slot);
    }

    @Override
    public ItemStack extract(IItemHandler handler, int slot, int amount, boolean simulate) {
        return handler.extractItem(slot, amount, simulate);
    }

    @Override
    public boolean matchesStackType(Object o) {
        return o instanceof ItemStack;
    }

    @Override
    public boolean matchesCapType(Object o) {
        return o instanceof IItemHandler;
    }

    @Override
    public int getSlots(IItemHandler handler) {
        return handler.getSlots();
    }

    @Override
    public ItemStack insert(IItemHandler handler, int slot, ItemStack stack, boolean simulate) {
        return handler.insertItem(slot, stack, simulate);
    }

    @Override
    public boolean isEmpty(ItemStack stack) {
        return stack.m_41619_();
    }

    @Override
    public Stream<ItemStack> collect(IItemHandler cap, LabelAccess labelAccess) {
        Stream.Builder<ItemStack> rtn = Stream.builder();
        for (int slot = 0; slot < cap.getSlots(); ++slot) {
            ItemStack stack;
            if (!labelAccess.slots().contains(slot) || (stack = cap.getStackInSlot(slot)).m_41619_()) continue;
            rtn.add(stack);
        }
        return rtn.build();
    }
}

