/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.common.program;

import ca.teamdman.sfm.common.program.ResourceType;
import ca.teamdman.sfml.ast.LabelAccess;
import java.util.stream.Stream;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.registries.ForgeRegistries;

public class FluidResourceType
extends ResourceType<FluidStack, IFluidHandler> {
    public FluidResourceType() {
        super(ForgeCapabilities.FLUID_HANDLER);
    }

    @Override
    public boolean containsKey(ResourceLocation location) {
        return ForgeRegistries.FLUIDS.containsKey(location);
    }

    @Override
    public ResourceLocation getKey(FluidStack stack) {
        return ForgeRegistries.FLUIDS.getKey((Object)stack.getFluid());
    }

    @Override
    public int getCount(FluidStack stack) {
        return stack.getAmount();
    }

    @Override
    public FluidStack getStackInSlot(IFluidHandler cap, int slot) {
        return cap.getFluidInTank(slot);
    }

    @Override
    public FluidStack extract(IFluidHandler handler, int slot, int amount, boolean simulate) {
        FluidStack in = this.getStackInSlot(handler, slot);
        FluidStack toExtract = new FluidStack(in.getFluid(), Math.min(in.getAmount(), amount));
        return handler.drain(toExtract, simulate ? IFluidHandler.FluidAction.SIMULATE : IFluidHandler.FluidAction.EXECUTE);
    }

    @Override
    public boolean matchesStackType(Object o) {
        return o instanceof FluidStack;
    }

    @Override
    public boolean matchesCapType(Object o) {
        return o instanceof IFluidHandler;
    }

    @Override
    public int getSlots(IFluidHandler handler) {
        return handler.getTanks();
    }

    @Override
    public FluidStack insert(IFluidHandler handler, int slot, FluidStack stack, boolean simulate) {
        int x = handler.fill(stack, simulate ? IFluidHandler.FluidAction.SIMULATE : IFluidHandler.FluidAction.EXECUTE);
        FluidStack rtn = new FluidStack(stack.getFluid(), stack.getAmount() - x);
        return rtn;
    }

    @Override
    public boolean isEmpty(FluidStack stack) {
        return stack.isEmpty();
    }

    @Override
    public Stream<FluidStack> collect(IFluidHandler cap, LabelAccess labelAccess) {
        Stream.Builder<FluidStack> rtn = Stream.builder();
        for (int slot = 0; slot < cap.getTanks(); ++slot) {
            FluidStack stack;
            if (!labelAccess.slots().contains(slot) || (stack = cap.getFluidInTank(slot)).isEmpty()) continue;
            rtn.add(stack);
        }
        return rtn.build();
    }
}

